/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medialive.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Placeholder documentation for DeleteMultiplexProgramResponse
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteMultiplexProgramResponse extends MediaLiveResponse implements
        ToCopyableBuilder<DeleteMultiplexProgramResponse.Builder, DeleteMultiplexProgramResponse> {
    private static final SdkField<String> CHANNEL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ChannelId").getter(getter(DeleteMultiplexProgramResponse::channelId)).setter(setter(Builder::channelId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("channelId").build()).build();

    private static final SdkField<MultiplexProgramSettings> MULTIPLEX_PROGRAM_SETTINGS_FIELD = SdkField
            .<MultiplexProgramSettings> builder(MarshallingType.SDK_POJO).memberName("MultiplexProgramSettings")
            .getter(getter(DeleteMultiplexProgramResponse::multiplexProgramSettings))
            .setter(setter(Builder::multiplexProgramSettings)).constructor(MultiplexProgramSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("multiplexProgramSettings").build())
            .build();

    private static final SdkField<MultiplexProgramPacketIdentifiersMap> PACKET_IDENTIFIERS_MAP_FIELD = SdkField
            .<MultiplexProgramPacketIdentifiersMap> builder(MarshallingType.SDK_POJO).memberName("PacketIdentifiersMap")
            .getter(getter(DeleteMultiplexProgramResponse::packetIdentifiersMap)).setter(setter(Builder::packetIdentifiersMap))
            .constructor(MultiplexProgramPacketIdentifiersMap::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("packetIdentifiersMap").build())
            .build();

    private static final SdkField<List<MultiplexProgramPipelineDetail>> PIPELINE_DETAILS_FIELD = SdkField
            .<List<MultiplexProgramPipelineDetail>> builder(MarshallingType.LIST)
            .memberName("PipelineDetails")
            .getter(getter(DeleteMultiplexProgramResponse::pipelineDetails))
            .setter(setter(Builder::pipelineDetails))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pipelineDetails").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<MultiplexProgramPipelineDetail> builder(MarshallingType.SDK_POJO)
                                            .constructor(MultiplexProgramPipelineDetail::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> PROGRAM_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProgramName").getter(getter(DeleteMultiplexProgramResponse::programName))
            .setter(setter(Builder::programName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("programName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHANNEL_ID_FIELD,
            MULTIPLEX_PROGRAM_SETTINGS_FIELD, PACKET_IDENTIFIERS_MAP_FIELD, PIPELINE_DETAILS_FIELD, PROGRAM_NAME_FIELD));

    private final String channelId;

    private final MultiplexProgramSettings multiplexProgramSettings;

    private final MultiplexProgramPacketIdentifiersMap packetIdentifiersMap;

    private final List<MultiplexProgramPipelineDetail> pipelineDetails;

    private final String programName;

    private DeleteMultiplexProgramResponse(BuilderImpl builder) {
        super(builder);
        this.channelId = builder.channelId;
        this.multiplexProgramSettings = builder.multiplexProgramSettings;
        this.packetIdentifiersMap = builder.packetIdentifiersMap;
        this.pipelineDetails = builder.pipelineDetails;
        this.programName = builder.programName;
    }

    /**
     * The MediaLive channel associated with the program.
     * 
     * @return The MediaLive channel associated with the program.
     */
    public final String channelId() {
        return channelId;
    }

    /**
     * The settings for this multiplex program.
     * 
     * @return The settings for this multiplex program.
     */
    public final MultiplexProgramSettings multiplexProgramSettings() {
        return multiplexProgramSettings;
    }

    /**
     * The packet identifier map for this multiplex program.
     * 
     * @return The packet identifier map for this multiplex program.
     */
    public final MultiplexProgramPacketIdentifiersMap packetIdentifiersMap() {
        return packetIdentifiersMap;
    }

    /**
     * Returns true if the PipelineDetails property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasPipelineDetails() {
        return pipelineDetails != null && !(pipelineDetails instanceof SdkAutoConstructList);
    }

    /**
     * Contains information about the current sources for the specified program in the specified multiplex. Keep in mind
     * that each multiplex pipeline connects to both pipelines in a given source channel (the channel identified by the
     * program). But only one of those channel pipelines is ever active at one time.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasPipelineDetails()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Contains information about the current sources for the specified program in the specified multiplex. Keep
     *         in mind that each multiplex pipeline connects to both pipelines in a given source channel (the channel
     *         identified by the program). But only one of those channel pipelines is ever active at one time.
     */
    public final List<MultiplexProgramPipelineDetail> pipelineDetails() {
        return pipelineDetails;
    }

    /**
     * The name of the multiplex program.
     * 
     * @return The name of the multiplex program.
     */
    public final String programName() {
        return programName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(channelId());
        hashCode = 31 * hashCode + Objects.hashCode(multiplexProgramSettings());
        hashCode = 31 * hashCode + Objects.hashCode(packetIdentifiersMap());
        hashCode = 31 * hashCode + Objects.hashCode(hasPipelineDetails() ? pipelineDetails() : null);
        hashCode = 31 * hashCode + Objects.hashCode(programName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteMultiplexProgramResponse)) {
            return false;
        }
        DeleteMultiplexProgramResponse other = (DeleteMultiplexProgramResponse) obj;
        return Objects.equals(channelId(), other.channelId())
                && Objects.equals(multiplexProgramSettings(), other.multiplexProgramSettings())
                && Objects.equals(packetIdentifiersMap(), other.packetIdentifiersMap())
                && hasPipelineDetails() == other.hasPipelineDetails()
                && Objects.equals(pipelineDetails(), other.pipelineDetails())
                && Objects.equals(programName(), other.programName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteMultiplexProgramResponse").add("ChannelId", channelId())
                .add("MultiplexProgramSettings", multiplexProgramSettings()).add("PacketIdentifiersMap", packetIdentifiersMap())
                .add("PipelineDetails", hasPipelineDetails() ? pipelineDetails() : null).add("ProgramName", programName())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ChannelId":
            return Optional.ofNullable(clazz.cast(channelId()));
        case "MultiplexProgramSettings":
            return Optional.ofNullable(clazz.cast(multiplexProgramSettings()));
        case "PacketIdentifiersMap":
            return Optional.ofNullable(clazz.cast(packetIdentifiersMap()));
        case "PipelineDetails":
            return Optional.ofNullable(clazz.cast(pipelineDetails()));
        case "ProgramName":
            return Optional.ofNullable(clazz.cast(programName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteMultiplexProgramResponse, T> g) {
        return obj -> g.apply((DeleteMultiplexProgramResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MediaLiveResponse.Builder, SdkPojo, CopyableBuilder<Builder, DeleteMultiplexProgramResponse> {
        /**
         * The MediaLive channel associated with the program.
         * 
         * @param channelId
         *        The MediaLive channel associated with the program.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder channelId(String channelId);

        /**
         * The settings for this multiplex program.
         * 
         * @param multiplexProgramSettings
         *        The settings for this multiplex program.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder multiplexProgramSettings(MultiplexProgramSettings multiplexProgramSettings);

        /**
         * The settings for this multiplex program. This is a convenience that creates an instance of the
         * {@link MultiplexProgramSettings.Builder} avoiding the need to create one manually via
         * {@link MultiplexProgramSettings#builder()}.
         *
         * When the {@link Consumer} completes, {@link MultiplexProgramSettings.Builder#build()} is called immediately
         * and its result is passed to {@link #multiplexProgramSettings(MultiplexProgramSettings)}.
         * 
         * @param multiplexProgramSettings
         *        a consumer that will call methods on {@link MultiplexProgramSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #multiplexProgramSettings(MultiplexProgramSettings)
         */
        default Builder multiplexProgramSettings(Consumer<MultiplexProgramSettings.Builder> multiplexProgramSettings) {
            return multiplexProgramSettings(MultiplexProgramSettings.builder().applyMutation(multiplexProgramSettings).build());
        }

        /**
         * The packet identifier map for this multiplex program.
         * 
         * @param packetIdentifiersMap
         *        The packet identifier map for this multiplex program.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder packetIdentifiersMap(MultiplexProgramPacketIdentifiersMap packetIdentifiersMap);

        /**
         * The packet identifier map for this multiplex program. This is a convenience that creates an instance of the
         * {@link MultiplexProgramPacketIdentifiersMap.Builder} avoiding the need to create one manually via
         * {@link MultiplexProgramPacketIdentifiersMap#builder()}.
         *
         * When the {@link Consumer} completes, {@link MultiplexProgramPacketIdentifiersMap.Builder#build()} is called
         * immediately and its result is passed to {@link #packetIdentifiersMap(MultiplexProgramPacketIdentifiersMap)}.
         * 
         * @param packetIdentifiersMap
         *        a consumer that will call methods on {@link MultiplexProgramPacketIdentifiersMap.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #packetIdentifiersMap(MultiplexProgramPacketIdentifiersMap)
         */
        default Builder packetIdentifiersMap(Consumer<MultiplexProgramPacketIdentifiersMap.Builder> packetIdentifiersMap) {
            return packetIdentifiersMap(MultiplexProgramPacketIdentifiersMap.builder().applyMutation(packetIdentifiersMap)
                    .build());
        }

        /**
         * Contains information about the current sources for the specified program in the specified multiplex. Keep in
         * mind that each multiplex pipeline connects to both pipelines in a given source channel (the channel
         * identified by the program). But only one of those channel pipelines is ever active at one time.
         * 
         * @param pipelineDetails
         *        Contains information about the current sources for the specified program in the specified multiplex.
         *        Keep in mind that each multiplex pipeline connects to both pipelines in a given source channel (the
         *        channel identified by the program). But only one of those channel pipelines is ever active at one
         *        time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pipelineDetails(Collection<MultiplexProgramPipelineDetail> pipelineDetails);

        /**
         * Contains information about the current sources for the specified program in the specified multiplex. Keep in
         * mind that each multiplex pipeline connects to both pipelines in a given source channel (the channel
         * identified by the program). But only one of those channel pipelines is ever active at one time.
         * 
         * @param pipelineDetails
         *        Contains information about the current sources for the specified program in the specified multiplex.
         *        Keep in mind that each multiplex pipeline connects to both pipelines in a given source channel (the
         *        channel identified by the program). But only one of those channel pipelines is ever active at one
         *        time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pipelineDetails(MultiplexProgramPipelineDetail... pipelineDetails);

        /**
         * Contains information about the current sources for the specified program in the specified multiplex. Keep in
         * mind that each multiplex pipeline connects to both pipelines in a given source channel (the channel
         * identified by the program). But only one of those channel pipelines is ever active at one time. This is a
         * convenience that creates an instance of the {@link List<MultiplexProgramPipelineDetail>.Builder} avoiding the
         * need to create one manually via {@link List<MultiplexProgramPipelineDetail>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<MultiplexProgramPipelineDetail>.Builder#build()} is called
         * immediately and its result is passed to {@link #pipelineDetails(List<MultiplexProgramPipelineDetail>)}.
         * 
         * @param pipelineDetails
         *        a consumer that will call methods on {@link List<MultiplexProgramPipelineDetail>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #pipelineDetails(List<MultiplexProgramPipelineDetail>)
         */
        Builder pipelineDetails(Consumer<MultiplexProgramPipelineDetail.Builder>... pipelineDetails);

        /**
         * The name of the multiplex program.
         * 
         * @param programName
         *        The name of the multiplex program.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder programName(String programName);
    }

    static final class BuilderImpl extends MediaLiveResponse.BuilderImpl implements Builder {
        private String channelId;

        private MultiplexProgramSettings multiplexProgramSettings;

        private MultiplexProgramPacketIdentifiersMap packetIdentifiersMap;

        private List<MultiplexProgramPipelineDetail> pipelineDetails = DefaultSdkAutoConstructList.getInstance();

        private String programName;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteMultiplexProgramResponse model) {
            super(model);
            channelId(model.channelId);
            multiplexProgramSettings(model.multiplexProgramSettings);
            packetIdentifiersMap(model.packetIdentifiersMap);
            pipelineDetails(model.pipelineDetails);
            programName(model.programName);
        }

        public final String getChannelId() {
            return channelId;
        }

        @Override
        public final Builder channelId(String channelId) {
            this.channelId = channelId;
            return this;
        }

        public final void setChannelId(String channelId) {
            this.channelId = channelId;
        }

        public final MultiplexProgramSettings.Builder getMultiplexProgramSettings() {
            return multiplexProgramSettings != null ? multiplexProgramSettings.toBuilder() : null;
        }

        @Override
        public final Builder multiplexProgramSettings(MultiplexProgramSettings multiplexProgramSettings) {
            this.multiplexProgramSettings = multiplexProgramSettings;
            return this;
        }

        public final void setMultiplexProgramSettings(MultiplexProgramSettings.BuilderImpl multiplexProgramSettings) {
            this.multiplexProgramSettings = multiplexProgramSettings != null ? multiplexProgramSettings.build() : null;
        }

        public final MultiplexProgramPacketIdentifiersMap.Builder getPacketIdentifiersMap() {
            return packetIdentifiersMap != null ? packetIdentifiersMap.toBuilder() : null;
        }

        @Override
        public final Builder packetIdentifiersMap(MultiplexProgramPacketIdentifiersMap packetIdentifiersMap) {
            this.packetIdentifiersMap = packetIdentifiersMap;
            return this;
        }

        public final void setPacketIdentifiersMap(MultiplexProgramPacketIdentifiersMap.BuilderImpl packetIdentifiersMap) {
            this.packetIdentifiersMap = packetIdentifiersMap != null ? packetIdentifiersMap.build() : null;
        }

        public final Collection<MultiplexProgramPipelineDetail.Builder> getPipelineDetails() {
            if (pipelineDetails instanceof SdkAutoConstructList) {
                return null;
            }
            return pipelineDetails != null ? pipelineDetails.stream().map(MultiplexProgramPipelineDetail::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder pipelineDetails(Collection<MultiplexProgramPipelineDetail> pipelineDetails) {
            this.pipelineDetails = ___listOfMultiplexProgramPipelineDetailCopier.copy(pipelineDetails);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder pipelineDetails(MultiplexProgramPipelineDetail... pipelineDetails) {
            pipelineDetails(Arrays.asList(pipelineDetails));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder pipelineDetails(Consumer<MultiplexProgramPipelineDetail.Builder>... pipelineDetails) {
            pipelineDetails(Stream.of(pipelineDetails)
                    .map(c -> MultiplexProgramPipelineDetail.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setPipelineDetails(Collection<MultiplexProgramPipelineDetail.BuilderImpl> pipelineDetails) {
            this.pipelineDetails = ___listOfMultiplexProgramPipelineDetailCopier.copyFromBuilder(pipelineDetails);
        }

        public final String getProgramName() {
            return programName;
        }

        @Override
        public final Builder programName(String programName) {
            this.programName = programName;
            return this;
        }

        public final void setProgramName(String programName) {
            this.programName = programName;
        }

        @Override
        public DeleteMultiplexProgramResponse build() {
            return new DeleteMultiplexProgramResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
