/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medialive.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * List of actions to create and list of actions to delete.
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchUpdateScheduleRequest extends MediaLiveRequest implements
        ToCopyableBuilder<BatchUpdateScheduleRequest.Builder, BatchUpdateScheduleRequest> {
    private static final SdkField<String> CHANNEL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ChannelId").getter(getter(BatchUpdateScheduleRequest::channelId)).setter(setter(Builder::channelId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("channelId").build()).build();

    private static final SdkField<BatchScheduleActionCreateRequest> CREATES_FIELD = SdkField
            .<BatchScheduleActionCreateRequest> builder(MarshallingType.SDK_POJO).memberName("Creates")
            .getter(getter(BatchUpdateScheduleRequest::creates)).setter(setter(Builder::creates))
            .constructor(BatchScheduleActionCreateRequest::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creates").build()).build();

    private static final SdkField<BatchScheduleActionDeleteRequest> DELETES_FIELD = SdkField
            .<BatchScheduleActionDeleteRequest> builder(MarshallingType.SDK_POJO).memberName("Deletes")
            .getter(getter(BatchUpdateScheduleRequest::deletes)).setter(setter(Builder::deletes))
            .constructor(BatchScheduleActionDeleteRequest::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deletes").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHANNEL_ID_FIELD,
            CREATES_FIELD, DELETES_FIELD));

    private final String channelId;

    private final BatchScheduleActionCreateRequest creates;

    private final BatchScheduleActionDeleteRequest deletes;

    private BatchUpdateScheduleRequest(BuilderImpl builder) {
        super(builder);
        this.channelId = builder.channelId;
        this.creates = builder.creates;
        this.deletes = builder.deletes;
    }

    /**
     * Id of the channel whose schedule is being updated.
     * 
     * @return Id of the channel whose schedule is being updated.
     */
    public final String channelId() {
        return channelId;
    }

    /**
     * Schedule actions to create in the schedule.
     * 
     * @return Schedule actions to create in the schedule.
     */
    public final BatchScheduleActionCreateRequest creates() {
        return creates;
    }

    /**
     * Schedule actions to delete from the schedule.
     * 
     * @return Schedule actions to delete from the schedule.
     */
    public final BatchScheduleActionDeleteRequest deletes() {
        return deletes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(channelId());
        hashCode = 31 * hashCode + Objects.hashCode(creates());
        hashCode = 31 * hashCode + Objects.hashCode(deletes());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchUpdateScheduleRequest)) {
            return false;
        }
        BatchUpdateScheduleRequest other = (BatchUpdateScheduleRequest) obj;
        return Objects.equals(channelId(), other.channelId()) && Objects.equals(creates(), other.creates())
                && Objects.equals(deletes(), other.deletes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchUpdateScheduleRequest").add("ChannelId", channelId()).add("Creates", creates())
                .add("Deletes", deletes()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ChannelId":
            return Optional.ofNullable(clazz.cast(channelId()));
        case "Creates":
            return Optional.ofNullable(clazz.cast(creates()));
        case "Deletes":
            return Optional.ofNullable(clazz.cast(deletes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchUpdateScheduleRequest, T> g) {
        return obj -> g.apply((BatchUpdateScheduleRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MediaLiveRequest.Builder, SdkPojo, CopyableBuilder<Builder, BatchUpdateScheduleRequest> {
        /**
         * Id of the channel whose schedule is being updated.
         * 
         * @param channelId
         *        Id of the channel whose schedule is being updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder channelId(String channelId);

        /**
         * Schedule actions to create in the schedule.
         * 
         * @param creates
         *        Schedule actions to create in the schedule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creates(BatchScheduleActionCreateRequest creates);

        /**
         * Schedule actions to create in the schedule. This is a convenience that creates an instance of the
         * {@link BatchScheduleActionCreateRequest.Builder} avoiding the need to create one manually via
         * {@link BatchScheduleActionCreateRequest#builder()}.
         *
         * When the {@link Consumer} completes, {@link BatchScheduleActionCreateRequest.Builder#build()} is called
         * immediately and its result is passed to {@link #creates(BatchScheduleActionCreateRequest)}.
         * 
         * @param creates
         *        a consumer that will call methods on {@link BatchScheduleActionCreateRequest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #creates(BatchScheduleActionCreateRequest)
         */
        default Builder creates(Consumer<BatchScheduleActionCreateRequest.Builder> creates) {
            return creates(BatchScheduleActionCreateRequest.builder().applyMutation(creates).build());
        }

        /**
         * Schedule actions to delete from the schedule.
         * 
         * @param deletes
         *        Schedule actions to delete from the schedule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deletes(BatchScheduleActionDeleteRequest deletes);

        /**
         * Schedule actions to delete from the schedule. This is a convenience that creates an instance of the
         * {@link BatchScheduleActionDeleteRequest.Builder} avoiding the need to create one manually via
         * {@link BatchScheduleActionDeleteRequest#builder()}.
         *
         * When the {@link Consumer} completes, {@link BatchScheduleActionDeleteRequest.Builder#build()} is called
         * immediately and its result is passed to {@link #deletes(BatchScheduleActionDeleteRequest)}.
         * 
         * @param deletes
         *        a consumer that will call methods on {@link BatchScheduleActionDeleteRequest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #deletes(BatchScheduleActionDeleteRequest)
         */
        default Builder deletes(Consumer<BatchScheduleActionDeleteRequest.Builder> deletes) {
            return deletes(BatchScheduleActionDeleteRequest.builder().applyMutation(deletes).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends MediaLiveRequest.BuilderImpl implements Builder {
        private String channelId;

        private BatchScheduleActionCreateRequest creates;

        private BatchScheduleActionDeleteRequest deletes;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchUpdateScheduleRequest model) {
            super(model);
            channelId(model.channelId);
            creates(model.creates);
            deletes(model.deletes);
        }

        public final String getChannelId() {
            return channelId;
        }

        @Override
        public final Builder channelId(String channelId) {
            this.channelId = channelId;
            return this;
        }

        public final void setChannelId(String channelId) {
            this.channelId = channelId;
        }

        public final BatchScheduleActionCreateRequest.Builder getCreates() {
            return creates != null ? creates.toBuilder() : null;
        }

        @Override
        public final Builder creates(BatchScheduleActionCreateRequest creates) {
            this.creates = creates;
            return this;
        }

        public final void setCreates(BatchScheduleActionCreateRequest.BuilderImpl creates) {
            this.creates = creates != null ? creates.build() : null;
        }

        public final BatchScheduleActionDeleteRequest.Builder getDeletes() {
            return deletes != null ? deletes.toBuilder() : null;
        }

        @Override
        public final Builder deletes(BatchScheduleActionDeleteRequest deletes) {
            this.deletes = deletes;
            return this;
        }

        public final void setDeletes(BatchScheduleActionDeleteRequest.BuilderImpl deletes) {
            this.deletes = deletes != null ? deletes.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public BatchUpdateScheduleRequest build() {
            return new BatchUpdateScheduleRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
