/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * A list of schedule actions to delete.
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchScheduleActionDeleteRequest implements SdkPojo, Serializable,
        ToCopyableBuilder<BatchScheduleActionDeleteRequest.Builder, BatchScheduleActionDeleteRequest> {
    private static final SdkField<List<String>> ACTION_NAMES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ActionNames")
            .getter(getter(BatchScheduleActionDeleteRequest::actionNames))
            .setter(setter(Builder::actionNames))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actionNames").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTION_NAMES_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<String> actionNames;

    private BatchScheduleActionDeleteRequest(BuilderImpl builder) {
        this.actionNames = builder.actionNames;
    }

    /**
     * Returns true if the ActionNames property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasActionNames() {
        return actionNames != null && !(actionNames instanceof SdkAutoConstructList);
    }

    /**
     * A list of schedule actions to delete.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasActionNames()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of schedule actions to delete.
     */
    public final List<String> actionNames() {
        return actionNames;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasActionNames() ? actionNames() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchScheduleActionDeleteRequest)) {
            return false;
        }
        BatchScheduleActionDeleteRequest other = (BatchScheduleActionDeleteRequest) obj;
        return hasActionNames() == other.hasActionNames() && Objects.equals(actionNames(), other.actionNames());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchScheduleActionDeleteRequest").add("ActionNames", hasActionNames() ? actionNames() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ActionNames":
            return Optional.ofNullable(clazz.cast(actionNames()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchScheduleActionDeleteRequest, T> g) {
        return obj -> g.apply((BatchScheduleActionDeleteRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BatchScheduleActionDeleteRequest> {
        /**
         * A list of schedule actions to delete.
         * 
         * @param actionNames
         *        A list of schedule actions to delete.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actionNames(Collection<String> actionNames);

        /**
         * A list of schedule actions to delete.
         * 
         * @param actionNames
         *        A list of schedule actions to delete.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actionNames(String... actionNames);
    }

    static final class BuilderImpl implements Builder {
        private List<String> actionNames = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchScheduleActionDeleteRequest model) {
            actionNames(model.actionNames);
        }

        public final Collection<String> getActionNames() {
            if (actionNames instanceof SdkAutoConstructList) {
                return null;
            }
            return actionNames;
        }

        @Override
        public final Builder actionNames(Collection<String> actionNames) {
            this.actionNames = ___listOf__stringCopier.copy(actionNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actionNames(String... actionNames) {
            actionNames(Arrays.asList(actionNames));
            return this;
        }

        public final void setActionNames(Collection<String> actionNames) {
            this.actionNames = ___listOf__stringCopier.copy(actionNames);
        }

        @Override
        public BatchScheduleActionDeleteRequest build() {
            return new BatchScheduleActionDeleteRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
