/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medialive.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * A request to delete resources
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchDeleteRequest extends MediaLiveRequest implements
        ToCopyableBuilder<BatchDeleteRequest.Builder, BatchDeleteRequest> {
    private static final SdkField<List<String>> CHANNEL_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ChannelIds")
            .getter(getter(BatchDeleteRequest::channelIds))
            .setter(setter(Builder::channelIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("channelIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> INPUT_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("InputIds")
            .getter(getter(BatchDeleteRequest::inputIds))
            .setter(setter(Builder::inputIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> INPUT_SECURITY_GROUP_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("InputSecurityGroupIds")
            .getter(getter(BatchDeleteRequest::inputSecurityGroupIds))
            .setter(setter(Builder::inputSecurityGroupIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputSecurityGroupIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> MULTIPLEX_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("MultiplexIds")
            .getter(getter(BatchDeleteRequest::multiplexIds))
            .setter(setter(Builder::multiplexIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("multiplexIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHANNEL_IDS_FIELD,
            INPUT_IDS_FIELD, INPUT_SECURITY_GROUP_IDS_FIELD, MULTIPLEX_IDS_FIELD));

    private final List<String> channelIds;

    private final List<String> inputIds;

    private final List<String> inputSecurityGroupIds;

    private final List<String> multiplexIds;

    private BatchDeleteRequest(BuilderImpl builder) {
        super(builder);
        this.channelIds = builder.channelIds;
        this.inputIds = builder.inputIds;
        this.inputSecurityGroupIds = builder.inputSecurityGroupIds;
        this.multiplexIds = builder.multiplexIds;
    }

    /**
     * Returns true if the ChannelIds property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasChannelIds() {
        return channelIds != null && !(channelIds instanceof SdkAutoConstructList);
    }

    /**
     * List of channel IDs
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasChannelIds()} to see if a value was sent in this field.
     * </p>
     * 
     * @return List of channel IDs
     */
    public final List<String> channelIds() {
        return channelIds;
    }

    /**
     * Returns true if the InputIds property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasInputIds() {
        return inputIds != null && !(inputIds instanceof SdkAutoConstructList);
    }

    /**
     * List of input IDs
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasInputIds()} to see if a value was sent in this field.
     * </p>
     * 
     * @return List of input IDs
     */
    public final List<String> inputIds() {
        return inputIds;
    }

    /**
     * Returns true if the InputSecurityGroupIds property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasInputSecurityGroupIds() {
        return inputSecurityGroupIds != null && !(inputSecurityGroupIds instanceof SdkAutoConstructList);
    }

    /**
     * List of input security group IDs
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasInputSecurityGroupIds()} to see if a value was sent in this field.
     * </p>
     * 
     * @return List of input security group IDs
     */
    public final List<String> inputSecurityGroupIds() {
        return inputSecurityGroupIds;
    }

    /**
     * Returns true if the MultiplexIds property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasMultiplexIds() {
        return multiplexIds != null && !(multiplexIds instanceof SdkAutoConstructList);
    }

    /**
     * List of multiplex IDs
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasMultiplexIds()} to see if a value was sent in this field.
     * </p>
     * 
     * @return List of multiplex IDs
     */
    public final List<String> multiplexIds() {
        return multiplexIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasChannelIds() ? channelIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasInputIds() ? inputIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasInputSecurityGroupIds() ? inputSecurityGroupIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasMultiplexIds() ? multiplexIds() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchDeleteRequest)) {
            return false;
        }
        BatchDeleteRequest other = (BatchDeleteRequest) obj;
        return hasChannelIds() == other.hasChannelIds() && Objects.equals(channelIds(), other.channelIds())
                && hasInputIds() == other.hasInputIds() && Objects.equals(inputIds(), other.inputIds())
                && hasInputSecurityGroupIds() == other.hasInputSecurityGroupIds()
                && Objects.equals(inputSecurityGroupIds(), other.inputSecurityGroupIds())
                && hasMultiplexIds() == other.hasMultiplexIds() && Objects.equals(multiplexIds(), other.multiplexIds());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchDeleteRequest").add("ChannelIds", hasChannelIds() ? channelIds() : null)
                .add("InputIds", hasInputIds() ? inputIds() : null)
                .add("InputSecurityGroupIds", hasInputSecurityGroupIds() ? inputSecurityGroupIds() : null)
                .add("MultiplexIds", hasMultiplexIds() ? multiplexIds() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ChannelIds":
            return Optional.ofNullable(clazz.cast(channelIds()));
        case "InputIds":
            return Optional.ofNullable(clazz.cast(inputIds()));
        case "InputSecurityGroupIds":
            return Optional.ofNullable(clazz.cast(inputSecurityGroupIds()));
        case "MultiplexIds":
            return Optional.ofNullable(clazz.cast(multiplexIds()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchDeleteRequest, T> g) {
        return obj -> g.apply((BatchDeleteRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MediaLiveRequest.Builder, SdkPojo, CopyableBuilder<Builder, BatchDeleteRequest> {
        /**
         * List of channel IDs
         * 
         * @param channelIds
         *        List of channel IDs
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder channelIds(Collection<String> channelIds);

        /**
         * List of channel IDs
         * 
         * @param channelIds
         *        List of channel IDs
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder channelIds(String... channelIds);

        /**
         * List of input IDs
         * 
         * @param inputIds
         *        List of input IDs
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputIds(Collection<String> inputIds);

        /**
         * List of input IDs
         * 
         * @param inputIds
         *        List of input IDs
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputIds(String... inputIds);

        /**
         * List of input security group IDs
         * 
         * @param inputSecurityGroupIds
         *        List of input security group IDs
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputSecurityGroupIds(Collection<String> inputSecurityGroupIds);

        /**
         * List of input security group IDs
         * 
         * @param inputSecurityGroupIds
         *        List of input security group IDs
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputSecurityGroupIds(String... inputSecurityGroupIds);

        /**
         * List of multiplex IDs
         * 
         * @param multiplexIds
         *        List of multiplex IDs
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder multiplexIds(Collection<String> multiplexIds);

        /**
         * List of multiplex IDs
         * 
         * @param multiplexIds
         *        List of multiplex IDs
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder multiplexIds(String... multiplexIds);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends MediaLiveRequest.BuilderImpl implements Builder {
        private List<String> channelIds = DefaultSdkAutoConstructList.getInstance();

        private List<String> inputIds = DefaultSdkAutoConstructList.getInstance();

        private List<String> inputSecurityGroupIds = DefaultSdkAutoConstructList.getInstance();

        private List<String> multiplexIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchDeleteRequest model) {
            super(model);
            channelIds(model.channelIds);
            inputIds(model.inputIds);
            inputSecurityGroupIds(model.inputSecurityGroupIds);
            multiplexIds(model.multiplexIds);
        }

        public final Collection<String> getChannelIds() {
            if (channelIds instanceof SdkAutoConstructList) {
                return null;
            }
            return channelIds;
        }

        @Override
        public final Builder channelIds(Collection<String> channelIds) {
            this.channelIds = ___listOf__stringCopier.copy(channelIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder channelIds(String... channelIds) {
            channelIds(Arrays.asList(channelIds));
            return this;
        }

        public final void setChannelIds(Collection<String> channelIds) {
            this.channelIds = ___listOf__stringCopier.copy(channelIds);
        }

        public final Collection<String> getInputIds() {
            if (inputIds instanceof SdkAutoConstructList) {
                return null;
            }
            return inputIds;
        }

        @Override
        public final Builder inputIds(Collection<String> inputIds) {
            this.inputIds = ___listOf__stringCopier.copy(inputIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputIds(String... inputIds) {
            inputIds(Arrays.asList(inputIds));
            return this;
        }

        public final void setInputIds(Collection<String> inputIds) {
            this.inputIds = ___listOf__stringCopier.copy(inputIds);
        }

        public final Collection<String> getInputSecurityGroupIds() {
            if (inputSecurityGroupIds instanceof SdkAutoConstructList) {
                return null;
            }
            return inputSecurityGroupIds;
        }

        @Override
        public final Builder inputSecurityGroupIds(Collection<String> inputSecurityGroupIds) {
            this.inputSecurityGroupIds = ___listOf__stringCopier.copy(inputSecurityGroupIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputSecurityGroupIds(String... inputSecurityGroupIds) {
            inputSecurityGroupIds(Arrays.asList(inputSecurityGroupIds));
            return this;
        }

        public final void setInputSecurityGroupIds(Collection<String> inputSecurityGroupIds) {
            this.inputSecurityGroupIds = ___listOf__stringCopier.copy(inputSecurityGroupIds);
        }

        public final Collection<String> getMultiplexIds() {
            if (multiplexIds instanceof SdkAutoConstructList) {
                return null;
            }
            return multiplexIds;
        }

        @Override
        public final Builder multiplexIds(Collection<String> multiplexIds) {
            this.multiplexIds = ___listOf__stringCopier.copy(multiplexIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder multiplexIds(String... multiplexIds) {
            multiplexIds(Arrays.asList(multiplexIds));
            return this;
        }

        public final void setMultiplexIds(Collection<String> multiplexIds) {
            this.multiplexIds = ___listOf__stringCopier.copy(multiplexIds);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public BatchDeleteRequest build() {
            return new BatchDeleteRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
