/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Audio Description
 */
@Generated("software.amazon.awssdk:codegen")
public final class AudioDescription implements SdkPojo, Serializable,
        ToCopyableBuilder<AudioDescription.Builder, AudioDescription> {
    private static final SdkField<AudioNormalizationSettings> AUDIO_NORMALIZATION_SETTINGS_FIELD = SdkField
            .<AudioNormalizationSettings> builder(MarshallingType.SDK_POJO)
            .memberName("AudioNormalizationSettings")
            .getter(getter(AudioDescription::audioNormalizationSettings))
            .setter(setter(Builder::audioNormalizationSettings))
            .constructor(AudioNormalizationSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("audioNormalizationSettings").build())
            .build();

    private static final SdkField<String> AUDIO_SELECTOR_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AudioSelectorName").getter(getter(AudioDescription::audioSelectorName))
            .setter(setter(Builder::audioSelectorName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("audioSelectorName").build()).build();

    private static final SdkField<String> AUDIO_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AudioType").getter(getter(AudioDescription::audioTypeAsString)).setter(setter(Builder::audioType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("audioType").build()).build();

    private static final SdkField<String> AUDIO_TYPE_CONTROL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AudioTypeControl").getter(getter(AudioDescription::audioTypeControlAsString))
            .setter(setter(Builder::audioTypeControl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("audioTypeControl").build()).build();

    private static final SdkField<AudioCodecSettings> CODEC_SETTINGS_FIELD = SdkField
            .<AudioCodecSettings> builder(MarshallingType.SDK_POJO).memberName("CodecSettings")
            .getter(getter(AudioDescription::codecSettings)).setter(setter(Builder::codecSettings))
            .constructor(AudioCodecSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("codecSettings").build()).build();

    private static final SdkField<String> LANGUAGE_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LanguageCode").getter(getter(AudioDescription::languageCode)).setter(setter(Builder::languageCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("languageCode").build()).build();

    private static final SdkField<String> LANGUAGE_CODE_CONTROL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LanguageCodeControl").getter(getter(AudioDescription::languageCodeControlAsString))
            .setter(setter(Builder::languageCodeControl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("languageCodeControl").build())
            .build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(AudioDescription::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<RemixSettings> REMIX_SETTINGS_FIELD = SdkField
            .<RemixSettings> builder(MarshallingType.SDK_POJO).memberName("RemixSettings")
            .getter(getter(AudioDescription::remixSettings)).setter(setter(Builder::remixSettings))
            .constructor(RemixSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("remixSettings").build()).build();

    private static final SdkField<String> STREAM_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StreamName").getter(getter(AudioDescription::streamName)).setter(setter(Builder::streamName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("streamName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            AUDIO_NORMALIZATION_SETTINGS_FIELD, AUDIO_SELECTOR_NAME_FIELD, AUDIO_TYPE_FIELD, AUDIO_TYPE_CONTROL_FIELD,
            CODEC_SETTINGS_FIELD, LANGUAGE_CODE_FIELD, LANGUAGE_CODE_CONTROL_FIELD, NAME_FIELD, REMIX_SETTINGS_FIELD,
            STREAM_NAME_FIELD));

    private static final long serialVersionUID = 1L;

    private final AudioNormalizationSettings audioNormalizationSettings;

    private final String audioSelectorName;

    private final String audioType;

    private final String audioTypeControl;

    private final AudioCodecSettings codecSettings;

    private final String languageCode;

    private final String languageCodeControl;

    private final String name;

    private final RemixSettings remixSettings;

    private final String streamName;

    private AudioDescription(BuilderImpl builder) {
        this.audioNormalizationSettings = builder.audioNormalizationSettings;
        this.audioSelectorName = builder.audioSelectorName;
        this.audioType = builder.audioType;
        this.audioTypeControl = builder.audioTypeControl;
        this.codecSettings = builder.codecSettings;
        this.languageCode = builder.languageCode;
        this.languageCodeControl = builder.languageCodeControl;
        this.name = builder.name;
        this.remixSettings = builder.remixSettings;
        this.streamName = builder.streamName;
    }

    /**
     * Advanced audio normalization settings.
     * 
     * @return Advanced audio normalization settings.
     */
    public final AudioNormalizationSettings audioNormalizationSettings() {
        return audioNormalizationSettings;
    }

    /**
     * The name of the AudioSelector used as the source for this AudioDescription.
     * 
     * @return The name of the AudioSelector used as the source for this AudioDescription.
     */
    public final String audioSelectorName() {
        return audioSelectorName;
    }

    /**
     * Applies only if audioTypeControl is useConfigured. The values for audioType are defined in ISO-IEC 13818-1.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #audioType} will
     * return {@link AudioType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #audioTypeAsString}.
     * </p>
     * 
     * @return Applies only if audioTypeControl is useConfigured. The values for audioType are defined in ISO-IEC
     *         13818-1.
     * @see AudioType
     */
    public final AudioType audioType() {
        return AudioType.fromValue(audioType);
    }

    /**
     * Applies only if audioTypeControl is useConfigured. The values for audioType are defined in ISO-IEC 13818-1.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #audioType} will
     * return {@link AudioType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #audioTypeAsString}.
     * </p>
     * 
     * @return Applies only if audioTypeControl is useConfigured. The values for audioType are defined in ISO-IEC
     *         13818-1.
     * @see AudioType
     */
    public final String audioTypeAsString() {
        return audioType;
    }

    /**
     * Determines how audio type is determined. followInput: If the input contains an ISO 639 audioType, then that value
     * is passed through to the output. If the input contains no ISO 639 audioType, the value in Audio Type is included
     * in the output. useConfigured: The value in Audio Type is included in the output. Note that this field and
     * audioType are both ignored if inputType is broadcasterMixedAd.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #audioTypeControl}
     * will return {@link AudioDescriptionAudioTypeControl#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #audioTypeControlAsString}.
     * </p>
     * 
     * @return Determines how audio type is determined. followInput: If the input contains an ISO 639 audioType, then
     *         that value is passed through to the output. If the input contains no ISO 639 audioType, the value in
     *         Audio Type is included in the output. useConfigured: The value in Audio Type is included in the output.
     *         Note that this field and audioType are both ignored if inputType is broadcasterMixedAd.
     * @see AudioDescriptionAudioTypeControl
     */
    public final AudioDescriptionAudioTypeControl audioTypeControl() {
        return AudioDescriptionAudioTypeControl.fromValue(audioTypeControl);
    }

    /**
     * Determines how audio type is determined. followInput: If the input contains an ISO 639 audioType, then that value
     * is passed through to the output. If the input contains no ISO 639 audioType, the value in Audio Type is included
     * in the output. useConfigured: The value in Audio Type is included in the output. Note that this field and
     * audioType are both ignored if inputType is broadcasterMixedAd.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #audioTypeControl}
     * will return {@link AudioDescriptionAudioTypeControl#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #audioTypeControlAsString}.
     * </p>
     * 
     * @return Determines how audio type is determined. followInput: If the input contains an ISO 639 audioType, then
     *         that value is passed through to the output. If the input contains no ISO 639 audioType, the value in
     *         Audio Type is included in the output. useConfigured: The value in Audio Type is included in the output.
     *         Note that this field and audioType are both ignored if inputType is broadcasterMixedAd.
     * @see AudioDescriptionAudioTypeControl
     */
    public final String audioTypeControlAsString() {
        return audioTypeControl;
    }

    /**
     * Audio codec settings.
     * 
     * @return Audio codec settings.
     */
    public final AudioCodecSettings codecSettings() {
        return codecSettings;
    }

    /**
     * RFC 5646 language code representing the language of the audio output track. Only used if languageControlMode is
     * useConfigured, or there is no ISO 639 language code specified in the input.
     * 
     * @return RFC 5646 language code representing the language of the audio output track. Only used if
     *         languageControlMode is useConfigured, or there is no ISO 639 language code specified in the input.
     */
    public final String languageCode() {
        return languageCode;
    }

    /**
     * Choosing followInput will cause the ISO 639 language code of the output to follow the ISO 639 language code of
     * the input. The languageCode will be used when useConfigured is set, or when followInput is selected but there is
     * no ISO 639 language code specified by the input.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #languageCodeControl} will return {@link AudioDescriptionLanguageCodeControl#UNKNOWN_TO_SDK_VERSION}. The
     * raw value returned by the service is available from {@link #languageCodeControlAsString}.
     * </p>
     * 
     * @return Choosing followInput will cause the ISO 639 language code of the output to follow the ISO 639 language
     *         code of the input. The languageCode will be used when useConfigured is set, or when followInput is
     *         selected but there is no ISO 639 language code specified by the input.
     * @see AudioDescriptionLanguageCodeControl
     */
    public final AudioDescriptionLanguageCodeControl languageCodeControl() {
        return AudioDescriptionLanguageCodeControl.fromValue(languageCodeControl);
    }

    /**
     * Choosing followInput will cause the ISO 639 language code of the output to follow the ISO 639 language code of
     * the input. The languageCode will be used when useConfigured is set, or when followInput is selected but there is
     * no ISO 639 language code specified by the input.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #languageCodeControl} will return {@link AudioDescriptionLanguageCodeControl#UNKNOWN_TO_SDK_VERSION}. The
     * raw value returned by the service is available from {@link #languageCodeControlAsString}.
     * </p>
     * 
     * @return Choosing followInput will cause the ISO 639 language code of the output to follow the ISO 639 language
     *         code of the input. The languageCode will be used when useConfigured is set, or when followInput is
     *         selected but there is no ISO 639 language code specified by the input.
     * @see AudioDescriptionLanguageCodeControl
     */
    public final String languageCodeControlAsString() {
        return languageCodeControl;
    }

    /**
     * The name of this AudioDescription. Outputs will use this name to uniquely identify this AudioDescription.
     * Description names should be unique within this Live Event.
     * 
     * @return The name of this AudioDescription. Outputs will use this name to uniquely identify this AudioDescription.
     *         Description names should be unique within this Live Event.
     */
    public final String name() {
        return name;
    }

    /**
     * Settings that control how input audio channels are remixed into the output audio channels.
     * 
     * @return Settings that control how input audio channels are remixed into the output audio channels.
     */
    public final RemixSettings remixSettings() {
        return remixSettings;
    }

    /**
     * Used for MS Smooth and Apple HLS outputs. Indicates the name displayed by the player (eg. English, or Director
     * Commentary).
     * 
     * @return Used for MS Smooth and Apple HLS outputs. Indicates the name displayed by the player (eg. English, or
     *         Director Commentary).
     */
    public final String streamName() {
        return streamName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(audioNormalizationSettings());
        hashCode = 31 * hashCode + Objects.hashCode(audioSelectorName());
        hashCode = 31 * hashCode + Objects.hashCode(audioTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(audioTypeControlAsString());
        hashCode = 31 * hashCode + Objects.hashCode(codecSettings());
        hashCode = 31 * hashCode + Objects.hashCode(languageCode());
        hashCode = 31 * hashCode + Objects.hashCode(languageCodeControlAsString());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(remixSettings());
        hashCode = 31 * hashCode + Objects.hashCode(streamName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AudioDescription)) {
            return false;
        }
        AudioDescription other = (AudioDescription) obj;
        return Objects.equals(audioNormalizationSettings(), other.audioNormalizationSettings())
                && Objects.equals(audioSelectorName(), other.audioSelectorName())
                && Objects.equals(audioTypeAsString(), other.audioTypeAsString())
                && Objects.equals(audioTypeControlAsString(), other.audioTypeControlAsString())
                && Objects.equals(codecSettings(), other.codecSettings()) && Objects.equals(languageCode(), other.languageCode())
                && Objects.equals(languageCodeControlAsString(), other.languageCodeControlAsString())
                && Objects.equals(name(), other.name()) && Objects.equals(remixSettings(), other.remixSettings())
                && Objects.equals(streamName(), other.streamName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AudioDescription").add("AudioNormalizationSettings", audioNormalizationSettings())
                .add("AudioSelectorName", audioSelectorName()).add("AudioType", audioTypeAsString())
                .add("AudioTypeControl", audioTypeControlAsString()).add("CodecSettings", codecSettings())
                .add("LanguageCode", languageCode()).add("LanguageCodeControl", languageCodeControlAsString())
                .add("Name", name()).add("RemixSettings", remixSettings()).add("StreamName", streamName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AudioNormalizationSettings":
            return Optional.ofNullable(clazz.cast(audioNormalizationSettings()));
        case "AudioSelectorName":
            return Optional.ofNullable(clazz.cast(audioSelectorName()));
        case "AudioType":
            return Optional.ofNullable(clazz.cast(audioTypeAsString()));
        case "AudioTypeControl":
            return Optional.ofNullable(clazz.cast(audioTypeControlAsString()));
        case "CodecSettings":
            return Optional.ofNullable(clazz.cast(codecSettings()));
        case "LanguageCode":
            return Optional.ofNullable(clazz.cast(languageCode()));
        case "LanguageCodeControl":
            return Optional.ofNullable(clazz.cast(languageCodeControlAsString()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "RemixSettings":
            return Optional.ofNullable(clazz.cast(remixSettings()));
        case "StreamName":
            return Optional.ofNullable(clazz.cast(streamName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AudioDescription, T> g) {
        return obj -> g.apply((AudioDescription) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AudioDescription> {
        /**
         * Advanced audio normalization settings.
         * 
         * @param audioNormalizationSettings
         *        Advanced audio normalization settings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder audioNormalizationSettings(AudioNormalizationSettings audioNormalizationSettings);

        /**
         * Advanced audio normalization settings. This is a convenience that creates an instance of the
         * {@link AudioNormalizationSettings.Builder} avoiding the need to create one manually via
         * {@link AudioNormalizationSettings#builder()}.
         *
         * When the {@link Consumer} completes, {@link AudioNormalizationSettings.Builder#build()} is called immediately
         * and its result is passed to {@link #audioNormalizationSettings(AudioNormalizationSettings)}.
         * 
         * @param audioNormalizationSettings
         *        a consumer that will call methods on {@link AudioNormalizationSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #audioNormalizationSettings(AudioNormalizationSettings)
         */
        default Builder audioNormalizationSettings(Consumer<AudioNormalizationSettings.Builder> audioNormalizationSettings) {
            return audioNormalizationSettings(AudioNormalizationSettings.builder().applyMutation(audioNormalizationSettings)
                    .build());
        }

        /**
         * The name of the AudioSelector used as the source for this AudioDescription.
         * 
         * @param audioSelectorName
         *        The name of the AudioSelector used as the source for this AudioDescription.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder audioSelectorName(String audioSelectorName);

        /**
         * Applies only if audioTypeControl is useConfigured. The values for audioType are defined in ISO-IEC 13818-1.
         * 
         * @param audioType
         *        Applies only if audioTypeControl is useConfigured. The values for audioType are defined in ISO-IEC
         *        13818-1.
         * @see AudioType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AudioType
         */
        Builder audioType(String audioType);

        /**
         * Applies only if audioTypeControl is useConfigured. The values for audioType are defined in ISO-IEC 13818-1.
         * 
         * @param audioType
         *        Applies only if audioTypeControl is useConfigured. The values for audioType are defined in ISO-IEC
         *        13818-1.
         * @see AudioType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AudioType
         */
        Builder audioType(AudioType audioType);

        /**
         * Determines how audio type is determined. followInput: If the input contains an ISO 639 audioType, then that
         * value is passed through to the output. If the input contains no ISO 639 audioType, the value in Audio Type is
         * included in the output. useConfigured: The value in Audio Type is included in the output. Note that this
         * field and audioType are both ignored if inputType is broadcasterMixedAd.
         * 
         * @param audioTypeControl
         *        Determines how audio type is determined. followInput: If the input contains an ISO 639 audioType, then
         *        that value is passed through to the output. If the input contains no ISO 639 audioType, the value in
         *        Audio Type is included in the output. useConfigured: The value in Audio Type is included in the
         *        output. Note that this field and audioType are both ignored if inputType is broadcasterMixedAd.
         * @see AudioDescriptionAudioTypeControl
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AudioDescriptionAudioTypeControl
         */
        Builder audioTypeControl(String audioTypeControl);

        /**
         * Determines how audio type is determined. followInput: If the input contains an ISO 639 audioType, then that
         * value is passed through to the output. If the input contains no ISO 639 audioType, the value in Audio Type is
         * included in the output. useConfigured: The value in Audio Type is included in the output. Note that this
         * field and audioType are both ignored if inputType is broadcasterMixedAd.
         * 
         * @param audioTypeControl
         *        Determines how audio type is determined. followInput: If the input contains an ISO 639 audioType, then
         *        that value is passed through to the output. If the input contains no ISO 639 audioType, the value in
         *        Audio Type is included in the output. useConfigured: The value in Audio Type is included in the
         *        output. Note that this field and audioType are both ignored if inputType is broadcasterMixedAd.
         * @see AudioDescriptionAudioTypeControl
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AudioDescriptionAudioTypeControl
         */
        Builder audioTypeControl(AudioDescriptionAudioTypeControl audioTypeControl);

        /**
         * Audio codec settings.
         * 
         * @param codecSettings
         *        Audio codec settings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder codecSettings(AudioCodecSettings codecSettings);

        /**
         * Audio codec settings. This is a convenience that creates an instance of the
         * {@link AudioCodecSettings.Builder} avoiding the need to create one manually via
         * {@link AudioCodecSettings#builder()}.
         *
         * When the {@link Consumer} completes, {@link AudioCodecSettings.Builder#build()} is called immediately and its
         * result is passed to {@link #codecSettings(AudioCodecSettings)}.
         * 
         * @param codecSettings
         *        a consumer that will call methods on {@link AudioCodecSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #codecSettings(AudioCodecSettings)
         */
        default Builder codecSettings(Consumer<AudioCodecSettings.Builder> codecSettings) {
            return codecSettings(AudioCodecSettings.builder().applyMutation(codecSettings).build());
        }

        /**
         * RFC 5646 language code representing the language of the audio output track. Only used if languageControlMode
         * is useConfigured, or there is no ISO 639 language code specified in the input.
         * 
         * @param languageCode
         *        RFC 5646 language code representing the language of the audio output track. Only used if
         *        languageControlMode is useConfigured, or there is no ISO 639 language code specified in the input.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder languageCode(String languageCode);

        /**
         * Choosing followInput will cause the ISO 639 language code of the output to follow the ISO 639 language code
         * of the input. The languageCode will be used when useConfigured is set, or when followInput is selected but
         * there is no ISO 639 language code specified by the input.
         * 
         * @param languageCodeControl
         *        Choosing followInput will cause the ISO 639 language code of the output to follow the ISO 639 language
         *        code of the input. The languageCode will be used when useConfigured is set, or when followInput is
         *        selected but there is no ISO 639 language code specified by the input.
         * @see AudioDescriptionLanguageCodeControl
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AudioDescriptionLanguageCodeControl
         */
        Builder languageCodeControl(String languageCodeControl);

        /**
         * Choosing followInput will cause the ISO 639 language code of the output to follow the ISO 639 language code
         * of the input. The languageCode will be used when useConfigured is set, or when followInput is selected but
         * there is no ISO 639 language code specified by the input.
         * 
         * @param languageCodeControl
         *        Choosing followInput will cause the ISO 639 language code of the output to follow the ISO 639 language
         *        code of the input. The languageCode will be used when useConfigured is set, or when followInput is
         *        selected but there is no ISO 639 language code specified by the input.
         * @see AudioDescriptionLanguageCodeControl
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AudioDescriptionLanguageCodeControl
         */
        Builder languageCodeControl(AudioDescriptionLanguageCodeControl languageCodeControl);

        /**
         * The name of this AudioDescription. Outputs will use this name to uniquely identify this AudioDescription.
         * Description names should be unique within this Live Event.
         * 
         * @param name
         *        The name of this AudioDescription. Outputs will use this name to uniquely identify this
         *        AudioDescription. Description names should be unique within this Live Event.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * Settings that control how input audio channels are remixed into the output audio channels.
         * 
         * @param remixSettings
         *        Settings that control how input audio channels are remixed into the output audio channels.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder remixSettings(RemixSettings remixSettings);

        /**
         * Settings that control how input audio channels are remixed into the output audio channels. This is a
         * convenience that creates an instance of the {@link RemixSettings.Builder} avoiding the need to create one
         * manually via {@link RemixSettings#builder()}.
         *
         * When the {@link Consumer} completes, {@link RemixSettings.Builder#build()} is called immediately and its
         * result is passed to {@link #remixSettings(RemixSettings)}.
         * 
         * @param remixSettings
         *        a consumer that will call methods on {@link RemixSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #remixSettings(RemixSettings)
         */
        default Builder remixSettings(Consumer<RemixSettings.Builder> remixSettings) {
            return remixSettings(RemixSettings.builder().applyMutation(remixSettings).build());
        }

        /**
         * Used for MS Smooth and Apple HLS outputs. Indicates the name displayed by the player (eg. English, or
         * Director Commentary).
         * 
         * @param streamName
         *        Used for MS Smooth and Apple HLS outputs. Indicates the name displayed by the player (eg. English, or
         *        Director Commentary).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder streamName(String streamName);
    }

    static final class BuilderImpl implements Builder {
        private AudioNormalizationSettings audioNormalizationSettings;

        private String audioSelectorName;

        private String audioType;

        private String audioTypeControl;

        private AudioCodecSettings codecSettings;

        private String languageCode;

        private String languageCodeControl;

        private String name;

        private RemixSettings remixSettings;

        private String streamName;

        private BuilderImpl() {
        }

        private BuilderImpl(AudioDescription model) {
            audioNormalizationSettings(model.audioNormalizationSettings);
            audioSelectorName(model.audioSelectorName);
            audioType(model.audioType);
            audioTypeControl(model.audioTypeControl);
            codecSettings(model.codecSettings);
            languageCode(model.languageCode);
            languageCodeControl(model.languageCodeControl);
            name(model.name);
            remixSettings(model.remixSettings);
            streamName(model.streamName);
        }

        public final AudioNormalizationSettings.Builder getAudioNormalizationSettings() {
            return audioNormalizationSettings != null ? audioNormalizationSettings.toBuilder() : null;
        }

        @Override
        public final Builder audioNormalizationSettings(AudioNormalizationSettings audioNormalizationSettings) {
            this.audioNormalizationSettings = audioNormalizationSettings;
            return this;
        }

        public final void setAudioNormalizationSettings(AudioNormalizationSettings.BuilderImpl audioNormalizationSettings) {
            this.audioNormalizationSettings = audioNormalizationSettings != null ? audioNormalizationSettings.build() : null;
        }

        public final String getAudioSelectorName() {
            return audioSelectorName;
        }

        @Override
        public final Builder audioSelectorName(String audioSelectorName) {
            this.audioSelectorName = audioSelectorName;
            return this;
        }

        public final void setAudioSelectorName(String audioSelectorName) {
            this.audioSelectorName = audioSelectorName;
        }

        public final String getAudioType() {
            return audioType;
        }

        @Override
        public final Builder audioType(String audioType) {
            this.audioType = audioType;
            return this;
        }

        @Override
        public final Builder audioType(AudioType audioType) {
            this.audioType(audioType == null ? null : audioType.toString());
            return this;
        }

        public final void setAudioType(String audioType) {
            this.audioType = audioType;
        }

        public final String getAudioTypeControl() {
            return audioTypeControl;
        }

        @Override
        public final Builder audioTypeControl(String audioTypeControl) {
            this.audioTypeControl = audioTypeControl;
            return this;
        }

        @Override
        public final Builder audioTypeControl(AudioDescriptionAudioTypeControl audioTypeControl) {
            this.audioTypeControl(audioTypeControl == null ? null : audioTypeControl.toString());
            return this;
        }

        public final void setAudioTypeControl(String audioTypeControl) {
            this.audioTypeControl = audioTypeControl;
        }

        public final AudioCodecSettings.Builder getCodecSettings() {
            return codecSettings != null ? codecSettings.toBuilder() : null;
        }

        @Override
        public final Builder codecSettings(AudioCodecSettings codecSettings) {
            this.codecSettings = codecSettings;
            return this;
        }

        public final void setCodecSettings(AudioCodecSettings.BuilderImpl codecSettings) {
            this.codecSettings = codecSettings != null ? codecSettings.build() : null;
        }

        public final String getLanguageCode() {
            return languageCode;
        }

        @Override
        public final Builder languageCode(String languageCode) {
            this.languageCode = languageCode;
            return this;
        }

        public final void setLanguageCode(String languageCode) {
            this.languageCode = languageCode;
        }

        public final String getLanguageCodeControl() {
            return languageCodeControl;
        }

        @Override
        public final Builder languageCodeControl(String languageCodeControl) {
            this.languageCodeControl = languageCodeControl;
            return this;
        }

        @Override
        public final Builder languageCodeControl(AudioDescriptionLanguageCodeControl languageCodeControl) {
            this.languageCodeControl(languageCodeControl == null ? null : languageCodeControl.toString());
            return this;
        }

        public final void setLanguageCodeControl(String languageCodeControl) {
            this.languageCodeControl = languageCodeControl;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final RemixSettings.Builder getRemixSettings() {
            return remixSettings != null ? remixSettings.toBuilder() : null;
        }

        @Override
        public final Builder remixSettings(RemixSettings remixSettings) {
            this.remixSettings = remixSettings;
            return this;
        }

        public final void setRemixSettings(RemixSettings.BuilderImpl remixSettings) {
            this.remixSettings = remixSettings != null ? remixSettings.build() : null;
        }

        public final String getStreamName() {
            return streamName;
        }

        @Override
        public final Builder streamName(String streamName) {
            this.streamName = streamName;
            return this;
        }

        public final void setStreamName(String streamName) {
            this.streamName = streamName;
        }

        @Override
        public AudioDescription build() {
            return new AudioDescription(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
