/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Aac Settings
 */
@Generated("software.amazon.awssdk:codegen")
public final class AacSettings implements SdkPojo, Serializable, ToCopyableBuilder<AacSettings.Builder, AacSettings> {
    private static final SdkField<Double> BITRATE_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE).memberName("Bitrate")
            .getter(getter(AacSettings::bitrate)).setter(setter(Builder::bitrate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bitrate").build()).build();

    private static final SdkField<String> CODING_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CodingMode").getter(getter(AacSettings::codingModeAsString)).setter(setter(Builder::codingMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("codingMode").build()).build();

    private static final SdkField<String> INPUT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InputType").getter(getter(AacSettings::inputTypeAsString)).setter(setter(Builder::inputType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputType").build()).build();

    private static final SdkField<String> PROFILE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Profile")
            .getter(getter(AacSettings::profileAsString)).setter(setter(Builder::profile))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("profile").build()).build();

    private static final SdkField<String> RATE_CONTROL_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RateControlMode").getter(getter(AacSettings::rateControlModeAsString))
            .setter(setter(Builder::rateControlMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rateControlMode").build()).build();

    private static final SdkField<String> RAW_FORMAT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RawFormat").getter(getter(AacSettings::rawFormatAsString)).setter(setter(Builder::rawFormat))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rawFormat").build()).build();

    private static final SdkField<Double> SAMPLE_RATE_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("SampleRate").getter(getter(AacSettings::sampleRate)).setter(setter(Builder::sampleRate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sampleRate").build()).build();

    private static final SdkField<String> SPEC_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Spec")
            .getter(getter(AacSettings::specAsString)).setter(setter(Builder::spec))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("spec").build()).build();

    private static final SdkField<String> VBR_QUALITY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VbrQuality").getter(getter(AacSettings::vbrQualityAsString)).setter(setter(Builder::vbrQuality))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vbrQuality").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BITRATE_FIELD,
            CODING_MODE_FIELD, INPUT_TYPE_FIELD, PROFILE_FIELD, RATE_CONTROL_MODE_FIELD, RAW_FORMAT_FIELD, SAMPLE_RATE_FIELD,
            SPEC_FIELD, VBR_QUALITY_FIELD));

    private static final long serialVersionUID = 1L;

    private final Double bitrate;

    private final String codingMode;

    private final String inputType;

    private final String profile;

    private final String rateControlMode;

    private final String rawFormat;

    private final Double sampleRate;

    private final String spec;

    private final String vbrQuality;

    private AacSettings(BuilderImpl builder) {
        this.bitrate = builder.bitrate;
        this.codingMode = builder.codingMode;
        this.inputType = builder.inputType;
        this.profile = builder.profile;
        this.rateControlMode = builder.rateControlMode;
        this.rawFormat = builder.rawFormat;
        this.sampleRate = builder.sampleRate;
        this.spec = builder.spec;
        this.vbrQuality = builder.vbrQuality;
    }

    /**
     * Average bitrate in bits/second. Valid values depend on rate control mode and profile.
     * 
     * @return Average bitrate in bits/second. Valid values depend on rate control mode and profile.
     */
    public final Double bitrate() {
        return bitrate;
    }

    /**
     * Mono, Stereo, or 5.1 channel layout. Valid values depend on rate control mode and profile. The adReceiverMix
     * setting receives a stereo description plus control track and emits a mono AAC encode of the description track,
     * with control data emitted in the PES header as per ETSI TS 101 154 Annex E.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #codingMode} will
     * return {@link AacCodingMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #codingModeAsString}.
     * </p>
     * 
     * @return Mono, Stereo, or 5.1 channel layout. Valid values depend on rate control mode and profile. The
     *         adReceiverMix setting receives a stereo description plus control track and emits a mono AAC encode of the
     *         description track, with control data emitted in the PES header as per ETSI TS 101 154 Annex E.
     * @see AacCodingMode
     */
    public final AacCodingMode codingMode() {
        return AacCodingMode.fromValue(codingMode);
    }

    /**
     * Mono, Stereo, or 5.1 channel layout. Valid values depend on rate control mode and profile. The adReceiverMix
     * setting receives a stereo description plus control track and emits a mono AAC encode of the description track,
     * with control data emitted in the PES header as per ETSI TS 101 154 Annex E.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #codingMode} will
     * return {@link AacCodingMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #codingModeAsString}.
     * </p>
     * 
     * @return Mono, Stereo, or 5.1 channel layout. Valid values depend on rate control mode and profile. The
     *         adReceiverMix setting receives a stereo description plus control track and emits a mono AAC encode of the
     *         description track, with control data emitted in the PES header as per ETSI TS 101 154 Annex E.
     * @see AacCodingMode
     */
    public final String codingModeAsString() {
        return codingMode;
    }

    /**
     * Set to "broadcasterMixedAd" when input contains pre-mixed main audio + AD (narration) as a stereo pair. The Audio
     * Type field (audioType) will be set to 3, which signals to downstream systems that this stream contains
     * "broadcaster mixed AD". Note that the input received by the encoder must contain pre-mixed audio; the encoder
     * does not perform the mixing. The values in audioTypeControl and audioType (in AudioDescription) are ignored when
     * set to broadcasterMixedAd.
     *
     * Leave set to "normal" when input does not contain pre-mixed audio + AD.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #inputType} will
     * return {@link AacInputType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #inputTypeAsString}.
     * </p>
     * 
     * @return Set to "broadcasterMixedAd" when input contains pre-mixed main audio + AD (narration) as a stereo pair.
     *         The Audio Type field (audioType) will be set to 3, which signals to downstream systems that this stream
     *         contains "broadcaster mixed AD". Note that the input received by the encoder must contain pre-mixed
     *         audio; the encoder does not perform the mixing. The values in audioTypeControl and audioType (in
     *         AudioDescription) are ignored when set to broadcasterMixedAd.
     *
     *         Leave set to "normal" when input does not contain pre-mixed audio + AD.
     * @see AacInputType
     */
    public final AacInputType inputType() {
        return AacInputType.fromValue(inputType);
    }

    /**
     * Set to "broadcasterMixedAd" when input contains pre-mixed main audio + AD (narration) as a stereo pair. The Audio
     * Type field (audioType) will be set to 3, which signals to downstream systems that this stream contains
     * "broadcaster mixed AD". Note that the input received by the encoder must contain pre-mixed audio; the encoder
     * does not perform the mixing. The values in audioTypeControl and audioType (in AudioDescription) are ignored when
     * set to broadcasterMixedAd.
     *
     * Leave set to "normal" when input does not contain pre-mixed audio + AD.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #inputType} will
     * return {@link AacInputType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #inputTypeAsString}.
     * </p>
     * 
     * @return Set to "broadcasterMixedAd" when input contains pre-mixed main audio + AD (narration) as a stereo pair.
     *         The Audio Type field (audioType) will be set to 3, which signals to downstream systems that this stream
     *         contains "broadcaster mixed AD". Note that the input received by the encoder must contain pre-mixed
     *         audio; the encoder does not perform the mixing. The values in audioTypeControl and audioType (in
     *         AudioDescription) are ignored when set to broadcasterMixedAd.
     *
     *         Leave set to "normal" when input does not contain pre-mixed audio + AD.
     * @see AacInputType
     */
    public final String inputTypeAsString() {
        return inputType;
    }

    /**
     * AAC Profile.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #profile} will
     * return {@link AacProfile#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #profileAsString}.
     * </p>
     * 
     * @return AAC Profile.
     * @see AacProfile
     */
    public final AacProfile profile() {
        return AacProfile.fromValue(profile);
    }

    /**
     * AAC Profile.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #profile} will
     * return {@link AacProfile#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #profileAsString}.
     * </p>
     * 
     * @return AAC Profile.
     * @see AacProfile
     */
    public final String profileAsString() {
        return profile;
    }

    /**
     * Rate Control Mode.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #rateControlMode}
     * will return {@link AacRateControlMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #rateControlModeAsString}.
     * </p>
     * 
     * @return Rate Control Mode.
     * @see AacRateControlMode
     */
    public final AacRateControlMode rateControlMode() {
        return AacRateControlMode.fromValue(rateControlMode);
    }

    /**
     * Rate Control Mode.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #rateControlMode}
     * will return {@link AacRateControlMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #rateControlModeAsString}.
     * </p>
     * 
     * @return Rate Control Mode.
     * @see AacRateControlMode
     */
    public final String rateControlModeAsString() {
        return rateControlMode;
    }

    /**
     * Sets LATM / LOAS AAC output for raw containers.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #rawFormat} will
     * return {@link AacRawFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #rawFormatAsString}.
     * </p>
     * 
     * @return Sets LATM / LOAS AAC output for raw containers.
     * @see AacRawFormat
     */
    public final AacRawFormat rawFormat() {
        return AacRawFormat.fromValue(rawFormat);
    }

    /**
     * Sets LATM / LOAS AAC output for raw containers.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #rawFormat} will
     * return {@link AacRawFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #rawFormatAsString}.
     * </p>
     * 
     * @return Sets LATM / LOAS AAC output for raw containers.
     * @see AacRawFormat
     */
    public final String rawFormatAsString() {
        return rawFormat;
    }

    /**
     * Sample rate in Hz. Valid values depend on rate control mode and profile.
     * 
     * @return Sample rate in Hz. Valid values depend on rate control mode and profile.
     */
    public final Double sampleRate() {
        return sampleRate;
    }

    /**
     * Use MPEG-2 AAC audio instead of MPEG-4 AAC audio for raw or MPEG-2 Transport Stream containers.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #spec} will return
     * {@link AacSpec#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #specAsString}.
     * </p>
     * 
     * @return Use MPEG-2 AAC audio instead of MPEG-4 AAC audio for raw or MPEG-2 Transport Stream containers.
     * @see AacSpec
     */
    public final AacSpec spec() {
        return AacSpec.fromValue(spec);
    }

    /**
     * Use MPEG-2 AAC audio instead of MPEG-4 AAC audio for raw or MPEG-2 Transport Stream containers.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #spec} will return
     * {@link AacSpec#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #specAsString}.
     * </p>
     * 
     * @return Use MPEG-2 AAC audio instead of MPEG-4 AAC audio for raw or MPEG-2 Transport Stream containers.
     * @see AacSpec
     */
    public final String specAsString() {
        return spec;
    }

    /**
     * VBR Quality Level - Only used if rateControlMode is VBR.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #vbrQuality} will
     * return {@link AacVbrQuality#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #vbrQualityAsString}.
     * </p>
     * 
     * @return VBR Quality Level - Only used if rateControlMode is VBR.
     * @see AacVbrQuality
     */
    public final AacVbrQuality vbrQuality() {
        return AacVbrQuality.fromValue(vbrQuality);
    }

    /**
     * VBR Quality Level - Only used if rateControlMode is VBR.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #vbrQuality} will
     * return {@link AacVbrQuality#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #vbrQualityAsString}.
     * </p>
     * 
     * @return VBR Quality Level - Only used if rateControlMode is VBR.
     * @see AacVbrQuality
     */
    public final String vbrQualityAsString() {
        return vbrQuality;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(bitrate());
        hashCode = 31 * hashCode + Objects.hashCode(codingModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(inputTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(profileAsString());
        hashCode = 31 * hashCode + Objects.hashCode(rateControlModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(rawFormatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(sampleRate());
        hashCode = 31 * hashCode + Objects.hashCode(specAsString());
        hashCode = 31 * hashCode + Objects.hashCode(vbrQualityAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AacSettings)) {
            return false;
        }
        AacSettings other = (AacSettings) obj;
        return Objects.equals(bitrate(), other.bitrate()) && Objects.equals(codingModeAsString(), other.codingModeAsString())
                && Objects.equals(inputTypeAsString(), other.inputTypeAsString())
                && Objects.equals(profileAsString(), other.profileAsString())
                && Objects.equals(rateControlModeAsString(), other.rateControlModeAsString())
                && Objects.equals(rawFormatAsString(), other.rawFormatAsString())
                && Objects.equals(sampleRate(), other.sampleRate()) && Objects.equals(specAsString(), other.specAsString())
                && Objects.equals(vbrQualityAsString(), other.vbrQualityAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AacSettings").add("Bitrate", bitrate()).add("CodingMode", codingModeAsString())
                .add("InputType", inputTypeAsString()).add("Profile", profileAsString())
                .add("RateControlMode", rateControlModeAsString()).add("RawFormat", rawFormatAsString())
                .add("SampleRate", sampleRate()).add("Spec", specAsString()).add("VbrQuality", vbrQualityAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Bitrate":
            return Optional.ofNullable(clazz.cast(bitrate()));
        case "CodingMode":
            return Optional.ofNullable(clazz.cast(codingModeAsString()));
        case "InputType":
            return Optional.ofNullable(clazz.cast(inputTypeAsString()));
        case "Profile":
            return Optional.ofNullable(clazz.cast(profileAsString()));
        case "RateControlMode":
            return Optional.ofNullable(clazz.cast(rateControlModeAsString()));
        case "RawFormat":
            return Optional.ofNullable(clazz.cast(rawFormatAsString()));
        case "SampleRate":
            return Optional.ofNullable(clazz.cast(sampleRate()));
        case "Spec":
            return Optional.ofNullable(clazz.cast(specAsString()));
        case "VbrQuality":
            return Optional.ofNullable(clazz.cast(vbrQualityAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AacSettings, T> g) {
        return obj -> g.apply((AacSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AacSettings> {
        /**
         * Average bitrate in bits/second. Valid values depend on rate control mode and profile.
         * 
         * @param bitrate
         *        Average bitrate in bits/second. Valid values depend on rate control mode and profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bitrate(Double bitrate);

        /**
         * Mono, Stereo, or 5.1 channel layout. Valid values depend on rate control mode and profile. The adReceiverMix
         * setting receives a stereo description plus control track and emits a mono AAC encode of the description
         * track, with control data emitted in the PES header as per ETSI TS 101 154 Annex E.
         * 
         * @param codingMode
         *        Mono, Stereo, or 5.1 channel layout. Valid values depend on rate control mode and profile. The
         *        adReceiverMix setting receives a stereo description plus control track and emits a mono AAC encode of
         *        the description track, with control data emitted in the PES header as per ETSI TS 101 154 Annex E.
         * @see AacCodingMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AacCodingMode
         */
        Builder codingMode(String codingMode);

        /**
         * Mono, Stereo, or 5.1 channel layout. Valid values depend on rate control mode and profile. The adReceiverMix
         * setting receives a stereo description plus control track and emits a mono AAC encode of the description
         * track, with control data emitted in the PES header as per ETSI TS 101 154 Annex E.
         * 
         * @param codingMode
         *        Mono, Stereo, or 5.1 channel layout. Valid values depend on rate control mode and profile. The
         *        adReceiverMix setting receives a stereo description plus control track and emits a mono AAC encode of
         *        the description track, with control data emitted in the PES header as per ETSI TS 101 154 Annex E.
         * @see AacCodingMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AacCodingMode
         */
        Builder codingMode(AacCodingMode codingMode);

        /**
         * Set to "broadcasterMixedAd" when input contains pre-mixed main audio + AD (narration) as a stereo pair. The
         * Audio Type field (audioType) will be set to 3, which signals to downstream systems that this stream contains
         * "broadcaster mixed AD". Note that the input received by the encoder must contain pre-mixed audio; the encoder
         * does not perform the mixing. The values in audioTypeControl and audioType (in AudioDescription) are ignored
         * when set to broadcasterMixedAd.
         *
         * Leave set to "normal" when input does not contain pre-mixed audio + AD.
         * 
         * @param inputType
         *        Set to "broadcasterMixedAd" when input contains pre-mixed main audio + AD (narration) as a stereo
         *        pair. The Audio Type field (audioType) will be set to 3, which signals to downstream systems that this
         *        stream contains "broadcaster mixed AD". Note that the input received by the encoder must contain
         *        pre-mixed audio; the encoder does not perform the mixing. The values in audioTypeControl and audioType
         *        (in AudioDescription) are ignored when set to broadcasterMixedAd.
         *
         *        Leave set to "normal" when input does not contain pre-mixed audio + AD.
         * @see AacInputType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AacInputType
         */
        Builder inputType(String inputType);

        /**
         * Set to "broadcasterMixedAd" when input contains pre-mixed main audio + AD (narration) as a stereo pair. The
         * Audio Type field (audioType) will be set to 3, which signals to downstream systems that this stream contains
         * "broadcaster mixed AD". Note that the input received by the encoder must contain pre-mixed audio; the encoder
         * does not perform the mixing. The values in audioTypeControl and audioType (in AudioDescription) are ignored
         * when set to broadcasterMixedAd.
         *
         * Leave set to "normal" when input does not contain pre-mixed audio + AD.
         * 
         * @param inputType
         *        Set to "broadcasterMixedAd" when input contains pre-mixed main audio + AD (narration) as a stereo
         *        pair. The Audio Type field (audioType) will be set to 3, which signals to downstream systems that this
         *        stream contains "broadcaster mixed AD". Note that the input received by the encoder must contain
         *        pre-mixed audio; the encoder does not perform the mixing. The values in audioTypeControl and audioType
         *        (in AudioDescription) are ignored when set to broadcasterMixedAd.
         *
         *        Leave set to "normal" when input does not contain pre-mixed audio + AD.
         * @see AacInputType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AacInputType
         */
        Builder inputType(AacInputType inputType);

        /**
         * AAC Profile.
         * 
         * @param profile
         *        AAC Profile.
         * @see AacProfile
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AacProfile
         */
        Builder profile(String profile);

        /**
         * AAC Profile.
         * 
         * @param profile
         *        AAC Profile.
         * @see AacProfile
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AacProfile
         */
        Builder profile(AacProfile profile);

        /**
         * Rate Control Mode.
         * 
         * @param rateControlMode
         *        Rate Control Mode.
         * @see AacRateControlMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AacRateControlMode
         */
        Builder rateControlMode(String rateControlMode);

        /**
         * Rate Control Mode.
         * 
         * @param rateControlMode
         *        Rate Control Mode.
         * @see AacRateControlMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AacRateControlMode
         */
        Builder rateControlMode(AacRateControlMode rateControlMode);

        /**
         * Sets LATM / LOAS AAC output for raw containers.
         * 
         * @param rawFormat
         *        Sets LATM / LOAS AAC output for raw containers.
         * @see AacRawFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AacRawFormat
         */
        Builder rawFormat(String rawFormat);

        /**
         * Sets LATM / LOAS AAC output for raw containers.
         * 
         * @param rawFormat
         *        Sets LATM / LOAS AAC output for raw containers.
         * @see AacRawFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AacRawFormat
         */
        Builder rawFormat(AacRawFormat rawFormat);

        /**
         * Sample rate in Hz. Valid values depend on rate control mode and profile.
         * 
         * @param sampleRate
         *        Sample rate in Hz. Valid values depend on rate control mode and profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sampleRate(Double sampleRate);

        /**
         * Use MPEG-2 AAC audio instead of MPEG-4 AAC audio for raw or MPEG-2 Transport Stream containers.
         * 
         * @param spec
         *        Use MPEG-2 AAC audio instead of MPEG-4 AAC audio for raw or MPEG-2 Transport Stream containers.
         * @see AacSpec
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AacSpec
         */
        Builder spec(String spec);

        /**
         * Use MPEG-2 AAC audio instead of MPEG-4 AAC audio for raw or MPEG-2 Transport Stream containers.
         * 
         * @param spec
         *        Use MPEG-2 AAC audio instead of MPEG-4 AAC audio for raw or MPEG-2 Transport Stream containers.
         * @see AacSpec
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AacSpec
         */
        Builder spec(AacSpec spec);

        /**
         * VBR Quality Level - Only used if rateControlMode is VBR.
         * 
         * @param vbrQuality
         *        VBR Quality Level - Only used if rateControlMode is VBR.
         * @see AacVbrQuality
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AacVbrQuality
         */
        Builder vbrQuality(String vbrQuality);

        /**
         * VBR Quality Level - Only used if rateControlMode is VBR.
         * 
         * @param vbrQuality
         *        VBR Quality Level - Only used if rateControlMode is VBR.
         * @see AacVbrQuality
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AacVbrQuality
         */
        Builder vbrQuality(AacVbrQuality vbrQuality);
    }

    static final class BuilderImpl implements Builder {
        private Double bitrate;

        private String codingMode;

        private String inputType;

        private String profile;

        private String rateControlMode;

        private String rawFormat;

        private Double sampleRate;

        private String spec;

        private String vbrQuality;

        private BuilderImpl() {
        }

        private BuilderImpl(AacSettings model) {
            bitrate(model.bitrate);
            codingMode(model.codingMode);
            inputType(model.inputType);
            profile(model.profile);
            rateControlMode(model.rateControlMode);
            rawFormat(model.rawFormat);
            sampleRate(model.sampleRate);
            spec(model.spec);
            vbrQuality(model.vbrQuality);
        }

        public final Double getBitrate() {
            return bitrate;
        }

        @Override
        public final Builder bitrate(Double bitrate) {
            this.bitrate = bitrate;
            return this;
        }

        public final void setBitrate(Double bitrate) {
            this.bitrate = bitrate;
        }

        public final String getCodingMode() {
            return codingMode;
        }

        @Override
        public final Builder codingMode(String codingMode) {
            this.codingMode = codingMode;
            return this;
        }

        @Override
        public final Builder codingMode(AacCodingMode codingMode) {
            this.codingMode(codingMode == null ? null : codingMode.toString());
            return this;
        }

        public final void setCodingMode(String codingMode) {
            this.codingMode = codingMode;
        }

        public final String getInputType() {
            return inputType;
        }

        @Override
        public final Builder inputType(String inputType) {
            this.inputType = inputType;
            return this;
        }

        @Override
        public final Builder inputType(AacInputType inputType) {
            this.inputType(inputType == null ? null : inputType.toString());
            return this;
        }

        public final void setInputType(String inputType) {
            this.inputType = inputType;
        }

        public final String getProfile() {
            return profile;
        }

        @Override
        public final Builder profile(String profile) {
            this.profile = profile;
            return this;
        }

        @Override
        public final Builder profile(AacProfile profile) {
            this.profile(profile == null ? null : profile.toString());
            return this;
        }

        public final void setProfile(String profile) {
            this.profile = profile;
        }

        public final String getRateControlMode() {
            return rateControlMode;
        }

        @Override
        public final Builder rateControlMode(String rateControlMode) {
            this.rateControlMode = rateControlMode;
            return this;
        }

        @Override
        public final Builder rateControlMode(AacRateControlMode rateControlMode) {
            this.rateControlMode(rateControlMode == null ? null : rateControlMode.toString());
            return this;
        }

        public final void setRateControlMode(String rateControlMode) {
            this.rateControlMode = rateControlMode;
        }

        public final String getRawFormat() {
            return rawFormat;
        }

        @Override
        public final Builder rawFormat(String rawFormat) {
            this.rawFormat = rawFormat;
            return this;
        }

        @Override
        public final Builder rawFormat(AacRawFormat rawFormat) {
            this.rawFormat(rawFormat == null ? null : rawFormat.toString());
            return this;
        }

        public final void setRawFormat(String rawFormat) {
            this.rawFormat = rawFormat;
        }

        public final Double getSampleRate() {
            return sampleRate;
        }

        @Override
        public final Builder sampleRate(Double sampleRate) {
            this.sampleRate = sampleRate;
            return this;
        }

        public final void setSampleRate(Double sampleRate) {
            this.sampleRate = sampleRate;
        }

        public final String getSpec() {
            return spec;
        }

        @Override
        public final Builder spec(String spec) {
            this.spec = spec;
            return this;
        }

        @Override
        public final Builder spec(AacSpec spec) {
            this.spec(spec == null ? null : spec.toString());
            return this;
        }

        public final void setSpec(String spec) {
            this.spec = spec;
        }

        public final String getVbrQuality() {
            return vbrQuality;
        }

        @Override
        public final Builder vbrQuality(String vbrQuality) {
            this.vbrQuality = vbrQuality;
            return this;
        }

        @Override
        public final Builder vbrQuality(AacVbrQuality vbrQuality) {
            this.vbrQuality(vbrQuality == null ? null : vbrQuality.toString());
            return this;
        }

        public final void setVbrQuality(String vbrQuality) {
            this.vbrQuality = vbrQuality;
        }

        @Override
        public AacSettings build() {
            return new AacSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
