/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.medialive.model.InputChannelLevel;
import software.amazon.awssdk.services.medialive.model.___listOfInputChannelLevelCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AudioChannelMapping
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AudioChannelMapping> {
    private static final SdkField<List<InputChannelLevel>> INPUT_CHANNEL_LEVELS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("InputChannelLevels").getter(AudioChannelMapping.getter(AudioChannelMapping::inputChannelLevels)).setter(AudioChannelMapping.setter(Builder::inputChannelLevels)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputChannelLevels").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(InputChannelLevel::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Integer> OUTPUT_CHANNEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("OutputChannel").getter(AudioChannelMapping.getter(AudioChannelMapping::outputChannel)).setter(AudioChannelMapping.setter(Builder::outputChannel)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputChannel").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INPUT_CHANNEL_LEVELS_FIELD, OUTPUT_CHANNEL_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<InputChannelLevel> inputChannelLevels;
    private final Integer outputChannel;

    private AudioChannelMapping(BuilderImpl builder) {
        this.inputChannelLevels = builder.inputChannelLevels;
        this.outputChannel = builder.outputChannel;
    }

    public final boolean hasInputChannelLevels() {
        return this.inputChannelLevels != null && !(this.inputChannelLevels instanceof SdkAutoConstructList);
    }

    public final List<InputChannelLevel> inputChannelLevels() {
        return this.inputChannelLevels;
    }

    public final Integer outputChannel() {
        return this.outputChannel;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInputChannelLevels() ? this.inputChannelLevels() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.outputChannel());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AudioChannelMapping)) {
            return false;
        }
        AudioChannelMapping other = (AudioChannelMapping)obj;
        return this.hasInputChannelLevels() == other.hasInputChannelLevels() && Objects.equals(this.inputChannelLevels(), other.inputChannelLevels()) && Objects.equals(this.outputChannel(), other.outputChannel());
    }

    public final String toString() {
        return ToString.builder((String)"AudioChannelMapping").add("InputChannelLevels", this.hasInputChannelLevels() ? this.inputChannelLevels() : null).add("OutputChannel", (Object)this.outputChannel()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InputChannelLevels": {
                return Optional.ofNullable(clazz.cast(this.inputChannelLevels()));
            }
            case "OutputChannel": {
                return Optional.ofNullable(clazz.cast(this.outputChannel()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AudioChannelMapping, T> g) {
        return obj -> g.apply((AudioChannelMapping)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<InputChannelLevel> inputChannelLevels = DefaultSdkAutoConstructList.getInstance();
        private Integer outputChannel;

        private BuilderImpl() {
        }

        private BuilderImpl(AudioChannelMapping model) {
            this.inputChannelLevels(model.inputChannelLevels);
            this.outputChannel(model.outputChannel);
        }

        public final Collection<InputChannelLevel.Builder> getInputChannelLevels() {
            if (this.inputChannelLevels instanceof SdkAutoConstructList) {
                return null;
            }
            return this.inputChannelLevels != null ? (Collection)this.inputChannelLevels.stream().map(InputChannelLevel::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder inputChannelLevels(Collection<InputChannelLevel> inputChannelLevels) {
            this.inputChannelLevels = ___listOfInputChannelLevelCopier.copy(inputChannelLevels);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputChannelLevels(InputChannelLevel ... inputChannelLevels) {
            this.inputChannelLevels(Arrays.asList(inputChannelLevels));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputChannelLevels(Consumer<InputChannelLevel.Builder> ... inputChannelLevels) {
            this.inputChannelLevels(Stream.of(inputChannelLevels).map(c -> (InputChannelLevel)((InputChannelLevel.Builder)InputChannelLevel.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setInputChannelLevels(Collection<InputChannelLevel.BuilderImpl> inputChannelLevels) {
            this.inputChannelLevels = ___listOfInputChannelLevelCopier.copyFromBuilder(inputChannelLevels);
        }

        public final Integer getOutputChannel() {
            return this.outputChannel;
        }

        @Override
        public final Builder outputChannel(Integer outputChannel) {
            this.outputChannel = outputChannel;
            return this;
        }

        public final void setOutputChannel(Integer outputChannel) {
            this.outputChannel = outputChannel;
        }

        public AudioChannelMapping build() {
            return new AudioChannelMapping(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AudioChannelMapping> {
        public Builder inputChannelLevels(Collection<InputChannelLevel> var1);

        public Builder inputChannelLevels(InputChannelLevel ... var1);

        public Builder inputChannelLevels(Consumer<InputChannelLevel.Builder> ... var1);

        public Builder outputChannel(Integer var1);
    }
}

