/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.medialive.model.MultiplexProgramServiceDescriptor;
import software.amazon.awssdk.services.medialive.model.MultiplexVideoSettings;
import software.amazon.awssdk.services.medialive.model.PreferredChannelPipeline;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MultiplexProgramSettings
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MultiplexProgramSettings> {
    private static final SdkField<String> PREFERRED_CHANNEL_PIPELINE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PreferredChannelPipeline").getter(MultiplexProgramSettings.getter(MultiplexProgramSettings::preferredChannelPipelineAsString)).setter(MultiplexProgramSettings.setter(Builder::preferredChannelPipeline)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("preferredChannelPipeline").build()}).build();
    private static final SdkField<Integer> PROGRAM_NUMBER_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ProgramNumber").getter(MultiplexProgramSettings.getter(MultiplexProgramSettings::programNumber)).setter(MultiplexProgramSettings.setter(Builder::programNumber)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("programNumber").build()}).build();
    private static final SdkField<MultiplexProgramServiceDescriptor> SERVICE_DESCRIPTOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ServiceDescriptor").getter(MultiplexProgramSettings.getter(MultiplexProgramSettings::serviceDescriptor)).setter(MultiplexProgramSettings.setter(Builder::serviceDescriptor)).constructor(MultiplexProgramServiceDescriptor::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceDescriptor").build()}).build();
    private static final SdkField<MultiplexVideoSettings> VIDEO_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("VideoSettings").getter(MultiplexProgramSettings.getter(MultiplexProgramSettings::videoSettings)).setter(MultiplexProgramSettings.setter(Builder::videoSettings)).constructor(MultiplexVideoSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("videoSettings").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PREFERRED_CHANNEL_PIPELINE_FIELD, PROGRAM_NUMBER_FIELD, SERVICE_DESCRIPTOR_FIELD, VIDEO_SETTINGS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String preferredChannelPipeline;
    private final Integer programNumber;
    private final MultiplexProgramServiceDescriptor serviceDescriptor;
    private final MultiplexVideoSettings videoSettings;

    private MultiplexProgramSettings(BuilderImpl builder) {
        this.preferredChannelPipeline = builder.preferredChannelPipeline;
        this.programNumber = builder.programNumber;
        this.serviceDescriptor = builder.serviceDescriptor;
        this.videoSettings = builder.videoSettings;
    }

    public PreferredChannelPipeline preferredChannelPipeline() {
        return PreferredChannelPipeline.fromValue(this.preferredChannelPipeline);
    }

    public String preferredChannelPipelineAsString() {
        return this.preferredChannelPipeline;
    }

    public Integer programNumber() {
        return this.programNumber;
    }

    public MultiplexProgramServiceDescriptor serviceDescriptor() {
        return this.serviceDescriptor;
    }

    public MultiplexVideoSettings videoSettings() {
        return this.videoSettings;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.preferredChannelPipelineAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.programNumber());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceDescriptor());
        hashCode = 31 * hashCode + Objects.hashCode(this.videoSettings());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MultiplexProgramSettings)) {
            return false;
        }
        MultiplexProgramSettings other = (MultiplexProgramSettings)obj;
        return Objects.equals(this.preferredChannelPipelineAsString(), other.preferredChannelPipelineAsString()) && Objects.equals(this.programNumber(), other.programNumber()) && Objects.equals(this.serviceDescriptor(), other.serviceDescriptor()) && Objects.equals(this.videoSettings(), other.videoSettings());
    }

    public String toString() {
        return ToString.builder((String)"MultiplexProgramSettings").add("PreferredChannelPipeline", (Object)this.preferredChannelPipelineAsString()).add("ProgramNumber", (Object)this.programNumber()).add("ServiceDescriptor", (Object)this.serviceDescriptor()).add("VideoSettings", (Object)this.videoSettings()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PreferredChannelPipeline": {
                return Optional.ofNullable(clazz.cast(this.preferredChannelPipelineAsString()));
            }
            case "ProgramNumber": {
                return Optional.ofNullable(clazz.cast(this.programNumber()));
            }
            case "ServiceDescriptor": {
                return Optional.ofNullable(clazz.cast(this.serviceDescriptor()));
            }
            case "VideoSettings": {
                return Optional.ofNullable(clazz.cast(this.videoSettings()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MultiplexProgramSettings, T> g) {
        return obj -> g.apply((MultiplexProgramSettings)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String preferredChannelPipeline;
        private Integer programNumber;
        private MultiplexProgramServiceDescriptor serviceDescriptor;
        private MultiplexVideoSettings videoSettings;

        private BuilderImpl() {
        }

        private BuilderImpl(MultiplexProgramSettings model) {
            this.preferredChannelPipeline(model.preferredChannelPipeline);
            this.programNumber(model.programNumber);
            this.serviceDescriptor(model.serviceDescriptor);
            this.videoSettings(model.videoSettings);
        }

        public final String getPreferredChannelPipeline() {
            return this.preferredChannelPipeline;
        }

        @Override
        public final Builder preferredChannelPipeline(String preferredChannelPipeline) {
            this.preferredChannelPipeline = preferredChannelPipeline;
            return this;
        }

        @Override
        public final Builder preferredChannelPipeline(PreferredChannelPipeline preferredChannelPipeline) {
            this.preferredChannelPipeline(preferredChannelPipeline == null ? null : preferredChannelPipeline.toString());
            return this;
        }

        public final void setPreferredChannelPipeline(String preferredChannelPipeline) {
            this.preferredChannelPipeline = preferredChannelPipeline;
        }

        public final Integer getProgramNumber() {
            return this.programNumber;
        }

        @Override
        public final Builder programNumber(Integer programNumber) {
            this.programNumber = programNumber;
            return this;
        }

        public final void setProgramNumber(Integer programNumber) {
            this.programNumber = programNumber;
        }

        public final MultiplexProgramServiceDescriptor.Builder getServiceDescriptor() {
            return this.serviceDescriptor != null ? this.serviceDescriptor.toBuilder() : null;
        }

        @Override
        public final Builder serviceDescriptor(MultiplexProgramServiceDescriptor serviceDescriptor) {
            this.serviceDescriptor = serviceDescriptor;
            return this;
        }

        public final void setServiceDescriptor(MultiplexProgramServiceDescriptor.BuilderImpl serviceDescriptor) {
            this.serviceDescriptor = serviceDescriptor != null ? serviceDescriptor.build() : null;
        }

        public final MultiplexVideoSettings.Builder getVideoSettings() {
            return this.videoSettings != null ? this.videoSettings.toBuilder() : null;
        }

        @Override
        public final Builder videoSettings(MultiplexVideoSettings videoSettings) {
            this.videoSettings = videoSettings;
            return this;
        }

        public final void setVideoSettings(MultiplexVideoSettings.BuilderImpl videoSettings) {
            this.videoSettings = videoSettings != null ? videoSettings.build() : null;
        }

        public MultiplexProgramSettings build() {
            return new MultiplexProgramSettings(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MultiplexProgramSettings> {
        public Builder preferredChannelPipeline(String var1);

        public Builder preferredChannelPipeline(PreferredChannelPipeline var1);

        public Builder programNumber(Integer var1);

        public Builder serviceDescriptor(MultiplexProgramServiceDescriptor var1);

        default public Builder serviceDescriptor(Consumer<MultiplexProgramServiceDescriptor.Builder> serviceDescriptor) {
            return this.serviceDescriptor((MultiplexProgramServiceDescriptor)((MultiplexProgramServiceDescriptor.Builder)MultiplexProgramServiceDescriptor.builder().applyMutation(serviceDescriptor)).build());
        }

        public Builder videoSettings(MultiplexVideoSettings var1);

        default public Builder videoSettings(Consumer<MultiplexVideoSettings.Builder> videoSettings) {
            return this.videoSettings((MultiplexVideoSettings)((MultiplexVideoSettings.Builder)MultiplexVideoSettings.builder().applyMutation(videoSettings)).build());
        }
    }
}

