/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.medialive.model.BatchFailedResultModel;
import software.amazon.awssdk.services.medialive.model.BatchSuccessfulResultModel;
import software.amazon.awssdk.services.medialive.model.MediaLiveResponse;
import software.amazon.awssdk.services.medialive.model.___listOfBatchFailedResultModelCopier;
import software.amazon.awssdk.services.medialive.model.___listOfBatchSuccessfulResultModelCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchDeleteResponse
extends MediaLiveResponse
implements ToCopyableBuilder<Builder, BatchDeleteResponse> {
    private static final SdkField<List<BatchFailedResultModel>> FAILED_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(BatchDeleteResponse.getter(BatchDeleteResponse::failed)).setter(BatchDeleteResponse.setter(Builder::failed)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failed").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(BatchFailedResultModel::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<BatchSuccessfulResultModel>> SUCCESSFUL_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(BatchDeleteResponse.getter(BatchDeleteResponse::successful)).setter(BatchDeleteResponse.setter(Builder::successful)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("successful").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(BatchSuccessfulResultModel::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FAILED_FIELD, SUCCESSFUL_FIELD));
    private final List<BatchFailedResultModel> failed;
    private final List<BatchSuccessfulResultModel> successful;

    private BatchDeleteResponse(BuilderImpl builder) {
        super(builder);
        this.failed = builder.failed;
        this.successful = builder.successful;
    }

    public boolean hasFailed() {
        return this.failed != null && !(this.failed instanceof SdkAutoConstructList);
    }

    public List<BatchFailedResultModel> failed() {
        return this.failed;
    }

    public boolean hasSuccessful() {
        return this.successful != null && !(this.successful instanceof SdkAutoConstructList);
    }

    public List<BatchSuccessfulResultModel> successful() {
        return this.successful;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.failed());
        hashCode = 31 * hashCode + Objects.hashCode(this.successful());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchDeleteResponse)) {
            return false;
        }
        BatchDeleteResponse other = (BatchDeleteResponse)((Object)obj);
        return Objects.equals(this.failed(), other.failed()) && Objects.equals(this.successful(), other.successful());
    }

    public String toString() {
        return ToString.builder((String)"BatchDeleteResponse").add("Failed", this.failed()).add("Successful", this.successful()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Failed": {
                return Optional.ofNullable(clazz.cast(this.failed()));
            }
            case "Successful": {
                return Optional.ofNullable(clazz.cast(this.successful()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchDeleteResponse, T> g) {
        return obj -> g.apply((BatchDeleteResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MediaLiveResponse.BuilderImpl
    implements Builder {
        private List<BatchFailedResultModel> failed = DefaultSdkAutoConstructList.getInstance();
        private List<BatchSuccessfulResultModel> successful = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchDeleteResponse model) {
            super(model);
            this.failed(model.failed);
            this.successful(model.successful);
        }

        public final Collection<BatchFailedResultModel.Builder> getFailed() {
            return this.failed != null ? (Collection)this.failed.stream().map(BatchFailedResultModel::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder failed(Collection<BatchFailedResultModel> failed) {
            this.failed = ___listOfBatchFailedResultModelCopier.copy(failed);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failed(BatchFailedResultModel ... failed) {
            this.failed(Arrays.asList(failed));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failed(Consumer<BatchFailedResultModel.Builder> ... failed) {
            this.failed(Stream.of(failed).map(c -> (BatchFailedResultModel)((BatchFailedResultModel.Builder)BatchFailedResultModel.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setFailed(Collection<BatchFailedResultModel.BuilderImpl> failed) {
            this.failed = ___listOfBatchFailedResultModelCopier.copyFromBuilder(failed);
        }

        public final Collection<BatchSuccessfulResultModel.Builder> getSuccessful() {
            return this.successful != null ? (Collection)this.successful.stream().map(BatchSuccessfulResultModel::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder successful(Collection<BatchSuccessfulResultModel> successful) {
            this.successful = ___listOfBatchSuccessfulResultModelCopier.copy(successful);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder successful(BatchSuccessfulResultModel ... successful) {
            this.successful(Arrays.asList(successful));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder successful(Consumer<BatchSuccessfulResultModel.Builder> ... successful) {
            this.successful(Stream.of(successful).map(c -> (BatchSuccessfulResultModel)((BatchSuccessfulResultModel.Builder)BatchSuccessfulResultModel.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setSuccessful(Collection<BatchSuccessfulResultModel.BuilderImpl> successful) {
            this.successful = ___listOfBatchSuccessfulResultModelCopier.copyFromBuilder(successful);
        }

        @Override
        public BatchDeleteResponse build() {
            return new BatchDeleteResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends MediaLiveResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchDeleteResponse> {
        public Builder failed(Collection<BatchFailedResultModel> var1);

        public Builder failed(BatchFailedResultModel ... var1);

        public Builder failed(Consumer<BatchFailedResultModel.Builder> ... var1);

        public Builder successful(Collection<BatchSuccessfulResultModel> var1);

        public Builder successful(BatchSuccessfulResultModel ... var1);

        public Builder successful(Consumer<BatchSuccessfulResultModel.Builder> ... var1);
    }
}

