/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.medialive.model.InputPreference;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AutomaticInputFailoverSettings
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AutomaticInputFailoverSettings> {
    private static final SdkField<String> INPUT_PREFERENCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AutomaticInputFailoverSettings.getter(AutomaticInputFailoverSettings::inputPreferenceAsString)).setter(AutomaticInputFailoverSettings.setter(Builder::inputPreference)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputPreference").build()}).build();
    private static final SdkField<String> SECONDARY_INPUT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AutomaticInputFailoverSettings.getter(AutomaticInputFailoverSettings::secondaryInputId)).setter(AutomaticInputFailoverSettings.setter(Builder::secondaryInputId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("secondaryInputId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INPUT_PREFERENCE_FIELD, SECONDARY_INPUT_ID_FIELD));
    private static final long serialVersionUID = 1L;
    private final String inputPreference;
    private final String secondaryInputId;

    private AutomaticInputFailoverSettings(BuilderImpl builder) {
        this.inputPreference = builder.inputPreference;
        this.secondaryInputId = builder.secondaryInputId;
    }

    public InputPreference inputPreference() {
        return InputPreference.fromValue(this.inputPreference);
    }

    public String inputPreferenceAsString() {
        return this.inputPreference;
    }

    public String secondaryInputId() {
        return this.secondaryInputId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.inputPreferenceAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.secondaryInputId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AutomaticInputFailoverSettings)) {
            return false;
        }
        AutomaticInputFailoverSettings other = (AutomaticInputFailoverSettings)obj;
        return Objects.equals(this.inputPreferenceAsString(), other.inputPreferenceAsString()) && Objects.equals(this.secondaryInputId(), other.secondaryInputId());
    }

    public String toString() {
        return ToString.builder((String)"AutomaticInputFailoverSettings").add("InputPreference", (Object)this.inputPreferenceAsString()).add("SecondaryInputId", (Object)this.secondaryInputId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InputPreference": {
                return Optional.ofNullable(clazz.cast(this.inputPreferenceAsString()));
            }
            case "SecondaryInputId": {
                return Optional.ofNullable(clazz.cast(this.secondaryInputId()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AutomaticInputFailoverSettings, T> g) {
        return obj -> g.apply((AutomaticInputFailoverSettings)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String inputPreference;
        private String secondaryInputId;

        private BuilderImpl() {
        }

        private BuilderImpl(AutomaticInputFailoverSettings model) {
            this.inputPreference(model.inputPreference);
            this.secondaryInputId(model.secondaryInputId);
        }

        public final String getInputPreference() {
            return this.inputPreference;
        }

        @Override
        public final Builder inputPreference(String inputPreference) {
            this.inputPreference = inputPreference;
            return this;
        }

        @Override
        public final Builder inputPreference(InputPreference inputPreference) {
            this.inputPreference(inputPreference == null ? null : inputPreference.toString());
            return this;
        }

        public final void setInputPreference(String inputPreference) {
            this.inputPreference = inputPreference;
        }

        public final String getSecondaryInputId() {
            return this.secondaryInputId;
        }

        @Override
        public final Builder secondaryInputId(String secondaryInputId) {
            this.secondaryInputId = secondaryInputId;
            return this;
        }

        public final void setSecondaryInputId(String secondaryInputId) {
            this.secondaryInputId = secondaryInputId;
        }

        public AutomaticInputFailoverSettings build() {
            return new AutomaticInputFailoverSettings(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AutomaticInputFailoverSettings> {
        public Builder inputPreference(String var1);

        public Builder inputPreference(InputPreference var1);

        public Builder secondaryInputId(String var1);
    }
}

