/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.medialive.model.InputTimecodeSource;
import software.amazon.awssdk.services.medialive.model.StartTimecode;
import software.amazon.awssdk.services.medialive.model.StopTimecode;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InputClippingSettings
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, InputClippingSettings> {
    private static final SdkField<String> INPUT_TIMECODE_SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(InputClippingSettings.getter(InputClippingSettings::inputTimecodeSourceAsString)).setter(InputClippingSettings.setter(Builder::inputTimecodeSource)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputTimecodeSource").build()}).build();
    private static final SdkField<StartTimecode> START_TIMECODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(InputClippingSettings.getter(InputClippingSettings::startTimecode)).setter(InputClippingSettings.setter(Builder::startTimecode)).constructor(StartTimecode::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startTimecode").build()}).build();
    private static final SdkField<StopTimecode> STOP_TIMECODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(InputClippingSettings.getter(InputClippingSettings::stopTimecode)).setter(InputClippingSettings.setter(Builder::stopTimecode)).constructor(StopTimecode::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stopTimecode").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INPUT_TIMECODE_SOURCE_FIELD, START_TIMECODE_FIELD, STOP_TIMECODE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String inputTimecodeSource;
    private final StartTimecode startTimecode;
    private final StopTimecode stopTimecode;

    private InputClippingSettings(BuilderImpl builder) {
        this.inputTimecodeSource = builder.inputTimecodeSource;
        this.startTimecode = builder.startTimecode;
        this.stopTimecode = builder.stopTimecode;
    }

    public InputTimecodeSource inputTimecodeSource() {
        return InputTimecodeSource.fromValue(this.inputTimecodeSource);
    }

    public String inputTimecodeSourceAsString() {
        return this.inputTimecodeSource;
    }

    public StartTimecode startTimecode() {
        return this.startTimecode;
    }

    public StopTimecode stopTimecode() {
        return this.stopTimecode;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.inputTimecodeSourceAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTimecode());
        hashCode = 31 * hashCode + Objects.hashCode(this.stopTimecode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InputClippingSettings)) {
            return false;
        }
        InputClippingSettings other = (InputClippingSettings)obj;
        return Objects.equals(this.inputTimecodeSourceAsString(), other.inputTimecodeSourceAsString()) && Objects.equals(this.startTimecode(), other.startTimecode()) && Objects.equals(this.stopTimecode(), other.stopTimecode());
    }

    public String toString() {
        return ToString.builder((String)"InputClippingSettings").add("InputTimecodeSource", (Object)this.inputTimecodeSourceAsString()).add("StartTimecode", (Object)this.startTimecode()).add("StopTimecode", (Object)this.stopTimecode()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InputTimecodeSource": {
                return Optional.ofNullable(clazz.cast(this.inputTimecodeSourceAsString()));
            }
            case "StartTimecode": {
                return Optional.ofNullable(clazz.cast(this.startTimecode()));
            }
            case "StopTimecode": {
                return Optional.ofNullable(clazz.cast(this.stopTimecode()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InputClippingSettings, T> g) {
        return obj -> g.apply((InputClippingSettings)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String inputTimecodeSource;
        private StartTimecode startTimecode;
        private StopTimecode stopTimecode;

        private BuilderImpl() {
        }

        private BuilderImpl(InputClippingSettings model) {
            this.inputTimecodeSource(model.inputTimecodeSource);
            this.startTimecode(model.startTimecode);
            this.stopTimecode(model.stopTimecode);
        }

        public final String getInputTimecodeSource() {
            return this.inputTimecodeSource;
        }

        @Override
        public final Builder inputTimecodeSource(String inputTimecodeSource) {
            this.inputTimecodeSource = inputTimecodeSource;
            return this;
        }

        @Override
        public final Builder inputTimecodeSource(InputTimecodeSource inputTimecodeSource) {
            this.inputTimecodeSource(inputTimecodeSource == null ? null : inputTimecodeSource.toString());
            return this;
        }

        public final void setInputTimecodeSource(String inputTimecodeSource) {
            this.inputTimecodeSource = inputTimecodeSource;
        }

        public final StartTimecode.Builder getStartTimecode() {
            return this.startTimecode != null ? this.startTimecode.toBuilder() : null;
        }

        @Override
        public final Builder startTimecode(StartTimecode startTimecode) {
            this.startTimecode = startTimecode;
            return this;
        }

        public final void setStartTimecode(StartTimecode.BuilderImpl startTimecode) {
            this.startTimecode = startTimecode != null ? startTimecode.build() : null;
        }

        public final StopTimecode.Builder getStopTimecode() {
            return this.stopTimecode != null ? this.stopTimecode.toBuilder() : null;
        }

        @Override
        public final Builder stopTimecode(StopTimecode stopTimecode) {
            this.stopTimecode = stopTimecode;
            return this;
        }

        public final void setStopTimecode(StopTimecode.BuilderImpl stopTimecode) {
            this.stopTimecode = stopTimecode != null ? stopTimecode.build() : null;
        }

        public InputClippingSettings build() {
            return new InputClippingSettings(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, InputClippingSettings> {
        public Builder inputTimecodeSource(String var1);

        public Builder inputTimecodeSource(InputTimecodeSource var1);

        public Builder startTimecode(StartTimecode var1);

        default public Builder startTimecode(Consumer<StartTimecode.Builder> startTimecode) {
            return this.startTimecode((StartTimecode)((StartTimecode.Builder)StartTimecode.builder().applyMutation(startTimecode)).build());
        }

        public Builder stopTimecode(StopTimecode var1);

        default public Builder stopTimecode(Consumer<StopTimecode.Builder> stopTimecode) {
            return this.stopTimecode((StopTimecode)((StopTimecode.Builder)StopTimecode.builder().applyMutation(stopTimecode)).build());
        }
    }
}

