/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum InputType {
    UDP_PUSH("UDP_PUSH"),
    RTP_PUSH("RTP_PUSH"),
    RTMP_PUSH("RTMP_PUSH"),
    RTMP_PULL("RTMP_PULL"),
    URL_PULL("URL_PULL"),
    MP4_FILE("MP4_FILE"),
    MEDIACONNECT("MEDIACONNECT"),
    INPUT_DEVICE("INPUT_DEVICE"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private InputType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static InputType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(InputType.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<InputType> knownValues() {
        return Stream.of(InputType.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

