/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.medialive.model.InputClippingSettings;
import software.amazon.awssdk.services.medialive.model.___listOf__stringCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InputSwitchScheduleActionSettings
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, InputSwitchScheduleActionSettings> {
    private static final SdkField<String> INPUT_ATTACHMENT_NAME_REFERENCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(InputSwitchScheduleActionSettings.getter(InputSwitchScheduleActionSettings::inputAttachmentNameReference)).setter(InputSwitchScheduleActionSettings.setter(Builder::inputAttachmentNameReference)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputAttachmentNameReference").build()}).build();
    private static final SdkField<InputClippingSettings> INPUT_CLIPPING_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(InputSwitchScheduleActionSettings.getter(InputSwitchScheduleActionSettings::inputClippingSettings)).setter(InputSwitchScheduleActionSettings.setter(Builder::inputClippingSettings)).constructor(InputClippingSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputClippingSettings").build()}).build();
    private static final SdkField<List<String>> URL_PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(InputSwitchScheduleActionSettings.getter(InputSwitchScheduleActionSettings::urlPath)).setter(InputSwitchScheduleActionSettings.setter(Builder::urlPath)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("urlPath").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INPUT_ATTACHMENT_NAME_REFERENCE_FIELD, INPUT_CLIPPING_SETTINGS_FIELD, URL_PATH_FIELD));
    private static final long serialVersionUID = 1L;
    private final String inputAttachmentNameReference;
    private final InputClippingSettings inputClippingSettings;
    private final List<String> urlPath;

    private InputSwitchScheduleActionSettings(BuilderImpl builder) {
        this.inputAttachmentNameReference = builder.inputAttachmentNameReference;
        this.inputClippingSettings = builder.inputClippingSettings;
        this.urlPath = builder.urlPath;
    }

    public String inputAttachmentNameReference() {
        return this.inputAttachmentNameReference;
    }

    public InputClippingSettings inputClippingSettings() {
        return this.inputClippingSettings;
    }

    public boolean hasUrlPath() {
        return this.urlPath != null && !(this.urlPath instanceof SdkAutoConstructList);
    }

    public List<String> urlPath() {
        return this.urlPath;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.inputAttachmentNameReference());
        hashCode = 31 * hashCode + Objects.hashCode(this.inputClippingSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.urlPath());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InputSwitchScheduleActionSettings)) {
            return false;
        }
        InputSwitchScheduleActionSettings other = (InputSwitchScheduleActionSettings)obj;
        return Objects.equals(this.inputAttachmentNameReference(), other.inputAttachmentNameReference()) && Objects.equals(this.inputClippingSettings(), other.inputClippingSettings()) && Objects.equals(this.urlPath(), other.urlPath());
    }

    public String toString() {
        return ToString.builder((String)"InputSwitchScheduleActionSettings").add("InputAttachmentNameReference", (Object)this.inputAttachmentNameReference()).add("InputClippingSettings", (Object)this.inputClippingSettings()).add("UrlPath", this.urlPath()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InputAttachmentNameReference": {
                return Optional.ofNullable(clazz.cast(this.inputAttachmentNameReference()));
            }
            case "InputClippingSettings": {
                return Optional.ofNullable(clazz.cast(this.inputClippingSettings()));
            }
            case "UrlPath": {
                return Optional.ofNullable(clazz.cast(this.urlPath()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InputSwitchScheduleActionSettings, T> g) {
        return obj -> g.apply((InputSwitchScheduleActionSettings)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String inputAttachmentNameReference;
        private InputClippingSettings inputClippingSettings;
        private List<String> urlPath = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(InputSwitchScheduleActionSettings model) {
            this.inputAttachmentNameReference(model.inputAttachmentNameReference);
            this.inputClippingSettings(model.inputClippingSettings);
            this.urlPath(model.urlPath);
        }

        public final String getInputAttachmentNameReference() {
            return this.inputAttachmentNameReference;
        }

        @Override
        public final Builder inputAttachmentNameReference(String inputAttachmentNameReference) {
            this.inputAttachmentNameReference = inputAttachmentNameReference;
            return this;
        }

        public final void setInputAttachmentNameReference(String inputAttachmentNameReference) {
            this.inputAttachmentNameReference = inputAttachmentNameReference;
        }

        public final InputClippingSettings.Builder getInputClippingSettings() {
            return this.inputClippingSettings != null ? this.inputClippingSettings.toBuilder() : null;
        }

        @Override
        public final Builder inputClippingSettings(InputClippingSettings inputClippingSettings) {
            this.inputClippingSettings = inputClippingSettings;
            return this;
        }

        public final void setInputClippingSettings(InputClippingSettings.BuilderImpl inputClippingSettings) {
            this.inputClippingSettings = inputClippingSettings != null ? inputClippingSettings.build() : null;
        }

        public final Collection<String> getUrlPath() {
            return this.urlPath;
        }

        @Override
        public final Builder urlPath(Collection<String> urlPath) {
            this.urlPath = ___listOf__stringCopier.copy(urlPath);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder urlPath(String ... urlPath) {
            this.urlPath(Arrays.asList(urlPath));
            return this;
        }

        public final void setUrlPath(Collection<String> urlPath) {
            this.urlPath = ___listOf__stringCopier.copy(urlPath);
        }

        public InputSwitchScheduleActionSettings build() {
            return new InputSwitchScheduleActionSettings(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, InputSwitchScheduleActionSettings> {
        public Builder inputAttachmentNameReference(String var1);

        public Builder inputClippingSettings(InputClippingSettings var1);

        default public Builder inputClippingSettings(Consumer<InputClippingSettings.Builder> inputClippingSettings) {
            return this.inputClippingSettings((InputClippingSettings)((InputClippingSettings.Builder)InputClippingSettings.builder().applyMutation(inputClippingSettings)).build());
        }

        public Builder urlPath(Collection<String> var1);

        public Builder urlPath(String ... var1);
    }
}

