/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.medialive.model.FrameCaptureIntervalUnit;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FrameCaptureSettings
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, FrameCaptureSettings> {
    private static final SdkField<Integer> CAPTURE_INTERVAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(FrameCaptureSettings.getter(FrameCaptureSettings::captureInterval)).setter(FrameCaptureSettings.setter(Builder::captureInterval)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("captureInterval").build()}).build();
    private static final SdkField<String> CAPTURE_INTERVAL_UNITS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(FrameCaptureSettings.getter(FrameCaptureSettings::captureIntervalUnitsAsString)).setter(FrameCaptureSettings.setter(Builder::captureIntervalUnits)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("captureIntervalUnits").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CAPTURE_INTERVAL_FIELD, CAPTURE_INTERVAL_UNITS_FIELD));
    private static final long serialVersionUID = 1L;
    private final Integer captureInterval;
    private final String captureIntervalUnits;

    private FrameCaptureSettings(BuilderImpl builder) {
        this.captureInterval = builder.captureInterval;
        this.captureIntervalUnits = builder.captureIntervalUnits;
    }

    public Integer captureInterval() {
        return this.captureInterval;
    }

    public FrameCaptureIntervalUnit captureIntervalUnits() {
        return FrameCaptureIntervalUnit.fromValue(this.captureIntervalUnits);
    }

    public String captureIntervalUnitsAsString() {
        return this.captureIntervalUnits;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.captureInterval());
        hashCode = 31 * hashCode + Objects.hashCode(this.captureIntervalUnitsAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FrameCaptureSettings)) {
            return false;
        }
        FrameCaptureSettings other = (FrameCaptureSettings)obj;
        return Objects.equals(this.captureInterval(), other.captureInterval()) && Objects.equals(this.captureIntervalUnitsAsString(), other.captureIntervalUnitsAsString());
    }

    public String toString() {
        return ToString.builder((String)"FrameCaptureSettings").add("CaptureInterval", (Object)this.captureInterval()).add("CaptureIntervalUnits", (Object)this.captureIntervalUnitsAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CaptureInterval": {
                return Optional.ofNullable(clazz.cast(this.captureInterval()));
            }
            case "CaptureIntervalUnits": {
                return Optional.ofNullable(clazz.cast(this.captureIntervalUnitsAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FrameCaptureSettings, T> g) {
        return obj -> g.apply((FrameCaptureSettings)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer captureInterval;
        private String captureIntervalUnits;

        private BuilderImpl() {
        }

        private BuilderImpl(FrameCaptureSettings model) {
            this.captureInterval(model.captureInterval);
            this.captureIntervalUnits(model.captureIntervalUnits);
        }

        public final Integer getCaptureInterval() {
            return this.captureInterval;
        }

        @Override
        public final Builder captureInterval(Integer captureInterval) {
            this.captureInterval = captureInterval;
            return this;
        }

        public final void setCaptureInterval(Integer captureInterval) {
            this.captureInterval = captureInterval;
        }

        public final String getCaptureIntervalUnitsAsString() {
            return this.captureIntervalUnits;
        }

        @Override
        public final Builder captureIntervalUnits(String captureIntervalUnits) {
            this.captureIntervalUnits = captureIntervalUnits;
            return this;
        }

        @Override
        public final Builder captureIntervalUnits(FrameCaptureIntervalUnit captureIntervalUnits) {
            this.captureIntervalUnits(captureIntervalUnits == null ? null : captureIntervalUnits.toString());
            return this;
        }

        public final void setCaptureIntervalUnits(String captureIntervalUnits) {
            this.captureIntervalUnits = captureIntervalUnits;
        }

        public FrameCaptureSettings build() {
            return new FrameCaptureSettings(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, FrameCaptureSettings> {
        public Builder captureInterval(Integer var1);

        public Builder captureIntervalUnits(String var1);

        public Builder captureIntervalUnits(FrameCaptureIntervalUnit var1);
    }
}

