/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum TimecodeConfigSource {
    EMBEDDED("EMBEDDED"),
    SYSTEMCLOCK("SYSTEMCLOCK"),
    ZEROBASED("ZEROBASED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private TimecodeConfigSource(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static TimecodeConfigSource fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(TimecodeConfigSource.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<TimecodeConfigSource> knownValues() {
        return Stream.of(TimecodeConfigSource.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

