/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.medialive.model.VideoSelectorColorSpace;
import software.amazon.awssdk.services.medialive.model.VideoSelectorColorSpaceUsage;
import software.amazon.awssdk.services.medialive.model.VideoSelectorSettings;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class VideoSelector
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, VideoSelector> {
    private static final SdkField<String> COLOR_SPACE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(VideoSelector.getter(VideoSelector::colorSpaceAsString)).setter(VideoSelector.setter(Builder::colorSpace)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("colorSpace").build()}).build();
    private static final SdkField<String> COLOR_SPACE_USAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(VideoSelector.getter(VideoSelector::colorSpaceUsageAsString)).setter(VideoSelector.setter(Builder::colorSpaceUsage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("colorSpaceUsage").build()}).build();
    private static final SdkField<VideoSelectorSettings> SELECTOR_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(VideoSelector.getter(VideoSelector::selectorSettings)).setter(VideoSelector.setter(Builder::selectorSettings)).constructor(VideoSelectorSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("selectorSettings").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COLOR_SPACE_FIELD, COLOR_SPACE_USAGE_FIELD, SELECTOR_SETTINGS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String colorSpace;
    private final String colorSpaceUsage;
    private final VideoSelectorSettings selectorSettings;

    private VideoSelector(BuilderImpl builder) {
        this.colorSpace = builder.colorSpace;
        this.colorSpaceUsage = builder.colorSpaceUsage;
        this.selectorSettings = builder.selectorSettings;
    }

    public VideoSelectorColorSpace colorSpace() {
        return VideoSelectorColorSpace.fromValue(this.colorSpace);
    }

    public String colorSpaceAsString() {
        return this.colorSpace;
    }

    public VideoSelectorColorSpaceUsage colorSpaceUsage() {
        return VideoSelectorColorSpaceUsage.fromValue(this.colorSpaceUsage);
    }

    public String colorSpaceUsageAsString() {
        return this.colorSpaceUsage;
    }

    public VideoSelectorSettings selectorSettings() {
        return this.selectorSettings;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.colorSpaceAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.colorSpaceUsageAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.selectorSettings());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VideoSelector)) {
            return false;
        }
        VideoSelector other = (VideoSelector)obj;
        return Objects.equals(this.colorSpaceAsString(), other.colorSpaceAsString()) && Objects.equals(this.colorSpaceUsageAsString(), other.colorSpaceUsageAsString()) && Objects.equals(this.selectorSettings(), other.selectorSettings());
    }

    public String toString() {
        return ToString.builder((String)"VideoSelector").add("ColorSpace", (Object)this.colorSpaceAsString()).add("ColorSpaceUsage", (Object)this.colorSpaceUsageAsString()).add("SelectorSettings", (Object)this.selectorSettings()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ColorSpace": {
                return Optional.ofNullable(clazz.cast(this.colorSpaceAsString()));
            }
            case "ColorSpaceUsage": {
                return Optional.ofNullable(clazz.cast(this.colorSpaceUsageAsString()));
            }
            case "SelectorSettings": {
                return Optional.ofNullable(clazz.cast(this.selectorSettings()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<VideoSelector, T> g) {
        return obj -> g.apply((VideoSelector)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String colorSpace;
        private String colorSpaceUsage;
        private VideoSelectorSettings selectorSettings;

        private BuilderImpl() {
        }

        private BuilderImpl(VideoSelector model) {
            this.colorSpace(model.colorSpace);
            this.colorSpaceUsage(model.colorSpaceUsage);
            this.selectorSettings(model.selectorSettings);
        }

        public final String getColorSpace() {
            return this.colorSpace;
        }

        @Override
        public final Builder colorSpace(String colorSpace) {
            this.colorSpace = colorSpace;
            return this;
        }

        @Override
        public final Builder colorSpace(VideoSelectorColorSpace colorSpace) {
            this.colorSpace(colorSpace.toString());
            return this;
        }

        public final void setColorSpace(String colorSpace) {
            this.colorSpace = colorSpace;
        }

        public final String getColorSpaceUsage() {
            return this.colorSpaceUsage;
        }

        @Override
        public final Builder colorSpaceUsage(String colorSpaceUsage) {
            this.colorSpaceUsage = colorSpaceUsage;
            return this;
        }

        @Override
        public final Builder colorSpaceUsage(VideoSelectorColorSpaceUsage colorSpaceUsage) {
            this.colorSpaceUsage(colorSpaceUsage.toString());
            return this;
        }

        public final void setColorSpaceUsage(String colorSpaceUsage) {
            this.colorSpaceUsage = colorSpaceUsage;
        }

        public final VideoSelectorSettings.Builder getSelectorSettings() {
            return this.selectorSettings != null ? this.selectorSettings.toBuilder() : null;
        }

        @Override
        public final Builder selectorSettings(VideoSelectorSettings selectorSettings) {
            this.selectorSettings = selectorSettings;
            return this;
        }

        public final void setSelectorSettings(VideoSelectorSettings.BuilderImpl selectorSettings) {
            this.selectorSettings = selectorSettings != null ? selectorSettings.build() : null;
        }

        public VideoSelector build() {
            return new VideoSelector(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, VideoSelector> {
        public Builder colorSpace(String var1);

        public Builder colorSpace(VideoSelectorColorSpace var1);

        public Builder colorSpaceUsage(String var1);

        public Builder colorSpaceUsage(VideoSelectorColorSpaceUsage var1);

        public Builder selectorSettings(VideoSelectorSettings var1);

        default public Builder selectorSettings(Consumer<VideoSelectorSettings.Builder> selectorSettings) {
            return this.selectorSettings((VideoSelectorSettings)((VideoSelectorSettings.Builder)VideoSelectorSettings.builder().applyMutation(selectorSettings)).build());
        }
    }
}

