/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.medialive.MediaLiveClient;
import software.amazon.awssdk.services.medialive.model.DescribeScheduleRequest;
import software.amazon.awssdk.services.medialive.model.DescribeScheduleResponse;
import software.amazon.awssdk.services.medialive.model.ScheduleAction;

public class DescribeScheduleIterable
implements SdkIterable<DescribeScheduleResponse> {
    private final MediaLiveClient client;
    private final DescribeScheduleRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeScheduleIterable(MediaLiveClient client, DescribeScheduleRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeScheduleResponseFetcher();
    }

    public Iterator<DescribeScheduleResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ScheduleAction> scheduleActions() {
        Function<DescribeScheduleResponse, Iterator> getIterator = response -> {
            if (response != null && response.scheduleActions() != null) {
                return response.scheduleActions().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private final DescribeScheduleIterable resume(DescribeScheduleResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new DescribeScheduleIterable(this.client, (DescribeScheduleRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new DescribeScheduleIterable(this.client, this.firstRequest){

            @Override
            public Iterator<DescribeScheduleResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class DescribeScheduleResponseFetcher
    implements SyncPageFetcher<DescribeScheduleResponse> {
        private DescribeScheduleResponseFetcher() {
        }

        public boolean hasNextPage(DescribeScheduleResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeScheduleResponse nextPage(DescribeScheduleResponse previousPage) {
            if (previousPage == null) {
                return DescribeScheduleIterable.this.client.describeSchedule(DescribeScheduleIterable.this.firstRequest);
            }
            return DescribeScheduleIterable.this.client.describeSchedule((DescribeScheduleRequest)((Object)DescribeScheduleIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

