/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.medialive.model.OutputLocationRef;
import software.amazon.awssdk.services.medialive.model.RtmpOutputCertificateMode;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RtmpOutputSettings
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RtmpOutputSettings> {
    private static final SdkField<String> CERTIFICATE_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(RtmpOutputSettings.getter(RtmpOutputSettings::certificateModeAsString)).setter(RtmpOutputSettings.setter(Builder::certificateMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("certificateMode").build()}).build();
    private static final SdkField<Integer> CONNECTION_RETRY_INTERVAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(RtmpOutputSettings.getter(RtmpOutputSettings::connectionRetryInterval)).setter(RtmpOutputSettings.setter(Builder::connectionRetryInterval)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectionRetryInterval").build()}).build();
    private static final SdkField<OutputLocationRef> DESTINATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(RtmpOutputSettings.getter(RtmpOutputSettings::destination)).setter(RtmpOutputSettings.setter(Builder::destination)).constructor(OutputLocationRef::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destination").build()}).build();
    private static final SdkField<Integer> NUM_RETRIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(RtmpOutputSettings.getter(RtmpOutputSettings::numRetries)).setter(RtmpOutputSettings.setter(Builder::numRetries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("numRetries").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CERTIFICATE_MODE_FIELD, CONNECTION_RETRY_INTERVAL_FIELD, DESTINATION_FIELD, NUM_RETRIES_FIELD));
    private static final long serialVersionUID = 1L;
    private final String certificateMode;
    private final Integer connectionRetryInterval;
    private final OutputLocationRef destination;
    private final Integer numRetries;

    private RtmpOutputSettings(BuilderImpl builder) {
        this.certificateMode = builder.certificateMode;
        this.connectionRetryInterval = builder.connectionRetryInterval;
        this.destination = builder.destination;
        this.numRetries = builder.numRetries;
    }

    public RtmpOutputCertificateMode certificateMode() {
        return RtmpOutputCertificateMode.fromValue(this.certificateMode);
    }

    public String certificateModeAsString() {
        return this.certificateMode;
    }

    public Integer connectionRetryInterval() {
        return this.connectionRetryInterval;
    }

    public OutputLocationRef destination() {
        return this.destination;
    }

    public Integer numRetries() {
        return this.numRetries;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.certificateModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.connectionRetryInterval());
        hashCode = 31 * hashCode + Objects.hashCode(this.destination());
        hashCode = 31 * hashCode + Objects.hashCode(this.numRetries());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RtmpOutputSettings)) {
            return false;
        }
        RtmpOutputSettings other = (RtmpOutputSettings)obj;
        return Objects.equals(this.certificateModeAsString(), other.certificateModeAsString()) && Objects.equals(this.connectionRetryInterval(), other.connectionRetryInterval()) && Objects.equals(this.destination(), other.destination()) && Objects.equals(this.numRetries(), other.numRetries());
    }

    public String toString() {
        return ToString.builder((String)"RtmpOutputSettings").add("CertificateMode", (Object)this.certificateModeAsString()).add("ConnectionRetryInterval", (Object)this.connectionRetryInterval()).add("Destination", (Object)this.destination()).add("NumRetries", (Object)this.numRetries()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CertificateMode": {
                return Optional.ofNullable(clazz.cast(this.certificateModeAsString()));
            }
            case "ConnectionRetryInterval": {
                return Optional.ofNullable(clazz.cast(this.connectionRetryInterval()));
            }
            case "Destination": {
                return Optional.ofNullable(clazz.cast(this.destination()));
            }
            case "NumRetries": {
                return Optional.ofNullable(clazz.cast(this.numRetries()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RtmpOutputSettings, T> g) {
        return obj -> g.apply((RtmpOutputSettings)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String certificateMode;
        private Integer connectionRetryInterval;
        private OutputLocationRef destination;
        private Integer numRetries;

        private BuilderImpl() {
        }

        private BuilderImpl(RtmpOutputSettings model) {
            this.certificateMode(model.certificateMode);
            this.connectionRetryInterval(model.connectionRetryInterval);
            this.destination(model.destination);
            this.numRetries(model.numRetries);
        }

        public final String getCertificateMode() {
            return this.certificateMode;
        }

        @Override
        public final Builder certificateMode(String certificateMode) {
            this.certificateMode = certificateMode;
            return this;
        }

        @Override
        public final Builder certificateMode(RtmpOutputCertificateMode certificateMode) {
            this.certificateMode(certificateMode.toString());
            return this;
        }

        public final void setCertificateMode(String certificateMode) {
            this.certificateMode = certificateMode;
        }

        public final Integer getConnectionRetryInterval() {
            return this.connectionRetryInterval;
        }

        @Override
        public final Builder connectionRetryInterval(Integer connectionRetryInterval) {
            this.connectionRetryInterval = connectionRetryInterval;
            return this;
        }

        public final void setConnectionRetryInterval(Integer connectionRetryInterval) {
            this.connectionRetryInterval = connectionRetryInterval;
        }

        public final OutputLocationRef.Builder getDestination() {
            return this.destination != null ? this.destination.toBuilder() : null;
        }

        @Override
        public final Builder destination(OutputLocationRef destination) {
            this.destination = destination;
            return this;
        }

        public final void setDestination(OutputLocationRef.BuilderImpl destination) {
            this.destination = destination != null ? destination.build() : null;
        }

        public final Integer getNumRetries() {
            return this.numRetries;
        }

        @Override
        public final Builder numRetries(Integer numRetries) {
            this.numRetries = numRetries;
            return this;
        }

        public final void setNumRetries(Integer numRetries) {
            this.numRetries = numRetries;
        }

        public RtmpOutputSettings build() {
            return new RtmpOutputSettings(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RtmpOutputSettings> {
        public Builder certificateMode(String var1);

        public Builder certificateMode(RtmpOutputCertificateMode var1);

        public Builder connectionRetryInterval(Integer var1);

        public Builder destination(OutputLocationRef var1);

        default public Builder destination(Consumer<OutputLocationRef.Builder> destination) {
            return this.destination((OutputLocationRef)((OutputLocationRef.Builder)OutputLocationRef.builder().applyMutation(destination)).build());
        }

        public Builder numRetries(Integer var1);
    }
}

