/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.medialive.model.AuthenticationScheme;
import software.amazon.awssdk.services.medialive.model.InputLossActionForRtmpOut;
import software.amazon.awssdk.services.medialive.model.RtmpCacheFullBehavior;
import software.amazon.awssdk.services.medialive.model.RtmpCaptionData;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RtmpGroupSettings
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RtmpGroupSettings> {
    private static final SdkField<String> AUTHENTICATION_SCHEME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(RtmpGroupSettings.getter(RtmpGroupSettings::authenticationSchemeAsString)).setter(RtmpGroupSettings.setter(Builder::authenticationScheme)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authenticationScheme").build()}).build();
    private static final SdkField<String> CACHE_FULL_BEHAVIOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(RtmpGroupSettings.getter(RtmpGroupSettings::cacheFullBehaviorAsString)).setter(RtmpGroupSettings.setter(Builder::cacheFullBehavior)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cacheFullBehavior").build()}).build();
    private static final SdkField<Integer> CACHE_LENGTH_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(RtmpGroupSettings.getter(RtmpGroupSettings::cacheLength)).setter(RtmpGroupSettings.setter(Builder::cacheLength)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cacheLength").build()}).build();
    private static final SdkField<String> CAPTION_DATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(RtmpGroupSettings.getter(RtmpGroupSettings::captionDataAsString)).setter(RtmpGroupSettings.setter(Builder::captionData)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("captionData").build()}).build();
    private static final SdkField<String> INPUT_LOSS_ACTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(RtmpGroupSettings.getter(RtmpGroupSettings::inputLossActionAsString)).setter(RtmpGroupSettings.setter(Builder::inputLossAction)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputLossAction").build()}).build();
    private static final SdkField<Integer> RESTART_DELAY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(RtmpGroupSettings.getter(RtmpGroupSettings::restartDelay)).setter(RtmpGroupSettings.setter(Builder::restartDelay)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("restartDelay").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTHENTICATION_SCHEME_FIELD, CACHE_FULL_BEHAVIOR_FIELD, CACHE_LENGTH_FIELD, CAPTION_DATA_FIELD, INPUT_LOSS_ACTION_FIELD, RESTART_DELAY_FIELD));
    private static final long serialVersionUID = 1L;
    private final String authenticationScheme;
    private final String cacheFullBehavior;
    private final Integer cacheLength;
    private final String captionData;
    private final String inputLossAction;
    private final Integer restartDelay;

    private RtmpGroupSettings(BuilderImpl builder) {
        this.authenticationScheme = builder.authenticationScheme;
        this.cacheFullBehavior = builder.cacheFullBehavior;
        this.cacheLength = builder.cacheLength;
        this.captionData = builder.captionData;
        this.inputLossAction = builder.inputLossAction;
        this.restartDelay = builder.restartDelay;
    }

    public AuthenticationScheme authenticationScheme() {
        return AuthenticationScheme.fromValue(this.authenticationScheme);
    }

    public String authenticationSchemeAsString() {
        return this.authenticationScheme;
    }

    public RtmpCacheFullBehavior cacheFullBehavior() {
        return RtmpCacheFullBehavior.fromValue(this.cacheFullBehavior);
    }

    public String cacheFullBehaviorAsString() {
        return this.cacheFullBehavior;
    }

    public Integer cacheLength() {
        return this.cacheLength;
    }

    public RtmpCaptionData captionData() {
        return RtmpCaptionData.fromValue(this.captionData);
    }

    public String captionDataAsString() {
        return this.captionData;
    }

    public InputLossActionForRtmpOut inputLossAction() {
        return InputLossActionForRtmpOut.fromValue(this.inputLossAction);
    }

    public String inputLossActionAsString() {
        return this.inputLossAction;
    }

    public Integer restartDelay() {
        return this.restartDelay;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.authenticationSchemeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.cacheFullBehaviorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.cacheLength());
        hashCode = 31 * hashCode + Objects.hashCode(this.captionDataAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.inputLossActionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.restartDelay());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RtmpGroupSettings)) {
            return false;
        }
        RtmpGroupSettings other = (RtmpGroupSettings)obj;
        return Objects.equals(this.authenticationSchemeAsString(), other.authenticationSchemeAsString()) && Objects.equals(this.cacheFullBehaviorAsString(), other.cacheFullBehaviorAsString()) && Objects.equals(this.cacheLength(), other.cacheLength()) && Objects.equals(this.captionDataAsString(), other.captionDataAsString()) && Objects.equals(this.inputLossActionAsString(), other.inputLossActionAsString()) && Objects.equals(this.restartDelay(), other.restartDelay());
    }

    public String toString() {
        return ToString.builder((String)"RtmpGroupSettings").add("AuthenticationScheme", (Object)this.authenticationSchemeAsString()).add("CacheFullBehavior", (Object)this.cacheFullBehaviorAsString()).add("CacheLength", (Object)this.cacheLength()).add("CaptionData", (Object)this.captionDataAsString()).add("InputLossAction", (Object)this.inputLossActionAsString()).add("RestartDelay", (Object)this.restartDelay()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AuthenticationScheme": {
                return Optional.ofNullable(clazz.cast(this.authenticationSchemeAsString()));
            }
            case "CacheFullBehavior": {
                return Optional.ofNullable(clazz.cast(this.cacheFullBehaviorAsString()));
            }
            case "CacheLength": {
                return Optional.ofNullable(clazz.cast(this.cacheLength()));
            }
            case "CaptionData": {
                return Optional.ofNullable(clazz.cast(this.captionDataAsString()));
            }
            case "InputLossAction": {
                return Optional.ofNullable(clazz.cast(this.inputLossActionAsString()));
            }
            case "RestartDelay": {
                return Optional.ofNullable(clazz.cast(this.restartDelay()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RtmpGroupSettings, T> g) {
        return obj -> g.apply((RtmpGroupSettings)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String authenticationScheme;
        private String cacheFullBehavior;
        private Integer cacheLength;
        private String captionData;
        private String inputLossAction;
        private Integer restartDelay;

        private BuilderImpl() {
        }

        private BuilderImpl(RtmpGroupSettings model) {
            this.authenticationScheme(model.authenticationScheme);
            this.cacheFullBehavior(model.cacheFullBehavior);
            this.cacheLength(model.cacheLength);
            this.captionData(model.captionData);
            this.inputLossAction(model.inputLossAction);
            this.restartDelay(model.restartDelay);
        }

        public final String getAuthenticationScheme() {
            return this.authenticationScheme;
        }

        @Override
        public final Builder authenticationScheme(String authenticationScheme) {
            this.authenticationScheme = authenticationScheme;
            return this;
        }

        @Override
        public final Builder authenticationScheme(AuthenticationScheme authenticationScheme) {
            this.authenticationScheme(authenticationScheme.toString());
            return this;
        }

        public final void setAuthenticationScheme(String authenticationScheme) {
            this.authenticationScheme = authenticationScheme;
        }

        public final String getCacheFullBehavior() {
            return this.cacheFullBehavior;
        }

        @Override
        public final Builder cacheFullBehavior(String cacheFullBehavior) {
            this.cacheFullBehavior = cacheFullBehavior;
            return this;
        }

        @Override
        public final Builder cacheFullBehavior(RtmpCacheFullBehavior cacheFullBehavior) {
            this.cacheFullBehavior(cacheFullBehavior.toString());
            return this;
        }

        public final void setCacheFullBehavior(String cacheFullBehavior) {
            this.cacheFullBehavior = cacheFullBehavior;
        }

        public final Integer getCacheLength() {
            return this.cacheLength;
        }

        @Override
        public final Builder cacheLength(Integer cacheLength) {
            this.cacheLength = cacheLength;
            return this;
        }

        public final void setCacheLength(Integer cacheLength) {
            this.cacheLength = cacheLength;
        }

        public final String getCaptionData() {
            return this.captionData;
        }

        @Override
        public final Builder captionData(String captionData) {
            this.captionData = captionData;
            return this;
        }

        @Override
        public final Builder captionData(RtmpCaptionData captionData) {
            this.captionData(captionData.toString());
            return this;
        }

        public final void setCaptionData(String captionData) {
            this.captionData = captionData;
        }

        public final String getInputLossAction() {
            return this.inputLossAction;
        }

        @Override
        public final Builder inputLossAction(String inputLossAction) {
            this.inputLossAction = inputLossAction;
            return this;
        }

        @Override
        public final Builder inputLossAction(InputLossActionForRtmpOut inputLossAction) {
            this.inputLossAction(inputLossAction.toString());
            return this;
        }

        public final void setInputLossAction(String inputLossAction) {
            this.inputLossAction = inputLossAction;
        }

        public final Integer getRestartDelay() {
            return this.restartDelay;
        }

        @Override
        public final Builder restartDelay(Integer restartDelay) {
            this.restartDelay = restartDelay;
            return this;
        }

        public final void setRestartDelay(Integer restartDelay) {
            this.restartDelay = restartDelay;
        }

        public RtmpGroupSettings build() {
            return new RtmpGroupSettings(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RtmpGroupSettings> {
        public Builder authenticationScheme(String var1);

        public Builder authenticationScheme(AuthenticationScheme var1);

        public Builder cacheFullBehavior(String var1);

        public Builder cacheFullBehavior(RtmpCacheFullBehavior var1);

        public Builder cacheLength(Integer var1);

        public Builder captionData(String var1);

        public Builder captionData(RtmpCaptionData var1);

        public Builder inputLossAction(String var1);

        public Builder inputLossAction(InputLossActionForRtmpOut var1);

        public Builder restartDelay(Integer var1);
    }
}

