/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.medialive.model.AfdSignaling;
import software.amazon.awssdk.services.medialive.model.FixedAfd;
import software.amazon.awssdk.services.medialive.model.H264AdaptiveQuantization;
import software.amazon.awssdk.services.medialive.model.H264ColorMetadata;
import software.amazon.awssdk.services.medialive.model.H264EntropyEncoding;
import software.amazon.awssdk.services.medialive.model.H264FlickerAq;
import software.amazon.awssdk.services.medialive.model.H264FramerateControl;
import software.amazon.awssdk.services.medialive.model.H264GopBReference;
import software.amazon.awssdk.services.medialive.model.H264GopSizeUnits;
import software.amazon.awssdk.services.medialive.model.H264Level;
import software.amazon.awssdk.services.medialive.model.H264LookAheadRateControl;
import software.amazon.awssdk.services.medialive.model.H264ParControl;
import software.amazon.awssdk.services.medialive.model.H264Profile;
import software.amazon.awssdk.services.medialive.model.H264RateControlMode;
import software.amazon.awssdk.services.medialive.model.H264ScanType;
import software.amazon.awssdk.services.medialive.model.H264SceneChangeDetect;
import software.amazon.awssdk.services.medialive.model.H264SpatialAq;
import software.amazon.awssdk.services.medialive.model.H264Syntax;
import software.amazon.awssdk.services.medialive.model.H264TemporalAq;
import software.amazon.awssdk.services.medialive.model.H264TimecodeInsertionBehavior;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class H264Settings
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, H264Settings> {
    private static final SdkField<String> ADAPTIVE_QUANTIZATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(H264Settings.getter(H264Settings::adaptiveQuantizationAsString)).setter(H264Settings.setter(Builder::adaptiveQuantization)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("adaptiveQuantization").build()}).build();
    private static final SdkField<String> AFD_SIGNALING_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(H264Settings.getter(H264Settings::afdSignalingAsString)).setter(H264Settings.setter(Builder::afdSignaling)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("afdSignaling").build()}).build();
    private static final SdkField<Integer> BITRATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(H264Settings.getter(H264Settings::bitrate)).setter(H264Settings.setter(Builder::bitrate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bitrate").build()}).build();
    private static final SdkField<Integer> BUF_FILL_PCT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(H264Settings.getter(H264Settings::bufFillPct)).setter(H264Settings.setter(Builder::bufFillPct)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bufFillPct").build()}).build();
    private static final SdkField<Integer> BUF_SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(H264Settings.getter(H264Settings::bufSize)).setter(H264Settings.setter(Builder::bufSize)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bufSize").build()}).build();
    private static final SdkField<String> COLOR_METADATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(H264Settings.getter(H264Settings::colorMetadataAsString)).setter(H264Settings.setter(Builder::colorMetadata)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("colorMetadata").build()}).build();
    private static final SdkField<String> ENTROPY_ENCODING_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(H264Settings.getter(H264Settings::entropyEncodingAsString)).setter(H264Settings.setter(Builder::entropyEncoding)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("entropyEncoding").build()}).build();
    private static final SdkField<String> FIXED_AFD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(H264Settings.getter(H264Settings::fixedAfdAsString)).setter(H264Settings.setter(Builder::fixedAfd)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fixedAfd").build()}).build();
    private static final SdkField<String> FLICKER_AQ_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(H264Settings.getter(H264Settings::flickerAqAsString)).setter(H264Settings.setter(Builder::flickerAq)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("flickerAq").build()}).build();
    private static final SdkField<String> FRAMERATE_CONTROL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(H264Settings.getter(H264Settings::framerateControlAsString)).setter(H264Settings.setter(Builder::framerateControl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("framerateControl").build()}).build();
    private static final SdkField<Integer> FRAMERATE_DENOMINATOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(H264Settings.getter(H264Settings::framerateDenominator)).setter(H264Settings.setter(Builder::framerateDenominator)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("framerateDenominator").build()}).build();
    private static final SdkField<Integer> FRAMERATE_NUMERATOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(H264Settings.getter(H264Settings::framerateNumerator)).setter(H264Settings.setter(Builder::framerateNumerator)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("framerateNumerator").build()}).build();
    private static final SdkField<String> GOP_B_REFERENCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(H264Settings.getter(H264Settings::gopBReferenceAsString)).setter(H264Settings.setter(Builder::gopBReference)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("gopBReference").build()}).build();
    private static final SdkField<Integer> GOP_CLOSED_CADENCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(H264Settings.getter(H264Settings::gopClosedCadence)).setter(H264Settings.setter(Builder::gopClosedCadence)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("gopClosedCadence").build()}).build();
    private static final SdkField<Integer> GOP_NUM_B_FRAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(H264Settings.getter(H264Settings::gopNumBFrames)).setter(H264Settings.setter(Builder::gopNumBFrames)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("gopNumBFrames").build()}).build();
    private static final SdkField<Double> GOP_SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).getter(H264Settings.getter(H264Settings::gopSize)).setter(H264Settings.setter(Builder::gopSize)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("gopSize").build()}).build();
    private static final SdkField<String> GOP_SIZE_UNITS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(H264Settings.getter(H264Settings::gopSizeUnitsAsString)).setter(H264Settings.setter(Builder::gopSizeUnits)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("gopSizeUnits").build()}).build();
    private static final SdkField<String> LEVEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(H264Settings.getter(H264Settings::levelAsString)).setter(H264Settings.setter(Builder::level)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("level").build()}).build();
    private static final SdkField<String> LOOK_AHEAD_RATE_CONTROL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(H264Settings.getter(H264Settings::lookAheadRateControlAsString)).setter(H264Settings.setter(Builder::lookAheadRateControl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lookAheadRateControl").build()}).build();
    private static final SdkField<Integer> MAX_BITRATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(H264Settings.getter(H264Settings::maxBitrate)).setter(H264Settings.setter(Builder::maxBitrate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxBitrate").build()}).build();
    private static final SdkField<Integer> MIN_I_INTERVAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(H264Settings.getter(H264Settings::minIInterval)).setter(H264Settings.setter(Builder::minIInterval)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("minIInterval").build()}).build();
    private static final SdkField<Integer> NUM_REF_FRAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(H264Settings.getter(H264Settings::numRefFrames)).setter(H264Settings.setter(Builder::numRefFrames)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("numRefFrames").build()}).build();
    private static final SdkField<String> PAR_CONTROL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(H264Settings.getter(H264Settings::parControlAsString)).setter(H264Settings.setter(Builder::parControl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parControl").build()}).build();
    private static final SdkField<Integer> PAR_DENOMINATOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(H264Settings.getter(H264Settings::parDenominator)).setter(H264Settings.setter(Builder::parDenominator)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parDenominator").build()}).build();
    private static final SdkField<Integer> PAR_NUMERATOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(H264Settings.getter(H264Settings::parNumerator)).setter(H264Settings.setter(Builder::parNumerator)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parNumerator").build()}).build();
    private static final SdkField<String> PROFILE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(H264Settings.getter(H264Settings::profileAsString)).setter(H264Settings.setter(Builder::profile)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("profile").build()}).build();
    private static final SdkField<Integer> QVBR_QUALITY_LEVEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(H264Settings.getter(H264Settings::qvbrQualityLevel)).setter(H264Settings.setter(Builder::qvbrQualityLevel)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("qvbrQualityLevel").build()}).build();
    private static final SdkField<String> RATE_CONTROL_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(H264Settings.getter(H264Settings::rateControlModeAsString)).setter(H264Settings.setter(Builder::rateControlMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rateControlMode").build()}).build();
    private static final SdkField<String> SCAN_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(H264Settings.getter(H264Settings::scanTypeAsString)).setter(H264Settings.setter(Builder::scanType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scanType").build()}).build();
    private static final SdkField<String> SCENE_CHANGE_DETECT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(H264Settings.getter(H264Settings::sceneChangeDetectAsString)).setter(H264Settings.setter(Builder::sceneChangeDetect)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sceneChangeDetect").build()}).build();
    private static final SdkField<Integer> SLICES_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(H264Settings.getter(H264Settings::slices)).setter(H264Settings.setter(Builder::slices)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("slices").build()}).build();
    private static final SdkField<Integer> SOFTNESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(H264Settings.getter(H264Settings::softness)).setter(H264Settings.setter(Builder::softness)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("softness").build()}).build();
    private static final SdkField<String> SPATIAL_AQ_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(H264Settings.getter(H264Settings::spatialAqAsString)).setter(H264Settings.setter(Builder::spatialAq)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("spatialAq").build()}).build();
    private static final SdkField<String> SYNTAX_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(H264Settings.getter(H264Settings::syntaxAsString)).setter(H264Settings.setter(Builder::syntax)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("syntax").build()}).build();
    private static final SdkField<String> TEMPORAL_AQ_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(H264Settings.getter(H264Settings::temporalAqAsString)).setter(H264Settings.setter(Builder::temporalAq)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("temporalAq").build()}).build();
    private static final SdkField<String> TIMECODE_INSERTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(H264Settings.getter(H264Settings::timecodeInsertionAsString)).setter(H264Settings.setter(Builder::timecodeInsertion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timecodeInsertion").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ADAPTIVE_QUANTIZATION_FIELD, AFD_SIGNALING_FIELD, BITRATE_FIELD, BUF_FILL_PCT_FIELD, BUF_SIZE_FIELD, COLOR_METADATA_FIELD, ENTROPY_ENCODING_FIELD, FIXED_AFD_FIELD, FLICKER_AQ_FIELD, FRAMERATE_CONTROL_FIELD, FRAMERATE_DENOMINATOR_FIELD, FRAMERATE_NUMERATOR_FIELD, GOP_B_REFERENCE_FIELD, GOP_CLOSED_CADENCE_FIELD, GOP_NUM_B_FRAMES_FIELD, GOP_SIZE_FIELD, GOP_SIZE_UNITS_FIELD, LEVEL_FIELD, LOOK_AHEAD_RATE_CONTROL_FIELD, MAX_BITRATE_FIELD, MIN_I_INTERVAL_FIELD, NUM_REF_FRAMES_FIELD, PAR_CONTROL_FIELD, PAR_DENOMINATOR_FIELD, PAR_NUMERATOR_FIELD, PROFILE_FIELD, QVBR_QUALITY_LEVEL_FIELD, RATE_CONTROL_MODE_FIELD, SCAN_TYPE_FIELD, SCENE_CHANGE_DETECT_FIELD, SLICES_FIELD, SOFTNESS_FIELD, SPATIAL_AQ_FIELD, SYNTAX_FIELD, TEMPORAL_AQ_FIELD, TIMECODE_INSERTION_FIELD));
    private static final long serialVersionUID = 1L;
    private final String adaptiveQuantization;
    private final String afdSignaling;
    private final Integer bitrate;
    private final Integer bufFillPct;
    private final Integer bufSize;
    private final String colorMetadata;
    private final String entropyEncoding;
    private final String fixedAfd;
    private final String flickerAq;
    private final String framerateControl;
    private final Integer framerateDenominator;
    private final Integer framerateNumerator;
    private final String gopBReference;
    private final Integer gopClosedCadence;
    private final Integer gopNumBFrames;
    private final Double gopSize;
    private final String gopSizeUnits;
    private final String level;
    private final String lookAheadRateControl;
    private final Integer maxBitrate;
    private final Integer minIInterval;
    private final Integer numRefFrames;
    private final String parControl;
    private final Integer parDenominator;
    private final Integer parNumerator;
    private final String profile;
    private final Integer qvbrQualityLevel;
    private final String rateControlMode;
    private final String scanType;
    private final String sceneChangeDetect;
    private final Integer slices;
    private final Integer softness;
    private final String spatialAq;
    private final String syntax;
    private final String temporalAq;
    private final String timecodeInsertion;

    private H264Settings(BuilderImpl builder) {
        this.adaptiveQuantization = builder.adaptiveQuantization;
        this.afdSignaling = builder.afdSignaling;
        this.bitrate = builder.bitrate;
        this.bufFillPct = builder.bufFillPct;
        this.bufSize = builder.bufSize;
        this.colorMetadata = builder.colorMetadata;
        this.entropyEncoding = builder.entropyEncoding;
        this.fixedAfd = builder.fixedAfd;
        this.flickerAq = builder.flickerAq;
        this.framerateControl = builder.framerateControl;
        this.framerateDenominator = builder.framerateDenominator;
        this.framerateNumerator = builder.framerateNumerator;
        this.gopBReference = builder.gopBReference;
        this.gopClosedCadence = builder.gopClosedCadence;
        this.gopNumBFrames = builder.gopNumBFrames;
        this.gopSize = builder.gopSize;
        this.gopSizeUnits = builder.gopSizeUnits;
        this.level = builder.level;
        this.lookAheadRateControl = builder.lookAheadRateControl;
        this.maxBitrate = builder.maxBitrate;
        this.minIInterval = builder.minIInterval;
        this.numRefFrames = builder.numRefFrames;
        this.parControl = builder.parControl;
        this.parDenominator = builder.parDenominator;
        this.parNumerator = builder.parNumerator;
        this.profile = builder.profile;
        this.qvbrQualityLevel = builder.qvbrQualityLevel;
        this.rateControlMode = builder.rateControlMode;
        this.scanType = builder.scanType;
        this.sceneChangeDetect = builder.sceneChangeDetect;
        this.slices = builder.slices;
        this.softness = builder.softness;
        this.spatialAq = builder.spatialAq;
        this.syntax = builder.syntax;
        this.temporalAq = builder.temporalAq;
        this.timecodeInsertion = builder.timecodeInsertion;
    }

    public H264AdaptiveQuantization adaptiveQuantization() {
        return H264AdaptiveQuantization.fromValue(this.adaptiveQuantization);
    }

    public String adaptiveQuantizationAsString() {
        return this.adaptiveQuantization;
    }

    public AfdSignaling afdSignaling() {
        return AfdSignaling.fromValue(this.afdSignaling);
    }

    public String afdSignalingAsString() {
        return this.afdSignaling;
    }

    public Integer bitrate() {
        return this.bitrate;
    }

    public Integer bufFillPct() {
        return this.bufFillPct;
    }

    public Integer bufSize() {
        return this.bufSize;
    }

    public H264ColorMetadata colorMetadata() {
        return H264ColorMetadata.fromValue(this.colorMetadata);
    }

    public String colorMetadataAsString() {
        return this.colorMetadata;
    }

    public H264EntropyEncoding entropyEncoding() {
        return H264EntropyEncoding.fromValue(this.entropyEncoding);
    }

    public String entropyEncodingAsString() {
        return this.entropyEncoding;
    }

    public FixedAfd fixedAfd() {
        return FixedAfd.fromValue(this.fixedAfd);
    }

    public String fixedAfdAsString() {
        return this.fixedAfd;
    }

    public H264FlickerAq flickerAq() {
        return H264FlickerAq.fromValue(this.flickerAq);
    }

    public String flickerAqAsString() {
        return this.flickerAq;
    }

    public H264FramerateControl framerateControl() {
        return H264FramerateControl.fromValue(this.framerateControl);
    }

    public String framerateControlAsString() {
        return this.framerateControl;
    }

    public Integer framerateDenominator() {
        return this.framerateDenominator;
    }

    public Integer framerateNumerator() {
        return this.framerateNumerator;
    }

    public H264GopBReference gopBReference() {
        return H264GopBReference.fromValue(this.gopBReference);
    }

    public String gopBReferenceAsString() {
        return this.gopBReference;
    }

    public Integer gopClosedCadence() {
        return this.gopClosedCadence;
    }

    public Integer gopNumBFrames() {
        return this.gopNumBFrames;
    }

    public Double gopSize() {
        return this.gopSize;
    }

    public H264GopSizeUnits gopSizeUnits() {
        return H264GopSizeUnits.fromValue(this.gopSizeUnits);
    }

    public String gopSizeUnitsAsString() {
        return this.gopSizeUnits;
    }

    public H264Level level() {
        return H264Level.fromValue(this.level);
    }

    public String levelAsString() {
        return this.level;
    }

    public H264LookAheadRateControl lookAheadRateControl() {
        return H264LookAheadRateControl.fromValue(this.lookAheadRateControl);
    }

    public String lookAheadRateControlAsString() {
        return this.lookAheadRateControl;
    }

    public Integer maxBitrate() {
        return this.maxBitrate;
    }

    public Integer minIInterval() {
        return this.minIInterval;
    }

    public Integer numRefFrames() {
        return this.numRefFrames;
    }

    public H264ParControl parControl() {
        return H264ParControl.fromValue(this.parControl);
    }

    public String parControlAsString() {
        return this.parControl;
    }

    public Integer parDenominator() {
        return this.parDenominator;
    }

    public Integer parNumerator() {
        return this.parNumerator;
    }

    public H264Profile profile() {
        return H264Profile.fromValue(this.profile);
    }

    public String profileAsString() {
        return this.profile;
    }

    public Integer qvbrQualityLevel() {
        return this.qvbrQualityLevel;
    }

    public H264RateControlMode rateControlMode() {
        return H264RateControlMode.fromValue(this.rateControlMode);
    }

    public String rateControlModeAsString() {
        return this.rateControlMode;
    }

    public H264ScanType scanType() {
        return H264ScanType.fromValue(this.scanType);
    }

    public String scanTypeAsString() {
        return this.scanType;
    }

    public H264SceneChangeDetect sceneChangeDetect() {
        return H264SceneChangeDetect.fromValue(this.sceneChangeDetect);
    }

    public String sceneChangeDetectAsString() {
        return this.sceneChangeDetect;
    }

    public Integer slices() {
        return this.slices;
    }

    public Integer softness() {
        return this.softness;
    }

    public H264SpatialAq spatialAq() {
        return H264SpatialAq.fromValue(this.spatialAq);
    }

    public String spatialAqAsString() {
        return this.spatialAq;
    }

    public H264Syntax syntax() {
        return H264Syntax.fromValue(this.syntax);
    }

    public String syntaxAsString() {
        return this.syntax;
    }

    public H264TemporalAq temporalAq() {
        return H264TemporalAq.fromValue(this.temporalAq);
    }

    public String temporalAqAsString() {
        return this.temporalAq;
    }

    public H264TimecodeInsertionBehavior timecodeInsertion() {
        return H264TimecodeInsertionBehavior.fromValue(this.timecodeInsertion);
    }

    public String timecodeInsertionAsString() {
        return this.timecodeInsertion;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.adaptiveQuantizationAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.afdSignalingAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.bitrate());
        hashCode = 31 * hashCode + Objects.hashCode(this.bufFillPct());
        hashCode = 31 * hashCode + Objects.hashCode(this.bufSize());
        hashCode = 31 * hashCode + Objects.hashCode(this.colorMetadataAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.entropyEncodingAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.fixedAfdAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.flickerAqAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.framerateControlAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.framerateDenominator());
        hashCode = 31 * hashCode + Objects.hashCode(this.framerateNumerator());
        hashCode = 31 * hashCode + Objects.hashCode(this.gopBReferenceAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.gopClosedCadence());
        hashCode = 31 * hashCode + Objects.hashCode(this.gopNumBFrames());
        hashCode = 31 * hashCode + Objects.hashCode(this.gopSize());
        hashCode = 31 * hashCode + Objects.hashCode(this.gopSizeUnitsAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.levelAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.lookAheadRateControlAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxBitrate());
        hashCode = 31 * hashCode + Objects.hashCode(this.minIInterval());
        hashCode = 31 * hashCode + Objects.hashCode(this.numRefFrames());
        hashCode = 31 * hashCode + Objects.hashCode(this.parControlAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.parDenominator());
        hashCode = 31 * hashCode + Objects.hashCode(this.parNumerator());
        hashCode = 31 * hashCode + Objects.hashCode(this.profileAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.qvbrQualityLevel());
        hashCode = 31 * hashCode + Objects.hashCode(this.rateControlModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.scanTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.sceneChangeDetectAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.slices());
        hashCode = 31 * hashCode + Objects.hashCode(this.softness());
        hashCode = 31 * hashCode + Objects.hashCode(this.spatialAqAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.syntaxAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.temporalAqAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.timecodeInsertionAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof H264Settings)) {
            return false;
        }
        H264Settings other = (H264Settings)obj;
        return Objects.equals(this.adaptiveQuantizationAsString(), other.adaptiveQuantizationAsString()) && Objects.equals(this.afdSignalingAsString(), other.afdSignalingAsString()) && Objects.equals(this.bitrate(), other.bitrate()) && Objects.equals(this.bufFillPct(), other.bufFillPct()) && Objects.equals(this.bufSize(), other.bufSize()) && Objects.equals(this.colorMetadataAsString(), other.colorMetadataAsString()) && Objects.equals(this.entropyEncodingAsString(), other.entropyEncodingAsString()) && Objects.equals(this.fixedAfdAsString(), other.fixedAfdAsString()) && Objects.equals(this.flickerAqAsString(), other.flickerAqAsString()) && Objects.equals(this.framerateControlAsString(), other.framerateControlAsString()) && Objects.equals(this.framerateDenominator(), other.framerateDenominator()) && Objects.equals(this.framerateNumerator(), other.framerateNumerator()) && Objects.equals(this.gopBReferenceAsString(), other.gopBReferenceAsString()) && Objects.equals(this.gopClosedCadence(), other.gopClosedCadence()) && Objects.equals(this.gopNumBFrames(), other.gopNumBFrames()) && Objects.equals(this.gopSize(), other.gopSize()) && Objects.equals(this.gopSizeUnitsAsString(), other.gopSizeUnitsAsString()) && Objects.equals(this.levelAsString(), other.levelAsString()) && Objects.equals(this.lookAheadRateControlAsString(), other.lookAheadRateControlAsString()) && Objects.equals(this.maxBitrate(), other.maxBitrate()) && Objects.equals(this.minIInterval(), other.minIInterval()) && Objects.equals(this.numRefFrames(), other.numRefFrames()) && Objects.equals(this.parControlAsString(), other.parControlAsString()) && Objects.equals(this.parDenominator(), other.parDenominator()) && Objects.equals(this.parNumerator(), other.parNumerator()) && Objects.equals(this.profileAsString(), other.profileAsString()) && Objects.equals(this.qvbrQualityLevel(), other.qvbrQualityLevel()) && Objects.equals(this.rateControlModeAsString(), other.rateControlModeAsString()) && Objects.equals(this.scanTypeAsString(), other.scanTypeAsString()) && Objects.equals(this.sceneChangeDetectAsString(), other.sceneChangeDetectAsString()) && Objects.equals(this.slices(), other.slices()) && Objects.equals(this.softness(), other.softness()) && Objects.equals(this.spatialAqAsString(), other.spatialAqAsString()) && Objects.equals(this.syntaxAsString(), other.syntaxAsString()) && Objects.equals(this.temporalAqAsString(), other.temporalAqAsString()) && Objects.equals(this.timecodeInsertionAsString(), other.timecodeInsertionAsString());
    }

    public String toString() {
        return ToString.builder((String)"H264Settings").add("AdaptiveQuantization", (Object)this.adaptiveQuantizationAsString()).add("AfdSignaling", (Object)this.afdSignalingAsString()).add("Bitrate", (Object)this.bitrate()).add("BufFillPct", (Object)this.bufFillPct()).add("BufSize", (Object)this.bufSize()).add("ColorMetadata", (Object)this.colorMetadataAsString()).add("EntropyEncoding", (Object)this.entropyEncodingAsString()).add("FixedAfd", (Object)this.fixedAfdAsString()).add("FlickerAq", (Object)this.flickerAqAsString()).add("FramerateControl", (Object)this.framerateControlAsString()).add("FramerateDenominator", (Object)this.framerateDenominator()).add("FramerateNumerator", (Object)this.framerateNumerator()).add("GopBReference", (Object)this.gopBReferenceAsString()).add("GopClosedCadence", (Object)this.gopClosedCadence()).add("GopNumBFrames", (Object)this.gopNumBFrames()).add("GopSize", (Object)this.gopSize()).add("GopSizeUnits", (Object)this.gopSizeUnitsAsString()).add("Level", (Object)this.levelAsString()).add("LookAheadRateControl", (Object)this.lookAheadRateControlAsString()).add("MaxBitrate", (Object)this.maxBitrate()).add("MinIInterval", (Object)this.minIInterval()).add("NumRefFrames", (Object)this.numRefFrames()).add("ParControl", (Object)this.parControlAsString()).add("ParDenominator", (Object)this.parDenominator()).add("ParNumerator", (Object)this.parNumerator()).add("Profile", (Object)this.profileAsString()).add("QvbrQualityLevel", (Object)this.qvbrQualityLevel()).add("RateControlMode", (Object)this.rateControlModeAsString()).add("ScanType", (Object)this.scanTypeAsString()).add("SceneChangeDetect", (Object)this.sceneChangeDetectAsString()).add("Slices", (Object)this.slices()).add("Softness", (Object)this.softness()).add("SpatialAq", (Object)this.spatialAqAsString()).add("Syntax", (Object)this.syntaxAsString()).add("TemporalAq", (Object)this.temporalAqAsString()).add("TimecodeInsertion", (Object)this.timecodeInsertionAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AdaptiveQuantization": {
                return Optional.ofNullable(clazz.cast(this.adaptiveQuantizationAsString()));
            }
            case "AfdSignaling": {
                return Optional.ofNullable(clazz.cast(this.afdSignalingAsString()));
            }
            case "Bitrate": {
                return Optional.ofNullable(clazz.cast(this.bitrate()));
            }
            case "BufFillPct": {
                return Optional.ofNullable(clazz.cast(this.bufFillPct()));
            }
            case "BufSize": {
                return Optional.ofNullable(clazz.cast(this.bufSize()));
            }
            case "ColorMetadata": {
                return Optional.ofNullable(clazz.cast(this.colorMetadataAsString()));
            }
            case "EntropyEncoding": {
                return Optional.ofNullable(clazz.cast(this.entropyEncodingAsString()));
            }
            case "FixedAfd": {
                return Optional.ofNullable(clazz.cast(this.fixedAfdAsString()));
            }
            case "FlickerAq": {
                return Optional.ofNullable(clazz.cast(this.flickerAqAsString()));
            }
            case "FramerateControl": {
                return Optional.ofNullable(clazz.cast(this.framerateControlAsString()));
            }
            case "FramerateDenominator": {
                return Optional.ofNullable(clazz.cast(this.framerateDenominator()));
            }
            case "FramerateNumerator": {
                return Optional.ofNullable(clazz.cast(this.framerateNumerator()));
            }
            case "GopBReference": {
                return Optional.ofNullable(clazz.cast(this.gopBReferenceAsString()));
            }
            case "GopClosedCadence": {
                return Optional.ofNullable(clazz.cast(this.gopClosedCadence()));
            }
            case "GopNumBFrames": {
                return Optional.ofNullable(clazz.cast(this.gopNumBFrames()));
            }
            case "GopSize": {
                return Optional.ofNullable(clazz.cast(this.gopSize()));
            }
            case "GopSizeUnits": {
                return Optional.ofNullable(clazz.cast(this.gopSizeUnitsAsString()));
            }
            case "Level": {
                return Optional.ofNullable(clazz.cast(this.levelAsString()));
            }
            case "LookAheadRateControl": {
                return Optional.ofNullable(clazz.cast(this.lookAheadRateControlAsString()));
            }
            case "MaxBitrate": {
                return Optional.ofNullable(clazz.cast(this.maxBitrate()));
            }
            case "MinIInterval": {
                return Optional.ofNullable(clazz.cast(this.minIInterval()));
            }
            case "NumRefFrames": {
                return Optional.ofNullable(clazz.cast(this.numRefFrames()));
            }
            case "ParControl": {
                return Optional.ofNullable(clazz.cast(this.parControlAsString()));
            }
            case "ParDenominator": {
                return Optional.ofNullable(clazz.cast(this.parDenominator()));
            }
            case "ParNumerator": {
                return Optional.ofNullable(clazz.cast(this.parNumerator()));
            }
            case "Profile": {
                return Optional.ofNullable(clazz.cast(this.profileAsString()));
            }
            case "QvbrQualityLevel": {
                return Optional.ofNullable(clazz.cast(this.qvbrQualityLevel()));
            }
            case "RateControlMode": {
                return Optional.ofNullable(clazz.cast(this.rateControlModeAsString()));
            }
            case "ScanType": {
                return Optional.ofNullable(clazz.cast(this.scanTypeAsString()));
            }
            case "SceneChangeDetect": {
                return Optional.ofNullable(clazz.cast(this.sceneChangeDetectAsString()));
            }
            case "Slices": {
                return Optional.ofNullable(clazz.cast(this.slices()));
            }
            case "Softness": {
                return Optional.ofNullable(clazz.cast(this.softness()));
            }
            case "SpatialAq": {
                return Optional.ofNullable(clazz.cast(this.spatialAqAsString()));
            }
            case "Syntax": {
                return Optional.ofNullable(clazz.cast(this.syntaxAsString()));
            }
            case "TemporalAq": {
                return Optional.ofNullable(clazz.cast(this.temporalAqAsString()));
            }
            case "TimecodeInsertion": {
                return Optional.ofNullable(clazz.cast(this.timecodeInsertionAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<H264Settings, T> g) {
        return obj -> g.apply((H264Settings)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String adaptiveQuantization;
        private String afdSignaling;
        private Integer bitrate;
        private Integer bufFillPct;
        private Integer bufSize;
        private String colorMetadata;
        private String entropyEncoding;
        private String fixedAfd;
        private String flickerAq;
        private String framerateControl;
        private Integer framerateDenominator;
        private Integer framerateNumerator;
        private String gopBReference;
        private Integer gopClosedCadence;
        private Integer gopNumBFrames;
        private Double gopSize;
        private String gopSizeUnits;
        private String level;
        private String lookAheadRateControl;
        private Integer maxBitrate;
        private Integer minIInterval;
        private Integer numRefFrames;
        private String parControl;
        private Integer parDenominator;
        private Integer parNumerator;
        private String profile;
        private Integer qvbrQualityLevel;
        private String rateControlMode;
        private String scanType;
        private String sceneChangeDetect;
        private Integer slices;
        private Integer softness;
        private String spatialAq;
        private String syntax;
        private String temporalAq;
        private String timecodeInsertion;

        private BuilderImpl() {
        }

        private BuilderImpl(H264Settings model) {
            this.adaptiveQuantization(model.adaptiveQuantization);
            this.afdSignaling(model.afdSignaling);
            this.bitrate(model.bitrate);
            this.bufFillPct(model.bufFillPct);
            this.bufSize(model.bufSize);
            this.colorMetadata(model.colorMetadata);
            this.entropyEncoding(model.entropyEncoding);
            this.fixedAfd(model.fixedAfd);
            this.flickerAq(model.flickerAq);
            this.framerateControl(model.framerateControl);
            this.framerateDenominator(model.framerateDenominator);
            this.framerateNumerator(model.framerateNumerator);
            this.gopBReference(model.gopBReference);
            this.gopClosedCadence(model.gopClosedCadence);
            this.gopNumBFrames(model.gopNumBFrames);
            this.gopSize(model.gopSize);
            this.gopSizeUnits(model.gopSizeUnits);
            this.level(model.level);
            this.lookAheadRateControl(model.lookAheadRateControl);
            this.maxBitrate(model.maxBitrate);
            this.minIInterval(model.minIInterval);
            this.numRefFrames(model.numRefFrames);
            this.parControl(model.parControl);
            this.parDenominator(model.parDenominator);
            this.parNumerator(model.parNumerator);
            this.profile(model.profile);
            this.qvbrQualityLevel(model.qvbrQualityLevel);
            this.rateControlMode(model.rateControlMode);
            this.scanType(model.scanType);
            this.sceneChangeDetect(model.sceneChangeDetect);
            this.slices(model.slices);
            this.softness(model.softness);
            this.spatialAq(model.spatialAq);
            this.syntax(model.syntax);
            this.temporalAq(model.temporalAq);
            this.timecodeInsertion(model.timecodeInsertion);
        }

        public final String getAdaptiveQuantization() {
            return this.adaptiveQuantization;
        }

        @Override
        public final Builder adaptiveQuantization(String adaptiveQuantization) {
            this.adaptiveQuantization = adaptiveQuantization;
            return this;
        }

        @Override
        public final Builder adaptiveQuantization(H264AdaptiveQuantization adaptiveQuantization) {
            this.adaptiveQuantization(adaptiveQuantization.toString());
            return this;
        }

        public final void setAdaptiveQuantization(String adaptiveQuantization) {
            this.adaptiveQuantization = adaptiveQuantization;
        }

        public final String getAfdSignaling() {
            return this.afdSignaling;
        }

        @Override
        public final Builder afdSignaling(String afdSignaling) {
            this.afdSignaling = afdSignaling;
            return this;
        }

        @Override
        public final Builder afdSignaling(AfdSignaling afdSignaling) {
            this.afdSignaling(afdSignaling.toString());
            return this;
        }

        public final void setAfdSignaling(String afdSignaling) {
            this.afdSignaling = afdSignaling;
        }

        public final Integer getBitrate() {
            return this.bitrate;
        }

        @Override
        public final Builder bitrate(Integer bitrate) {
            this.bitrate = bitrate;
            return this;
        }

        public final void setBitrate(Integer bitrate) {
            this.bitrate = bitrate;
        }

        public final Integer getBufFillPct() {
            return this.bufFillPct;
        }

        @Override
        public final Builder bufFillPct(Integer bufFillPct) {
            this.bufFillPct = bufFillPct;
            return this;
        }

        public final void setBufFillPct(Integer bufFillPct) {
            this.bufFillPct = bufFillPct;
        }

        public final Integer getBufSize() {
            return this.bufSize;
        }

        @Override
        public final Builder bufSize(Integer bufSize) {
            this.bufSize = bufSize;
            return this;
        }

        public final void setBufSize(Integer bufSize) {
            this.bufSize = bufSize;
        }

        public final String getColorMetadata() {
            return this.colorMetadata;
        }

        @Override
        public final Builder colorMetadata(String colorMetadata) {
            this.colorMetadata = colorMetadata;
            return this;
        }

        @Override
        public final Builder colorMetadata(H264ColorMetadata colorMetadata) {
            this.colorMetadata(colorMetadata.toString());
            return this;
        }

        public final void setColorMetadata(String colorMetadata) {
            this.colorMetadata = colorMetadata;
        }

        public final String getEntropyEncoding() {
            return this.entropyEncoding;
        }

        @Override
        public final Builder entropyEncoding(String entropyEncoding) {
            this.entropyEncoding = entropyEncoding;
            return this;
        }

        @Override
        public final Builder entropyEncoding(H264EntropyEncoding entropyEncoding) {
            this.entropyEncoding(entropyEncoding.toString());
            return this;
        }

        public final void setEntropyEncoding(String entropyEncoding) {
            this.entropyEncoding = entropyEncoding;
        }

        public final String getFixedAfd() {
            return this.fixedAfd;
        }

        @Override
        public final Builder fixedAfd(String fixedAfd) {
            this.fixedAfd = fixedAfd;
            return this;
        }

        @Override
        public final Builder fixedAfd(FixedAfd fixedAfd) {
            this.fixedAfd(fixedAfd.toString());
            return this;
        }

        public final void setFixedAfd(String fixedAfd) {
            this.fixedAfd = fixedAfd;
        }

        public final String getFlickerAq() {
            return this.flickerAq;
        }

        @Override
        public final Builder flickerAq(String flickerAq) {
            this.flickerAq = flickerAq;
            return this;
        }

        @Override
        public final Builder flickerAq(H264FlickerAq flickerAq) {
            this.flickerAq(flickerAq.toString());
            return this;
        }

        public final void setFlickerAq(String flickerAq) {
            this.flickerAq = flickerAq;
        }

        public final String getFramerateControl() {
            return this.framerateControl;
        }

        @Override
        public final Builder framerateControl(String framerateControl) {
            this.framerateControl = framerateControl;
            return this;
        }

        @Override
        public final Builder framerateControl(H264FramerateControl framerateControl) {
            this.framerateControl(framerateControl.toString());
            return this;
        }

        public final void setFramerateControl(String framerateControl) {
            this.framerateControl = framerateControl;
        }

        public final Integer getFramerateDenominator() {
            return this.framerateDenominator;
        }

        @Override
        public final Builder framerateDenominator(Integer framerateDenominator) {
            this.framerateDenominator = framerateDenominator;
            return this;
        }

        public final void setFramerateDenominator(Integer framerateDenominator) {
            this.framerateDenominator = framerateDenominator;
        }

        public final Integer getFramerateNumerator() {
            return this.framerateNumerator;
        }

        @Override
        public final Builder framerateNumerator(Integer framerateNumerator) {
            this.framerateNumerator = framerateNumerator;
            return this;
        }

        public final void setFramerateNumerator(Integer framerateNumerator) {
            this.framerateNumerator = framerateNumerator;
        }

        public final String getGopBReference() {
            return this.gopBReference;
        }

        @Override
        public final Builder gopBReference(String gopBReference) {
            this.gopBReference = gopBReference;
            return this;
        }

        @Override
        public final Builder gopBReference(H264GopBReference gopBReference) {
            this.gopBReference(gopBReference.toString());
            return this;
        }

        public final void setGopBReference(String gopBReference) {
            this.gopBReference = gopBReference;
        }

        public final Integer getGopClosedCadence() {
            return this.gopClosedCadence;
        }

        @Override
        public final Builder gopClosedCadence(Integer gopClosedCadence) {
            this.gopClosedCadence = gopClosedCadence;
            return this;
        }

        public final void setGopClosedCadence(Integer gopClosedCadence) {
            this.gopClosedCadence = gopClosedCadence;
        }

        public final Integer getGopNumBFrames() {
            return this.gopNumBFrames;
        }

        @Override
        public final Builder gopNumBFrames(Integer gopNumBFrames) {
            this.gopNumBFrames = gopNumBFrames;
            return this;
        }

        public final void setGopNumBFrames(Integer gopNumBFrames) {
            this.gopNumBFrames = gopNumBFrames;
        }

        public final Double getGopSize() {
            return this.gopSize;
        }

        @Override
        public final Builder gopSize(Double gopSize) {
            this.gopSize = gopSize;
            return this;
        }

        public final void setGopSize(Double gopSize) {
            this.gopSize = gopSize;
        }

        public final String getGopSizeUnits() {
            return this.gopSizeUnits;
        }

        @Override
        public final Builder gopSizeUnits(String gopSizeUnits) {
            this.gopSizeUnits = gopSizeUnits;
            return this;
        }

        @Override
        public final Builder gopSizeUnits(H264GopSizeUnits gopSizeUnits) {
            this.gopSizeUnits(gopSizeUnits.toString());
            return this;
        }

        public final void setGopSizeUnits(String gopSizeUnits) {
            this.gopSizeUnits = gopSizeUnits;
        }

        public final String getLevel() {
            return this.level;
        }

        @Override
        public final Builder level(String level) {
            this.level = level;
            return this;
        }

        @Override
        public final Builder level(H264Level level) {
            this.level(level.toString());
            return this;
        }

        public final void setLevel(String level) {
            this.level = level;
        }

        public final String getLookAheadRateControl() {
            return this.lookAheadRateControl;
        }

        @Override
        public final Builder lookAheadRateControl(String lookAheadRateControl) {
            this.lookAheadRateControl = lookAheadRateControl;
            return this;
        }

        @Override
        public final Builder lookAheadRateControl(H264LookAheadRateControl lookAheadRateControl) {
            this.lookAheadRateControl(lookAheadRateControl.toString());
            return this;
        }

        public final void setLookAheadRateControl(String lookAheadRateControl) {
            this.lookAheadRateControl = lookAheadRateControl;
        }

        public final Integer getMaxBitrate() {
            return this.maxBitrate;
        }

        @Override
        public final Builder maxBitrate(Integer maxBitrate) {
            this.maxBitrate = maxBitrate;
            return this;
        }

        public final void setMaxBitrate(Integer maxBitrate) {
            this.maxBitrate = maxBitrate;
        }

        public final Integer getMinIInterval() {
            return this.minIInterval;
        }

        @Override
        public final Builder minIInterval(Integer minIInterval) {
            this.minIInterval = minIInterval;
            return this;
        }

        public final void setMinIInterval(Integer minIInterval) {
            this.minIInterval = minIInterval;
        }

        public final Integer getNumRefFrames() {
            return this.numRefFrames;
        }

        @Override
        public final Builder numRefFrames(Integer numRefFrames) {
            this.numRefFrames = numRefFrames;
            return this;
        }

        public final void setNumRefFrames(Integer numRefFrames) {
            this.numRefFrames = numRefFrames;
        }

        public final String getParControl() {
            return this.parControl;
        }

        @Override
        public final Builder parControl(String parControl) {
            this.parControl = parControl;
            return this;
        }

        @Override
        public final Builder parControl(H264ParControl parControl) {
            this.parControl(parControl.toString());
            return this;
        }

        public final void setParControl(String parControl) {
            this.parControl = parControl;
        }

        public final Integer getParDenominator() {
            return this.parDenominator;
        }

        @Override
        public final Builder parDenominator(Integer parDenominator) {
            this.parDenominator = parDenominator;
            return this;
        }

        public final void setParDenominator(Integer parDenominator) {
            this.parDenominator = parDenominator;
        }

        public final Integer getParNumerator() {
            return this.parNumerator;
        }

        @Override
        public final Builder parNumerator(Integer parNumerator) {
            this.parNumerator = parNumerator;
            return this;
        }

        public final void setParNumerator(Integer parNumerator) {
            this.parNumerator = parNumerator;
        }

        public final String getProfile() {
            return this.profile;
        }

        @Override
        public final Builder profile(String profile) {
            this.profile = profile;
            return this;
        }

        @Override
        public final Builder profile(H264Profile profile) {
            this.profile(profile.toString());
            return this;
        }

        public final void setProfile(String profile) {
            this.profile = profile;
        }

        public final Integer getQvbrQualityLevel() {
            return this.qvbrQualityLevel;
        }

        @Override
        public final Builder qvbrQualityLevel(Integer qvbrQualityLevel) {
            this.qvbrQualityLevel = qvbrQualityLevel;
            return this;
        }

        public final void setQvbrQualityLevel(Integer qvbrQualityLevel) {
            this.qvbrQualityLevel = qvbrQualityLevel;
        }

        public final String getRateControlMode() {
            return this.rateControlMode;
        }

        @Override
        public final Builder rateControlMode(String rateControlMode) {
            this.rateControlMode = rateControlMode;
            return this;
        }

        @Override
        public final Builder rateControlMode(H264RateControlMode rateControlMode) {
            this.rateControlMode(rateControlMode.toString());
            return this;
        }

        public final void setRateControlMode(String rateControlMode) {
            this.rateControlMode = rateControlMode;
        }

        public final String getScanType() {
            return this.scanType;
        }

        @Override
        public final Builder scanType(String scanType) {
            this.scanType = scanType;
            return this;
        }

        @Override
        public final Builder scanType(H264ScanType scanType) {
            this.scanType(scanType.toString());
            return this;
        }

        public final void setScanType(String scanType) {
            this.scanType = scanType;
        }

        public final String getSceneChangeDetect() {
            return this.sceneChangeDetect;
        }

        @Override
        public final Builder sceneChangeDetect(String sceneChangeDetect) {
            this.sceneChangeDetect = sceneChangeDetect;
            return this;
        }

        @Override
        public final Builder sceneChangeDetect(H264SceneChangeDetect sceneChangeDetect) {
            this.sceneChangeDetect(sceneChangeDetect.toString());
            return this;
        }

        public final void setSceneChangeDetect(String sceneChangeDetect) {
            this.sceneChangeDetect = sceneChangeDetect;
        }

        public final Integer getSlices() {
            return this.slices;
        }

        @Override
        public final Builder slices(Integer slices) {
            this.slices = slices;
            return this;
        }

        public final void setSlices(Integer slices) {
            this.slices = slices;
        }

        public final Integer getSoftness() {
            return this.softness;
        }

        @Override
        public final Builder softness(Integer softness) {
            this.softness = softness;
            return this;
        }

        public final void setSoftness(Integer softness) {
            this.softness = softness;
        }

        public final String getSpatialAq() {
            return this.spatialAq;
        }

        @Override
        public final Builder spatialAq(String spatialAq) {
            this.spatialAq = spatialAq;
            return this;
        }

        @Override
        public final Builder spatialAq(H264SpatialAq spatialAq) {
            this.spatialAq(spatialAq.toString());
            return this;
        }

        public final void setSpatialAq(String spatialAq) {
            this.spatialAq = spatialAq;
        }

        public final String getSyntax() {
            return this.syntax;
        }

        @Override
        public final Builder syntax(String syntax) {
            this.syntax = syntax;
            return this;
        }

        @Override
        public final Builder syntax(H264Syntax syntax) {
            this.syntax(syntax.toString());
            return this;
        }

        public final void setSyntax(String syntax) {
            this.syntax = syntax;
        }

        public final String getTemporalAq() {
            return this.temporalAq;
        }

        @Override
        public final Builder temporalAq(String temporalAq) {
            this.temporalAq = temporalAq;
            return this;
        }

        @Override
        public final Builder temporalAq(H264TemporalAq temporalAq) {
            this.temporalAq(temporalAq.toString());
            return this;
        }

        public final void setTemporalAq(String temporalAq) {
            this.temporalAq = temporalAq;
        }

        public final String getTimecodeInsertion() {
            return this.timecodeInsertion;
        }

        @Override
        public final Builder timecodeInsertion(String timecodeInsertion) {
            this.timecodeInsertion = timecodeInsertion;
            return this;
        }

        @Override
        public final Builder timecodeInsertion(H264TimecodeInsertionBehavior timecodeInsertion) {
            this.timecodeInsertion(timecodeInsertion.toString());
            return this;
        }

        public final void setTimecodeInsertion(String timecodeInsertion) {
            this.timecodeInsertion = timecodeInsertion;
        }

        public H264Settings build() {
            return new H264Settings(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, H264Settings> {
        public Builder adaptiveQuantization(String var1);

        public Builder adaptiveQuantization(H264AdaptiveQuantization var1);

        public Builder afdSignaling(String var1);

        public Builder afdSignaling(AfdSignaling var1);

        public Builder bitrate(Integer var1);

        public Builder bufFillPct(Integer var1);

        public Builder bufSize(Integer var1);

        public Builder colorMetadata(String var1);

        public Builder colorMetadata(H264ColorMetadata var1);

        public Builder entropyEncoding(String var1);

        public Builder entropyEncoding(H264EntropyEncoding var1);

        public Builder fixedAfd(String var1);

        public Builder fixedAfd(FixedAfd var1);

        public Builder flickerAq(String var1);

        public Builder flickerAq(H264FlickerAq var1);

        public Builder framerateControl(String var1);

        public Builder framerateControl(H264FramerateControl var1);

        public Builder framerateDenominator(Integer var1);

        public Builder framerateNumerator(Integer var1);

        public Builder gopBReference(String var1);

        public Builder gopBReference(H264GopBReference var1);

        public Builder gopClosedCadence(Integer var1);

        public Builder gopNumBFrames(Integer var1);

        public Builder gopSize(Double var1);

        public Builder gopSizeUnits(String var1);

        public Builder gopSizeUnits(H264GopSizeUnits var1);

        public Builder level(String var1);

        public Builder level(H264Level var1);

        public Builder lookAheadRateControl(String var1);

        public Builder lookAheadRateControl(H264LookAheadRateControl var1);

        public Builder maxBitrate(Integer var1);

        public Builder minIInterval(Integer var1);

        public Builder numRefFrames(Integer var1);

        public Builder parControl(String var1);

        public Builder parControl(H264ParControl var1);

        public Builder parDenominator(Integer var1);

        public Builder parNumerator(Integer var1);

        public Builder profile(String var1);

        public Builder profile(H264Profile var1);

        public Builder qvbrQualityLevel(Integer var1);

        public Builder rateControlMode(String var1);

        public Builder rateControlMode(H264RateControlMode var1);

        public Builder scanType(String var1);

        public Builder scanType(H264ScanType var1);

        public Builder sceneChangeDetect(String var1);

        public Builder sceneChangeDetect(H264SceneChangeDetect var1);

        public Builder slices(Integer var1);

        public Builder softness(Integer var1);

        public Builder spatialAq(String var1);

        public Builder spatialAq(H264SpatialAq var1);

        public Builder syntax(String var1);

        public Builder syntax(H264Syntax var1);

        public Builder temporalAq(String var1);

        public Builder temporalAq(H264TemporalAq var1);

        public Builder timecodeInsertion(String var1);

        public Builder timecodeInsertion(H264TimecodeInsertionBehavior var1);
    }
}

