/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.medialive.model.AribSourceSettings;
import software.amazon.awssdk.services.medialive.model.DvbSubSourceSettings;
import software.amazon.awssdk.services.medialive.model.EmbeddedSourceSettings;
import software.amazon.awssdk.services.medialive.model.Scte20SourceSettings;
import software.amazon.awssdk.services.medialive.model.Scte27SourceSettings;
import software.amazon.awssdk.services.medialive.model.TeletextSourceSettings;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CaptionSelectorSettings
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CaptionSelectorSettings> {
    private static final SdkField<AribSourceSettings> ARIB_SOURCE_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(CaptionSelectorSettings.getter(CaptionSelectorSettings::aribSourceSettings)).setter(CaptionSelectorSettings.setter(Builder::aribSourceSettings)).constructor(AribSourceSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("aribSourceSettings").build()}).build();
    private static final SdkField<DvbSubSourceSettings> DVB_SUB_SOURCE_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(CaptionSelectorSettings.getter(CaptionSelectorSettings::dvbSubSourceSettings)).setter(CaptionSelectorSettings.setter(Builder::dvbSubSourceSettings)).constructor(DvbSubSourceSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dvbSubSourceSettings").build()}).build();
    private static final SdkField<EmbeddedSourceSettings> EMBEDDED_SOURCE_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(CaptionSelectorSettings.getter(CaptionSelectorSettings::embeddedSourceSettings)).setter(CaptionSelectorSettings.setter(Builder::embeddedSourceSettings)).constructor(EmbeddedSourceSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("embeddedSourceSettings").build()}).build();
    private static final SdkField<Scte20SourceSettings> SCTE20_SOURCE_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(CaptionSelectorSettings.getter(CaptionSelectorSettings::scte20SourceSettings)).setter(CaptionSelectorSettings.setter(Builder::scte20SourceSettings)).constructor(Scte20SourceSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scte20SourceSettings").build()}).build();
    private static final SdkField<Scte27SourceSettings> SCTE27_SOURCE_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(CaptionSelectorSettings.getter(CaptionSelectorSettings::scte27SourceSettings)).setter(CaptionSelectorSettings.setter(Builder::scte27SourceSettings)).constructor(Scte27SourceSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scte27SourceSettings").build()}).build();
    private static final SdkField<TeletextSourceSettings> TELETEXT_SOURCE_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(CaptionSelectorSettings.getter(CaptionSelectorSettings::teletextSourceSettings)).setter(CaptionSelectorSettings.setter(Builder::teletextSourceSettings)).constructor(TeletextSourceSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("teletextSourceSettings").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARIB_SOURCE_SETTINGS_FIELD, DVB_SUB_SOURCE_SETTINGS_FIELD, EMBEDDED_SOURCE_SETTINGS_FIELD, SCTE20_SOURCE_SETTINGS_FIELD, SCTE27_SOURCE_SETTINGS_FIELD, TELETEXT_SOURCE_SETTINGS_FIELD));
    private static final long serialVersionUID = 1L;
    private final AribSourceSettings aribSourceSettings;
    private final DvbSubSourceSettings dvbSubSourceSettings;
    private final EmbeddedSourceSettings embeddedSourceSettings;
    private final Scte20SourceSettings scte20SourceSettings;
    private final Scte27SourceSettings scte27SourceSettings;
    private final TeletextSourceSettings teletextSourceSettings;

    private CaptionSelectorSettings(BuilderImpl builder) {
        this.aribSourceSettings = builder.aribSourceSettings;
        this.dvbSubSourceSettings = builder.dvbSubSourceSettings;
        this.embeddedSourceSettings = builder.embeddedSourceSettings;
        this.scte20SourceSettings = builder.scte20SourceSettings;
        this.scte27SourceSettings = builder.scte27SourceSettings;
        this.teletextSourceSettings = builder.teletextSourceSettings;
    }

    public AribSourceSettings aribSourceSettings() {
        return this.aribSourceSettings;
    }

    public DvbSubSourceSettings dvbSubSourceSettings() {
        return this.dvbSubSourceSettings;
    }

    public EmbeddedSourceSettings embeddedSourceSettings() {
        return this.embeddedSourceSettings;
    }

    public Scte20SourceSettings scte20SourceSettings() {
        return this.scte20SourceSettings;
    }

    public Scte27SourceSettings scte27SourceSettings() {
        return this.scte27SourceSettings;
    }

    public TeletextSourceSettings teletextSourceSettings() {
        return this.teletextSourceSettings;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.aribSourceSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.dvbSubSourceSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.embeddedSourceSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.scte20SourceSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.scte27SourceSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.teletextSourceSettings());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CaptionSelectorSettings)) {
            return false;
        }
        CaptionSelectorSettings other = (CaptionSelectorSettings)obj;
        return Objects.equals(this.aribSourceSettings(), other.aribSourceSettings()) && Objects.equals(this.dvbSubSourceSettings(), other.dvbSubSourceSettings()) && Objects.equals(this.embeddedSourceSettings(), other.embeddedSourceSettings()) && Objects.equals(this.scte20SourceSettings(), other.scte20SourceSettings()) && Objects.equals(this.scte27SourceSettings(), other.scte27SourceSettings()) && Objects.equals(this.teletextSourceSettings(), other.teletextSourceSettings());
    }

    public String toString() {
        return ToString.builder((String)"CaptionSelectorSettings").add("AribSourceSettings", (Object)this.aribSourceSettings()).add("DvbSubSourceSettings", (Object)this.dvbSubSourceSettings()).add("EmbeddedSourceSettings", (Object)this.embeddedSourceSettings()).add("Scte20SourceSettings", (Object)this.scte20SourceSettings()).add("Scte27SourceSettings", (Object)this.scte27SourceSettings()).add("TeletextSourceSettings", (Object)this.teletextSourceSettings()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AribSourceSettings": {
                return Optional.ofNullable(clazz.cast(this.aribSourceSettings()));
            }
            case "DvbSubSourceSettings": {
                return Optional.ofNullable(clazz.cast(this.dvbSubSourceSettings()));
            }
            case "EmbeddedSourceSettings": {
                return Optional.ofNullable(clazz.cast(this.embeddedSourceSettings()));
            }
            case "Scte20SourceSettings": {
                return Optional.ofNullable(clazz.cast(this.scte20SourceSettings()));
            }
            case "Scte27SourceSettings": {
                return Optional.ofNullable(clazz.cast(this.scte27SourceSettings()));
            }
            case "TeletextSourceSettings": {
                return Optional.ofNullable(clazz.cast(this.teletextSourceSettings()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CaptionSelectorSettings, T> g) {
        return obj -> g.apply((CaptionSelectorSettings)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private AribSourceSettings aribSourceSettings;
        private DvbSubSourceSettings dvbSubSourceSettings;
        private EmbeddedSourceSettings embeddedSourceSettings;
        private Scte20SourceSettings scte20SourceSettings;
        private Scte27SourceSettings scte27SourceSettings;
        private TeletextSourceSettings teletextSourceSettings;

        private BuilderImpl() {
        }

        private BuilderImpl(CaptionSelectorSettings model) {
            this.aribSourceSettings(model.aribSourceSettings);
            this.dvbSubSourceSettings(model.dvbSubSourceSettings);
            this.embeddedSourceSettings(model.embeddedSourceSettings);
            this.scte20SourceSettings(model.scte20SourceSettings);
            this.scte27SourceSettings(model.scte27SourceSettings);
            this.teletextSourceSettings(model.teletextSourceSettings);
        }

        public final AribSourceSettings.Builder getAribSourceSettings() {
            return this.aribSourceSettings != null ? this.aribSourceSettings.toBuilder() : null;
        }

        @Override
        public final Builder aribSourceSettings(AribSourceSettings aribSourceSettings) {
            this.aribSourceSettings = aribSourceSettings;
            return this;
        }

        public final void setAribSourceSettings(AribSourceSettings.BuilderImpl aribSourceSettings) {
            this.aribSourceSettings = aribSourceSettings != null ? aribSourceSettings.build() : null;
        }

        public final DvbSubSourceSettings.Builder getDvbSubSourceSettings() {
            return this.dvbSubSourceSettings != null ? this.dvbSubSourceSettings.toBuilder() : null;
        }

        @Override
        public final Builder dvbSubSourceSettings(DvbSubSourceSettings dvbSubSourceSettings) {
            this.dvbSubSourceSettings = dvbSubSourceSettings;
            return this;
        }

        public final void setDvbSubSourceSettings(DvbSubSourceSettings.BuilderImpl dvbSubSourceSettings) {
            this.dvbSubSourceSettings = dvbSubSourceSettings != null ? dvbSubSourceSettings.build() : null;
        }

        public final EmbeddedSourceSettings.Builder getEmbeddedSourceSettings() {
            return this.embeddedSourceSettings != null ? this.embeddedSourceSettings.toBuilder() : null;
        }

        @Override
        public final Builder embeddedSourceSettings(EmbeddedSourceSettings embeddedSourceSettings) {
            this.embeddedSourceSettings = embeddedSourceSettings;
            return this;
        }

        public final void setEmbeddedSourceSettings(EmbeddedSourceSettings.BuilderImpl embeddedSourceSettings) {
            this.embeddedSourceSettings = embeddedSourceSettings != null ? embeddedSourceSettings.build() : null;
        }

        public final Scte20SourceSettings.Builder getScte20SourceSettings() {
            return this.scte20SourceSettings != null ? this.scte20SourceSettings.toBuilder() : null;
        }

        @Override
        public final Builder scte20SourceSettings(Scte20SourceSettings scte20SourceSettings) {
            this.scte20SourceSettings = scte20SourceSettings;
            return this;
        }

        public final void setScte20SourceSettings(Scte20SourceSettings.BuilderImpl scte20SourceSettings) {
            this.scte20SourceSettings = scte20SourceSettings != null ? scte20SourceSettings.build() : null;
        }

        public final Scte27SourceSettings.Builder getScte27SourceSettings() {
            return this.scte27SourceSettings != null ? this.scte27SourceSettings.toBuilder() : null;
        }

        @Override
        public final Builder scte27SourceSettings(Scte27SourceSettings scte27SourceSettings) {
            this.scte27SourceSettings = scte27SourceSettings;
            return this;
        }

        public final void setScte27SourceSettings(Scte27SourceSettings.BuilderImpl scte27SourceSettings) {
            this.scte27SourceSettings = scte27SourceSettings != null ? scte27SourceSettings.build() : null;
        }

        public final TeletextSourceSettings.Builder getTeletextSourceSettings() {
            return this.teletextSourceSettings != null ? this.teletextSourceSettings.toBuilder() : null;
        }

        @Override
        public final Builder teletextSourceSettings(TeletextSourceSettings teletextSourceSettings) {
            this.teletextSourceSettings = teletextSourceSettings;
            return this;
        }

        public final void setTeletextSourceSettings(TeletextSourceSettings.BuilderImpl teletextSourceSettings) {
            this.teletextSourceSettings = teletextSourceSettings != null ? teletextSourceSettings.build() : null;
        }

        public CaptionSelectorSettings build() {
            return new CaptionSelectorSettings(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CaptionSelectorSettings> {
        public Builder aribSourceSettings(AribSourceSettings var1);

        default public Builder aribSourceSettings(Consumer<AribSourceSettings.Builder> aribSourceSettings) {
            return this.aribSourceSettings((AribSourceSettings)((AribSourceSettings.Builder)AribSourceSettings.builder().applyMutation(aribSourceSettings)).build());
        }

        public Builder dvbSubSourceSettings(DvbSubSourceSettings var1);

        default public Builder dvbSubSourceSettings(Consumer<DvbSubSourceSettings.Builder> dvbSubSourceSettings) {
            return this.dvbSubSourceSettings((DvbSubSourceSettings)((DvbSubSourceSettings.Builder)DvbSubSourceSettings.builder().applyMutation(dvbSubSourceSettings)).build());
        }

        public Builder embeddedSourceSettings(EmbeddedSourceSettings var1);

        default public Builder embeddedSourceSettings(Consumer<EmbeddedSourceSettings.Builder> embeddedSourceSettings) {
            return this.embeddedSourceSettings((EmbeddedSourceSettings)((EmbeddedSourceSettings.Builder)EmbeddedSourceSettings.builder().applyMutation(embeddedSourceSettings)).build());
        }

        public Builder scte20SourceSettings(Scte20SourceSettings var1);

        default public Builder scte20SourceSettings(Consumer<Scte20SourceSettings.Builder> scte20SourceSettings) {
            return this.scte20SourceSettings((Scte20SourceSettings)((Scte20SourceSettings.Builder)Scte20SourceSettings.builder().applyMutation(scte20SourceSettings)).build());
        }

        public Builder scte27SourceSettings(Scte27SourceSettings var1);

        default public Builder scte27SourceSettings(Consumer<Scte27SourceSettings.Builder> scte27SourceSettings) {
            return this.scte27SourceSettings((Scte27SourceSettings)((Scte27SourceSettings.Builder)Scte27SourceSettings.builder().applyMutation(scte27SourceSettings)).build());
        }

        public Builder teletextSourceSettings(TeletextSourceSettings var1);

        default public Builder teletextSourceSettings(Consumer<TeletextSourceSettings.Builder> teletextSourceSettings) {
            return this.teletextSourceSettings((TeletextSourceSettings)((TeletextSourceSettings.Builder)TeletextSourceSettings.builder().applyMutation(teletextSourceSettings)).build());
        }
    }
}

