/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.mediaconvert.model.DeinterlaceAlgorithm;
import software.amazon.awssdk.services.mediaconvert.model.DeinterlacerControl;
import software.amazon.awssdk.services.mediaconvert.model.DeinterlacerMode;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Deinterlacer
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Deinterlacer> {
    private static final SdkField<String> ALGORITHM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Deinterlacer.getter(Deinterlacer::algorithmAsString)).setter(Deinterlacer.setter(Builder::algorithm)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("algorithm").build()}).build();
    private static final SdkField<String> CONTROL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Deinterlacer.getter(Deinterlacer::controlAsString)).setter(Deinterlacer.setter(Builder::control)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("control").build()}).build();
    private static final SdkField<String> MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Deinterlacer.getter(Deinterlacer::modeAsString)).setter(Deinterlacer.setter(Builder::mode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mode").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALGORITHM_FIELD, CONTROL_FIELD, MODE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String algorithm;
    private final String control;
    private final String mode;

    private Deinterlacer(BuilderImpl builder) {
        this.algorithm = builder.algorithm;
        this.control = builder.control;
        this.mode = builder.mode;
    }

    public DeinterlaceAlgorithm algorithm() {
        return DeinterlaceAlgorithm.fromValue(this.algorithm);
    }

    public String algorithmAsString() {
        return this.algorithm;
    }

    public DeinterlacerControl control() {
        return DeinterlacerControl.fromValue(this.control);
    }

    public String controlAsString() {
        return this.control;
    }

    public DeinterlacerMode mode() {
        return DeinterlacerMode.fromValue(this.mode);
    }

    public String modeAsString() {
        return this.mode;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.algorithmAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.controlAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.modeAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Deinterlacer)) {
            return false;
        }
        Deinterlacer other = (Deinterlacer)obj;
        return Objects.equals(this.algorithmAsString(), other.algorithmAsString()) && Objects.equals(this.controlAsString(), other.controlAsString()) && Objects.equals(this.modeAsString(), other.modeAsString());
    }

    public String toString() {
        return ToString.builder((String)"Deinterlacer").add("Algorithm", (Object)this.algorithmAsString()).add("Control", (Object)this.controlAsString()).add("Mode", (Object)this.modeAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Algorithm": {
                return Optional.ofNullable(clazz.cast(this.algorithmAsString()));
            }
            case "Control": {
                return Optional.ofNullable(clazz.cast(this.controlAsString()));
            }
            case "Mode": {
                return Optional.ofNullable(clazz.cast(this.modeAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Deinterlacer, T> g) {
        return obj -> g.apply((Deinterlacer)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String algorithm;
        private String control;
        private String mode;

        private BuilderImpl() {
        }

        private BuilderImpl(Deinterlacer model) {
            this.algorithm(model.algorithm);
            this.control(model.control);
            this.mode(model.mode);
        }

        public final String getAlgorithmAsString() {
            return this.algorithm;
        }

        @Override
        public final Builder algorithm(String algorithm) {
            this.algorithm = algorithm;
            return this;
        }

        @Override
        public final Builder algorithm(DeinterlaceAlgorithm algorithm) {
            this.algorithm(algorithm == null ? null : algorithm.toString());
            return this;
        }

        public final void setAlgorithm(String algorithm) {
            this.algorithm = algorithm;
        }

        public final String getControlAsString() {
            return this.control;
        }

        @Override
        public final Builder control(String control) {
            this.control = control;
            return this;
        }

        @Override
        public final Builder control(DeinterlacerControl control) {
            this.control(control == null ? null : control.toString());
            return this;
        }

        public final void setControl(String control) {
            this.control = control;
        }

        public final String getModeAsString() {
            return this.mode;
        }

        @Override
        public final Builder mode(String mode) {
            this.mode = mode;
            return this;
        }

        @Override
        public final Builder mode(DeinterlacerMode mode) {
            this.mode(mode == null ? null : mode.toString());
            return this;
        }

        public final void setMode(String mode) {
            this.mode = mode;
        }

        public Deinterlacer build() {
            return new Deinterlacer(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Deinterlacer> {
        public Builder algorithm(String var1);

        public Builder algorithm(DeinterlaceAlgorithm var1);

        public Builder control(String var1);

        public Builder control(DeinterlacerControl var1);

        public Builder mode(String var1);

        public Builder mode(DeinterlacerMode var1);
    }
}

