/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.mediaconvert.model.___listOf__integerCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TrackMapping
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TrackMapping> {
    private static final SdkField<List<Integer>> AUDIO_TRACK_INDEXES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AudioTrackIndexes").getter(TrackMapping.getter(TrackMapping::audioTrackIndexes)).setter(TrackMapping.setter(Builder::audioTrackIndexes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("audioTrackIndexes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.INTEGER).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Integer>> DATA_TRACK_INDEXES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DataTrackIndexes").getter(TrackMapping.getter(TrackMapping::dataTrackIndexes)).setter(TrackMapping.setter(Builder::dataTrackIndexes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataTrackIndexes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.INTEGER).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Integer>> VIDEO_TRACK_INDEXES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("VideoTrackIndexes").getter(TrackMapping.getter(TrackMapping::videoTrackIndexes)).setter(TrackMapping.setter(Builder::videoTrackIndexes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("videoTrackIndexes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.INTEGER).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUDIO_TRACK_INDEXES_FIELD, DATA_TRACK_INDEXES_FIELD, VIDEO_TRACK_INDEXES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = TrackMapping.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<Integer> audioTrackIndexes;
    private final List<Integer> dataTrackIndexes;
    private final List<Integer> videoTrackIndexes;

    private TrackMapping(BuilderImpl builder) {
        this.audioTrackIndexes = builder.audioTrackIndexes;
        this.dataTrackIndexes = builder.dataTrackIndexes;
        this.videoTrackIndexes = builder.videoTrackIndexes;
    }

    public final boolean hasAudioTrackIndexes() {
        return this.audioTrackIndexes != null && !(this.audioTrackIndexes instanceof SdkAutoConstructList);
    }

    public final List<Integer> audioTrackIndexes() {
        return this.audioTrackIndexes;
    }

    public final boolean hasDataTrackIndexes() {
        return this.dataTrackIndexes != null && !(this.dataTrackIndexes instanceof SdkAutoConstructList);
    }

    public final List<Integer> dataTrackIndexes() {
        return this.dataTrackIndexes;
    }

    public final boolean hasVideoTrackIndexes() {
        return this.videoTrackIndexes != null && !(this.videoTrackIndexes instanceof SdkAutoConstructList);
    }

    public final List<Integer> videoTrackIndexes() {
        return this.videoTrackIndexes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAudioTrackIndexes() ? this.audioTrackIndexes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDataTrackIndexes() ? this.dataTrackIndexes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasVideoTrackIndexes() ? this.videoTrackIndexes() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TrackMapping)) {
            return false;
        }
        TrackMapping other = (TrackMapping)obj;
        return this.hasAudioTrackIndexes() == other.hasAudioTrackIndexes() && Objects.equals(this.audioTrackIndexes(), other.audioTrackIndexes()) && this.hasDataTrackIndexes() == other.hasDataTrackIndexes() && Objects.equals(this.dataTrackIndexes(), other.dataTrackIndexes()) && this.hasVideoTrackIndexes() == other.hasVideoTrackIndexes() && Objects.equals(this.videoTrackIndexes(), other.videoTrackIndexes());
    }

    public final String toString() {
        return ToString.builder((String)"TrackMapping").add("AudioTrackIndexes", this.hasAudioTrackIndexes() ? this.audioTrackIndexes() : null).add("DataTrackIndexes", this.hasDataTrackIndexes() ? this.dataTrackIndexes() : null).add("VideoTrackIndexes", this.hasVideoTrackIndexes() ? this.videoTrackIndexes() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AudioTrackIndexes": {
                return Optional.ofNullable(clazz.cast(this.audioTrackIndexes()));
            }
            case "DataTrackIndexes": {
                return Optional.ofNullable(clazz.cast(this.dataTrackIndexes()));
            }
            case "VideoTrackIndexes": {
                return Optional.ofNullable(clazz.cast(this.videoTrackIndexes()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<List<Integer>>> map = new HashMap<String, SdkField<List<Integer>>>();
        map.put("audioTrackIndexes", AUDIO_TRACK_INDEXES_FIELD);
        map.put("dataTrackIndexes", DATA_TRACK_INDEXES_FIELD);
        map.put("videoTrackIndexes", VIDEO_TRACK_INDEXES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TrackMapping, T> g) {
        return obj -> g.apply((TrackMapping)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<Integer> audioTrackIndexes = DefaultSdkAutoConstructList.getInstance();
        private List<Integer> dataTrackIndexes = DefaultSdkAutoConstructList.getInstance();
        private List<Integer> videoTrackIndexes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(TrackMapping model) {
            this.audioTrackIndexes(model.audioTrackIndexes);
            this.dataTrackIndexes(model.dataTrackIndexes);
            this.videoTrackIndexes(model.videoTrackIndexes);
        }

        public final Collection<Integer> getAudioTrackIndexes() {
            if (this.audioTrackIndexes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.audioTrackIndexes;
        }

        public final void setAudioTrackIndexes(Collection<Integer> audioTrackIndexes) {
            this.audioTrackIndexes = ___listOf__integerCopier.copy(audioTrackIndexes);
        }

        @Override
        public final Builder audioTrackIndexes(Collection<Integer> audioTrackIndexes) {
            this.audioTrackIndexes = ___listOf__integerCopier.copy(audioTrackIndexes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder audioTrackIndexes(Integer ... audioTrackIndexes) {
            this.audioTrackIndexes(Arrays.asList(audioTrackIndexes));
            return this;
        }

        public final Collection<Integer> getDataTrackIndexes() {
            if (this.dataTrackIndexes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.dataTrackIndexes;
        }

        public final void setDataTrackIndexes(Collection<Integer> dataTrackIndexes) {
            this.dataTrackIndexes = ___listOf__integerCopier.copy(dataTrackIndexes);
        }

        @Override
        public final Builder dataTrackIndexes(Collection<Integer> dataTrackIndexes) {
            this.dataTrackIndexes = ___listOf__integerCopier.copy(dataTrackIndexes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dataTrackIndexes(Integer ... dataTrackIndexes) {
            this.dataTrackIndexes(Arrays.asList(dataTrackIndexes));
            return this;
        }

        public final Collection<Integer> getVideoTrackIndexes() {
            if (this.videoTrackIndexes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.videoTrackIndexes;
        }

        public final void setVideoTrackIndexes(Collection<Integer> videoTrackIndexes) {
            this.videoTrackIndexes = ___listOf__integerCopier.copy(videoTrackIndexes);
        }

        @Override
        public final Builder videoTrackIndexes(Collection<Integer> videoTrackIndexes) {
            this.videoTrackIndexes = ___listOf__integerCopier.copy(videoTrackIndexes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder videoTrackIndexes(Integer ... videoTrackIndexes) {
            this.videoTrackIndexes(Arrays.asList(videoTrackIndexes));
            return this;
        }

        public TrackMapping build() {
            return new TrackMapping(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TrackMapping> {
        public Builder audioTrackIndexes(Collection<Integer> var1);

        public Builder audioTrackIndexes(Integer ... var1);

        public Builder dataTrackIndexes(Collection<Integer> var1);

        public Builder dataTrackIndexes(Integer ... var1);

        public Builder videoTrackIndexes(Collection<Integer> var1);

        public Builder videoTrackIndexes(Integer ... var1);
    }
}

