/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum TransferCharacteristics {
    ITU_709("ITU_709"),
    UNSPECIFIED("UNSPECIFIED"),
    RESERVED("RESERVED"),
    ITU_470_M("ITU_470M"),
    ITU_470_BG("ITU_470BG"),
    SMPTE_170_M("SMPTE_170M"),
    SMPTE_240_M("SMPTE_240M"),
    LINEAR("LINEAR"),
    LOG10_2("LOG10_2"),
    LOC10_2_5("LOC10_2_5"),
    IEC_61966_2_4("IEC_61966_2_4"),
    ITU_1361("ITU_1361"),
    IEC_61966_2_1("IEC_61966_2_1"),
    ITU_2020_10_BIT("ITU_2020_10bit"),
    ITU_2020_12_BIT("ITU_2020_12bit"),
    SMPTE_2084("SMPTE_2084"),
    SMPTE_428_1("SMPTE_428_1"),
    ARIB_B67("ARIB_B67"),
    LAST("LAST"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, TransferCharacteristics> VALUE_MAP;
    private final String value;

    private TransferCharacteristics(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static TransferCharacteristics fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<TransferCharacteristics> knownValues() {
        EnumSet<TransferCharacteristics> knownValues = EnumSet.allOf(TransferCharacteristics.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(TransferCharacteristics.class, TransferCharacteristics::toString);
    }
}

