/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.mediaconvert.model.EncryptionContractConfiguration;
import software.amazon.awssdk.services.mediaconvert.model.___listOf__stringMin36Max36Pattern09aFAF809aFAF409aFAF409aFAF409aFAF12Copier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SpekeKeyProviderCmaf
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SpekeKeyProviderCmaf> {
    private static final SdkField<String> CERTIFICATE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CertificateArn").getter(SpekeKeyProviderCmaf.getter(SpekeKeyProviderCmaf::certificateArn)).setter(SpekeKeyProviderCmaf.setter(Builder::certificateArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("certificateArn").build()}).build();
    private static final SdkField<List<String>> DASH_SIGNALED_SYSTEM_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DashSignaledSystemIds").getter(SpekeKeyProviderCmaf.getter(SpekeKeyProviderCmaf::dashSignaledSystemIds)).setter(SpekeKeyProviderCmaf.setter(Builder::dashSignaledSystemIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dashSignaledSystemIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<EncryptionContractConfiguration> ENCRYPTION_CONTRACT_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("EncryptionContractConfiguration").getter(SpekeKeyProviderCmaf.getter(SpekeKeyProviderCmaf::encryptionContractConfiguration)).setter(SpekeKeyProviderCmaf.setter(Builder::encryptionContractConfiguration)).constructor(EncryptionContractConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("encryptionContractConfiguration").build()}).build();
    private static final SdkField<List<String>> HLS_SIGNALED_SYSTEM_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("HlsSignaledSystemIds").getter(SpekeKeyProviderCmaf.getter(SpekeKeyProviderCmaf::hlsSignaledSystemIds)).setter(SpekeKeyProviderCmaf.setter(Builder::hlsSignaledSystemIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hlsSignaledSystemIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> RESOURCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceId").getter(SpekeKeyProviderCmaf.getter(SpekeKeyProviderCmaf::resourceId)).setter(SpekeKeyProviderCmaf.setter(Builder::resourceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceId").build()}).build();
    private static final SdkField<String> URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Url").getter(SpekeKeyProviderCmaf.getter(SpekeKeyProviderCmaf::url)).setter(SpekeKeyProviderCmaf.setter(Builder::url)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("url").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CERTIFICATE_ARN_FIELD, DASH_SIGNALED_SYSTEM_IDS_FIELD, ENCRYPTION_CONTRACT_CONFIGURATION_FIELD, HLS_SIGNALED_SYSTEM_IDS_FIELD, RESOURCE_ID_FIELD, URL_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = SpekeKeyProviderCmaf.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String certificateArn;
    private final List<String> dashSignaledSystemIds;
    private final EncryptionContractConfiguration encryptionContractConfiguration;
    private final List<String> hlsSignaledSystemIds;
    private final String resourceId;
    private final String url;

    private SpekeKeyProviderCmaf(BuilderImpl builder) {
        this.certificateArn = builder.certificateArn;
        this.dashSignaledSystemIds = builder.dashSignaledSystemIds;
        this.encryptionContractConfiguration = builder.encryptionContractConfiguration;
        this.hlsSignaledSystemIds = builder.hlsSignaledSystemIds;
        this.resourceId = builder.resourceId;
        this.url = builder.url;
    }

    public final String certificateArn() {
        return this.certificateArn;
    }

    public final boolean hasDashSignaledSystemIds() {
        return this.dashSignaledSystemIds != null && !(this.dashSignaledSystemIds instanceof SdkAutoConstructList);
    }

    public final List<String> dashSignaledSystemIds() {
        return this.dashSignaledSystemIds;
    }

    public final EncryptionContractConfiguration encryptionContractConfiguration() {
        return this.encryptionContractConfiguration;
    }

    public final boolean hasHlsSignaledSystemIds() {
        return this.hlsSignaledSystemIds != null && !(this.hlsSignaledSystemIds instanceof SdkAutoConstructList);
    }

    public final List<String> hlsSignaledSystemIds() {
        return this.hlsSignaledSystemIds;
    }

    public final String resourceId() {
        return this.resourceId;
    }

    public final String url() {
        return this.url;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.certificateArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDashSignaledSystemIds() ? this.dashSignaledSystemIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.encryptionContractConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasHlsSignaledSystemIds() ? this.hlsSignaledSystemIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.url());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SpekeKeyProviderCmaf)) {
            return false;
        }
        SpekeKeyProviderCmaf other = (SpekeKeyProviderCmaf)obj;
        return Objects.equals(this.certificateArn(), other.certificateArn()) && this.hasDashSignaledSystemIds() == other.hasDashSignaledSystemIds() && Objects.equals(this.dashSignaledSystemIds(), other.dashSignaledSystemIds()) && Objects.equals(this.encryptionContractConfiguration(), other.encryptionContractConfiguration()) && this.hasHlsSignaledSystemIds() == other.hasHlsSignaledSystemIds() && Objects.equals(this.hlsSignaledSystemIds(), other.hlsSignaledSystemIds()) && Objects.equals(this.resourceId(), other.resourceId()) && Objects.equals(this.url(), other.url());
    }

    public final String toString() {
        return ToString.builder((String)"SpekeKeyProviderCmaf").add("CertificateArn", (Object)this.certificateArn()).add("DashSignaledSystemIds", this.hasDashSignaledSystemIds() ? this.dashSignaledSystemIds() : null).add("EncryptionContractConfiguration", (Object)this.encryptionContractConfiguration()).add("HlsSignaledSystemIds", this.hasHlsSignaledSystemIds() ? this.hlsSignaledSystemIds() : null).add("ResourceId", (Object)this.resourceId()).add("Url", (Object)this.url()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CertificateArn": {
                return Optional.ofNullable(clazz.cast(this.certificateArn()));
            }
            case "DashSignaledSystemIds": {
                return Optional.ofNullable(clazz.cast(this.dashSignaledSystemIds()));
            }
            case "EncryptionContractConfiguration": {
                return Optional.ofNullable(clazz.cast(this.encryptionContractConfiguration()));
            }
            case "HlsSignaledSystemIds": {
                return Optional.ofNullable(clazz.cast(this.hlsSignaledSystemIds()));
            }
            case "ResourceId": {
                return Optional.ofNullable(clazz.cast(this.resourceId()));
            }
            case "Url": {
                return Optional.ofNullable(clazz.cast(this.url()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("certificateArn", CERTIFICATE_ARN_FIELD);
        map.put("dashSignaledSystemIds", DASH_SIGNALED_SYSTEM_IDS_FIELD);
        map.put("encryptionContractConfiguration", ENCRYPTION_CONTRACT_CONFIGURATION_FIELD);
        map.put("hlsSignaledSystemIds", HLS_SIGNALED_SYSTEM_IDS_FIELD);
        map.put("resourceId", RESOURCE_ID_FIELD);
        map.put("url", URL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SpekeKeyProviderCmaf, T> g) {
        return obj -> g.apply((SpekeKeyProviderCmaf)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String certificateArn;
        private List<String> dashSignaledSystemIds = DefaultSdkAutoConstructList.getInstance();
        private EncryptionContractConfiguration encryptionContractConfiguration;
        private List<String> hlsSignaledSystemIds = DefaultSdkAutoConstructList.getInstance();
        private String resourceId;
        private String url;

        private BuilderImpl() {
        }

        private BuilderImpl(SpekeKeyProviderCmaf model) {
            this.certificateArn(model.certificateArn);
            this.dashSignaledSystemIds(model.dashSignaledSystemIds);
            this.encryptionContractConfiguration(model.encryptionContractConfiguration);
            this.hlsSignaledSystemIds(model.hlsSignaledSystemIds);
            this.resourceId(model.resourceId);
            this.url(model.url);
        }

        public final String getCertificateArn() {
            return this.certificateArn;
        }

        public final void setCertificateArn(String certificateArn) {
            this.certificateArn = certificateArn;
        }

        @Override
        public final Builder certificateArn(String certificateArn) {
            this.certificateArn = certificateArn;
            return this;
        }

        public final Collection<String> getDashSignaledSystemIds() {
            if (this.dashSignaledSystemIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.dashSignaledSystemIds;
        }

        public final void setDashSignaledSystemIds(Collection<String> dashSignaledSystemIds) {
            this.dashSignaledSystemIds = ___listOf__stringMin36Max36Pattern09aFAF809aFAF409aFAF409aFAF409aFAF12Copier.copy(dashSignaledSystemIds);
        }

        @Override
        public final Builder dashSignaledSystemIds(Collection<String> dashSignaledSystemIds) {
            this.dashSignaledSystemIds = ___listOf__stringMin36Max36Pattern09aFAF809aFAF409aFAF409aFAF409aFAF12Copier.copy(dashSignaledSystemIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dashSignaledSystemIds(String ... dashSignaledSystemIds) {
            this.dashSignaledSystemIds(Arrays.asList(dashSignaledSystemIds));
            return this;
        }

        public final EncryptionContractConfiguration.Builder getEncryptionContractConfiguration() {
            return this.encryptionContractConfiguration != null ? this.encryptionContractConfiguration.toBuilder() : null;
        }

        public final void setEncryptionContractConfiguration(EncryptionContractConfiguration.BuilderImpl encryptionContractConfiguration) {
            this.encryptionContractConfiguration = encryptionContractConfiguration != null ? encryptionContractConfiguration.build() : null;
        }

        @Override
        public final Builder encryptionContractConfiguration(EncryptionContractConfiguration encryptionContractConfiguration) {
            this.encryptionContractConfiguration = encryptionContractConfiguration;
            return this;
        }

        public final Collection<String> getHlsSignaledSystemIds() {
            if (this.hlsSignaledSystemIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.hlsSignaledSystemIds;
        }

        public final void setHlsSignaledSystemIds(Collection<String> hlsSignaledSystemIds) {
            this.hlsSignaledSystemIds = ___listOf__stringMin36Max36Pattern09aFAF809aFAF409aFAF409aFAF409aFAF12Copier.copy(hlsSignaledSystemIds);
        }

        @Override
        public final Builder hlsSignaledSystemIds(Collection<String> hlsSignaledSystemIds) {
            this.hlsSignaledSystemIds = ___listOf__stringMin36Max36Pattern09aFAF809aFAF409aFAF409aFAF409aFAF12Copier.copy(hlsSignaledSystemIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder hlsSignaledSystemIds(String ... hlsSignaledSystemIds) {
            this.hlsSignaledSystemIds(Arrays.asList(hlsSignaledSystemIds));
            return this;
        }

        public final String getResourceId() {
            return this.resourceId;
        }

        public final void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        @Override
        public final Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public final String getUrl() {
            return this.url;
        }

        public final void setUrl(String url) {
            this.url = url;
        }

        @Override
        public final Builder url(String url) {
            this.url = url;
            return this;
        }

        public SpekeKeyProviderCmaf build() {
            return new SpekeKeyProviderCmaf(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SpekeKeyProviderCmaf> {
        public Builder certificateArn(String var1);

        public Builder dashSignaledSystemIds(Collection<String> var1);

        public Builder dashSignaledSystemIds(String ... var1);

        public Builder encryptionContractConfiguration(EncryptionContractConfiguration var1);

        default public Builder encryptionContractConfiguration(Consumer<EncryptionContractConfiguration.Builder> encryptionContractConfiguration) {
            return this.encryptionContractConfiguration((EncryptionContractConfiguration)((EncryptionContractConfiguration.Builder)EncryptionContractConfiguration.builder().applyMutation(encryptionContractConfiguration)).build());
        }

        public Builder hlsSignaledSystemIds(Collection<String> var1);

        public Builder hlsSignaledSystemIds(String ... var1);

        public Builder resourceId(String var1);

        public Builder url(String var1);
    }
}

