/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.mediaconvert.model.Xavc4kIntraCbgProfileSettings;
import software.amazon.awssdk.services.mediaconvert.model.Xavc4kIntraVbrProfileSettings;
import software.amazon.awssdk.services.mediaconvert.model.Xavc4kProfileSettings;
import software.amazon.awssdk.services.mediaconvert.model.XavcAdaptiveQuantization;
import software.amazon.awssdk.services.mediaconvert.model.XavcEntropyEncoding;
import software.amazon.awssdk.services.mediaconvert.model.XavcFramerateControl;
import software.amazon.awssdk.services.mediaconvert.model.XavcFramerateConversionAlgorithm;
import software.amazon.awssdk.services.mediaconvert.model.XavcHdIntraCbgProfileSettings;
import software.amazon.awssdk.services.mediaconvert.model.XavcHdProfileSettings;
import software.amazon.awssdk.services.mediaconvert.model.XavcProfile;
import software.amazon.awssdk.services.mediaconvert.model.XavcSlowPal;
import software.amazon.awssdk.services.mediaconvert.model.XavcSpatialAdaptiveQuantization;
import software.amazon.awssdk.services.mediaconvert.model.XavcTemporalAdaptiveQuantization;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class XavcSettings
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, XavcSettings> {
    private static final SdkField<String> ADAPTIVE_QUANTIZATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AdaptiveQuantization").getter(XavcSettings.getter(XavcSettings::adaptiveQuantizationAsString)).setter(XavcSettings.setter(Builder::adaptiveQuantization)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("adaptiveQuantization").build()}).build();
    private static final SdkField<String> ENTROPY_ENCODING_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EntropyEncoding").getter(XavcSettings.getter(XavcSettings::entropyEncodingAsString)).setter(XavcSettings.setter(Builder::entropyEncoding)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("entropyEncoding").build()}).build();
    private static final SdkField<String> FRAMERATE_CONTROL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FramerateControl").getter(XavcSettings.getter(XavcSettings::framerateControlAsString)).setter(XavcSettings.setter(Builder::framerateControl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("framerateControl").build()}).build();
    private static final SdkField<String> FRAMERATE_CONVERSION_ALGORITHM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FramerateConversionAlgorithm").getter(XavcSettings.getter(XavcSettings::framerateConversionAlgorithmAsString)).setter(XavcSettings.setter(Builder::framerateConversionAlgorithm)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("framerateConversionAlgorithm").build()}).build();
    private static final SdkField<Integer> FRAMERATE_DENOMINATOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("FramerateDenominator").getter(XavcSettings.getter(XavcSettings::framerateDenominator)).setter(XavcSettings.setter(Builder::framerateDenominator)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("framerateDenominator").build()}).build();
    private static final SdkField<Integer> FRAMERATE_NUMERATOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("FramerateNumerator").getter(XavcSettings.getter(XavcSettings::framerateNumerator)).setter(XavcSettings.setter(Builder::framerateNumerator)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("framerateNumerator").build()}).build();
    private static final SdkField<String> PROFILE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Profile").getter(XavcSettings.getter(XavcSettings::profileAsString)).setter(XavcSettings.setter(Builder::profile)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("profile").build()}).build();
    private static final SdkField<String> SLOW_PAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SlowPal").getter(XavcSettings.getter(XavcSettings::slowPalAsString)).setter(XavcSettings.setter(Builder::slowPal)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("slowPal").build()}).build();
    private static final SdkField<Integer> SOFTNESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Softness").getter(XavcSettings.getter(XavcSettings::softness)).setter(XavcSettings.setter(Builder::softness)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("softness").build()}).build();
    private static final SdkField<String> SPATIAL_ADAPTIVE_QUANTIZATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SpatialAdaptiveQuantization").getter(XavcSettings.getter(XavcSettings::spatialAdaptiveQuantizationAsString)).setter(XavcSettings.setter(Builder::spatialAdaptiveQuantization)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("spatialAdaptiveQuantization").build()}).build();
    private static final SdkField<String> TEMPORAL_ADAPTIVE_QUANTIZATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TemporalAdaptiveQuantization").getter(XavcSettings.getter(XavcSettings::temporalAdaptiveQuantizationAsString)).setter(XavcSettings.setter(Builder::temporalAdaptiveQuantization)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("temporalAdaptiveQuantization").build()}).build();
    private static final SdkField<Xavc4kIntraCbgProfileSettings> XAVC4_K_INTRA_CBG_PROFILE_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Xavc4kIntraCbgProfileSettings").getter(XavcSettings.getter(XavcSettings::xavc4kIntraCbgProfileSettings)).setter(XavcSettings.setter(Builder::xavc4kIntraCbgProfileSettings)).constructor(Xavc4kIntraCbgProfileSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("xavc4kIntraCbgProfileSettings").build()}).build();
    private static final SdkField<Xavc4kIntraVbrProfileSettings> XAVC4_K_INTRA_VBR_PROFILE_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Xavc4kIntraVbrProfileSettings").getter(XavcSettings.getter(XavcSettings::xavc4kIntraVbrProfileSettings)).setter(XavcSettings.setter(Builder::xavc4kIntraVbrProfileSettings)).constructor(Xavc4kIntraVbrProfileSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("xavc4kIntraVbrProfileSettings").build()}).build();
    private static final SdkField<Xavc4kProfileSettings> XAVC4_K_PROFILE_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Xavc4kProfileSettings").getter(XavcSettings.getter(XavcSettings::xavc4kProfileSettings)).setter(XavcSettings.setter(Builder::xavc4kProfileSettings)).constructor(Xavc4kProfileSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("xavc4kProfileSettings").build()}).build();
    private static final SdkField<XavcHdIntraCbgProfileSettings> XAVC_HD_INTRA_CBG_PROFILE_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("XavcHdIntraCbgProfileSettings").getter(XavcSettings.getter(XavcSettings::xavcHdIntraCbgProfileSettings)).setter(XavcSettings.setter(Builder::xavcHdIntraCbgProfileSettings)).constructor(XavcHdIntraCbgProfileSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("xavcHdIntraCbgProfileSettings").build()}).build();
    private static final SdkField<XavcHdProfileSettings> XAVC_HD_PROFILE_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("XavcHdProfileSettings").getter(XavcSettings.getter(XavcSettings::xavcHdProfileSettings)).setter(XavcSettings.setter(Builder::xavcHdProfileSettings)).constructor(XavcHdProfileSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("xavcHdProfileSettings").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ADAPTIVE_QUANTIZATION_FIELD, ENTROPY_ENCODING_FIELD, FRAMERATE_CONTROL_FIELD, FRAMERATE_CONVERSION_ALGORITHM_FIELD, FRAMERATE_DENOMINATOR_FIELD, FRAMERATE_NUMERATOR_FIELD, PROFILE_FIELD, SLOW_PAL_FIELD, SOFTNESS_FIELD, SPATIAL_ADAPTIVE_QUANTIZATION_FIELD, TEMPORAL_ADAPTIVE_QUANTIZATION_FIELD, XAVC4_K_INTRA_CBG_PROFILE_SETTINGS_FIELD, XAVC4_K_INTRA_VBR_PROFILE_SETTINGS_FIELD, XAVC4_K_PROFILE_SETTINGS_FIELD, XAVC_HD_INTRA_CBG_PROFILE_SETTINGS_FIELD, XAVC_HD_PROFILE_SETTINGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("adaptiveQuantization", ADAPTIVE_QUANTIZATION_FIELD);
            this.put("entropyEncoding", ENTROPY_ENCODING_FIELD);
            this.put("framerateControl", FRAMERATE_CONTROL_FIELD);
            this.put("framerateConversionAlgorithm", FRAMERATE_CONVERSION_ALGORITHM_FIELD);
            this.put("framerateDenominator", FRAMERATE_DENOMINATOR_FIELD);
            this.put("framerateNumerator", FRAMERATE_NUMERATOR_FIELD);
            this.put("profile", PROFILE_FIELD);
            this.put("slowPal", SLOW_PAL_FIELD);
            this.put("softness", SOFTNESS_FIELD);
            this.put("spatialAdaptiveQuantization", SPATIAL_ADAPTIVE_QUANTIZATION_FIELD);
            this.put("temporalAdaptiveQuantization", TEMPORAL_ADAPTIVE_QUANTIZATION_FIELD);
            this.put("xavc4kIntraCbgProfileSettings", XAVC4_K_INTRA_CBG_PROFILE_SETTINGS_FIELD);
            this.put("xavc4kIntraVbrProfileSettings", XAVC4_K_INTRA_VBR_PROFILE_SETTINGS_FIELD);
            this.put("xavc4kProfileSettings", XAVC4_K_PROFILE_SETTINGS_FIELD);
            this.put("xavcHdIntraCbgProfileSettings", XAVC_HD_INTRA_CBG_PROFILE_SETTINGS_FIELD);
            this.put("xavcHdProfileSettings", XAVC_HD_PROFILE_SETTINGS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String adaptiveQuantization;
    private final String entropyEncoding;
    private final String framerateControl;
    private final String framerateConversionAlgorithm;
    private final Integer framerateDenominator;
    private final Integer framerateNumerator;
    private final String profile;
    private final String slowPal;
    private final Integer softness;
    private final String spatialAdaptiveQuantization;
    private final String temporalAdaptiveQuantization;
    private final Xavc4kIntraCbgProfileSettings xavc4kIntraCbgProfileSettings;
    private final Xavc4kIntraVbrProfileSettings xavc4kIntraVbrProfileSettings;
    private final Xavc4kProfileSettings xavc4kProfileSettings;
    private final XavcHdIntraCbgProfileSettings xavcHdIntraCbgProfileSettings;
    private final XavcHdProfileSettings xavcHdProfileSettings;

    private XavcSettings(BuilderImpl builder) {
        this.adaptiveQuantization = builder.adaptiveQuantization;
        this.entropyEncoding = builder.entropyEncoding;
        this.framerateControl = builder.framerateControl;
        this.framerateConversionAlgorithm = builder.framerateConversionAlgorithm;
        this.framerateDenominator = builder.framerateDenominator;
        this.framerateNumerator = builder.framerateNumerator;
        this.profile = builder.profile;
        this.slowPal = builder.slowPal;
        this.softness = builder.softness;
        this.spatialAdaptiveQuantization = builder.spatialAdaptiveQuantization;
        this.temporalAdaptiveQuantization = builder.temporalAdaptiveQuantization;
        this.xavc4kIntraCbgProfileSettings = builder.xavc4kIntraCbgProfileSettings;
        this.xavc4kIntraVbrProfileSettings = builder.xavc4kIntraVbrProfileSettings;
        this.xavc4kProfileSettings = builder.xavc4kProfileSettings;
        this.xavcHdIntraCbgProfileSettings = builder.xavcHdIntraCbgProfileSettings;
        this.xavcHdProfileSettings = builder.xavcHdProfileSettings;
    }

    public final XavcAdaptiveQuantization adaptiveQuantization() {
        return XavcAdaptiveQuantization.fromValue(this.adaptiveQuantization);
    }

    public final String adaptiveQuantizationAsString() {
        return this.adaptiveQuantization;
    }

    public final XavcEntropyEncoding entropyEncoding() {
        return XavcEntropyEncoding.fromValue(this.entropyEncoding);
    }

    public final String entropyEncodingAsString() {
        return this.entropyEncoding;
    }

    public final XavcFramerateControl framerateControl() {
        return XavcFramerateControl.fromValue(this.framerateControl);
    }

    public final String framerateControlAsString() {
        return this.framerateControl;
    }

    public final XavcFramerateConversionAlgorithm framerateConversionAlgorithm() {
        return XavcFramerateConversionAlgorithm.fromValue(this.framerateConversionAlgorithm);
    }

    public final String framerateConversionAlgorithmAsString() {
        return this.framerateConversionAlgorithm;
    }

    public final Integer framerateDenominator() {
        return this.framerateDenominator;
    }

    public final Integer framerateNumerator() {
        return this.framerateNumerator;
    }

    public final XavcProfile profile() {
        return XavcProfile.fromValue(this.profile);
    }

    public final String profileAsString() {
        return this.profile;
    }

    public final XavcSlowPal slowPal() {
        return XavcSlowPal.fromValue(this.slowPal);
    }

    public final String slowPalAsString() {
        return this.slowPal;
    }

    public final Integer softness() {
        return this.softness;
    }

    public final XavcSpatialAdaptiveQuantization spatialAdaptiveQuantization() {
        return XavcSpatialAdaptiveQuantization.fromValue(this.spatialAdaptiveQuantization);
    }

    public final String spatialAdaptiveQuantizationAsString() {
        return this.spatialAdaptiveQuantization;
    }

    public final XavcTemporalAdaptiveQuantization temporalAdaptiveQuantization() {
        return XavcTemporalAdaptiveQuantization.fromValue(this.temporalAdaptiveQuantization);
    }

    public final String temporalAdaptiveQuantizationAsString() {
        return this.temporalAdaptiveQuantization;
    }

    public final Xavc4kIntraCbgProfileSettings xavc4kIntraCbgProfileSettings() {
        return this.xavc4kIntraCbgProfileSettings;
    }

    public final Xavc4kIntraVbrProfileSettings xavc4kIntraVbrProfileSettings() {
        return this.xavc4kIntraVbrProfileSettings;
    }

    public final Xavc4kProfileSettings xavc4kProfileSettings() {
        return this.xavc4kProfileSettings;
    }

    public final XavcHdIntraCbgProfileSettings xavcHdIntraCbgProfileSettings() {
        return this.xavcHdIntraCbgProfileSettings;
    }

    public final XavcHdProfileSettings xavcHdProfileSettings() {
        return this.xavcHdProfileSettings;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.adaptiveQuantizationAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.entropyEncodingAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.framerateControlAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.framerateConversionAlgorithmAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.framerateDenominator());
        hashCode = 31 * hashCode + Objects.hashCode(this.framerateNumerator());
        hashCode = 31 * hashCode + Objects.hashCode(this.profileAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.slowPalAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.softness());
        hashCode = 31 * hashCode + Objects.hashCode(this.spatialAdaptiveQuantizationAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.temporalAdaptiveQuantizationAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.xavc4kIntraCbgProfileSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.xavc4kIntraVbrProfileSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.xavc4kProfileSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.xavcHdIntraCbgProfileSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.xavcHdProfileSettings());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof XavcSettings)) {
            return false;
        }
        XavcSettings other = (XavcSettings)obj;
        return Objects.equals(this.adaptiveQuantizationAsString(), other.adaptiveQuantizationAsString()) && Objects.equals(this.entropyEncodingAsString(), other.entropyEncodingAsString()) && Objects.equals(this.framerateControlAsString(), other.framerateControlAsString()) && Objects.equals(this.framerateConversionAlgorithmAsString(), other.framerateConversionAlgorithmAsString()) && Objects.equals(this.framerateDenominator(), other.framerateDenominator()) && Objects.equals(this.framerateNumerator(), other.framerateNumerator()) && Objects.equals(this.profileAsString(), other.profileAsString()) && Objects.equals(this.slowPalAsString(), other.slowPalAsString()) && Objects.equals(this.softness(), other.softness()) && Objects.equals(this.spatialAdaptiveQuantizationAsString(), other.spatialAdaptiveQuantizationAsString()) && Objects.equals(this.temporalAdaptiveQuantizationAsString(), other.temporalAdaptiveQuantizationAsString()) && Objects.equals(this.xavc4kIntraCbgProfileSettings(), other.xavc4kIntraCbgProfileSettings()) && Objects.equals(this.xavc4kIntraVbrProfileSettings(), other.xavc4kIntraVbrProfileSettings()) && Objects.equals(this.xavc4kProfileSettings(), other.xavc4kProfileSettings()) && Objects.equals(this.xavcHdIntraCbgProfileSettings(), other.xavcHdIntraCbgProfileSettings()) && Objects.equals(this.xavcHdProfileSettings(), other.xavcHdProfileSettings());
    }

    public final String toString() {
        return ToString.builder((String)"XavcSettings").add("AdaptiveQuantization", (Object)this.adaptiveQuantizationAsString()).add("EntropyEncoding", (Object)this.entropyEncodingAsString()).add("FramerateControl", (Object)this.framerateControlAsString()).add("FramerateConversionAlgorithm", (Object)this.framerateConversionAlgorithmAsString()).add("FramerateDenominator", (Object)this.framerateDenominator()).add("FramerateNumerator", (Object)this.framerateNumerator()).add("Profile", (Object)this.profileAsString()).add("SlowPal", (Object)this.slowPalAsString()).add("Softness", (Object)this.softness()).add("SpatialAdaptiveQuantization", (Object)this.spatialAdaptiveQuantizationAsString()).add("TemporalAdaptiveQuantization", (Object)this.temporalAdaptiveQuantizationAsString()).add("Xavc4kIntraCbgProfileSettings", (Object)this.xavc4kIntraCbgProfileSettings()).add("Xavc4kIntraVbrProfileSettings", (Object)this.xavc4kIntraVbrProfileSettings()).add("Xavc4kProfileSettings", (Object)this.xavc4kProfileSettings()).add("XavcHdIntraCbgProfileSettings", (Object)this.xavcHdIntraCbgProfileSettings()).add("XavcHdProfileSettings", (Object)this.xavcHdProfileSettings()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AdaptiveQuantization": {
                return Optional.ofNullable(clazz.cast(this.adaptiveQuantizationAsString()));
            }
            case "EntropyEncoding": {
                return Optional.ofNullable(clazz.cast(this.entropyEncodingAsString()));
            }
            case "FramerateControl": {
                return Optional.ofNullable(clazz.cast(this.framerateControlAsString()));
            }
            case "FramerateConversionAlgorithm": {
                return Optional.ofNullable(clazz.cast(this.framerateConversionAlgorithmAsString()));
            }
            case "FramerateDenominator": {
                return Optional.ofNullable(clazz.cast(this.framerateDenominator()));
            }
            case "FramerateNumerator": {
                return Optional.ofNullable(clazz.cast(this.framerateNumerator()));
            }
            case "Profile": {
                return Optional.ofNullable(clazz.cast(this.profileAsString()));
            }
            case "SlowPal": {
                return Optional.ofNullable(clazz.cast(this.slowPalAsString()));
            }
            case "Softness": {
                return Optional.ofNullable(clazz.cast(this.softness()));
            }
            case "SpatialAdaptiveQuantization": {
                return Optional.ofNullable(clazz.cast(this.spatialAdaptiveQuantizationAsString()));
            }
            case "TemporalAdaptiveQuantization": {
                return Optional.ofNullable(clazz.cast(this.temporalAdaptiveQuantizationAsString()));
            }
            case "Xavc4kIntraCbgProfileSettings": {
                return Optional.ofNullable(clazz.cast(this.xavc4kIntraCbgProfileSettings()));
            }
            case "Xavc4kIntraVbrProfileSettings": {
                return Optional.ofNullable(clazz.cast(this.xavc4kIntraVbrProfileSettings()));
            }
            case "Xavc4kProfileSettings": {
                return Optional.ofNullable(clazz.cast(this.xavc4kProfileSettings()));
            }
            case "XavcHdIntraCbgProfileSettings": {
                return Optional.ofNullable(clazz.cast(this.xavcHdIntraCbgProfileSettings()));
            }
            case "XavcHdProfileSettings": {
                return Optional.ofNullable(clazz.cast(this.xavcHdProfileSettings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<XavcSettings, T> g) {
        return obj -> g.apply((XavcSettings)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String adaptiveQuantization;
        private String entropyEncoding;
        private String framerateControl;
        private String framerateConversionAlgorithm;
        private Integer framerateDenominator;
        private Integer framerateNumerator;
        private String profile;
        private String slowPal;
        private Integer softness;
        private String spatialAdaptiveQuantization;
        private String temporalAdaptiveQuantization;
        private Xavc4kIntraCbgProfileSettings xavc4kIntraCbgProfileSettings;
        private Xavc4kIntraVbrProfileSettings xavc4kIntraVbrProfileSettings;
        private Xavc4kProfileSettings xavc4kProfileSettings;
        private XavcHdIntraCbgProfileSettings xavcHdIntraCbgProfileSettings;
        private XavcHdProfileSettings xavcHdProfileSettings;

        private BuilderImpl() {
        }

        private BuilderImpl(XavcSettings model) {
            this.adaptiveQuantization(model.adaptiveQuantization);
            this.entropyEncoding(model.entropyEncoding);
            this.framerateControl(model.framerateControl);
            this.framerateConversionAlgorithm(model.framerateConversionAlgorithm);
            this.framerateDenominator(model.framerateDenominator);
            this.framerateNumerator(model.framerateNumerator);
            this.profile(model.profile);
            this.slowPal(model.slowPal);
            this.softness(model.softness);
            this.spatialAdaptiveQuantization(model.spatialAdaptiveQuantization);
            this.temporalAdaptiveQuantization(model.temporalAdaptiveQuantization);
            this.xavc4kIntraCbgProfileSettings(model.xavc4kIntraCbgProfileSettings);
            this.xavc4kIntraVbrProfileSettings(model.xavc4kIntraVbrProfileSettings);
            this.xavc4kProfileSettings(model.xavc4kProfileSettings);
            this.xavcHdIntraCbgProfileSettings(model.xavcHdIntraCbgProfileSettings);
            this.xavcHdProfileSettings(model.xavcHdProfileSettings);
        }

        public final String getAdaptiveQuantization() {
            return this.adaptiveQuantization;
        }

        public final void setAdaptiveQuantization(String adaptiveQuantization) {
            this.adaptiveQuantization = adaptiveQuantization;
        }

        @Override
        public final Builder adaptiveQuantization(String adaptiveQuantization) {
            this.adaptiveQuantization = adaptiveQuantization;
            return this;
        }

        @Override
        public final Builder adaptiveQuantization(XavcAdaptiveQuantization adaptiveQuantization) {
            this.adaptiveQuantization(adaptiveQuantization == null ? null : adaptiveQuantization.toString());
            return this;
        }

        public final String getEntropyEncoding() {
            return this.entropyEncoding;
        }

        public final void setEntropyEncoding(String entropyEncoding) {
            this.entropyEncoding = entropyEncoding;
        }

        @Override
        public final Builder entropyEncoding(String entropyEncoding) {
            this.entropyEncoding = entropyEncoding;
            return this;
        }

        @Override
        public final Builder entropyEncoding(XavcEntropyEncoding entropyEncoding) {
            this.entropyEncoding(entropyEncoding == null ? null : entropyEncoding.toString());
            return this;
        }

        public final String getFramerateControl() {
            return this.framerateControl;
        }

        public final void setFramerateControl(String framerateControl) {
            this.framerateControl = framerateControl;
        }

        @Override
        public final Builder framerateControl(String framerateControl) {
            this.framerateControl = framerateControl;
            return this;
        }

        @Override
        public final Builder framerateControl(XavcFramerateControl framerateControl) {
            this.framerateControl(framerateControl == null ? null : framerateControl.toString());
            return this;
        }

        public final String getFramerateConversionAlgorithm() {
            return this.framerateConversionAlgorithm;
        }

        public final void setFramerateConversionAlgorithm(String framerateConversionAlgorithm) {
            this.framerateConversionAlgorithm = framerateConversionAlgorithm;
        }

        @Override
        public final Builder framerateConversionAlgorithm(String framerateConversionAlgorithm) {
            this.framerateConversionAlgorithm = framerateConversionAlgorithm;
            return this;
        }

        @Override
        public final Builder framerateConversionAlgorithm(XavcFramerateConversionAlgorithm framerateConversionAlgorithm) {
            this.framerateConversionAlgorithm(framerateConversionAlgorithm == null ? null : framerateConversionAlgorithm.toString());
            return this;
        }

        public final Integer getFramerateDenominator() {
            return this.framerateDenominator;
        }

        public final void setFramerateDenominator(Integer framerateDenominator) {
            this.framerateDenominator = framerateDenominator;
        }

        @Override
        public final Builder framerateDenominator(Integer framerateDenominator) {
            this.framerateDenominator = framerateDenominator;
            return this;
        }

        public final Integer getFramerateNumerator() {
            return this.framerateNumerator;
        }

        public final void setFramerateNumerator(Integer framerateNumerator) {
            this.framerateNumerator = framerateNumerator;
        }

        @Override
        public final Builder framerateNumerator(Integer framerateNumerator) {
            this.framerateNumerator = framerateNumerator;
            return this;
        }

        public final String getProfile() {
            return this.profile;
        }

        public final void setProfile(String profile) {
            this.profile = profile;
        }

        @Override
        public final Builder profile(String profile) {
            this.profile = profile;
            return this;
        }

        @Override
        public final Builder profile(XavcProfile profile) {
            this.profile(profile == null ? null : profile.toString());
            return this;
        }

        public final String getSlowPal() {
            return this.slowPal;
        }

        public final void setSlowPal(String slowPal) {
            this.slowPal = slowPal;
        }

        @Override
        public final Builder slowPal(String slowPal) {
            this.slowPal = slowPal;
            return this;
        }

        @Override
        public final Builder slowPal(XavcSlowPal slowPal) {
            this.slowPal(slowPal == null ? null : slowPal.toString());
            return this;
        }

        public final Integer getSoftness() {
            return this.softness;
        }

        public final void setSoftness(Integer softness) {
            this.softness = softness;
        }

        @Override
        public final Builder softness(Integer softness) {
            this.softness = softness;
            return this;
        }

        public final String getSpatialAdaptiveQuantization() {
            return this.spatialAdaptiveQuantization;
        }

        public final void setSpatialAdaptiveQuantization(String spatialAdaptiveQuantization) {
            this.spatialAdaptiveQuantization = spatialAdaptiveQuantization;
        }

        @Override
        public final Builder spatialAdaptiveQuantization(String spatialAdaptiveQuantization) {
            this.spatialAdaptiveQuantization = spatialAdaptiveQuantization;
            return this;
        }

        @Override
        public final Builder spatialAdaptiveQuantization(XavcSpatialAdaptiveQuantization spatialAdaptiveQuantization) {
            this.spatialAdaptiveQuantization(spatialAdaptiveQuantization == null ? null : spatialAdaptiveQuantization.toString());
            return this;
        }

        public final String getTemporalAdaptiveQuantization() {
            return this.temporalAdaptiveQuantization;
        }

        public final void setTemporalAdaptiveQuantization(String temporalAdaptiveQuantization) {
            this.temporalAdaptiveQuantization = temporalAdaptiveQuantization;
        }

        @Override
        public final Builder temporalAdaptiveQuantization(String temporalAdaptiveQuantization) {
            this.temporalAdaptiveQuantization = temporalAdaptiveQuantization;
            return this;
        }

        @Override
        public final Builder temporalAdaptiveQuantization(XavcTemporalAdaptiveQuantization temporalAdaptiveQuantization) {
            this.temporalAdaptiveQuantization(temporalAdaptiveQuantization == null ? null : temporalAdaptiveQuantization.toString());
            return this;
        }

        public final Xavc4kIntraCbgProfileSettings.Builder getXavc4kIntraCbgProfileSettings() {
            return this.xavc4kIntraCbgProfileSettings != null ? this.xavc4kIntraCbgProfileSettings.toBuilder() : null;
        }

        public final void setXavc4kIntraCbgProfileSettings(Xavc4kIntraCbgProfileSettings.BuilderImpl xavc4kIntraCbgProfileSettings) {
            this.xavc4kIntraCbgProfileSettings = xavc4kIntraCbgProfileSettings != null ? xavc4kIntraCbgProfileSettings.build() : null;
        }

        @Override
        public final Builder xavc4kIntraCbgProfileSettings(Xavc4kIntraCbgProfileSettings xavc4kIntraCbgProfileSettings) {
            this.xavc4kIntraCbgProfileSettings = xavc4kIntraCbgProfileSettings;
            return this;
        }

        public final Xavc4kIntraVbrProfileSettings.Builder getXavc4kIntraVbrProfileSettings() {
            return this.xavc4kIntraVbrProfileSettings != null ? this.xavc4kIntraVbrProfileSettings.toBuilder() : null;
        }

        public final void setXavc4kIntraVbrProfileSettings(Xavc4kIntraVbrProfileSettings.BuilderImpl xavc4kIntraVbrProfileSettings) {
            this.xavc4kIntraVbrProfileSettings = xavc4kIntraVbrProfileSettings != null ? xavc4kIntraVbrProfileSettings.build() : null;
        }

        @Override
        public final Builder xavc4kIntraVbrProfileSettings(Xavc4kIntraVbrProfileSettings xavc4kIntraVbrProfileSettings) {
            this.xavc4kIntraVbrProfileSettings = xavc4kIntraVbrProfileSettings;
            return this;
        }

        public final Xavc4kProfileSettings.Builder getXavc4kProfileSettings() {
            return this.xavc4kProfileSettings != null ? this.xavc4kProfileSettings.toBuilder() : null;
        }

        public final void setXavc4kProfileSettings(Xavc4kProfileSettings.BuilderImpl xavc4kProfileSettings) {
            this.xavc4kProfileSettings = xavc4kProfileSettings != null ? xavc4kProfileSettings.build() : null;
        }

        @Override
        public final Builder xavc4kProfileSettings(Xavc4kProfileSettings xavc4kProfileSettings) {
            this.xavc4kProfileSettings = xavc4kProfileSettings;
            return this;
        }

        public final XavcHdIntraCbgProfileSettings.Builder getXavcHdIntraCbgProfileSettings() {
            return this.xavcHdIntraCbgProfileSettings != null ? this.xavcHdIntraCbgProfileSettings.toBuilder() : null;
        }

        public final void setXavcHdIntraCbgProfileSettings(XavcHdIntraCbgProfileSettings.BuilderImpl xavcHdIntraCbgProfileSettings) {
            this.xavcHdIntraCbgProfileSettings = xavcHdIntraCbgProfileSettings != null ? xavcHdIntraCbgProfileSettings.build() : null;
        }

        @Override
        public final Builder xavcHdIntraCbgProfileSettings(XavcHdIntraCbgProfileSettings xavcHdIntraCbgProfileSettings) {
            this.xavcHdIntraCbgProfileSettings = xavcHdIntraCbgProfileSettings;
            return this;
        }

        public final XavcHdProfileSettings.Builder getXavcHdProfileSettings() {
            return this.xavcHdProfileSettings != null ? this.xavcHdProfileSettings.toBuilder() : null;
        }

        public final void setXavcHdProfileSettings(XavcHdProfileSettings.BuilderImpl xavcHdProfileSettings) {
            this.xavcHdProfileSettings = xavcHdProfileSettings != null ? xavcHdProfileSettings.build() : null;
        }

        @Override
        public final Builder xavcHdProfileSettings(XavcHdProfileSettings xavcHdProfileSettings) {
            this.xavcHdProfileSettings = xavcHdProfileSettings;
            return this;
        }

        public XavcSettings build() {
            return new XavcSettings(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, XavcSettings> {
        public Builder adaptiveQuantization(String var1);

        public Builder adaptiveQuantization(XavcAdaptiveQuantization var1);

        public Builder entropyEncoding(String var1);

        public Builder entropyEncoding(XavcEntropyEncoding var1);

        public Builder framerateControl(String var1);

        public Builder framerateControl(XavcFramerateControl var1);

        public Builder framerateConversionAlgorithm(String var1);

        public Builder framerateConversionAlgorithm(XavcFramerateConversionAlgorithm var1);

        public Builder framerateDenominator(Integer var1);

        public Builder framerateNumerator(Integer var1);

        public Builder profile(String var1);

        public Builder profile(XavcProfile var1);

        public Builder slowPal(String var1);

        public Builder slowPal(XavcSlowPal var1);

        public Builder softness(Integer var1);

        public Builder spatialAdaptiveQuantization(String var1);

        public Builder spatialAdaptiveQuantization(XavcSpatialAdaptiveQuantization var1);

        public Builder temporalAdaptiveQuantization(String var1);

        public Builder temporalAdaptiveQuantization(XavcTemporalAdaptiveQuantization var1);

        public Builder xavc4kIntraCbgProfileSettings(Xavc4kIntraCbgProfileSettings var1);

        default public Builder xavc4kIntraCbgProfileSettings(Consumer<Xavc4kIntraCbgProfileSettings.Builder> xavc4kIntraCbgProfileSettings) {
            return this.xavc4kIntraCbgProfileSettings((Xavc4kIntraCbgProfileSettings)((Xavc4kIntraCbgProfileSettings.Builder)Xavc4kIntraCbgProfileSettings.builder().applyMutation(xavc4kIntraCbgProfileSettings)).build());
        }

        public Builder xavc4kIntraVbrProfileSettings(Xavc4kIntraVbrProfileSettings var1);

        default public Builder xavc4kIntraVbrProfileSettings(Consumer<Xavc4kIntraVbrProfileSettings.Builder> xavc4kIntraVbrProfileSettings) {
            return this.xavc4kIntraVbrProfileSettings((Xavc4kIntraVbrProfileSettings)((Xavc4kIntraVbrProfileSettings.Builder)Xavc4kIntraVbrProfileSettings.builder().applyMutation(xavc4kIntraVbrProfileSettings)).build());
        }

        public Builder xavc4kProfileSettings(Xavc4kProfileSettings var1);

        default public Builder xavc4kProfileSettings(Consumer<Xavc4kProfileSettings.Builder> xavc4kProfileSettings) {
            return this.xavc4kProfileSettings((Xavc4kProfileSettings)((Xavc4kProfileSettings.Builder)Xavc4kProfileSettings.builder().applyMutation(xavc4kProfileSettings)).build());
        }

        public Builder xavcHdIntraCbgProfileSettings(XavcHdIntraCbgProfileSettings var1);

        default public Builder xavcHdIntraCbgProfileSettings(Consumer<XavcHdIntraCbgProfileSettings.Builder> xavcHdIntraCbgProfileSettings) {
            return this.xavcHdIntraCbgProfileSettings((XavcHdIntraCbgProfileSettings)((XavcHdIntraCbgProfileSettings.Builder)XavcHdIntraCbgProfileSettings.builder().applyMutation(xavcHdIntraCbgProfileSettings)).build());
        }

        public Builder xavcHdProfileSettings(XavcHdProfileSettings var1);

        default public Builder xavcHdProfileSettings(Consumer<XavcHdProfileSettings.Builder> xavcHdProfileSettings) {
            return this.xavcHdProfileSettings((XavcHdProfileSettings)((XavcHdProfileSettings.Builder)XavcHdProfileSettings.builder().applyMutation(xavcHdProfileSettings)).build());
        }
    }
}

