/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.mediaconvert.model.DashAdditionalManifest;
import software.amazon.awssdk.services.mediaconvert.model.DashIsoEncryptionSettings;
import software.amazon.awssdk.services.mediaconvert.model.DashIsoGroupAudioChannelConfigSchemeIdUri;
import software.amazon.awssdk.services.mediaconvert.model.DashIsoHbbtvCompliance;
import software.amazon.awssdk.services.mediaconvert.model.DashIsoImageBasedTrickPlay;
import software.amazon.awssdk.services.mediaconvert.model.DashIsoImageBasedTrickPlaySettings;
import software.amazon.awssdk.services.mediaconvert.model.DashIsoMpdManifestBandwidthType;
import software.amazon.awssdk.services.mediaconvert.model.DashIsoMpdProfile;
import software.amazon.awssdk.services.mediaconvert.model.DashIsoPtsOffsetHandlingForBFrames;
import software.amazon.awssdk.services.mediaconvert.model.DashIsoSegmentControl;
import software.amazon.awssdk.services.mediaconvert.model.DashIsoSegmentLengthControl;
import software.amazon.awssdk.services.mediaconvert.model.DashIsoVideoCompositionOffsets;
import software.amazon.awssdk.services.mediaconvert.model.DashIsoWriteSegmentTimelineInRepresentation;
import software.amazon.awssdk.services.mediaconvert.model.DashManifestStyle;
import software.amazon.awssdk.services.mediaconvert.model.DestinationSettings;
import software.amazon.awssdk.services.mediaconvert.model.___listOfDashAdditionalManifestCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DashIsoGroupSettings
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DashIsoGroupSettings> {
    private static final SdkField<List<DashAdditionalManifest>> ADDITIONAL_MANIFESTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AdditionalManifests").getter(DashIsoGroupSettings.getter(DashIsoGroupSettings::additionalManifests)).setter(DashIsoGroupSettings.setter(Builder::additionalManifests)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("additionalManifests").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DashAdditionalManifest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> AUDIO_CHANNEL_CONFIG_SCHEME_ID_URI_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AudioChannelConfigSchemeIdUri").getter(DashIsoGroupSettings.getter(DashIsoGroupSettings::audioChannelConfigSchemeIdUriAsString)).setter(DashIsoGroupSettings.setter(Builder::audioChannelConfigSchemeIdUri)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("audioChannelConfigSchemeIdUri").build()}).build();
    private static final SdkField<String> BASE_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BaseUrl").getter(DashIsoGroupSettings.getter(DashIsoGroupSettings::baseUrl)).setter(DashIsoGroupSettings.setter(Builder::baseUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("baseUrl").build()}).build();
    private static final SdkField<String> DASH_I_FRAME_TRICK_PLAY_NAME_MODIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DashIFrameTrickPlayNameModifier").getter(DashIsoGroupSettings.getter(DashIsoGroupSettings::dashIFrameTrickPlayNameModifier)).setter(DashIsoGroupSettings.setter(Builder::dashIFrameTrickPlayNameModifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dashIFrameTrickPlayNameModifier").build()}).build();
    private static final SdkField<String> DASH_MANIFEST_STYLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DashManifestStyle").getter(DashIsoGroupSettings.getter(DashIsoGroupSettings::dashManifestStyleAsString)).setter(DashIsoGroupSettings.setter(Builder::dashManifestStyle)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dashManifestStyle").build()}).build();
    private static final SdkField<String> DESTINATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Destination").getter(DashIsoGroupSettings.getter(DashIsoGroupSettings::destination)).setter(DashIsoGroupSettings.setter(Builder::destination)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destination").build()}).build();
    private static final SdkField<DestinationSettings> DESTINATION_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DestinationSettings").getter(DashIsoGroupSettings.getter(DashIsoGroupSettings::destinationSettings)).setter(DashIsoGroupSettings.setter(Builder::destinationSettings)).constructor(DestinationSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destinationSettings").build()}).build();
    private static final SdkField<DashIsoEncryptionSettings> ENCRYPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Encryption").getter(DashIsoGroupSettings.getter(DashIsoGroupSettings::encryption)).setter(DashIsoGroupSettings.setter(Builder::encryption)).constructor(DashIsoEncryptionSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("encryption").build()}).build();
    private static final SdkField<Integer> FRAGMENT_LENGTH_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("FragmentLength").getter(DashIsoGroupSettings.getter(DashIsoGroupSettings::fragmentLength)).setter(DashIsoGroupSettings.setter(Builder::fragmentLength)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fragmentLength").build()}).build();
    private static final SdkField<String> HBBTV_COMPLIANCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HbbtvCompliance").getter(DashIsoGroupSettings.getter(DashIsoGroupSettings::hbbtvComplianceAsString)).setter(DashIsoGroupSettings.setter(Builder::hbbtvCompliance)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hbbtvCompliance").build()}).build();
    private static final SdkField<String> IMAGE_BASED_TRICK_PLAY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ImageBasedTrickPlay").getter(DashIsoGroupSettings.getter(DashIsoGroupSettings::imageBasedTrickPlayAsString)).setter(DashIsoGroupSettings.setter(Builder::imageBasedTrickPlay)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("imageBasedTrickPlay").build()}).build();
    private static final SdkField<DashIsoImageBasedTrickPlaySettings> IMAGE_BASED_TRICK_PLAY_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ImageBasedTrickPlaySettings").getter(DashIsoGroupSettings.getter(DashIsoGroupSettings::imageBasedTrickPlaySettings)).setter(DashIsoGroupSettings.setter(Builder::imageBasedTrickPlaySettings)).constructor(DashIsoImageBasedTrickPlaySettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("imageBasedTrickPlaySettings").build()}).build();
    private static final SdkField<Integer> MIN_BUFFER_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MinBufferTime").getter(DashIsoGroupSettings.getter(DashIsoGroupSettings::minBufferTime)).setter(DashIsoGroupSettings.setter(Builder::minBufferTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("minBufferTime").build()}).build();
    private static final SdkField<Double> MIN_FINAL_SEGMENT_LENGTH_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("MinFinalSegmentLength").getter(DashIsoGroupSettings.getter(DashIsoGroupSettings::minFinalSegmentLength)).setter(DashIsoGroupSettings.setter(Builder::minFinalSegmentLength)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("minFinalSegmentLength").build()}).build();
    private static final SdkField<String> MPD_MANIFEST_BANDWIDTH_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MpdManifestBandwidthType").getter(DashIsoGroupSettings.getter(DashIsoGroupSettings::mpdManifestBandwidthTypeAsString)).setter(DashIsoGroupSettings.setter(Builder::mpdManifestBandwidthType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mpdManifestBandwidthType").build()}).build();
    private static final SdkField<String> MPD_PROFILE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MpdProfile").getter(DashIsoGroupSettings.getter(DashIsoGroupSettings::mpdProfileAsString)).setter(DashIsoGroupSettings.setter(Builder::mpdProfile)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mpdProfile").build()}).build();
    private static final SdkField<String> PTS_OFFSET_HANDLING_FOR_B_FRAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PtsOffsetHandlingForBFrames").getter(DashIsoGroupSettings.getter(DashIsoGroupSettings::ptsOffsetHandlingForBFramesAsString)).setter(DashIsoGroupSettings.setter(Builder::ptsOffsetHandlingForBFrames)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ptsOffsetHandlingForBFrames").build()}).build();
    private static final SdkField<String> SEGMENT_CONTROL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SegmentControl").getter(DashIsoGroupSettings.getter(DashIsoGroupSettings::segmentControlAsString)).setter(DashIsoGroupSettings.setter(Builder::segmentControl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("segmentControl").build()}).build();
    private static final SdkField<Integer> SEGMENT_LENGTH_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("SegmentLength").getter(DashIsoGroupSettings.getter(DashIsoGroupSettings::segmentLength)).setter(DashIsoGroupSettings.setter(Builder::segmentLength)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("segmentLength").build()}).build();
    private static final SdkField<String> SEGMENT_LENGTH_CONTROL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SegmentLengthControl").getter(DashIsoGroupSettings.getter(DashIsoGroupSettings::segmentLengthControlAsString)).setter(DashIsoGroupSettings.setter(Builder::segmentLengthControl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("segmentLengthControl").build()}).build();
    private static final SdkField<String> VIDEO_COMPOSITION_OFFSETS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VideoCompositionOffsets").getter(DashIsoGroupSettings.getter(DashIsoGroupSettings::videoCompositionOffsetsAsString)).setter(DashIsoGroupSettings.setter(Builder::videoCompositionOffsets)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("videoCompositionOffsets").build()}).build();
    private static final SdkField<String> WRITE_SEGMENT_TIMELINE_IN_REPRESENTATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WriteSegmentTimelineInRepresentation").getter(DashIsoGroupSettings.getter(DashIsoGroupSettings::writeSegmentTimelineInRepresentationAsString)).setter(DashIsoGroupSettings.setter(Builder::writeSegmentTimelineInRepresentation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("writeSegmentTimelineInRepresentation").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ADDITIONAL_MANIFESTS_FIELD, AUDIO_CHANNEL_CONFIG_SCHEME_ID_URI_FIELD, BASE_URL_FIELD, DASH_I_FRAME_TRICK_PLAY_NAME_MODIFIER_FIELD, DASH_MANIFEST_STYLE_FIELD, DESTINATION_FIELD, DESTINATION_SETTINGS_FIELD, ENCRYPTION_FIELD, FRAGMENT_LENGTH_FIELD, HBBTV_COMPLIANCE_FIELD, IMAGE_BASED_TRICK_PLAY_FIELD, IMAGE_BASED_TRICK_PLAY_SETTINGS_FIELD, MIN_BUFFER_TIME_FIELD, MIN_FINAL_SEGMENT_LENGTH_FIELD, MPD_MANIFEST_BANDWIDTH_TYPE_FIELD, MPD_PROFILE_FIELD, PTS_OFFSET_HANDLING_FOR_B_FRAMES_FIELD, SEGMENT_CONTROL_FIELD, SEGMENT_LENGTH_FIELD, SEGMENT_LENGTH_CONTROL_FIELD, VIDEO_COMPOSITION_OFFSETS_FIELD, WRITE_SEGMENT_TIMELINE_IN_REPRESENTATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("additionalManifests", ADDITIONAL_MANIFESTS_FIELD);
            this.put("audioChannelConfigSchemeIdUri", AUDIO_CHANNEL_CONFIG_SCHEME_ID_URI_FIELD);
            this.put("baseUrl", BASE_URL_FIELD);
            this.put("dashIFrameTrickPlayNameModifier", DASH_I_FRAME_TRICK_PLAY_NAME_MODIFIER_FIELD);
            this.put("dashManifestStyle", DASH_MANIFEST_STYLE_FIELD);
            this.put("destination", DESTINATION_FIELD);
            this.put("destinationSettings", DESTINATION_SETTINGS_FIELD);
            this.put("encryption", ENCRYPTION_FIELD);
            this.put("fragmentLength", FRAGMENT_LENGTH_FIELD);
            this.put("hbbtvCompliance", HBBTV_COMPLIANCE_FIELD);
            this.put("imageBasedTrickPlay", IMAGE_BASED_TRICK_PLAY_FIELD);
            this.put("imageBasedTrickPlaySettings", IMAGE_BASED_TRICK_PLAY_SETTINGS_FIELD);
            this.put("minBufferTime", MIN_BUFFER_TIME_FIELD);
            this.put("minFinalSegmentLength", MIN_FINAL_SEGMENT_LENGTH_FIELD);
            this.put("mpdManifestBandwidthType", MPD_MANIFEST_BANDWIDTH_TYPE_FIELD);
            this.put("mpdProfile", MPD_PROFILE_FIELD);
            this.put("ptsOffsetHandlingForBFrames", PTS_OFFSET_HANDLING_FOR_B_FRAMES_FIELD);
            this.put("segmentControl", SEGMENT_CONTROL_FIELD);
            this.put("segmentLength", SEGMENT_LENGTH_FIELD);
            this.put("segmentLengthControl", SEGMENT_LENGTH_CONTROL_FIELD);
            this.put("videoCompositionOffsets", VIDEO_COMPOSITION_OFFSETS_FIELD);
            this.put("writeSegmentTimelineInRepresentation", WRITE_SEGMENT_TIMELINE_IN_REPRESENTATION_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final List<DashAdditionalManifest> additionalManifests;
    private final String audioChannelConfigSchemeIdUri;
    private final String baseUrl;
    private final String dashIFrameTrickPlayNameModifier;
    private final String dashManifestStyle;
    private final String destination;
    private final DestinationSettings destinationSettings;
    private final DashIsoEncryptionSettings encryption;
    private final Integer fragmentLength;
    private final String hbbtvCompliance;
    private final String imageBasedTrickPlay;
    private final DashIsoImageBasedTrickPlaySettings imageBasedTrickPlaySettings;
    private final Integer minBufferTime;
    private final Double minFinalSegmentLength;
    private final String mpdManifestBandwidthType;
    private final String mpdProfile;
    private final String ptsOffsetHandlingForBFrames;
    private final String segmentControl;
    private final Integer segmentLength;
    private final String segmentLengthControl;
    private final String videoCompositionOffsets;
    private final String writeSegmentTimelineInRepresentation;

    private DashIsoGroupSettings(BuilderImpl builder) {
        this.additionalManifests = builder.additionalManifests;
        this.audioChannelConfigSchemeIdUri = builder.audioChannelConfigSchemeIdUri;
        this.baseUrl = builder.baseUrl;
        this.dashIFrameTrickPlayNameModifier = builder.dashIFrameTrickPlayNameModifier;
        this.dashManifestStyle = builder.dashManifestStyle;
        this.destination = builder.destination;
        this.destinationSettings = builder.destinationSettings;
        this.encryption = builder.encryption;
        this.fragmentLength = builder.fragmentLength;
        this.hbbtvCompliance = builder.hbbtvCompliance;
        this.imageBasedTrickPlay = builder.imageBasedTrickPlay;
        this.imageBasedTrickPlaySettings = builder.imageBasedTrickPlaySettings;
        this.minBufferTime = builder.minBufferTime;
        this.minFinalSegmentLength = builder.minFinalSegmentLength;
        this.mpdManifestBandwidthType = builder.mpdManifestBandwidthType;
        this.mpdProfile = builder.mpdProfile;
        this.ptsOffsetHandlingForBFrames = builder.ptsOffsetHandlingForBFrames;
        this.segmentControl = builder.segmentControl;
        this.segmentLength = builder.segmentLength;
        this.segmentLengthControl = builder.segmentLengthControl;
        this.videoCompositionOffsets = builder.videoCompositionOffsets;
        this.writeSegmentTimelineInRepresentation = builder.writeSegmentTimelineInRepresentation;
    }

    public final boolean hasAdditionalManifests() {
        return this.additionalManifests != null && !(this.additionalManifests instanceof SdkAutoConstructList);
    }

    public final List<DashAdditionalManifest> additionalManifests() {
        return this.additionalManifests;
    }

    public final DashIsoGroupAudioChannelConfigSchemeIdUri audioChannelConfigSchemeIdUri() {
        return DashIsoGroupAudioChannelConfigSchemeIdUri.fromValue(this.audioChannelConfigSchemeIdUri);
    }

    public final String audioChannelConfigSchemeIdUriAsString() {
        return this.audioChannelConfigSchemeIdUri;
    }

    public final String baseUrl() {
        return this.baseUrl;
    }

    public final String dashIFrameTrickPlayNameModifier() {
        return this.dashIFrameTrickPlayNameModifier;
    }

    public final DashManifestStyle dashManifestStyle() {
        return DashManifestStyle.fromValue(this.dashManifestStyle);
    }

    public final String dashManifestStyleAsString() {
        return this.dashManifestStyle;
    }

    public final String destination() {
        return this.destination;
    }

    public final DestinationSettings destinationSettings() {
        return this.destinationSettings;
    }

    public final DashIsoEncryptionSettings encryption() {
        return this.encryption;
    }

    public final Integer fragmentLength() {
        return this.fragmentLength;
    }

    public final DashIsoHbbtvCompliance hbbtvCompliance() {
        return DashIsoHbbtvCompliance.fromValue(this.hbbtvCompliance);
    }

    public final String hbbtvComplianceAsString() {
        return this.hbbtvCompliance;
    }

    public final DashIsoImageBasedTrickPlay imageBasedTrickPlay() {
        return DashIsoImageBasedTrickPlay.fromValue(this.imageBasedTrickPlay);
    }

    public final String imageBasedTrickPlayAsString() {
        return this.imageBasedTrickPlay;
    }

    public final DashIsoImageBasedTrickPlaySettings imageBasedTrickPlaySettings() {
        return this.imageBasedTrickPlaySettings;
    }

    public final Integer minBufferTime() {
        return this.minBufferTime;
    }

    public final Double minFinalSegmentLength() {
        return this.minFinalSegmentLength;
    }

    public final DashIsoMpdManifestBandwidthType mpdManifestBandwidthType() {
        return DashIsoMpdManifestBandwidthType.fromValue(this.mpdManifestBandwidthType);
    }

    public final String mpdManifestBandwidthTypeAsString() {
        return this.mpdManifestBandwidthType;
    }

    public final DashIsoMpdProfile mpdProfile() {
        return DashIsoMpdProfile.fromValue(this.mpdProfile);
    }

    public final String mpdProfileAsString() {
        return this.mpdProfile;
    }

    public final DashIsoPtsOffsetHandlingForBFrames ptsOffsetHandlingForBFrames() {
        return DashIsoPtsOffsetHandlingForBFrames.fromValue(this.ptsOffsetHandlingForBFrames);
    }

    public final String ptsOffsetHandlingForBFramesAsString() {
        return this.ptsOffsetHandlingForBFrames;
    }

    public final DashIsoSegmentControl segmentControl() {
        return DashIsoSegmentControl.fromValue(this.segmentControl);
    }

    public final String segmentControlAsString() {
        return this.segmentControl;
    }

    public final Integer segmentLength() {
        return this.segmentLength;
    }

    public final DashIsoSegmentLengthControl segmentLengthControl() {
        return DashIsoSegmentLengthControl.fromValue(this.segmentLengthControl);
    }

    public final String segmentLengthControlAsString() {
        return this.segmentLengthControl;
    }

    public final DashIsoVideoCompositionOffsets videoCompositionOffsets() {
        return DashIsoVideoCompositionOffsets.fromValue(this.videoCompositionOffsets);
    }

    public final String videoCompositionOffsetsAsString() {
        return this.videoCompositionOffsets;
    }

    public final DashIsoWriteSegmentTimelineInRepresentation writeSegmentTimelineInRepresentation() {
        return DashIsoWriteSegmentTimelineInRepresentation.fromValue(this.writeSegmentTimelineInRepresentation);
    }

    public final String writeSegmentTimelineInRepresentationAsString() {
        return this.writeSegmentTimelineInRepresentation;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAdditionalManifests() ? this.additionalManifests() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.audioChannelConfigSchemeIdUriAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.baseUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.dashIFrameTrickPlayNameModifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.dashManifestStyleAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.destination());
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.encryption());
        hashCode = 31 * hashCode + Objects.hashCode(this.fragmentLength());
        hashCode = 31 * hashCode + Objects.hashCode(this.hbbtvComplianceAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.imageBasedTrickPlayAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.imageBasedTrickPlaySettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.minBufferTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.minFinalSegmentLength());
        hashCode = 31 * hashCode + Objects.hashCode(this.mpdManifestBandwidthTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.mpdProfileAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.ptsOffsetHandlingForBFramesAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.segmentControlAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.segmentLength());
        hashCode = 31 * hashCode + Objects.hashCode(this.segmentLengthControlAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.videoCompositionOffsetsAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.writeSegmentTimelineInRepresentationAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DashIsoGroupSettings)) {
            return false;
        }
        DashIsoGroupSettings other = (DashIsoGroupSettings)obj;
        return this.hasAdditionalManifests() == other.hasAdditionalManifests() && Objects.equals(this.additionalManifests(), other.additionalManifests()) && Objects.equals(this.audioChannelConfigSchemeIdUriAsString(), other.audioChannelConfigSchemeIdUriAsString()) && Objects.equals(this.baseUrl(), other.baseUrl()) && Objects.equals(this.dashIFrameTrickPlayNameModifier(), other.dashIFrameTrickPlayNameModifier()) && Objects.equals(this.dashManifestStyleAsString(), other.dashManifestStyleAsString()) && Objects.equals(this.destination(), other.destination()) && Objects.equals(this.destinationSettings(), other.destinationSettings()) && Objects.equals(this.encryption(), other.encryption()) && Objects.equals(this.fragmentLength(), other.fragmentLength()) && Objects.equals(this.hbbtvComplianceAsString(), other.hbbtvComplianceAsString()) && Objects.equals(this.imageBasedTrickPlayAsString(), other.imageBasedTrickPlayAsString()) && Objects.equals(this.imageBasedTrickPlaySettings(), other.imageBasedTrickPlaySettings()) && Objects.equals(this.minBufferTime(), other.minBufferTime()) && Objects.equals(this.minFinalSegmentLength(), other.minFinalSegmentLength()) && Objects.equals(this.mpdManifestBandwidthTypeAsString(), other.mpdManifestBandwidthTypeAsString()) && Objects.equals(this.mpdProfileAsString(), other.mpdProfileAsString()) && Objects.equals(this.ptsOffsetHandlingForBFramesAsString(), other.ptsOffsetHandlingForBFramesAsString()) && Objects.equals(this.segmentControlAsString(), other.segmentControlAsString()) && Objects.equals(this.segmentLength(), other.segmentLength()) && Objects.equals(this.segmentLengthControlAsString(), other.segmentLengthControlAsString()) && Objects.equals(this.videoCompositionOffsetsAsString(), other.videoCompositionOffsetsAsString()) && Objects.equals(this.writeSegmentTimelineInRepresentationAsString(), other.writeSegmentTimelineInRepresentationAsString());
    }

    public final String toString() {
        return ToString.builder((String)"DashIsoGroupSettings").add("AdditionalManifests", this.hasAdditionalManifests() ? this.additionalManifests() : null).add("AudioChannelConfigSchemeIdUri", (Object)this.audioChannelConfigSchemeIdUriAsString()).add("BaseUrl", (Object)this.baseUrl()).add("DashIFrameTrickPlayNameModifier", (Object)this.dashIFrameTrickPlayNameModifier()).add("DashManifestStyle", (Object)this.dashManifestStyleAsString()).add("Destination", (Object)this.destination()).add("DestinationSettings", (Object)this.destinationSettings()).add("Encryption", (Object)this.encryption()).add("FragmentLength", (Object)this.fragmentLength()).add("HbbtvCompliance", (Object)this.hbbtvComplianceAsString()).add("ImageBasedTrickPlay", (Object)this.imageBasedTrickPlayAsString()).add("ImageBasedTrickPlaySettings", (Object)this.imageBasedTrickPlaySettings()).add("MinBufferTime", (Object)this.minBufferTime()).add("MinFinalSegmentLength", (Object)this.minFinalSegmentLength()).add("MpdManifestBandwidthType", (Object)this.mpdManifestBandwidthTypeAsString()).add("MpdProfile", (Object)this.mpdProfileAsString()).add("PtsOffsetHandlingForBFrames", (Object)this.ptsOffsetHandlingForBFramesAsString()).add("SegmentControl", (Object)this.segmentControlAsString()).add("SegmentLength", (Object)this.segmentLength()).add("SegmentLengthControl", (Object)this.segmentLengthControlAsString()).add("VideoCompositionOffsets", (Object)this.videoCompositionOffsetsAsString()).add("WriteSegmentTimelineInRepresentation", (Object)this.writeSegmentTimelineInRepresentationAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AdditionalManifests": {
                return Optional.ofNullable(clazz.cast(this.additionalManifests()));
            }
            case "AudioChannelConfigSchemeIdUri": {
                return Optional.ofNullable(clazz.cast(this.audioChannelConfigSchemeIdUriAsString()));
            }
            case "BaseUrl": {
                return Optional.ofNullable(clazz.cast(this.baseUrl()));
            }
            case "DashIFrameTrickPlayNameModifier": {
                return Optional.ofNullable(clazz.cast(this.dashIFrameTrickPlayNameModifier()));
            }
            case "DashManifestStyle": {
                return Optional.ofNullable(clazz.cast(this.dashManifestStyleAsString()));
            }
            case "Destination": {
                return Optional.ofNullable(clazz.cast(this.destination()));
            }
            case "DestinationSettings": {
                return Optional.ofNullable(clazz.cast(this.destinationSettings()));
            }
            case "Encryption": {
                return Optional.ofNullable(clazz.cast(this.encryption()));
            }
            case "FragmentLength": {
                return Optional.ofNullable(clazz.cast(this.fragmentLength()));
            }
            case "HbbtvCompliance": {
                return Optional.ofNullable(clazz.cast(this.hbbtvComplianceAsString()));
            }
            case "ImageBasedTrickPlay": {
                return Optional.ofNullable(clazz.cast(this.imageBasedTrickPlayAsString()));
            }
            case "ImageBasedTrickPlaySettings": {
                return Optional.ofNullable(clazz.cast(this.imageBasedTrickPlaySettings()));
            }
            case "MinBufferTime": {
                return Optional.ofNullable(clazz.cast(this.minBufferTime()));
            }
            case "MinFinalSegmentLength": {
                return Optional.ofNullable(clazz.cast(this.minFinalSegmentLength()));
            }
            case "MpdManifestBandwidthType": {
                return Optional.ofNullable(clazz.cast(this.mpdManifestBandwidthTypeAsString()));
            }
            case "MpdProfile": {
                return Optional.ofNullable(clazz.cast(this.mpdProfileAsString()));
            }
            case "PtsOffsetHandlingForBFrames": {
                return Optional.ofNullable(clazz.cast(this.ptsOffsetHandlingForBFramesAsString()));
            }
            case "SegmentControl": {
                return Optional.ofNullable(clazz.cast(this.segmentControlAsString()));
            }
            case "SegmentLength": {
                return Optional.ofNullable(clazz.cast(this.segmentLength()));
            }
            case "SegmentLengthControl": {
                return Optional.ofNullable(clazz.cast(this.segmentLengthControlAsString()));
            }
            case "VideoCompositionOffsets": {
                return Optional.ofNullable(clazz.cast(this.videoCompositionOffsetsAsString()));
            }
            case "WriteSegmentTimelineInRepresentation": {
                return Optional.ofNullable(clazz.cast(this.writeSegmentTimelineInRepresentationAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DashIsoGroupSettings, T> g) {
        return obj -> g.apply((DashIsoGroupSettings)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<DashAdditionalManifest> additionalManifests = DefaultSdkAutoConstructList.getInstance();
        private String audioChannelConfigSchemeIdUri;
        private String baseUrl;
        private String dashIFrameTrickPlayNameModifier;
        private String dashManifestStyle;
        private String destination;
        private DestinationSettings destinationSettings;
        private DashIsoEncryptionSettings encryption;
        private Integer fragmentLength;
        private String hbbtvCompliance;
        private String imageBasedTrickPlay;
        private DashIsoImageBasedTrickPlaySettings imageBasedTrickPlaySettings;
        private Integer minBufferTime;
        private Double minFinalSegmentLength;
        private String mpdManifestBandwidthType;
        private String mpdProfile;
        private String ptsOffsetHandlingForBFrames;
        private String segmentControl;
        private Integer segmentLength;
        private String segmentLengthControl;
        private String videoCompositionOffsets;
        private String writeSegmentTimelineInRepresentation;

        private BuilderImpl() {
        }

        private BuilderImpl(DashIsoGroupSettings model) {
            this.additionalManifests(model.additionalManifests);
            this.audioChannelConfigSchemeIdUri(model.audioChannelConfigSchemeIdUri);
            this.baseUrl(model.baseUrl);
            this.dashIFrameTrickPlayNameModifier(model.dashIFrameTrickPlayNameModifier);
            this.dashManifestStyle(model.dashManifestStyle);
            this.destination(model.destination);
            this.destinationSettings(model.destinationSettings);
            this.encryption(model.encryption);
            this.fragmentLength(model.fragmentLength);
            this.hbbtvCompliance(model.hbbtvCompliance);
            this.imageBasedTrickPlay(model.imageBasedTrickPlay);
            this.imageBasedTrickPlaySettings(model.imageBasedTrickPlaySettings);
            this.minBufferTime(model.minBufferTime);
            this.minFinalSegmentLength(model.minFinalSegmentLength);
            this.mpdManifestBandwidthType(model.mpdManifestBandwidthType);
            this.mpdProfile(model.mpdProfile);
            this.ptsOffsetHandlingForBFrames(model.ptsOffsetHandlingForBFrames);
            this.segmentControl(model.segmentControl);
            this.segmentLength(model.segmentLength);
            this.segmentLengthControl(model.segmentLengthControl);
            this.videoCompositionOffsets(model.videoCompositionOffsets);
            this.writeSegmentTimelineInRepresentation(model.writeSegmentTimelineInRepresentation);
        }

        public final List<DashAdditionalManifest.Builder> getAdditionalManifests() {
            List<DashAdditionalManifest.Builder> result = ___listOfDashAdditionalManifestCopier.copyToBuilder(this.additionalManifests);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAdditionalManifests(Collection<DashAdditionalManifest.BuilderImpl> additionalManifests) {
            this.additionalManifests = ___listOfDashAdditionalManifestCopier.copyFromBuilder(additionalManifests);
        }

        @Override
        public final Builder additionalManifests(Collection<DashAdditionalManifest> additionalManifests) {
            this.additionalManifests = ___listOfDashAdditionalManifestCopier.copy(additionalManifests);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder additionalManifests(DashAdditionalManifest ... additionalManifests) {
            this.additionalManifests(Arrays.asList(additionalManifests));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder additionalManifests(Consumer<DashAdditionalManifest.Builder> ... additionalManifests) {
            this.additionalManifests(Stream.of(additionalManifests).map(c -> (DashAdditionalManifest)((DashAdditionalManifest.Builder)DashAdditionalManifest.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getAudioChannelConfigSchemeIdUri() {
            return this.audioChannelConfigSchemeIdUri;
        }

        public final void setAudioChannelConfigSchemeIdUri(String audioChannelConfigSchemeIdUri) {
            this.audioChannelConfigSchemeIdUri = audioChannelConfigSchemeIdUri;
        }

        @Override
        public final Builder audioChannelConfigSchemeIdUri(String audioChannelConfigSchemeIdUri) {
            this.audioChannelConfigSchemeIdUri = audioChannelConfigSchemeIdUri;
            return this;
        }

        @Override
        public final Builder audioChannelConfigSchemeIdUri(DashIsoGroupAudioChannelConfigSchemeIdUri audioChannelConfigSchemeIdUri) {
            this.audioChannelConfigSchemeIdUri(audioChannelConfigSchemeIdUri == null ? null : audioChannelConfigSchemeIdUri.toString());
            return this;
        }

        public final String getBaseUrl() {
            return this.baseUrl;
        }

        public final void setBaseUrl(String baseUrl) {
            this.baseUrl = baseUrl;
        }

        @Override
        public final Builder baseUrl(String baseUrl) {
            this.baseUrl = baseUrl;
            return this;
        }

        public final String getDashIFrameTrickPlayNameModifier() {
            return this.dashIFrameTrickPlayNameModifier;
        }

        public final void setDashIFrameTrickPlayNameModifier(String dashIFrameTrickPlayNameModifier) {
            this.dashIFrameTrickPlayNameModifier = dashIFrameTrickPlayNameModifier;
        }

        @Override
        public final Builder dashIFrameTrickPlayNameModifier(String dashIFrameTrickPlayNameModifier) {
            this.dashIFrameTrickPlayNameModifier = dashIFrameTrickPlayNameModifier;
            return this;
        }

        public final String getDashManifestStyle() {
            return this.dashManifestStyle;
        }

        public final void setDashManifestStyle(String dashManifestStyle) {
            this.dashManifestStyle = dashManifestStyle;
        }

        @Override
        public final Builder dashManifestStyle(String dashManifestStyle) {
            this.dashManifestStyle = dashManifestStyle;
            return this;
        }

        @Override
        public final Builder dashManifestStyle(DashManifestStyle dashManifestStyle) {
            this.dashManifestStyle(dashManifestStyle == null ? null : dashManifestStyle.toString());
            return this;
        }

        public final String getDestination() {
            return this.destination;
        }

        public final void setDestination(String destination) {
            this.destination = destination;
        }

        @Override
        public final Builder destination(String destination) {
            this.destination = destination;
            return this;
        }

        public final DestinationSettings.Builder getDestinationSettings() {
            return this.destinationSettings != null ? this.destinationSettings.toBuilder() : null;
        }

        public final void setDestinationSettings(DestinationSettings.BuilderImpl destinationSettings) {
            this.destinationSettings = destinationSettings != null ? destinationSettings.build() : null;
        }

        @Override
        public final Builder destinationSettings(DestinationSettings destinationSettings) {
            this.destinationSettings = destinationSettings;
            return this;
        }

        public final DashIsoEncryptionSettings.Builder getEncryption() {
            return this.encryption != null ? this.encryption.toBuilder() : null;
        }

        public final void setEncryption(DashIsoEncryptionSettings.BuilderImpl encryption) {
            this.encryption = encryption != null ? encryption.build() : null;
        }

        @Override
        public final Builder encryption(DashIsoEncryptionSettings encryption) {
            this.encryption = encryption;
            return this;
        }

        public final Integer getFragmentLength() {
            return this.fragmentLength;
        }

        public final void setFragmentLength(Integer fragmentLength) {
            this.fragmentLength = fragmentLength;
        }

        @Override
        public final Builder fragmentLength(Integer fragmentLength) {
            this.fragmentLength = fragmentLength;
            return this;
        }

        public final String getHbbtvCompliance() {
            return this.hbbtvCompliance;
        }

        public final void setHbbtvCompliance(String hbbtvCompliance) {
            this.hbbtvCompliance = hbbtvCompliance;
        }

        @Override
        public final Builder hbbtvCompliance(String hbbtvCompliance) {
            this.hbbtvCompliance = hbbtvCompliance;
            return this;
        }

        @Override
        public final Builder hbbtvCompliance(DashIsoHbbtvCompliance hbbtvCompliance) {
            this.hbbtvCompliance(hbbtvCompliance == null ? null : hbbtvCompliance.toString());
            return this;
        }

        public final String getImageBasedTrickPlay() {
            return this.imageBasedTrickPlay;
        }

        public final void setImageBasedTrickPlay(String imageBasedTrickPlay) {
            this.imageBasedTrickPlay = imageBasedTrickPlay;
        }

        @Override
        public final Builder imageBasedTrickPlay(String imageBasedTrickPlay) {
            this.imageBasedTrickPlay = imageBasedTrickPlay;
            return this;
        }

        @Override
        public final Builder imageBasedTrickPlay(DashIsoImageBasedTrickPlay imageBasedTrickPlay) {
            this.imageBasedTrickPlay(imageBasedTrickPlay == null ? null : imageBasedTrickPlay.toString());
            return this;
        }

        public final DashIsoImageBasedTrickPlaySettings.Builder getImageBasedTrickPlaySettings() {
            return this.imageBasedTrickPlaySettings != null ? this.imageBasedTrickPlaySettings.toBuilder() : null;
        }

        public final void setImageBasedTrickPlaySettings(DashIsoImageBasedTrickPlaySettings.BuilderImpl imageBasedTrickPlaySettings) {
            this.imageBasedTrickPlaySettings = imageBasedTrickPlaySettings != null ? imageBasedTrickPlaySettings.build() : null;
        }

        @Override
        public final Builder imageBasedTrickPlaySettings(DashIsoImageBasedTrickPlaySettings imageBasedTrickPlaySettings) {
            this.imageBasedTrickPlaySettings = imageBasedTrickPlaySettings;
            return this;
        }

        public final Integer getMinBufferTime() {
            return this.minBufferTime;
        }

        public final void setMinBufferTime(Integer minBufferTime) {
            this.minBufferTime = minBufferTime;
        }

        @Override
        public final Builder minBufferTime(Integer minBufferTime) {
            this.minBufferTime = minBufferTime;
            return this;
        }

        public final Double getMinFinalSegmentLength() {
            return this.minFinalSegmentLength;
        }

        public final void setMinFinalSegmentLength(Double minFinalSegmentLength) {
            this.minFinalSegmentLength = minFinalSegmentLength;
        }

        @Override
        public final Builder minFinalSegmentLength(Double minFinalSegmentLength) {
            this.minFinalSegmentLength = minFinalSegmentLength;
            return this;
        }

        public final String getMpdManifestBandwidthType() {
            return this.mpdManifestBandwidthType;
        }

        public final void setMpdManifestBandwidthType(String mpdManifestBandwidthType) {
            this.mpdManifestBandwidthType = mpdManifestBandwidthType;
        }

        @Override
        public final Builder mpdManifestBandwidthType(String mpdManifestBandwidthType) {
            this.mpdManifestBandwidthType = mpdManifestBandwidthType;
            return this;
        }

        @Override
        public final Builder mpdManifestBandwidthType(DashIsoMpdManifestBandwidthType mpdManifestBandwidthType) {
            this.mpdManifestBandwidthType(mpdManifestBandwidthType == null ? null : mpdManifestBandwidthType.toString());
            return this;
        }

        public final String getMpdProfile() {
            return this.mpdProfile;
        }

        public final void setMpdProfile(String mpdProfile) {
            this.mpdProfile = mpdProfile;
        }

        @Override
        public final Builder mpdProfile(String mpdProfile) {
            this.mpdProfile = mpdProfile;
            return this;
        }

        @Override
        public final Builder mpdProfile(DashIsoMpdProfile mpdProfile) {
            this.mpdProfile(mpdProfile == null ? null : mpdProfile.toString());
            return this;
        }

        public final String getPtsOffsetHandlingForBFrames() {
            return this.ptsOffsetHandlingForBFrames;
        }

        public final void setPtsOffsetHandlingForBFrames(String ptsOffsetHandlingForBFrames) {
            this.ptsOffsetHandlingForBFrames = ptsOffsetHandlingForBFrames;
        }

        @Override
        public final Builder ptsOffsetHandlingForBFrames(String ptsOffsetHandlingForBFrames) {
            this.ptsOffsetHandlingForBFrames = ptsOffsetHandlingForBFrames;
            return this;
        }

        @Override
        public final Builder ptsOffsetHandlingForBFrames(DashIsoPtsOffsetHandlingForBFrames ptsOffsetHandlingForBFrames) {
            this.ptsOffsetHandlingForBFrames(ptsOffsetHandlingForBFrames == null ? null : ptsOffsetHandlingForBFrames.toString());
            return this;
        }

        public final String getSegmentControl() {
            return this.segmentControl;
        }

        public final void setSegmentControl(String segmentControl) {
            this.segmentControl = segmentControl;
        }

        @Override
        public final Builder segmentControl(String segmentControl) {
            this.segmentControl = segmentControl;
            return this;
        }

        @Override
        public final Builder segmentControl(DashIsoSegmentControl segmentControl) {
            this.segmentControl(segmentControl == null ? null : segmentControl.toString());
            return this;
        }

        public final Integer getSegmentLength() {
            return this.segmentLength;
        }

        public final void setSegmentLength(Integer segmentLength) {
            this.segmentLength = segmentLength;
        }

        @Override
        public final Builder segmentLength(Integer segmentLength) {
            this.segmentLength = segmentLength;
            return this;
        }

        public final String getSegmentLengthControl() {
            return this.segmentLengthControl;
        }

        public final void setSegmentLengthControl(String segmentLengthControl) {
            this.segmentLengthControl = segmentLengthControl;
        }

        @Override
        public final Builder segmentLengthControl(String segmentLengthControl) {
            this.segmentLengthControl = segmentLengthControl;
            return this;
        }

        @Override
        public final Builder segmentLengthControl(DashIsoSegmentLengthControl segmentLengthControl) {
            this.segmentLengthControl(segmentLengthControl == null ? null : segmentLengthControl.toString());
            return this;
        }

        public final String getVideoCompositionOffsets() {
            return this.videoCompositionOffsets;
        }

        public final void setVideoCompositionOffsets(String videoCompositionOffsets) {
            this.videoCompositionOffsets = videoCompositionOffsets;
        }

        @Override
        public final Builder videoCompositionOffsets(String videoCompositionOffsets) {
            this.videoCompositionOffsets = videoCompositionOffsets;
            return this;
        }

        @Override
        public final Builder videoCompositionOffsets(DashIsoVideoCompositionOffsets videoCompositionOffsets) {
            this.videoCompositionOffsets(videoCompositionOffsets == null ? null : videoCompositionOffsets.toString());
            return this;
        }

        public final String getWriteSegmentTimelineInRepresentation() {
            return this.writeSegmentTimelineInRepresentation;
        }

        public final void setWriteSegmentTimelineInRepresentation(String writeSegmentTimelineInRepresentation) {
            this.writeSegmentTimelineInRepresentation = writeSegmentTimelineInRepresentation;
        }

        @Override
        public final Builder writeSegmentTimelineInRepresentation(String writeSegmentTimelineInRepresentation) {
            this.writeSegmentTimelineInRepresentation = writeSegmentTimelineInRepresentation;
            return this;
        }

        @Override
        public final Builder writeSegmentTimelineInRepresentation(DashIsoWriteSegmentTimelineInRepresentation writeSegmentTimelineInRepresentation) {
            this.writeSegmentTimelineInRepresentation(writeSegmentTimelineInRepresentation == null ? null : writeSegmentTimelineInRepresentation.toString());
            return this;
        }

        public DashIsoGroupSettings build() {
            return new DashIsoGroupSettings(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DashIsoGroupSettings> {
        public Builder additionalManifests(Collection<DashAdditionalManifest> var1);

        public Builder additionalManifests(DashAdditionalManifest ... var1);

        public Builder additionalManifests(Consumer<DashAdditionalManifest.Builder> ... var1);

        public Builder audioChannelConfigSchemeIdUri(String var1);

        public Builder audioChannelConfigSchemeIdUri(DashIsoGroupAudioChannelConfigSchemeIdUri var1);

        public Builder baseUrl(String var1);

        public Builder dashIFrameTrickPlayNameModifier(String var1);

        public Builder dashManifestStyle(String var1);

        public Builder dashManifestStyle(DashManifestStyle var1);

        public Builder destination(String var1);

        public Builder destinationSettings(DestinationSettings var1);

        default public Builder destinationSettings(Consumer<DestinationSettings.Builder> destinationSettings) {
            return this.destinationSettings((DestinationSettings)((DestinationSettings.Builder)DestinationSettings.builder().applyMutation(destinationSettings)).build());
        }

        public Builder encryption(DashIsoEncryptionSettings var1);

        default public Builder encryption(Consumer<DashIsoEncryptionSettings.Builder> encryption) {
            return this.encryption((DashIsoEncryptionSettings)((DashIsoEncryptionSettings.Builder)DashIsoEncryptionSettings.builder().applyMutation(encryption)).build());
        }

        public Builder fragmentLength(Integer var1);

        public Builder hbbtvCompliance(String var1);

        public Builder hbbtvCompliance(DashIsoHbbtvCompliance var1);

        public Builder imageBasedTrickPlay(String var1);

        public Builder imageBasedTrickPlay(DashIsoImageBasedTrickPlay var1);

        public Builder imageBasedTrickPlaySettings(DashIsoImageBasedTrickPlaySettings var1);

        default public Builder imageBasedTrickPlaySettings(Consumer<DashIsoImageBasedTrickPlaySettings.Builder> imageBasedTrickPlaySettings) {
            return this.imageBasedTrickPlaySettings((DashIsoImageBasedTrickPlaySettings)((DashIsoImageBasedTrickPlaySettings.Builder)DashIsoImageBasedTrickPlaySettings.builder().applyMutation(imageBasedTrickPlaySettings)).build());
        }

        public Builder minBufferTime(Integer var1);

        public Builder minFinalSegmentLength(Double var1);

        public Builder mpdManifestBandwidthType(String var1);

        public Builder mpdManifestBandwidthType(DashIsoMpdManifestBandwidthType var1);

        public Builder mpdProfile(String var1);

        public Builder mpdProfile(DashIsoMpdProfile var1);

        public Builder ptsOffsetHandlingForBFrames(String var1);

        public Builder ptsOffsetHandlingForBFrames(DashIsoPtsOffsetHandlingForBFrames var1);

        public Builder segmentControl(String var1);

        public Builder segmentControl(DashIsoSegmentControl var1);

        public Builder segmentLength(Integer var1);

        public Builder segmentLengthControl(String var1);

        public Builder segmentLengthControl(DashIsoSegmentLengthControl var1);

        public Builder videoCompositionOffsets(String var1);

        public Builder videoCompositionOffsets(DashIsoVideoCompositionOffsets var1);

        public Builder writeSegmentTimelineInRepresentation(String var1);

        public Builder writeSegmentTimelineInRepresentation(DashIsoWriteSegmentTimelineInRepresentation var1);
    }
}

