/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum S3ObjectCannedAcl {
    PUBLIC_READ("PUBLIC_READ"),
    AUTHENTICATED_READ("AUTHENTICATED_READ"),
    BUCKET_OWNER_READ("BUCKET_OWNER_READ"),
    BUCKET_OWNER_FULL_CONTROL("BUCKET_OWNER_FULL_CONTROL"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, S3ObjectCannedAcl> VALUE_MAP;
    private final String value;

    private S3ObjectCannedAcl(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static S3ObjectCannedAcl fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<S3ObjectCannedAcl> knownValues() {
        EnumSet<S3ObjectCannedAcl> knownValues = EnumSet.allOf(S3ObjectCannedAcl.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(S3ObjectCannedAcl.class, S3ObjectCannedAcl::toString);
    }
}

