/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconvert.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.internal.EnumUtils;

/**
 * Required when you set Dolby Vision Profile to Profile 8.1. When you set Content mapping to None, content mapping is
 * not applied to the HDR10-compatible signal. Depending on the source peak nit level, clipping might occur on HDR
 * devices without Dolby Vision. When you set Content mapping to HDR10 1000, the transcoder creates a 1,000 nits peak
 * HDR10-compatible signal by applying static content mapping to the source. This mode is speed-optimized for PQ10
 * sources with metadata that is created from analysis. For graded Dolby Vision content, be aware that creative intent
 * might not be guaranteed with extreme 1,000 nits trims.
 */
@Generated("software.amazon.awssdk:codegen")
public enum DolbyVisionMapping {
    HDR10_NOMAP("HDR10_NOMAP"),

    HDR10_1000("HDR10_1000"),

    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, DolbyVisionMapping> VALUE_MAP = EnumUtils.uniqueIndex(DolbyVisionMapping.class,
            DolbyVisionMapping::toString);

    private final String value;

    private DolbyVisionMapping(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return DolbyVisionMapping corresponding to the value
     */
    public static DolbyVisionMapping fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link DolbyVisionMapping}s
     */
    public static Set<DolbyVisionMapping> knownValues() {
        Set<DolbyVisionMapping> knownValues = EnumSet.allOf(DolbyVisionMapping.class);
        knownValues.remove(UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }
}
