/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum AccelerationStatus {
    NOT_APPLICABLE("NOT_APPLICABLE"),
    IN_PROGRESS("IN_PROGRESS"),
    ACCELERATED("ACCELERATED"),
    NOT_ACCELERATED("NOT_ACCELERATED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, AccelerationStatus> VALUE_MAP;
    private final String value;

    private AccelerationStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static AccelerationStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<AccelerationStatus> knownValues() {
        EnumSet<AccelerationStatus> knownValues = EnumSet.allOf(AccelerationStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(AccelerationStatus.class, AccelerationStatus::toString);
    }
}

