/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum H265SceneChangeDetect {
    DISABLED("DISABLED"),
    ENABLED("ENABLED"),
    TRANSITION_DETECTION("TRANSITION_DETECTION"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, H265SceneChangeDetect> VALUE_MAP;
    private final String value;

    private H265SceneChangeDetect(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static H265SceneChangeDetect fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<H265SceneChangeDetect> knownValues() {
        EnumSet<H265SceneChangeDetect> knownValues = EnumSet.allOf(H265SceneChangeDetect.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(H265SceneChangeDetect.class, H265SceneChangeDetect::toString);
    }
}

