/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconvert.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Use these settings to insert a DVB Service Description Table (SDT) in the transport stream of this output.
 */
@Generated("software.amazon.awssdk:codegen")
public final class DvbSdtSettings implements SdkPojo, Serializable, ToCopyableBuilder<DvbSdtSettings.Builder, DvbSdtSettings> {
    private static final SdkField<String> OUTPUT_SDT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OutputSdt").getter(getter(DvbSdtSettings::outputSdtAsString)).setter(setter(Builder::outputSdt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputSdt").build()).build();

    private static final SdkField<Integer> SDT_INTERVAL_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("SdtInterval").getter(getter(DvbSdtSettings::sdtInterval)).setter(setter(Builder::sdtInterval))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sdtInterval").build()).build();

    private static final SdkField<String> SERVICE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ServiceName").getter(getter(DvbSdtSettings::serviceName)).setter(setter(Builder::serviceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceName").build()).build();

    private static final SdkField<String> SERVICE_PROVIDER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ServiceProviderName").getter(getter(DvbSdtSettings::serviceProviderName))
            .setter(setter(Builder::serviceProviderName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceProviderName").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OUTPUT_SDT_FIELD,
            SDT_INTERVAL_FIELD, SERVICE_NAME_FIELD, SERVICE_PROVIDER_NAME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String outputSdt;

    private final Integer sdtInterval;

    private final String serviceName;

    private final String serviceProviderName;

    private DvbSdtSettings(BuilderImpl builder) {
        this.outputSdt = builder.outputSdt;
        this.sdtInterval = builder.sdtInterval;
        this.serviceName = builder.serviceName;
        this.serviceProviderName = builder.serviceProviderName;
    }

    /**
     * Selects method of inserting SDT information into output stream. "Follow input SDT" copies SDT information from
     * input stream to output stream. "Follow input SDT if present" copies SDT information from input stream to output
     * stream if SDT information is present in the input, otherwise it will fall back on the user-defined values. Enter
     * "SDT Manually" means user will enter the SDT information. "No SDT" means output stream will not contain SDT
     * information.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #outputSdt} will
     * return {@link OutputSdt#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #outputSdtAsString}.
     * </p>
     * 
     * @return Selects method of inserting SDT information into output stream. "Follow input SDT" copies SDT information
     *         from input stream to output stream. "Follow input SDT if present" copies SDT information from input
     *         stream to output stream if SDT information is present in the input, otherwise it will fall back on the
     *         user-defined values. Enter "SDT Manually" means user will enter the SDT information. "No SDT" means
     *         output stream will not contain SDT information.
     * @see OutputSdt
     */
    public final OutputSdt outputSdt() {
        return OutputSdt.fromValue(outputSdt);
    }

    /**
     * Selects method of inserting SDT information into output stream. "Follow input SDT" copies SDT information from
     * input stream to output stream. "Follow input SDT if present" copies SDT information from input stream to output
     * stream if SDT information is present in the input, otherwise it will fall back on the user-defined values. Enter
     * "SDT Manually" means user will enter the SDT information. "No SDT" means output stream will not contain SDT
     * information.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #outputSdt} will
     * return {@link OutputSdt#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #outputSdtAsString}.
     * </p>
     * 
     * @return Selects method of inserting SDT information into output stream. "Follow input SDT" copies SDT information
     *         from input stream to output stream. "Follow input SDT if present" copies SDT information from input
     *         stream to output stream if SDT information is present in the input, otherwise it will fall back on the
     *         user-defined values. Enter "SDT Manually" means user will enter the SDT information. "No SDT" means
     *         output stream will not contain SDT information.
     * @see OutputSdt
     */
    public final String outputSdtAsString() {
        return outputSdt;
    }

    /**
     * The number of milliseconds between instances of this table in the output transport stream.
     * 
     * @return The number of milliseconds between instances of this table in the output transport stream.
     */
    public final Integer sdtInterval() {
        return sdtInterval;
    }

    /**
     * The service name placed in the service_descriptor in the Service Description Table. Maximum length is 256
     * characters.
     * 
     * @return The service name placed in the service_descriptor in the Service Description Table. Maximum length is 256
     *         characters.
     */
    public final String serviceName() {
        return serviceName;
    }

    /**
     * The service provider name placed in the service_descriptor in the Service Description Table. Maximum length is
     * 256 characters.
     * 
     * @return The service provider name placed in the service_descriptor in the Service Description Table. Maximum
     *         length is 256 characters.
     */
    public final String serviceProviderName() {
        return serviceProviderName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(outputSdtAsString());
        hashCode = 31 * hashCode + Objects.hashCode(sdtInterval());
        hashCode = 31 * hashCode + Objects.hashCode(serviceName());
        hashCode = 31 * hashCode + Objects.hashCode(serviceProviderName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DvbSdtSettings)) {
            return false;
        }
        DvbSdtSettings other = (DvbSdtSettings) obj;
        return Objects.equals(outputSdtAsString(), other.outputSdtAsString())
                && Objects.equals(sdtInterval(), other.sdtInterval()) && Objects.equals(serviceName(), other.serviceName())
                && Objects.equals(serviceProviderName(), other.serviceProviderName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DvbSdtSettings").add("OutputSdt", outputSdtAsString()).add("SdtInterval", sdtInterval())
                .add("ServiceName", serviceName()).add("ServiceProviderName", serviceProviderName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "OutputSdt":
            return Optional.ofNullable(clazz.cast(outputSdtAsString()));
        case "SdtInterval":
            return Optional.ofNullable(clazz.cast(sdtInterval()));
        case "ServiceName":
            return Optional.ofNullable(clazz.cast(serviceName()));
        case "ServiceProviderName":
            return Optional.ofNullable(clazz.cast(serviceProviderName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DvbSdtSettings, T> g) {
        return obj -> g.apply((DvbSdtSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DvbSdtSettings> {
        /**
         * Selects method of inserting SDT information into output stream. "Follow input SDT" copies SDT information
         * from input stream to output stream. "Follow input SDT if present" copies SDT information from input stream to
         * output stream if SDT information is present in the input, otherwise it will fall back on the user-defined
         * values. Enter "SDT Manually" means user will enter the SDT information. "No SDT" means output stream will not
         * contain SDT information.
         * 
         * @param outputSdt
         *        Selects method of inserting SDT information into output stream. "Follow input SDT" copies SDT
         *        information from input stream to output stream. "Follow input SDT if present" copies SDT information
         *        from input stream to output stream if SDT information is present in the input, otherwise it will fall
         *        back on the user-defined values. Enter "SDT Manually" means user will enter the SDT information.
         *        "No SDT" means output stream will not contain SDT information.
         * @see OutputSdt
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OutputSdt
         */
        Builder outputSdt(String outputSdt);

        /**
         * Selects method of inserting SDT information into output stream. "Follow input SDT" copies SDT information
         * from input stream to output stream. "Follow input SDT if present" copies SDT information from input stream to
         * output stream if SDT information is present in the input, otherwise it will fall back on the user-defined
         * values. Enter "SDT Manually" means user will enter the SDT information. "No SDT" means output stream will not
         * contain SDT information.
         * 
         * @param outputSdt
         *        Selects method of inserting SDT information into output stream. "Follow input SDT" copies SDT
         *        information from input stream to output stream. "Follow input SDT if present" copies SDT information
         *        from input stream to output stream if SDT information is present in the input, otherwise it will fall
         *        back on the user-defined values. Enter "SDT Manually" means user will enter the SDT information.
         *        "No SDT" means output stream will not contain SDT information.
         * @see OutputSdt
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OutputSdt
         */
        Builder outputSdt(OutputSdt outputSdt);

        /**
         * The number of milliseconds between instances of this table in the output transport stream.
         * 
         * @param sdtInterval
         *        The number of milliseconds between instances of this table in the output transport stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sdtInterval(Integer sdtInterval);

        /**
         * The service name placed in the service_descriptor in the Service Description Table. Maximum length is 256
         * characters.
         * 
         * @param serviceName
         *        The service name placed in the service_descriptor in the Service Description Table. Maximum length is
         *        256 characters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceName(String serviceName);

        /**
         * The service provider name placed in the service_descriptor in the Service Description Table. Maximum length
         * is 256 characters.
         * 
         * @param serviceProviderName
         *        The service provider name placed in the service_descriptor in the Service Description Table. Maximum
         *        length is 256 characters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceProviderName(String serviceProviderName);
    }

    static final class BuilderImpl implements Builder {
        private String outputSdt;

        private Integer sdtInterval;

        private String serviceName;

        private String serviceProviderName;

        private BuilderImpl() {
        }

        private BuilderImpl(DvbSdtSettings model) {
            outputSdt(model.outputSdt);
            sdtInterval(model.sdtInterval);
            serviceName(model.serviceName);
            serviceProviderName(model.serviceProviderName);
        }

        public final String getOutputSdt() {
            return outputSdt;
        }

        public final void setOutputSdt(String outputSdt) {
            this.outputSdt = outputSdt;
        }

        @Override
        public final Builder outputSdt(String outputSdt) {
            this.outputSdt = outputSdt;
            return this;
        }

        @Override
        public final Builder outputSdt(OutputSdt outputSdt) {
            this.outputSdt(outputSdt == null ? null : outputSdt.toString());
            return this;
        }

        public final Integer getSdtInterval() {
            return sdtInterval;
        }

        public final void setSdtInterval(Integer sdtInterval) {
            this.sdtInterval = sdtInterval;
        }

        @Override
        public final Builder sdtInterval(Integer sdtInterval) {
            this.sdtInterval = sdtInterval;
            return this;
        }

        public final String getServiceName() {
            return serviceName;
        }

        public final void setServiceName(String serviceName) {
            this.serviceName = serviceName;
        }

        @Override
        public final Builder serviceName(String serviceName) {
            this.serviceName = serviceName;
            return this;
        }

        public final String getServiceProviderName() {
            return serviceProviderName;
        }

        public final void setServiceProviderName(String serviceProviderName) {
            this.serviceProviderName = serviceProviderName;
        }

        @Override
        public final Builder serviceProviderName(String serviceProviderName) {
            this.serviceProviderName = serviceProviderName;
            return this;
        }

        @Override
        public DvbSdtSettings build() {
            return new DvbSdtSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
