/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconvert.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.internal.EnumUtils;

/**
 * Specify the video sample composition time offset mode in the output fMP4 TRUN box. For wider player compatibility,
 * set Video composition offsets to Unsigned or leave blank. The earliest presentation time may be greater than zero,
 * and sample composition time offsets will increment using unsigned integers. For strict fMP4 video and audio timing,
 * set Video composition offsets to Signed. The earliest presentation time will be equal to zero, and sample composition
 * time offsets will increment using signed integers.
 */
@Generated("software.amazon.awssdk:codegen")
public enum CmafVideoCompositionOffsets {
    SIGNED("SIGNED"),

    UNSIGNED("UNSIGNED"),

    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, CmafVideoCompositionOffsets> VALUE_MAP = EnumUtils.uniqueIndex(
            CmafVideoCompositionOffsets.class, CmafVideoCompositionOffsets::toString);

    private final String value;

    private CmafVideoCompositionOffsets(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return CmafVideoCompositionOffsets corresponding to the value
     */
    public static CmafVideoCompositionOffsets fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link CmafVideoCompositionOffsets}s
     */
    public static Set<CmafVideoCompositionOffsets> knownValues() {
        Set<CmafVideoCompositionOffsets> knownValues = EnumSet.allOf(CmafVideoCompositionOffsets.class);
        knownValues.remove(UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }
}
