/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconvert.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * If your input captions are SCC, TTML, STL, SMI, SRT, or IMSC in an xml file, specify the URI of the input captions
 * source file. If your input captions are IMSC in an IMF package, use TrackSourceSettings instead of FileSoureSettings.
 */
@Generated("software.amazon.awssdk:codegen")
public final class CaptionSourceSettings implements SdkPojo, Serializable,
        ToCopyableBuilder<CaptionSourceSettings.Builder, CaptionSourceSettings> {
    private static final SdkField<AncillarySourceSettings> ANCILLARY_SOURCE_SETTINGS_FIELD = SdkField
            .<AncillarySourceSettings> builder(MarshallingType.SDK_POJO).memberName("AncillarySourceSettings")
            .getter(getter(CaptionSourceSettings::ancillarySourceSettings)).setter(setter(Builder::ancillarySourceSettings))
            .constructor(AncillarySourceSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ancillarySourceSettings").build())
            .build();

    private static final SdkField<DvbSubSourceSettings> DVB_SUB_SOURCE_SETTINGS_FIELD = SdkField
            .<DvbSubSourceSettings> builder(MarshallingType.SDK_POJO).memberName("DvbSubSourceSettings")
            .getter(getter(CaptionSourceSettings::dvbSubSourceSettings)).setter(setter(Builder::dvbSubSourceSettings))
            .constructor(DvbSubSourceSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dvbSubSourceSettings").build())
            .build();

    private static final SdkField<EmbeddedSourceSettings> EMBEDDED_SOURCE_SETTINGS_FIELD = SdkField
            .<EmbeddedSourceSettings> builder(MarshallingType.SDK_POJO).memberName("EmbeddedSourceSettings")
            .getter(getter(CaptionSourceSettings::embeddedSourceSettings)).setter(setter(Builder::embeddedSourceSettings))
            .constructor(EmbeddedSourceSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("embeddedSourceSettings").build())
            .build();

    private static final SdkField<FileSourceSettings> FILE_SOURCE_SETTINGS_FIELD = SdkField
            .<FileSourceSettings> builder(MarshallingType.SDK_POJO).memberName("FileSourceSettings")
            .getter(getter(CaptionSourceSettings::fileSourceSettings)).setter(setter(Builder::fileSourceSettings))
            .constructor(FileSourceSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fileSourceSettings").build())
            .build();

    private static final SdkField<String> SOURCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SourceType").getter(getter(CaptionSourceSettings::sourceTypeAsString))
            .setter(setter(Builder::sourceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceType").build()).build();

    private static final SdkField<TeletextSourceSettings> TELETEXT_SOURCE_SETTINGS_FIELD = SdkField
            .<TeletextSourceSettings> builder(MarshallingType.SDK_POJO).memberName("TeletextSourceSettings")
            .getter(getter(CaptionSourceSettings::teletextSourceSettings)).setter(setter(Builder::teletextSourceSettings))
            .constructor(TeletextSourceSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("teletextSourceSettings").build())
            .build();

    private static final SdkField<TrackSourceSettings> TRACK_SOURCE_SETTINGS_FIELD = SdkField
            .<TrackSourceSettings> builder(MarshallingType.SDK_POJO).memberName("TrackSourceSettings")
            .getter(getter(CaptionSourceSettings::trackSourceSettings)).setter(setter(Builder::trackSourceSettings))
            .constructor(TrackSourceSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("trackSourceSettings").build())
            .build();

    private static final SdkField<WebvttHlsSourceSettings> WEBVTT_HLS_SOURCE_SETTINGS_FIELD = SdkField
            .<WebvttHlsSourceSettings> builder(MarshallingType.SDK_POJO).memberName("WebvttHlsSourceSettings")
            .getter(getter(CaptionSourceSettings::webvttHlsSourceSettings)).setter(setter(Builder::webvttHlsSourceSettings))
            .constructor(WebvttHlsSourceSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("webvttHlsSourceSettings").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            ANCILLARY_SOURCE_SETTINGS_FIELD, DVB_SUB_SOURCE_SETTINGS_FIELD, EMBEDDED_SOURCE_SETTINGS_FIELD,
            FILE_SOURCE_SETTINGS_FIELD, SOURCE_TYPE_FIELD, TELETEXT_SOURCE_SETTINGS_FIELD, TRACK_SOURCE_SETTINGS_FIELD,
            WEBVTT_HLS_SOURCE_SETTINGS_FIELD));

    private static final long serialVersionUID = 1L;

    private final AncillarySourceSettings ancillarySourceSettings;

    private final DvbSubSourceSettings dvbSubSourceSettings;

    private final EmbeddedSourceSettings embeddedSourceSettings;

    private final FileSourceSettings fileSourceSettings;

    private final String sourceType;

    private final TeletextSourceSettings teletextSourceSettings;

    private final TrackSourceSettings trackSourceSettings;

    private final WebvttHlsSourceSettings webvttHlsSourceSettings;

    private CaptionSourceSettings(BuilderImpl builder) {
        this.ancillarySourceSettings = builder.ancillarySourceSettings;
        this.dvbSubSourceSettings = builder.dvbSubSourceSettings;
        this.embeddedSourceSettings = builder.embeddedSourceSettings;
        this.fileSourceSettings = builder.fileSourceSettings;
        this.sourceType = builder.sourceType;
        this.teletextSourceSettings = builder.teletextSourceSettings;
        this.trackSourceSettings = builder.trackSourceSettings;
        this.webvttHlsSourceSettings = builder.webvttHlsSourceSettings;
    }

    /**
     * Settings for ancillary captions source.
     * 
     * @return Settings for ancillary captions source.
     */
    public final AncillarySourceSettings ancillarySourceSettings() {
        return ancillarySourceSettings;
    }

    /**
     * DVB Sub Source Settings
     * 
     * @return DVB Sub Source Settings
     */
    public final DvbSubSourceSettings dvbSubSourceSettings() {
        return dvbSubSourceSettings;
    }

    /**
     * Settings for embedded captions Source
     * 
     * @return Settings for embedded captions Source
     */
    public final EmbeddedSourceSettings embeddedSourceSettings() {
        return embeddedSourceSettings;
    }

    /**
     * If your input captions are SCC, SMI, SRT, STL, TTML, WebVTT, or IMSC 1.1 in an xml file, specify the URI of the
     * input caption source file. If your caption source is IMSC in an IMF package, use TrackSourceSettings instead of
     * FileSoureSettings.
     * 
     * @return If your input captions are SCC, SMI, SRT, STL, TTML, WebVTT, or IMSC 1.1 in an xml file, specify the URI
     *         of the input caption source file. If your caption source is IMSC in an IMF package, use
     *         TrackSourceSettings instead of FileSoureSettings.
     */
    public final FileSourceSettings fileSourceSettings() {
        return fileSourceSettings;
    }

    /**
     * Use Source to identify the format of your input captions. The service cannot auto-detect caption format.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sourceType} will
     * return {@link CaptionSourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sourceTypeAsString}.
     * </p>
     * 
     * @return Use Source to identify the format of your input captions. The service cannot auto-detect caption format.
     * @see CaptionSourceType
     */
    public final CaptionSourceType sourceType() {
        return CaptionSourceType.fromValue(sourceType);
    }

    /**
     * Use Source to identify the format of your input captions. The service cannot auto-detect caption format.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sourceType} will
     * return {@link CaptionSourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sourceTypeAsString}.
     * </p>
     * 
     * @return Use Source to identify the format of your input captions. The service cannot auto-detect caption format.
     * @see CaptionSourceType
     */
    public final String sourceTypeAsString() {
        return sourceType;
    }

    /**
     * Settings specific to Teletext caption sources, including Page number.
     * 
     * @return Settings specific to Teletext caption sources, including Page number.
     */
    public final TeletextSourceSettings teletextSourceSettings() {
        return teletextSourceSettings;
    }

    /**
     * Settings specific to caption sources that are specified by track number. Currently, this is only IMSC captions in
     * an IMF package. If your caption source is IMSC 1.1 in a separate xml file, use FileSourceSettings instead of
     * TrackSourceSettings.
     * 
     * @return Settings specific to caption sources that are specified by track number. Currently, this is only IMSC
     *         captions in an IMF package. If your caption source is IMSC 1.1 in a separate xml file, use
     *         FileSourceSettings instead of TrackSourceSettings.
     */
    public final TrackSourceSettings trackSourceSettings() {
        return trackSourceSettings;
    }

    /**
     * Settings specific to WebVTT sources in HLS alternative rendition group. Specify the properties (renditionGroupId,
     * renditionName or renditionLanguageCode) to identify the unique subtitle track among the alternative rendition
     * groups present in the HLS manifest. If no unique track is found, or multiple tracks match the specified
     * properties, the job fails. If there is only one subtitle track in the rendition group, the settings can be left
     * empty and the default subtitle track will be chosen. If your caption source is a sidecar file, use
     * FileSourceSettings instead of WebvttHlsSourceSettings.
     * 
     * @return Settings specific to WebVTT sources in HLS alternative rendition group. Specify the properties
     *         (renditionGroupId, renditionName or renditionLanguageCode) to identify the unique subtitle track among
     *         the alternative rendition groups present in the HLS manifest. If no unique track is found, or multiple
     *         tracks match the specified properties, the job fails. If there is only one subtitle track in the
     *         rendition group, the settings can be left empty and the default subtitle track will be chosen. If your
     *         caption source is a sidecar file, use FileSourceSettings instead of WebvttHlsSourceSettings.
     */
    public final WebvttHlsSourceSettings webvttHlsSourceSettings() {
        return webvttHlsSourceSettings;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(ancillarySourceSettings());
        hashCode = 31 * hashCode + Objects.hashCode(dvbSubSourceSettings());
        hashCode = 31 * hashCode + Objects.hashCode(embeddedSourceSettings());
        hashCode = 31 * hashCode + Objects.hashCode(fileSourceSettings());
        hashCode = 31 * hashCode + Objects.hashCode(sourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(teletextSourceSettings());
        hashCode = 31 * hashCode + Objects.hashCode(trackSourceSettings());
        hashCode = 31 * hashCode + Objects.hashCode(webvttHlsSourceSettings());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CaptionSourceSettings)) {
            return false;
        }
        CaptionSourceSettings other = (CaptionSourceSettings) obj;
        return Objects.equals(ancillarySourceSettings(), other.ancillarySourceSettings())
                && Objects.equals(dvbSubSourceSettings(), other.dvbSubSourceSettings())
                && Objects.equals(embeddedSourceSettings(), other.embeddedSourceSettings())
                && Objects.equals(fileSourceSettings(), other.fileSourceSettings())
                && Objects.equals(sourceTypeAsString(), other.sourceTypeAsString())
                && Objects.equals(teletextSourceSettings(), other.teletextSourceSettings())
                && Objects.equals(trackSourceSettings(), other.trackSourceSettings())
                && Objects.equals(webvttHlsSourceSettings(), other.webvttHlsSourceSettings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CaptionSourceSettings").add("AncillarySourceSettings", ancillarySourceSettings())
                .add("DvbSubSourceSettings", dvbSubSourceSettings()).add("EmbeddedSourceSettings", embeddedSourceSettings())
                .add("FileSourceSettings", fileSourceSettings()).add("SourceType", sourceTypeAsString())
                .add("TeletextSourceSettings", teletextSourceSettings()).add("TrackSourceSettings", trackSourceSettings())
                .add("WebvttHlsSourceSettings", webvttHlsSourceSettings()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AncillarySourceSettings":
            return Optional.ofNullable(clazz.cast(ancillarySourceSettings()));
        case "DvbSubSourceSettings":
            return Optional.ofNullable(clazz.cast(dvbSubSourceSettings()));
        case "EmbeddedSourceSettings":
            return Optional.ofNullable(clazz.cast(embeddedSourceSettings()));
        case "FileSourceSettings":
            return Optional.ofNullable(clazz.cast(fileSourceSettings()));
        case "SourceType":
            return Optional.ofNullable(clazz.cast(sourceTypeAsString()));
        case "TeletextSourceSettings":
            return Optional.ofNullable(clazz.cast(teletextSourceSettings()));
        case "TrackSourceSettings":
            return Optional.ofNullable(clazz.cast(trackSourceSettings()));
        case "WebvttHlsSourceSettings":
            return Optional.ofNullable(clazz.cast(webvttHlsSourceSettings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CaptionSourceSettings, T> g) {
        return obj -> g.apply((CaptionSourceSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CaptionSourceSettings> {
        /**
         * Settings for ancillary captions source.
         * 
         * @param ancillarySourceSettings
         *        Settings for ancillary captions source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ancillarySourceSettings(AncillarySourceSettings ancillarySourceSettings);

        /**
         * Settings for ancillary captions source. This is a convenience method that creates an instance of the
         * {@link AncillarySourceSettings.Builder} avoiding the need to create one manually via
         * {@link AncillarySourceSettings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AncillarySourceSettings.Builder#build()} is called immediately
         * and its result is passed to {@link #ancillarySourceSettings(AncillarySourceSettings)}.
         * 
         * @param ancillarySourceSettings
         *        a consumer that will call methods on {@link AncillarySourceSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ancillarySourceSettings(AncillarySourceSettings)
         */
        default Builder ancillarySourceSettings(Consumer<AncillarySourceSettings.Builder> ancillarySourceSettings) {
            return ancillarySourceSettings(AncillarySourceSettings.builder().applyMutation(ancillarySourceSettings).build());
        }

        /**
         * DVB Sub Source Settings
         * 
         * @param dvbSubSourceSettings
         *        DVB Sub Source Settings
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dvbSubSourceSettings(DvbSubSourceSettings dvbSubSourceSettings);

        /**
         * DVB Sub Source Settings This is a convenience method that creates an instance of the
         * {@link DvbSubSourceSettings.Builder} avoiding the need to create one manually via
         * {@link DvbSubSourceSettings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DvbSubSourceSettings.Builder#build()} is called immediately and
         * its result is passed to {@link #dvbSubSourceSettings(DvbSubSourceSettings)}.
         * 
         * @param dvbSubSourceSettings
         *        a consumer that will call methods on {@link DvbSubSourceSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dvbSubSourceSettings(DvbSubSourceSettings)
         */
        default Builder dvbSubSourceSettings(Consumer<DvbSubSourceSettings.Builder> dvbSubSourceSettings) {
            return dvbSubSourceSettings(DvbSubSourceSettings.builder().applyMutation(dvbSubSourceSettings).build());
        }

        /**
         * Settings for embedded captions Source
         * 
         * @param embeddedSourceSettings
         *        Settings for embedded captions Source
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder embeddedSourceSettings(EmbeddedSourceSettings embeddedSourceSettings);

        /**
         * Settings for embedded captions Source This is a convenience method that creates an instance of the
         * {@link EmbeddedSourceSettings.Builder} avoiding the need to create one manually via
         * {@link EmbeddedSourceSettings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EmbeddedSourceSettings.Builder#build()} is called immediately and
         * its result is passed to {@link #embeddedSourceSettings(EmbeddedSourceSettings)}.
         * 
         * @param embeddedSourceSettings
         *        a consumer that will call methods on {@link EmbeddedSourceSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #embeddedSourceSettings(EmbeddedSourceSettings)
         */
        default Builder embeddedSourceSettings(Consumer<EmbeddedSourceSettings.Builder> embeddedSourceSettings) {
            return embeddedSourceSettings(EmbeddedSourceSettings.builder().applyMutation(embeddedSourceSettings).build());
        }

        /**
         * If your input captions are SCC, SMI, SRT, STL, TTML, WebVTT, or IMSC 1.1 in an xml file, specify the URI of
         * the input caption source file. If your caption source is IMSC in an IMF package, use TrackSourceSettings
         * instead of FileSoureSettings.
         * 
         * @param fileSourceSettings
         *        If your input captions are SCC, SMI, SRT, STL, TTML, WebVTT, or IMSC 1.1 in an xml file, specify the
         *        URI of the input caption source file. If your caption source is IMSC in an IMF package, use
         *        TrackSourceSettings instead of FileSoureSettings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fileSourceSettings(FileSourceSettings fileSourceSettings);

        /**
         * If your input captions are SCC, SMI, SRT, STL, TTML, WebVTT, or IMSC 1.1 in an xml file, specify the URI of
         * the input caption source file. If your caption source is IMSC in an IMF package, use TrackSourceSettings
         * instead of FileSoureSettings. This is a convenience method that creates an instance of the
         * {@link FileSourceSettings.Builder} avoiding the need to create one manually via
         * {@link FileSourceSettings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FileSourceSettings.Builder#build()} is called immediately and its
         * result is passed to {@link #fileSourceSettings(FileSourceSettings)}.
         * 
         * @param fileSourceSettings
         *        a consumer that will call methods on {@link FileSourceSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #fileSourceSettings(FileSourceSettings)
         */
        default Builder fileSourceSettings(Consumer<FileSourceSettings.Builder> fileSourceSettings) {
            return fileSourceSettings(FileSourceSettings.builder().applyMutation(fileSourceSettings).build());
        }

        /**
         * Use Source to identify the format of your input captions. The service cannot auto-detect caption format.
         * 
         * @param sourceType
         *        Use Source to identify the format of your input captions. The service cannot auto-detect caption
         *        format.
         * @see CaptionSourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CaptionSourceType
         */
        Builder sourceType(String sourceType);

        /**
         * Use Source to identify the format of your input captions. The service cannot auto-detect caption format.
         * 
         * @param sourceType
         *        Use Source to identify the format of your input captions. The service cannot auto-detect caption
         *        format.
         * @see CaptionSourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CaptionSourceType
         */
        Builder sourceType(CaptionSourceType sourceType);

        /**
         * Settings specific to Teletext caption sources, including Page number.
         * 
         * @param teletextSourceSettings
         *        Settings specific to Teletext caption sources, including Page number.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder teletextSourceSettings(TeletextSourceSettings teletextSourceSettings);

        /**
         * Settings specific to Teletext caption sources, including Page number. This is a convenience method that
         * creates an instance of the {@link TeletextSourceSettings.Builder} avoiding the need to create one manually
         * via {@link TeletextSourceSettings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TeletextSourceSettings.Builder#build()} is called immediately and
         * its result is passed to {@link #teletextSourceSettings(TeletextSourceSettings)}.
         * 
         * @param teletextSourceSettings
         *        a consumer that will call methods on {@link TeletextSourceSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #teletextSourceSettings(TeletextSourceSettings)
         */
        default Builder teletextSourceSettings(Consumer<TeletextSourceSettings.Builder> teletextSourceSettings) {
            return teletextSourceSettings(TeletextSourceSettings.builder().applyMutation(teletextSourceSettings).build());
        }

        /**
         * Settings specific to caption sources that are specified by track number. Currently, this is only IMSC
         * captions in an IMF package. If your caption source is IMSC 1.1 in a separate xml file, use FileSourceSettings
         * instead of TrackSourceSettings.
         * 
         * @param trackSourceSettings
         *        Settings specific to caption sources that are specified by track number. Currently, this is only IMSC
         *        captions in an IMF package. If your caption source is IMSC 1.1 in a separate xml file, use
         *        FileSourceSettings instead of TrackSourceSettings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trackSourceSettings(TrackSourceSettings trackSourceSettings);

        /**
         * Settings specific to caption sources that are specified by track number. Currently, this is only IMSC
         * captions in an IMF package. If your caption source is IMSC 1.1 in a separate xml file, use FileSourceSettings
         * instead of TrackSourceSettings. This is a convenience method that creates an instance of the
         * {@link TrackSourceSettings.Builder} avoiding the need to create one manually via
         * {@link TrackSourceSettings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TrackSourceSettings.Builder#build()} is called immediately and
         * its result is passed to {@link #trackSourceSettings(TrackSourceSettings)}.
         * 
         * @param trackSourceSettings
         *        a consumer that will call methods on {@link TrackSourceSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #trackSourceSettings(TrackSourceSettings)
         */
        default Builder trackSourceSettings(Consumer<TrackSourceSettings.Builder> trackSourceSettings) {
            return trackSourceSettings(TrackSourceSettings.builder().applyMutation(trackSourceSettings).build());
        }

        /**
         * Settings specific to WebVTT sources in HLS alternative rendition group. Specify the properties
         * (renditionGroupId, renditionName or renditionLanguageCode) to identify the unique subtitle track among the
         * alternative rendition groups present in the HLS manifest. If no unique track is found, or multiple tracks
         * match the specified properties, the job fails. If there is only one subtitle track in the rendition group,
         * the settings can be left empty and the default subtitle track will be chosen. If your caption source is a
         * sidecar file, use FileSourceSettings instead of WebvttHlsSourceSettings.
         * 
         * @param webvttHlsSourceSettings
         *        Settings specific to WebVTT sources in HLS alternative rendition group. Specify the properties
         *        (renditionGroupId, renditionName or renditionLanguageCode) to identify the unique subtitle track among
         *        the alternative rendition groups present in the HLS manifest. If no unique track is found, or multiple
         *        tracks match the specified properties, the job fails. If there is only one subtitle track in the
         *        rendition group, the settings can be left empty and the default subtitle track will be chosen. If your
         *        caption source is a sidecar file, use FileSourceSettings instead of WebvttHlsSourceSettings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder webvttHlsSourceSettings(WebvttHlsSourceSettings webvttHlsSourceSettings);

        /**
         * Settings specific to WebVTT sources in HLS alternative rendition group. Specify the properties
         * (renditionGroupId, renditionName or renditionLanguageCode) to identify the unique subtitle track among the
         * alternative rendition groups present in the HLS manifest. If no unique track is found, or multiple tracks
         * match the specified properties, the job fails. If there is only one subtitle track in the rendition group,
         * the settings can be left empty and the default subtitle track will be chosen. If your caption source is a
         * sidecar file, use FileSourceSettings instead of WebvttHlsSourceSettings. This is a convenience method that
         * creates an instance of the {@link WebvttHlsSourceSettings.Builder} avoiding the need to create one manually
         * via {@link WebvttHlsSourceSettings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link WebvttHlsSourceSettings.Builder#build()} is called immediately
         * and its result is passed to {@link #webvttHlsSourceSettings(WebvttHlsSourceSettings)}.
         * 
         * @param webvttHlsSourceSettings
         *        a consumer that will call methods on {@link WebvttHlsSourceSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #webvttHlsSourceSettings(WebvttHlsSourceSettings)
         */
        default Builder webvttHlsSourceSettings(Consumer<WebvttHlsSourceSettings.Builder> webvttHlsSourceSettings) {
            return webvttHlsSourceSettings(WebvttHlsSourceSettings.builder().applyMutation(webvttHlsSourceSettings).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private AncillarySourceSettings ancillarySourceSettings;

        private DvbSubSourceSettings dvbSubSourceSettings;

        private EmbeddedSourceSettings embeddedSourceSettings;

        private FileSourceSettings fileSourceSettings;

        private String sourceType;

        private TeletextSourceSettings teletextSourceSettings;

        private TrackSourceSettings trackSourceSettings;

        private WebvttHlsSourceSettings webvttHlsSourceSettings;

        private BuilderImpl() {
        }

        private BuilderImpl(CaptionSourceSettings model) {
            ancillarySourceSettings(model.ancillarySourceSettings);
            dvbSubSourceSettings(model.dvbSubSourceSettings);
            embeddedSourceSettings(model.embeddedSourceSettings);
            fileSourceSettings(model.fileSourceSettings);
            sourceType(model.sourceType);
            teletextSourceSettings(model.teletextSourceSettings);
            trackSourceSettings(model.trackSourceSettings);
            webvttHlsSourceSettings(model.webvttHlsSourceSettings);
        }

        public final AncillarySourceSettings.Builder getAncillarySourceSettings() {
            return ancillarySourceSettings != null ? ancillarySourceSettings.toBuilder() : null;
        }

        public final void setAncillarySourceSettings(AncillarySourceSettings.BuilderImpl ancillarySourceSettings) {
            this.ancillarySourceSettings = ancillarySourceSettings != null ? ancillarySourceSettings.build() : null;
        }

        @Override
        public final Builder ancillarySourceSettings(AncillarySourceSettings ancillarySourceSettings) {
            this.ancillarySourceSettings = ancillarySourceSettings;
            return this;
        }

        public final DvbSubSourceSettings.Builder getDvbSubSourceSettings() {
            return dvbSubSourceSettings != null ? dvbSubSourceSettings.toBuilder() : null;
        }

        public final void setDvbSubSourceSettings(DvbSubSourceSettings.BuilderImpl dvbSubSourceSettings) {
            this.dvbSubSourceSettings = dvbSubSourceSettings != null ? dvbSubSourceSettings.build() : null;
        }

        @Override
        public final Builder dvbSubSourceSettings(DvbSubSourceSettings dvbSubSourceSettings) {
            this.dvbSubSourceSettings = dvbSubSourceSettings;
            return this;
        }

        public final EmbeddedSourceSettings.Builder getEmbeddedSourceSettings() {
            return embeddedSourceSettings != null ? embeddedSourceSettings.toBuilder() : null;
        }

        public final void setEmbeddedSourceSettings(EmbeddedSourceSettings.BuilderImpl embeddedSourceSettings) {
            this.embeddedSourceSettings = embeddedSourceSettings != null ? embeddedSourceSettings.build() : null;
        }

        @Override
        public final Builder embeddedSourceSettings(EmbeddedSourceSettings embeddedSourceSettings) {
            this.embeddedSourceSettings = embeddedSourceSettings;
            return this;
        }

        public final FileSourceSettings.Builder getFileSourceSettings() {
            return fileSourceSettings != null ? fileSourceSettings.toBuilder() : null;
        }

        public final void setFileSourceSettings(FileSourceSettings.BuilderImpl fileSourceSettings) {
            this.fileSourceSettings = fileSourceSettings != null ? fileSourceSettings.build() : null;
        }

        @Override
        public final Builder fileSourceSettings(FileSourceSettings fileSourceSettings) {
            this.fileSourceSettings = fileSourceSettings;
            return this;
        }

        public final String getSourceType() {
            return sourceType;
        }

        public final void setSourceType(String sourceType) {
            this.sourceType = sourceType;
        }

        @Override
        public final Builder sourceType(String sourceType) {
            this.sourceType = sourceType;
            return this;
        }

        @Override
        public final Builder sourceType(CaptionSourceType sourceType) {
            this.sourceType(sourceType == null ? null : sourceType.toString());
            return this;
        }

        public final TeletextSourceSettings.Builder getTeletextSourceSettings() {
            return teletextSourceSettings != null ? teletextSourceSettings.toBuilder() : null;
        }

        public final void setTeletextSourceSettings(TeletextSourceSettings.BuilderImpl teletextSourceSettings) {
            this.teletextSourceSettings = teletextSourceSettings != null ? teletextSourceSettings.build() : null;
        }

        @Override
        public final Builder teletextSourceSettings(TeletextSourceSettings teletextSourceSettings) {
            this.teletextSourceSettings = teletextSourceSettings;
            return this;
        }

        public final TrackSourceSettings.Builder getTrackSourceSettings() {
            return trackSourceSettings != null ? trackSourceSettings.toBuilder() : null;
        }

        public final void setTrackSourceSettings(TrackSourceSettings.BuilderImpl trackSourceSettings) {
            this.trackSourceSettings = trackSourceSettings != null ? trackSourceSettings.build() : null;
        }

        @Override
        public final Builder trackSourceSettings(TrackSourceSettings trackSourceSettings) {
            this.trackSourceSettings = trackSourceSettings;
            return this;
        }

        public final WebvttHlsSourceSettings.Builder getWebvttHlsSourceSettings() {
            return webvttHlsSourceSettings != null ? webvttHlsSourceSettings.toBuilder() : null;
        }

        public final void setWebvttHlsSourceSettings(WebvttHlsSourceSettings.BuilderImpl webvttHlsSourceSettings) {
            this.webvttHlsSourceSettings = webvttHlsSourceSettings != null ? webvttHlsSourceSettings.build() : null;
        }

        @Override
        public final Builder webvttHlsSourceSettings(WebvttHlsSourceSettings webvttHlsSourceSettings) {
            this.webvttHlsSourceSettings = webvttHlsSourceSettings;
            return this;
        }

        @Override
        public CaptionSourceSettings build() {
            return new CaptionSourceSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
