/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconvert.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;

@Generated("software.amazon.awssdk:codegen")
final class ___listOfDashAdditionalManifestCopier {
    static List<DashAdditionalManifest> copy(Collection<? extends DashAdditionalManifest> __listOfDashAdditionalManifestParam) {
        List<DashAdditionalManifest> list;
        if (__listOfDashAdditionalManifestParam == null || __listOfDashAdditionalManifestParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<DashAdditionalManifest> modifiableList = new ArrayList<>();
            __listOfDashAdditionalManifestParam.forEach(entry -> {
                modifiableList.add(entry);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<DashAdditionalManifest> copyFromBuilder(
            Collection<? extends DashAdditionalManifest.Builder> __listOfDashAdditionalManifestParam) {
        List<DashAdditionalManifest> list;
        if (__listOfDashAdditionalManifestParam == null || __listOfDashAdditionalManifestParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<DashAdditionalManifest> modifiableList = new ArrayList<>();
            __listOfDashAdditionalManifestParam.forEach(entry -> {
                DashAdditionalManifest member = entry == null ? null : entry.build();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<DashAdditionalManifest.Builder> copyToBuilder(
            Collection<? extends DashAdditionalManifest> __listOfDashAdditionalManifestParam) {
        List<DashAdditionalManifest.Builder> list;
        if (__listOfDashAdditionalManifestParam == null || __listOfDashAdditionalManifestParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<DashAdditionalManifest.Builder> modifiableList = new ArrayList<>();
            __listOfDashAdditionalManifestParam.forEach(entry -> {
                DashAdditionalManifest.Builder member = entry == null ? null : entry.toBuilder();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }
}
