/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconvert;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.mediaconvert.model.AssociateCertificateRequest;
import software.amazon.awssdk.services.mediaconvert.model.AssociateCertificateResponse;
import software.amazon.awssdk.services.mediaconvert.model.BadRequestException;
import software.amazon.awssdk.services.mediaconvert.model.CancelJobRequest;
import software.amazon.awssdk.services.mediaconvert.model.CancelJobResponse;
import software.amazon.awssdk.services.mediaconvert.model.ConflictException;
import software.amazon.awssdk.services.mediaconvert.model.CreateJobRequest;
import software.amazon.awssdk.services.mediaconvert.model.CreateJobResponse;
import software.amazon.awssdk.services.mediaconvert.model.CreateJobTemplateRequest;
import software.amazon.awssdk.services.mediaconvert.model.CreateJobTemplateResponse;
import software.amazon.awssdk.services.mediaconvert.model.CreatePresetRequest;
import software.amazon.awssdk.services.mediaconvert.model.CreatePresetResponse;
import software.amazon.awssdk.services.mediaconvert.model.CreateQueueRequest;
import software.amazon.awssdk.services.mediaconvert.model.CreateQueueResponse;
import software.amazon.awssdk.services.mediaconvert.model.DeleteJobTemplateRequest;
import software.amazon.awssdk.services.mediaconvert.model.DeleteJobTemplateResponse;
import software.amazon.awssdk.services.mediaconvert.model.DeletePolicyRequest;
import software.amazon.awssdk.services.mediaconvert.model.DeletePolicyResponse;
import software.amazon.awssdk.services.mediaconvert.model.DeletePresetRequest;
import software.amazon.awssdk.services.mediaconvert.model.DeletePresetResponse;
import software.amazon.awssdk.services.mediaconvert.model.DeleteQueueRequest;
import software.amazon.awssdk.services.mediaconvert.model.DeleteQueueResponse;
import software.amazon.awssdk.services.mediaconvert.model.DescribeEndpointsRequest;
import software.amazon.awssdk.services.mediaconvert.model.DescribeEndpointsResponse;
import software.amazon.awssdk.services.mediaconvert.model.DisassociateCertificateRequest;
import software.amazon.awssdk.services.mediaconvert.model.DisassociateCertificateResponse;
import software.amazon.awssdk.services.mediaconvert.model.ForbiddenException;
import software.amazon.awssdk.services.mediaconvert.model.GetJobRequest;
import software.amazon.awssdk.services.mediaconvert.model.GetJobResponse;
import software.amazon.awssdk.services.mediaconvert.model.GetJobTemplateRequest;
import software.amazon.awssdk.services.mediaconvert.model.GetJobTemplateResponse;
import software.amazon.awssdk.services.mediaconvert.model.GetPolicyRequest;
import software.amazon.awssdk.services.mediaconvert.model.GetPolicyResponse;
import software.amazon.awssdk.services.mediaconvert.model.GetPresetRequest;
import software.amazon.awssdk.services.mediaconvert.model.GetPresetResponse;
import software.amazon.awssdk.services.mediaconvert.model.GetQueueRequest;
import software.amazon.awssdk.services.mediaconvert.model.GetQueueResponse;
import software.amazon.awssdk.services.mediaconvert.model.InternalServerErrorException;
import software.amazon.awssdk.services.mediaconvert.model.ListJobTemplatesRequest;
import software.amazon.awssdk.services.mediaconvert.model.ListJobTemplatesResponse;
import software.amazon.awssdk.services.mediaconvert.model.ListJobsRequest;
import software.amazon.awssdk.services.mediaconvert.model.ListJobsResponse;
import software.amazon.awssdk.services.mediaconvert.model.ListPresetsRequest;
import software.amazon.awssdk.services.mediaconvert.model.ListPresetsResponse;
import software.amazon.awssdk.services.mediaconvert.model.ListQueuesRequest;
import software.amazon.awssdk.services.mediaconvert.model.ListQueuesResponse;
import software.amazon.awssdk.services.mediaconvert.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.mediaconvert.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.mediaconvert.model.MediaConvertException;
import software.amazon.awssdk.services.mediaconvert.model.NotFoundException;
import software.amazon.awssdk.services.mediaconvert.model.PutPolicyRequest;
import software.amazon.awssdk.services.mediaconvert.model.PutPolicyResponse;
import software.amazon.awssdk.services.mediaconvert.model.TagResourceRequest;
import software.amazon.awssdk.services.mediaconvert.model.TagResourceResponse;
import software.amazon.awssdk.services.mediaconvert.model.TooManyRequestsException;
import software.amazon.awssdk.services.mediaconvert.model.UntagResourceRequest;
import software.amazon.awssdk.services.mediaconvert.model.UntagResourceResponse;
import software.amazon.awssdk.services.mediaconvert.model.UpdateJobTemplateRequest;
import software.amazon.awssdk.services.mediaconvert.model.UpdateJobTemplateResponse;
import software.amazon.awssdk.services.mediaconvert.model.UpdatePresetRequest;
import software.amazon.awssdk.services.mediaconvert.model.UpdatePresetResponse;
import software.amazon.awssdk.services.mediaconvert.model.UpdateQueueRequest;
import software.amazon.awssdk.services.mediaconvert.model.UpdateQueueResponse;
import software.amazon.awssdk.services.mediaconvert.paginators.DescribeEndpointsIterable;
import software.amazon.awssdk.services.mediaconvert.paginators.ListJobTemplatesIterable;
import software.amazon.awssdk.services.mediaconvert.paginators.ListJobsIterable;
import software.amazon.awssdk.services.mediaconvert.paginators.ListPresetsIterable;
import software.amazon.awssdk.services.mediaconvert.paginators.ListQueuesIterable;

/**
 * Service client for accessing MediaConvert. This can be created using the static {@link #builder()} method.
 *
 * AWS Elemental MediaConvert
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface MediaConvertClient extends AwsClient {
    String SERVICE_NAME = "mediaconvert";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "mediaconvert";

    /**
     * Associates an AWS Certificate Manager (ACM) Amazon Resource Name (ARN) with AWS Elemental MediaConvert.
     *
     * @param associateCertificateRequest
     * @return Result of the AssociateCertificate operation returned by the service.
     * @throws BadRequestException
     *         The service can't process your request because of a problem in the request. Please check your request
     *         form and syntax.
     * @throws InternalServerErrorException
     *         The service encountered an unexpected condition and cannot fulfill your request.
     * @throws ForbiddenException
     *         You don't have permissions for this action with the credentials you sent.
     * @throws NotFoundException
     *         The resource you requested does not exist.
     * @throws TooManyRequestsException
     *         Too many requests have been sent in too short of a time. The service limits the rate at which it will
     *         accept requests.
     * @throws ConflictException
     *         The service could not complete your request because there is a conflict with the current state of the
     *         resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConvertException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConvertClient.AssociateCertificate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconvert-2017-08-29/AssociateCertificate"
     *      target="_top">AWS API Documentation</a>
     */
    default AssociateCertificateResponse associateCertificate(AssociateCertificateRequest associateCertificateRequest)
            throws BadRequestException, InternalServerErrorException, ForbiddenException, NotFoundException,
            TooManyRequestsException, ConflictException, AwsServiceException, SdkClientException, MediaConvertException {
        throw new UnsupportedOperationException();
    }

    /**
     * Associates an AWS Certificate Manager (ACM) Amazon Resource Name (ARN) with AWS Elemental MediaConvert.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssociateCertificateRequest.Builder} avoiding the
     * need to create one manually via {@link AssociateCertificateRequest#builder()}
     * </p>
     *
     * @param associateCertificateRequest
     *        A {@link Consumer} that will call methods on {@link AssociateCertificateRequest.Builder} to create a
     *        request.
     * @return Result of the AssociateCertificate operation returned by the service.
     * @throws BadRequestException
     *         The service can't process your request because of a problem in the request. Please check your request
     *         form and syntax.
     * @throws InternalServerErrorException
     *         The service encountered an unexpected condition and cannot fulfill your request.
     * @throws ForbiddenException
     *         You don't have permissions for this action with the credentials you sent.
     * @throws NotFoundException
     *         The resource you requested does not exist.
     * @throws TooManyRequestsException
     *         Too many requests have been sent in too short of a time. The service limits the rate at which it will
     *         accept requests.
     * @throws ConflictException
     *         The service could not complete your request because there is a conflict with the current state of the
     *         resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConvertException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConvertClient.AssociateCertificate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconvert-2017-08-29/AssociateCertificate"
     *      target="_top">AWS API Documentation</a>
     */
    default AssociateCertificateResponse associateCertificate(
            Consumer<AssociateCertificateRequest.Builder> associateCertificateRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, NotFoundException, TooManyRequestsException, ConflictException,
            AwsServiceException, SdkClientException, MediaConvertException {
        return associateCertificate(AssociateCertificateRequest.builder().applyMutation(associateCertificateRequest).build());
    }

    /**
     * Permanently cancel a job. Once you have canceled a job, you can't start it again.
     *
     * @param cancelJobRequest
     * @return Result of the CancelJob operation returned by the service.
     * @throws BadRequestException
     *         The service can't process your request because of a problem in the request. Please check your request
     *         form and syntax.
     * @throws InternalServerErrorException
     *         The service encountered an unexpected condition and can't fulfill your request.
     * @throws ForbiddenException
     *         You don't have permissions for this action with the credentials you sent.
     * @throws NotFoundException
     *         The resource you requested doesn't exist.
     * @throws TooManyRequestsException
     *         Too many requests have been sent in too short of a time. The service limits the rate at which it will
     *         accept requests.
     * @throws ConflictException
     *         The service couldn't complete your request because there is a conflict with the current state of the
     *         resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConvertException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConvertClient.CancelJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconvert-2017-08-29/CancelJob" target="_top">AWS API
     *      Documentation</a>
     */
    default CancelJobResponse cancelJob(CancelJobRequest cancelJobRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, NotFoundException, TooManyRequestsException, ConflictException,
            AwsServiceException, SdkClientException, MediaConvertException {
        throw new UnsupportedOperationException();
    }

    /**
     * Permanently cancel a job. Once you have canceled a job, you can't start it again.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CancelJobRequest.Builder} avoiding the need to
     * create one manually via {@link CancelJobRequest#builder()}
     * </p>
     *
     * @param cancelJobRequest
     *        A {@link Consumer} that will call methods on {@link CancelJobRequest.Builder} to create a request.
     * @return Result of the CancelJob operation returned by the service.
     * @throws BadRequestException
     *         The service can't process your request because of a problem in the request. Please check your request
     *         form and syntax.
     * @throws InternalServerErrorException
     *         The service encountered an unexpected condition and can't fulfill your request.
     * @throws ForbiddenException
     *         You don't have permissions for this action with the credentials you sent.
     * @throws NotFoundException
     *         The resource you requested doesn't exist.
     * @throws TooManyRequestsException
     *         Too many requests have been sent in too short of a time. The service limits the rate at which it will
     *         accept requests.
     * @throws ConflictException
     *         The service couldn't complete your request because there is a conflict with the current state of the
     *         resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConvertException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConvertClient.CancelJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconvert-2017-08-29/CancelJob" target="_top">AWS API
     *      Documentation</a>
     */
    default CancelJobResponse cancelJob(Consumer<CancelJobRequest.Builder> cancelJobRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, NotFoundException, TooManyRequestsException, ConflictException,
            AwsServiceException, SdkClientException, MediaConvertException {
        return cancelJob(CancelJobRequest.builder().applyMutation(cancelJobRequest).build());
    }

    /**
     * Create a new transcoding job. For information about jobs and job settings, see the User Guide at
     * http://docs.aws.amazon.com/mediaconvert/latest/ug/what-is.html
     *
     * @param createJobRequest
     * @return Result of the CreateJob operation returned by the service.
     * @throws BadRequestException
     *         The service can't process your request because of a problem in the request. Please check your request
     *         form and syntax.
     * @throws InternalServerErrorException
     *         The service encountered an unexpected condition and can't fulfill your request.
     * @throws ForbiddenException
     *         You don't have permissions for this action with the credentials you sent.
     * @throws NotFoundException
     *         The resource you requested doesn't exist.
     * @throws TooManyRequestsException
     *         Too many requests have been sent in too short of a time. The service limits the rate at which it will
     *         accept requests.
     * @throws ConflictException
     *         The service couldn't complete your request because there is a conflict with the current state of the
     *         resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConvertException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConvertClient.CreateJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconvert-2017-08-29/CreateJob" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateJobResponse createJob(CreateJobRequest createJobRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, NotFoundException, TooManyRequestsException, ConflictException,
            AwsServiceException, SdkClientException, MediaConvertException {
        throw new UnsupportedOperationException();
    }

    /**
     * Create a new transcoding job. For information about jobs and job settings, see the User Guide at
     * http://docs.aws.amazon.com/mediaconvert/latest/ug/what-is.html<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateJobRequest.Builder} avoiding the need to
     * create one manually via {@link CreateJobRequest#builder()}
     * </p>
     *
     * @param createJobRequest
     *        A {@link Consumer} that will call methods on {@link CreateJobRequest.Builder} to create a request.
     * @return Result of the CreateJob operation returned by the service.
     * @throws BadRequestException
     *         The service can't process your request because of a problem in the request. Please check your request
     *         form and syntax.
     * @throws InternalServerErrorException
     *         The service encountered an unexpected condition and can't fulfill your request.
     * @throws ForbiddenException
     *         You don't have permissions for this action with the credentials you sent.
     * @throws NotFoundException
     *         The resource you requested doesn't exist.
     * @throws TooManyRequestsException
     *         Too many requests have been sent in too short of a time. The service limits the rate at which it will
     *         accept requests.
     * @throws ConflictException
     *         The service couldn't complete your request because there is a conflict with the current state of the
     *         resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConvertException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConvertClient.CreateJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconvert-2017-08-29/CreateJob" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateJobResponse createJob(Consumer<CreateJobRequest.Builder> createJobRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, NotFoundException, TooManyRequestsException, ConflictException,
            AwsServiceException, SdkClientException, MediaConvertException {
        return createJob(CreateJobRequest.builder().applyMutation(createJobRequest).build());
    }

    /**
     * Create a new job template. For information about job templates see the User Guide at
     * http://docs.aws.amazon.com/mediaconvert/latest/ug/what-is.html
     *
     * @param createJobTemplateRequest
     * @return Result of the CreateJobTemplate operation returned by the service.
     * @throws BadRequestException
     *         The service can't process your request because of a problem in the request. Please check your request
     *         form and syntax.
     * @throws InternalServerErrorException
     *         The service encountered an unexpected condition and can't fulfill your request.
     * @throws ForbiddenException
     *         You don't have permissions for this action with the credentials you sent.
     * @throws NotFoundException
     *         The resource you requested doesn't exist.
     * @throws TooManyRequestsException
     *         Too many requests have been sent in too short of a time. The service limits the rate at which it will
     *         accept requests.
     * @throws ConflictException
     *         The service couldn't complete your request because there is a conflict with the current state of the
     *         resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConvertException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConvertClient.CreateJobTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconvert-2017-08-29/CreateJobTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateJobTemplateResponse createJobTemplate(CreateJobTemplateRequest createJobTemplateRequest)
            throws BadRequestException, InternalServerErrorException, ForbiddenException, NotFoundException,
            TooManyRequestsException, ConflictException, AwsServiceException, SdkClientException, MediaConvertException {
        throw new UnsupportedOperationException();
    }

    /**
     * Create a new job template. For information about job templates see the User Guide at
     * http://docs.aws.amazon.com/mediaconvert/latest/ug/what-is.html<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateJobTemplateRequest.Builder} avoiding the need
     * to create one manually via {@link CreateJobTemplateRequest#builder()}
     * </p>
     *
     * @param createJobTemplateRequest
     *        A {@link Consumer} that will call methods on {@link CreateJobTemplateRequest.Builder} to create a request.
     * @return Result of the CreateJobTemplate operation returned by the service.
     * @throws BadRequestException
     *         The service can't process your request because of a problem in the request. Please check your request
     *         form and syntax.
     * @throws InternalServerErrorException
     *         The service encountered an unexpected condition and can't fulfill your request.
     * @throws ForbiddenException
     *         You don't have permissions for this action with the credentials you sent.
     * @throws NotFoundException
     *         The resource you requested doesn't exist.
     * @throws TooManyRequestsException
     *         Too many requests have been sent in too short of a time. The service limits the rate at which it will
     *         accept requests.
     * @throws ConflictException
     *         The service couldn't complete your request because there is a conflict with the current state of the
     *         resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConvertException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConvertClient.CreateJobTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconvert-2017-08-29/CreateJobTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateJobTemplateResponse createJobTemplate(Consumer<CreateJobTemplateRequest.Builder> createJobTemplateRequest)
            throws BadRequestException, InternalServerErrorException, ForbiddenException, NotFoundException,
            TooManyRequestsException, ConflictException, AwsServiceException, SdkClientException, MediaConvertException {
        return createJobTemplate(CreateJobTemplateRequest.builder().applyMutation(createJobTemplateRequest).build());
    }

    /**
     * Create a new preset. For information about job templates see the User Guide at
     * http://docs.aws.amazon.com/mediaconvert/latest/ug/what-is.html
     *
     * @param createPresetRequest
     * @return Result of the CreatePreset operation returned by the service.
     * @throws BadRequestException
     *         The service can't process your request because of a problem in the request. Please check your request
     *         form and syntax.
     * @throws InternalServerErrorException
     *         The service encountered an unexpected condition and can't fulfill your request.
     * @throws ForbiddenException
     *         You don't have permissions for this action with the credentials you sent.
     * @throws NotFoundException
     *         The resource you requested doesn't exist.
     * @throws TooManyRequestsException
     *         Too many requests have been sent in too short of a time. The service limits the rate at which it will
     *         accept requests.
     * @throws ConflictException
     *         The service couldn't complete your request because there is a conflict with the current state of the
     *         resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConvertException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConvertClient.CreatePreset
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconvert-2017-08-29/CreatePreset" target="_top">AWS API
     *      Documentation</a>
     */
    default CreatePresetResponse createPreset(CreatePresetRequest createPresetRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, NotFoundException, TooManyRequestsException, ConflictException,
            AwsServiceException, SdkClientException, MediaConvertException {
        throw new UnsupportedOperationException();
    }

    /**
     * Create a new preset. For information about job templates see the User Guide at
     * http://docs.aws.amazon.com/mediaconvert/latest/ug/what-is.html<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreatePresetRequest.Builder} avoiding the need to
     * create one manually via {@link CreatePresetRequest#builder()}
     * </p>
     *
     * @param createPresetRequest
     *        A {@link Consumer} that will call methods on {@link CreatePresetRequest.Builder} to create a request.
     * @return Result of the CreatePreset operation returned by the service.
     * @throws BadRequestException
     *         The service can't process your request because of a problem in the request. Please check your request
     *         form and syntax.
     * @throws InternalServerErrorException
     *         The service encountered an unexpected condition and can't fulfill your request.
     * @throws ForbiddenException
     *         You don't have permissions for this action with the credentials you sent.
     * @throws NotFoundException
     *         The resource you requested doesn't exist.
     * @throws TooManyRequestsException
     *         Too many requests have been sent in too short of a time. The service limits the rate at which it will
     *         accept requests.
     * @throws ConflictException
     *         The service couldn't complete your request because there is a conflict with the current state of the
     *         resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConvertException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConvertClient.CreatePreset
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconvert-2017-08-29/CreatePreset" target="_top">AWS API
     *      Documentation</a>
     */
    default CreatePresetResponse createPreset(Consumer<CreatePresetRequest.Builder> createPresetRequest)
            throws BadRequestException, InternalServerErrorException, ForbiddenException, NotFoundException,
            TooManyRequestsException, ConflictException, AwsServiceException, SdkClientException, MediaConvertException {
        return createPreset(CreatePresetRequest.builder().applyMutation(createPresetRequest).build());
    }

    /**
     * Create a new transcoding queue. For information about queues, see Working With Queues in the User Guide at
     * https://docs.aws.amazon.com/mediaconvert/latest/ug/working-with-queues.html
     *
     * @param createQueueRequest
     * @return Result of the CreateQueue operation returned by the service.
     * @throws BadRequestException
     *         The service can't process your request because of a problem in the request. Please check your request
     *         form and syntax.
     * @throws InternalServerErrorException
     *         The service encountered an unexpected condition and can't fulfill your request.
     * @throws ForbiddenException
     *         You don't have permissions for this action with the credentials you sent.
     * @throws NotFoundException
     *         The resource you requested doesn't exist.
     * @throws TooManyRequestsException
     *         Too many requests have been sent in too short of a time. The service limits the rate at which it will
     *         accept requests.
     * @throws ConflictException
     *         The service couldn't complete your request because there is a conflict with the current state of the
     *         resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConvertException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConvertClient.CreateQueue
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconvert-2017-08-29/CreateQueue" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateQueueResponse createQueue(CreateQueueRequest createQueueRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, NotFoundException, TooManyRequestsException, ConflictException,
            AwsServiceException, SdkClientException, MediaConvertException {
        throw new UnsupportedOperationException();
    }

    /**
     * Create a new transcoding queue. For information about queues, see Working With Queues in the User Guide at
     * https://docs.aws.amazon.com/mediaconvert/latest/ug/working-with-queues.html<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateQueueRequest.Builder} avoiding the need to
     * create one manually via {@link CreateQueueRequest#builder()}
     * </p>
     *
     * @param createQueueRequest
     *        A {@link Consumer} that will call methods on {@link CreateQueueRequest.Builder} to create a request.
     * @return Result of the CreateQueue operation returned by the service.
     * @throws BadRequestException
     *         The service can't process your request because of a problem in the request. Please check your request
     *         form and syntax.
     * @throws InternalServerErrorException
     *         The service encountered an unexpected condition and can't fulfill your request.
     * @throws ForbiddenException
     *         You don't have permissions for this action with the credentials you sent.
     * @throws NotFoundException
     *         The resource you requested doesn't exist.
     * @throws TooManyRequestsException
     *         Too many requests have been sent in too short of a time. The service limits the rate at which it will
     *         accept requests.
     * @throws ConflictException
     *         The service couldn't complete your request because there is a conflict with the current state of the
     *         resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConvertException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConvertClient.CreateQueue
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconvert-2017-08-29/CreateQueue" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateQueueResponse createQueue(Consumer<CreateQueueRequest.Builder> createQueueRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, NotFoundException, TooManyRequestsException, ConflictException,
            AwsServiceException, SdkClientException, MediaConvertException {
        return createQueue(CreateQueueRequest.builder().applyMutation(createQueueRequest).build());
    }

    /**
     * Permanently delete a job template you have created.
     *
     * @param deleteJobTemplateRequest
     * @return Result of the DeleteJobTemplate operation returned by the service.
     * @throws BadRequestException
     *         The service can't process your request because of a problem in the request. Please check your request
     *         form and syntax.
     * @throws InternalServerErrorException
     *         The service encountered an unexpected condition and can't fulfill your request.
     * @throws ForbiddenException
     *         You don't have permissions for this action with the credentials you sent.
     * @throws NotFoundException
     *         The resource you requested doesn't exist.
     * @throws TooManyRequestsException
     *         Too many requests have been sent in too short of a time. The service limits the rate at which it will
     *         accept requests.
     * @throws ConflictException
     *         The service couldn't complete your request because there is a conflict with the current state of the
     *         resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConvertException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConvertClient.DeleteJobTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconvert-2017-08-29/DeleteJobTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteJobTemplateResponse deleteJobTemplate(DeleteJobTemplateRequest deleteJobTemplateRequest)
            throws BadRequestException, InternalServerErrorException, ForbiddenException, NotFoundException,
            TooManyRequestsException, ConflictException, AwsServiceException, SdkClientException, MediaConvertException {
        throw new UnsupportedOperationException();
    }

    /**
     * Permanently delete a job template you have created.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteJobTemplateRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteJobTemplateRequest#builder()}
     * </p>
     *
     * @param deleteJobTemplateRequest
     *        A {@link Consumer} that will call methods on {@link DeleteJobTemplateRequest.Builder} to create a request.
     * @return Result of the DeleteJobTemplate operation returned by the service.
     * @throws BadRequestException
     *         The service can't process your request because of a problem in the request. Please check your request
     *         form and syntax.
     * @throws InternalServerErrorException
     *         The service encountered an unexpected condition and can't fulfill your request.
     * @throws ForbiddenException
     *         You don't have permissions for this action with the credentials you sent.
     * @throws NotFoundException
     *         The resource you requested doesn't exist.
     * @throws TooManyRequestsException
     *         Too many requests have been sent in too short of a time. The service limits the rate at which it will
     *         accept requests.
     * @throws ConflictException
     *         The service couldn't complete your request because there is a conflict with the current state of the
     *         resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConvertException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConvertClient.DeleteJobTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconvert-2017-08-29/DeleteJobTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteJobTemplateResponse deleteJobTemplate(Consumer<DeleteJobTemplateRequest.Builder> deleteJobTemplateRequest)
            throws BadRequestException, InternalServerErrorException, ForbiddenException, NotFoundException,
            TooManyRequestsException, ConflictException, AwsServiceException, SdkClientException, MediaConvertException {
        return deleteJobTemplate(DeleteJobTemplateRequest.builder().applyMutation(deleteJobTemplateRequest).build());
    }

    /**
     * Permanently delete a policy that you created.
     *
     * @param deletePolicyRequest
     * @return Result of the DeletePolicy operation returned by the service.
     * @throws BadRequestException
     *         The service can't process your request because of a problem in the request. Please check your request
     *         form and syntax.
     * @throws InternalServerErrorException
     *         The service encountered an unexpected condition and can't fulfill your request.
     * @throws ForbiddenException
     *         You don't have permissions for this action with the credentials you sent.
     * @throws NotFoundException
     *         The resource you requested doesn't exist.
     * @throws TooManyRequestsException
     *         Too many requests have been sent in too short of a time. The service limits the rate at which it will
     *         accept requests.
     * @throws ConflictException
     *         The service couldn't complete your request because there is a conflict with the current state of the
     *         resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConvertException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConvertClient.DeletePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconvert-2017-08-29/DeletePolicy" target="_top">AWS API
     *      Documentation</a>
     */
    default DeletePolicyResponse deletePolicy(DeletePolicyRequest deletePolicyRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, NotFoundException, TooManyRequestsException, ConflictException,
            AwsServiceException, SdkClientException, MediaConvertException {
        throw new UnsupportedOperationException();
    }

    /**
     * Permanently delete a policy that you created.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeletePolicyRequest.Builder} avoiding the need to
     * create one manually via {@link DeletePolicyRequest#builder()}
     * </p>
     *
     * @param deletePolicyRequest
     *        A {@link Consumer} that will call methods on {@link DeletePolicyRequest.Builder} to create a request.
     * @return Result of the DeletePolicy operation returned by the service.
     * @throws BadRequestException
     *         The service can't process your request because of a problem in the request. Please check your request
     *         form and syntax.
     * @throws InternalServerErrorException
     *         The service encountered an unexpected condition and can't fulfill your request.
     * @throws ForbiddenException
     *         You don't have permissions for this action with the credentials you sent.
     * @throws NotFoundException
     *         The resource you requested doesn't exist.
     * @throws TooManyRequestsException
     *         Too many requests have been sent in too short of a time. The service limits the rate at which it will
     *         accept requests.
     * @throws ConflictException
     *         The service couldn't complete your request because there is a conflict with the current state of the
     *         resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConvertException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConvertClient.DeletePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconvert-2017-08-29/DeletePolicy" target="_top">AWS API
     *      Documentation</a>
     */
    default DeletePolicyResponse deletePolicy(Consumer<DeletePolicyRequest.Builder> deletePolicyRequest)
            throws BadRequestException, InternalServerErrorException, ForbiddenException, NotFoundException,
            TooManyRequestsException, ConflictException, AwsServiceException, SdkClientException, MediaConvertException {
        return deletePolicy(DeletePolicyRequest.builder().applyMutation(deletePolicyRequest).build());
    }

    /**
     * Permanently delete a preset you have created.
     *
     * @param deletePresetRequest
     * @return Result of the DeletePreset operation returned by the service.
     * @throws BadRequestException
     *         The service can't process your request because of a problem in the request. Please check your request
     *         form and syntax.
     * @throws InternalServerErrorException
     *         The service encountered an unexpected condition and can't fulfill your request.
     * @throws ForbiddenException
     *         You don't have permissions for this action with the credentials you sent.
     * @throws NotFoundException
     *         The resource you requested doesn't exist.
     * @throws TooManyRequestsException
     *         Too many requests have been sent in too short of a time. The service limits the rate at which it will
     *         accept requests.
     * @throws ConflictException
     *         The service couldn't complete your request because there is a conflict with the current state of the
     *         resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConvertException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConvertClient.DeletePreset
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconvert-2017-08-29/DeletePreset" target="_top">AWS API
     *      Documentation</a>
     */
    default DeletePresetResponse deletePreset(DeletePresetRequest deletePresetRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, NotFoundException, TooManyRequestsException, ConflictException,
            AwsServiceException, SdkClientException, MediaConvertException {
        throw new UnsupportedOperationException();
    }

    /**
     * Permanently delete a preset you have created.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeletePresetRequest.Builder} avoiding the need to
     * create one manually via {@link DeletePresetRequest#builder()}
     * </p>
     *
     * @param deletePresetRequest
     *        A {@link Consumer} that will call methods on {@link DeletePresetRequest.Builder} to create a request.
     * @return Result of the DeletePreset operation returned by the service.
     * @throws BadRequestException
     *         The service can't process your request because of a problem in the request. Please check your request
     *         form and syntax.
     * @throws InternalServerErrorException
     *         The service encountered an unexpected condition and can't fulfill your request.
     * @throws ForbiddenException
     *         You don't have permissions for this action with the credentials you sent.
     * @throws NotFoundException
     *         The resource you requested doesn't exist.
     * @throws TooManyRequestsException
     *         Too many requests have been sent in too short of a time. The service limits the rate at which it will
     *         accept requests.
     * @throws ConflictException
     *         The service couldn't complete your request because there is a conflict with the current state of the
     *         resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConvertException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConvertClient.DeletePreset
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconvert-2017-08-29/DeletePreset" target="_top">AWS API
     *      Documentation</a>
     */
    default DeletePresetResponse deletePreset(Consumer<DeletePresetRequest.Builder> deletePresetRequest)
            throws BadRequestException, InternalServerErrorException, ForbiddenException, NotFoundException,
            TooManyRequestsException, ConflictException, AwsServiceException, SdkClientException, MediaConvertException {
        return deletePreset(DeletePresetRequest.builder().applyMutation(deletePresetRequest).build());
    }

    /**
     * Permanently delete a queue you have created.
     *
     * @param deleteQueueRequest
     * @return Result of the DeleteQueue operation returned by the service.
     * @throws BadRequestException
     *         The service can't process your request because of a problem in the request. Please check your request
     *         form and syntax.
     * @throws InternalServerErrorException
     *         The service encountered an unexpected condition and can't fulfill your request.
     * @throws ForbiddenException
     *         You don't have permissions for this action with the credentials you sent.
     * @throws NotFoundException
     *         The resource you requested doesn't exist.
     * @throws TooManyRequestsException
     *         Too many requests have been sent in too short of a time. The service limits the rate at which it will
     *         accept requests.
     * @throws ConflictException
     *         The service couldn't complete your request because there is a conflict with the current state of the
     *         resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConvertException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConvertClient.DeleteQueue
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconvert-2017-08-29/DeleteQueue" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteQueueResponse deleteQueue(DeleteQueueRequest deleteQueueRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, NotFoundException, TooManyRequestsException, ConflictException,
            AwsServiceException, SdkClientException, MediaConvertException {
        throw new UnsupportedOperationException();
    }

    /**
     * Permanently delete a queue you have created.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteQueueRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteQueueRequest#builder()}
     * </p>
     *
     * @param deleteQueueRequest
     *        A {@link Consumer} that will call methods on {@link DeleteQueueRequest.Builder} to create a request.
     * @return Result of the DeleteQueue operation returned by the service.
     * @throws BadRequestException
     *         The service can't process your request because of a problem in the request. Please check your request
     *         form and syntax.
     * @throws InternalServerErrorException
     *         The service encountered an unexpected condition and can't fulfill your request.
     * @throws ForbiddenException
     *         You don't have permissions for this action with the credentials you sent.
     * @throws NotFoundException
     *         The resource you requested doesn't exist.
     * @throws TooManyRequestsException
     *         Too many requests have been sent in too short of a time. The service limits the rate at which it will
     *         accept requests.
     * @throws ConflictException
     *         The service couldn't complete your request because there is a conflict with the current state of the
     *         resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConvertException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConvertClient.DeleteQueue
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconvert-2017-08-29/DeleteQueue" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteQueueResponse deleteQueue(Consumer<DeleteQueueRequest.Builder> deleteQueueRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, NotFoundException, TooManyRequestsException, ConflictException,
            AwsServiceException, SdkClientException, MediaConvertException {
        return deleteQueue(DeleteQueueRequest.builder().applyMutation(deleteQueueRequest).build());
    }

    /**
     * Send an request with an empty body to the regional API endpoint to get your account API endpoint.
     *
     * @param describeEndpointsRequest
     *        DescribeEndpointsRequest
     * @return Result of the DescribeEndpoints operation returned by the service.
     * @throws BadRequestException
     *         BadRequestException
     * @throws InternalServerErrorException
     *         InternalServiceException
     * @throws ForbiddenException
     *         AccessDeniedException
     * @throws NotFoundException
     *         ResourceNotFoundException
     * @throws TooManyRequestsException
     *         LimitExceededException
     * @throws ConflictException
     *         ResourceInUseException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConvertException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConvertClient.DescribeEndpoints
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconvert-2017-08-29/DescribeEndpoints"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeEndpointsResponse describeEndpoints(DescribeEndpointsRequest describeEndpointsRequest)
            throws BadRequestException, InternalServerErrorException, ForbiddenException, NotFoundException,
            TooManyRequestsException, ConflictException, AwsServiceException, SdkClientException, MediaConvertException {
        throw new UnsupportedOperationException();
    }

    /**
     * Send an request with an empty body to the regional API endpoint to get your account API endpoint.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeEndpointsRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeEndpointsRequest#builder()}
     * </p>
     *
     * @param describeEndpointsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeEndpointsRequest.Builder} to create a request.
     *        DescribeEndpointsRequest
     * @return Result of the DescribeEndpoints operation returned by the service.
     * @throws BadRequestException
     *         BadRequestException
     * @throws InternalServerErrorException
     *         InternalServiceException
     * @throws ForbiddenException
     *         AccessDeniedException
     * @throws NotFoundException
     *         ResourceNotFoundException
     * @throws TooManyRequestsException
     *         LimitExceededException
     * @throws ConflictException
     *         ResourceInUseException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConvertException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConvertClient.DescribeEndpoints
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconvert-2017-08-29/DescribeEndpoints"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeEndpointsResponse describeEndpoints(Consumer<DescribeEndpointsRequest.Builder> describeEndpointsRequest)
            throws BadRequestException, InternalServerErrorException, ForbiddenException, NotFoundException,
            TooManyRequestsException, ConflictException, AwsServiceException, SdkClientException, MediaConvertException {
        return describeEndpoints(DescribeEndpointsRequest.builder().applyMutation(describeEndpointsRequest).build());
    }

    /**
     * Send an request with an empty body to the regional API endpoint to get your account API endpoint.<br/>
     * <p>
     * This is a variant of
     * {@link #describeEndpoints(software.amazon.awssdk.services.mediaconvert.model.DescribeEndpointsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mediaconvert.paginators.DescribeEndpointsIterable responses = client.describeEndpointsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.mediaconvert.paginators.DescribeEndpointsIterable responses = client
     *             .describeEndpointsPaginator(request);
     *     for (software.amazon.awssdk.services.mediaconvert.model.DescribeEndpointsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mediaconvert.paginators.DescribeEndpointsIterable responses = client.describeEndpointsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeEndpoints(software.amazon.awssdk.services.mediaconvert.model.DescribeEndpointsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeEndpointsRequest
     *        DescribeEndpointsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws BadRequestException
     *         BadRequestException
     * @throws InternalServerErrorException
     *         InternalServiceException
     * @throws ForbiddenException
     *         AccessDeniedException
     * @throws NotFoundException
     *         ResourceNotFoundException
     * @throws TooManyRequestsException
     *         LimitExceededException
     * @throws ConflictException
     *         ResourceInUseException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConvertException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConvertClient.DescribeEndpoints
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconvert-2017-08-29/DescribeEndpoints"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeEndpointsIterable describeEndpointsPaginator(DescribeEndpointsRequest describeEndpointsRequest)
            throws BadRequestException, InternalServerErrorException, ForbiddenException, NotFoundException,
            TooManyRequestsException, ConflictException, AwsServiceException, SdkClientException, MediaConvertException {
        return new DescribeEndpointsIterable(this, describeEndpointsRequest);
    }

    /**
     * Send an request with an empty body to the regional API endpoint to get your account API endpoint.<br/>
     * <p>
     * This is a variant of
     * {@link #describeEndpoints(software.amazon.awssdk.services.mediaconvert.model.DescribeEndpointsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mediaconvert.paginators.DescribeEndpointsIterable responses = client.describeEndpointsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.mediaconvert.paginators.DescribeEndpointsIterable responses = client
     *             .describeEndpointsPaginator(request);
     *     for (software.amazon.awssdk.services.mediaconvert.model.DescribeEndpointsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mediaconvert.paginators.DescribeEndpointsIterable responses = client.describeEndpointsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeEndpoints(software.amazon.awssdk.services.mediaconvert.model.DescribeEndpointsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeEndpointsRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeEndpointsRequest#builder()}
     * </p>
     *
     * @param describeEndpointsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeEndpointsRequest.Builder} to create a request.
     *        DescribeEndpointsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws BadRequestException
     *         BadRequestException
     * @throws InternalServerErrorException
     *         InternalServiceException
     * @throws ForbiddenException
     *         AccessDeniedException
     * @throws NotFoundException
     *         ResourceNotFoundException
     * @throws TooManyRequestsException
     *         LimitExceededException
     * @throws ConflictException
     *         ResourceInUseException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConvertException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConvertClient.DescribeEndpoints
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconvert-2017-08-29/DescribeEndpoints"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeEndpointsIterable describeEndpointsPaginator(
            Consumer<DescribeEndpointsRequest.Builder> describeEndpointsRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, NotFoundException, TooManyRequestsException, ConflictException,
            AwsServiceException, SdkClientException, MediaConvertException {
        return describeEndpointsPaginator(DescribeEndpointsRequest.builder().applyMutation(describeEndpointsRequest).build());
    }

    /**
     * Removes an association between the Amazon Resource Name (ARN) of an AWS Certificate Manager (ACM) certificate and
     * an AWS Elemental MediaConvert resource.
     *
     * @param disassociateCertificateRequest
     * @return Result of the DisassociateCertificate operation returned by the service.
     * @throws BadRequestException
     *         The service can't process your request because of a problem in the request. Please check your request
     *         form and syntax.
     * @throws InternalServerErrorException
     *         The service encountered an unexpected condition and cannot fulfill your request.
     * @throws ForbiddenException
     *         You don't have permissions for this action with the credentials you sent.
     * @throws NotFoundException
     *         The resource you requested does not exist.
     * @throws TooManyRequestsException
     *         Too many requests have been sent in too short of a time. The service limits the rate at which it will
     *         accept requests.
     * @throws ConflictException
     *         The service could not complete your request because there is a conflict with the current state of the
     *         resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConvertException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConvertClient.DisassociateCertificate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconvert-2017-08-29/DisassociateCertificate"
     *      target="_top">AWS API Documentation</a>
     */
    default DisassociateCertificateResponse disassociateCertificate(DisassociateCertificateRequest disassociateCertificateRequest)
            throws BadRequestException, InternalServerErrorException, ForbiddenException, NotFoundException,
            TooManyRequestsException, ConflictException, AwsServiceException, SdkClientException, MediaConvertException {
        throw new UnsupportedOperationException();
    }

    /**
     * Removes an association between the Amazon Resource Name (ARN) of an AWS Certificate Manager (ACM) certificate and
     * an AWS Elemental MediaConvert resource.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisassociateCertificateRequest.Builder} avoiding
     * the need to create one manually via {@link DisassociateCertificateRequest#builder()}
     * </p>
     *
     * @param disassociateCertificateRequest
     *        A {@link Consumer} that will call methods on {@link DisassociateCertificateRequest.Builder} to create a
     *        request.
     * @return Result of the DisassociateCertificate operation returned by the service.
     * @throws BadRequestException
     *         The service can't process your request because of a problem in the request. Please check your request
     *         form and syntax.
     * @throws InternalServerErrorException
     *         The service encountered an unexpected condition and cannot fulfill your request.
     * @throws ForbiddenException
     *         You don't have permissions for this action with the credentials you sent.
     * @throws NotFoundException
     *         The resource you requested does not exist.
     * @throws TooManyRequestsException
     *         Too many requests have been sent in too short of a time. The service limits the rate at which it will
     *         accept requests.
     * @throws ConflictException
     *         The service could not complete your request because there is a conflict with the current state of the
     *         resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConvertException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConvertClient.DisassociateCertificate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconvert-2017-08-29/DisassociateCertificate"
     *      target="_top">AWS API Documentation</a>
     */
    default DisassociateCertificateResponse disassociateCertificate(
            Consumer<DisassociateCertificateRequest.Builder> disassociateCertificateRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, NotFoundException, TooManyRequestsException, ConflictException,
            AwsServiceException, SdkClientException, MediaConvertException {
        return disassociateCertificate(DisassociateCertificateRequest.builder().applyMutation(disassociateCertificateRequest)
                .build());
    }

    /**
     * Retrieve the JSON for a specific completed transcoding job.
     *
     * @param getJobRequest
     * @return Result of the GetJob operation returned by the service.
     * @throws BadRequestException
     *         The service can't process your request because of a problem in the request. Please check your request
     *         form and syntax.
     * @throws InternalServerErrorException
     *         The service encountered an unexpected condition and can't fulfill your request.
     * @throws ForbiddenException
     *         You don't have permissions for this action with the credentials you sent.
     * @throws NotFoundException
     *         The resource you requested doesn't exist.
     * @throws TooManyRequestsException
     *         Too many requests have been sent in too short of a time. The service limits the rate at which it will
     *         accept requests.
     * @throws ConflictException
     *         The service couldn't complete your request because there is a conflict with the current state of the
     *         resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConvertException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConvertClient.GetJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconvert-2017-08-29/GetJob" target="_top">AWS API
     *      Documentation</a>
     */
    default GetJobResponse getJob(GetJobRequest getJobRequest) throws BadRequestException, InternalServerErrorException,
            ForbiddenException, NotFoundException, TooManyRequestsException, ConflictException, AwsServiceException,
            SdkClientException, MediaConvertException {
        throw new UnsupportedOperationException();
    }

    /**
     * Retrieve the JSON for a specific completed transcoding job.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetJobRequest.Builder} avoiding the need to create
     * one manually via {@link GetJobRequest#builder()}
     * </p>
     *
     * @param getJobRequest
     *        A {@link Consumer} that will call methods on {@link GetJobRequest.Builder} to create a request.
     * @return Result of the GetJob operation returned by the service.
     * @throws BadRequestException
     *         The service can't process your request because of a problem in the request. Please check your request
     *         form and syntax.
     * @throws InternalServerErrorException
     *         The service encountered an unexpected condition and can't fulfill your request.
     * @throws ForbiddenException
     *         You don't have permissions for this action with the credentials you sent.
     * @throws NotFoundException
     *         The resource you requested doesn't exist.
     * @throws TooManyRequestsException
     *         Too many requests have been sent in too short of a time. The service limits the rate at which it will
     *         accept requests.
     * @throws ConflictException
     *         The service couldn't complete your request because there is a conflict with the current state of the
     *         resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConvertException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConvertClient.GetJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconvert-2017-08-29/GetJob" target="_top">AWS API
     *      Documentation</a>
     */
    default GetJobResponse getJob(Consumer<GetJobRequest.Builder> getJobRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, NotFoundException, TooManyRequestsException, ConflictException,
            AwsServiceException, SdkClientException, MediaConvertException {
        return getJob(GetJobRequest.builder().applyMutation(getJobRequest).build());
    }

    /**
     * Retrieve the JSON for a specific job template.
     *
     * @param getJobTemplateRequest
     * @return Result of the GetJobTemplate operation returned by the service.
     * @throws BadRequestException
     *         The service can't process your request because of a problem in the request. Please check your request
     *         form and syntax.
     * @throws InternalServerErrorException
     *         The service encountered an unexpected condition and can't fulfill your request.
     * @throws ForbiddenException
     *         You don't have permissions for this action with the credentials you sent.
     * @throws NotFoundException
     *         The resource you requested doesn't exist.
     * @throws TooManyRequestsException
     *         Too many requests have been sent in too short of a time. The service limits the rate at which it will
     *         accept requests.
     * @throws ConflictException
     *         The service couldn't complete your request because there is a conflict with the current state of the
     *         resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConvertException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConvertClient.GetJobTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconvert-2017-08-29/GetJobTemplate" target="_top">AWS
     *      API Documentation</a>
     */
    default GetJobTemplateResponse getJobTemplate(GetJobTemplateRequest getJobTemplateRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, NotFoundException, TooManyRequestsException, ConflictException,
            AwsServiceException, SdkClientException, MediaConvertException {
        throw new UnsupportedOperationException();
    }

    /**
     * Retrieve the JSON for a specific job template.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetJobTemplateRequest.Builder} avoiding the need to
     * create one manually via {@link GetJobTemplateRequest#builder()}
     * </p>
     *
     * @param getJobTemplateRequest
     *        A {@link Consumer} that will call methods on {@link GetJobTemplateRequest.Builder} to create a request.
     * @return Result of the GetJobTemplate operation returned by the service.
     * @throws BadRequestException
     *         The service can't process your request because of a problem in the request. Please check your request
     *         form and syntax.
     * @throws InternalServerErrorException
     *         The service encountered an unexpected condition and can't fulfill your request.
     * @throws ForbiddenException
     *         You don't have permissions for this action with the credentials you sent.
     * @throws NotFoundException
     *         The resource you requested doesn't exist.
     * @throws TooManyRequestsException
     *         Too many requests have been sent in too short of a time. The service limits the rate at which it will
     *         accept requests.
     * @throws ConflictException
     *         The service couldn't complete your request because there is a conflict with the current state of the
     *         resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConvertException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConvertClient.GetJobTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconvert-2017-08-29/GetJobTemplate" target="_top">AWS
     *      API Documentation</a>
     */
    default GetJobTemplateResponse getJobTemplate(Consumer<GetJobTemplateRequest.Builder> getJobTemplateRequest)
            throws BadRequestException, InternalServerErrorException, ForbiddenException, NotFoundException,
            TooManyRequestsException, ConflictException, AwsServiceException, SdkClientException, MediaConvertException {
        return getJobTemplate(GetJobTemplateRequest.builder().applyMutation(getJobTemplateRequest).build());
    }

    /**
     * Retrieve the JSON for your policy.
     *
     * @param getPolicyRequest
     * @return Result of the GetPolicy operation returned by the service.
     * @throws BadRequestException
     *         The service can't process your request because of a problem in the request. Please check your request
     *         form and syntax.
     * @throws InternalServerErrorException
     *         The service encountered an unexpected condition and can't fulfill your request.
     * @throws ForbiddenException
     *         You don't have permissions for this action with the credentials you sent.
     * @throws NotFoundException
     *         The resource you requested doesn't exist.
     * @throws TooManyRequestsException
     *         Too many requests have been sent in too short of a time. The service limits the rate at which it will
     *         accept requests.
     * @throws ConflictException
     *         The service couldn't complete your request because there is a conflict with the current state of the
     *         resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConvertException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConvertClient.GetPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconvert-2017-08-29/GetPolicy" target="_top">AWS API
     *      Documentation</a>
     */
    default GetPolicyResponse getPolicy(GetPolicyRequest getPolicyRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, NotFoundException, TooManyRequestsException, ConflictException,
            AwsServiceException, SdkClientException, MediaConvertException {
        throw new UnsupportedOperationException();
    }

    /**
     * Retrieve the JSON for your policy.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetPolicyRequest.Builder} avoiding the need to
     * create one manually via {@link GetPolicyRequest#builder()}
     * </p>
     *
     * @param getPolicyRequest
     *        A {@link Consumer} that will call methods on {@link GetPolicyRequest.Builder} to create a request.
     * @return Result of the GetPolicy operation returned by the service.
     * @throws BadRequestException
     *         The service can't process your request because of a problem in the request. Please check your request
     *         form and syntax.
     * @throws InternalServerErrorException
     *         The service encountered an unexpected condition and can't fulfill your request.
     * @throws ForbiddenException
     *         You don't have permissions for this action with the credentials you sent.
     * @throws NotFoundException
     *         The resource you requested doesn't exist.
     * @throws TooManyRequestsException
     *         Too many requests have been sent in too short of a time. The service limits the rate at which it will
     *         accept requests.
     * @throws ConflictException
     *         The service couldn't complete your request because there is a conflict with the current state of the
     *         resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConvertException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConvertClient.GetPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconvert-2017-08-29/GetPolicy" target="_top">AWS API
     *      Documentation</a>
     */
    default GetPolicyResponse getPolicy(Consumer<GetPolicyRequest.Builder> getPolicyRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, NotFoundException, TooManyRequestsException, ConflictException,
            AwsServiceException, SdkClientException, MediaConvertException {
        return getPolicy(GetPolicyRequest.builder().applyMutation(getPolicyRequest).build());
    }

    /**
     * Retrieve the JSON for a specific preset.
     *
     * @param getPresetRequest
     * @return Result of the GetPreset operation returned by the service.
     * @throws BadRequestException
     *         The service can't process your request because of a problem in the request. Please check your request
     *         form and syntax.
     * @throws InternalServerErrorException
     *         The service encountered an unexpected condition and can't fulfill your request.
     * @throws ForbiddenException
     *         You don't have permissions for this action with the credentials you sent.
     * @throws NotFoundException
     *         The resource you requested doesn't exist.
     * @throws TooManyRequestsException
     *         Too many requests have been sent in too short of a time. The service limits the rate at which it will
     *         accept requests.
     * @throws ConflictException
     *         The service couldn't complete your request because there is a conflict with the current state of the
     *         resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConvertException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConvertClient.GetPreset
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconvert-2017-08-29/GetPreset" target="_top">AWS API
     *      Documentation</a>
     */
    default GetPresetResponse getPreset(GetPresetRequest getPresetRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, NotFoundException, TooManyRequestsException, ConflictException,
            AwsServiceException, SdkClientException, MediaConvertException {
        throw new UnsupportedOperationException();
    }

    /**
     * Retrieve the JSON for a specific preset.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetPresetRequest.Builder} avoiding the need to
     * create one manually via {@link GetPresetRequest#builder()}
     * </p>
     *
     * @param getPresetRequest
     *        A {@link Consumer} that will call methods on {@link GetPresetRequest.Builder} to create a request.
     * @return Result of the GetPreset operation returned by the service.
     * @throws BadRequestException
     *         The service can't process your request because of a problem in the request. Please check your request
     *         form and syntax.
     * @throws InternalServerErrorException
     *         The service encountered an unexpected condition and can't fulfill your request.
     * @throws ForbiddenException
     *         You don't have permissions for this action with the credentials you sent.
     * @throws NotFoundException
     *         The resource you requested doesn't exist.
     * @throws TooManyRequestsException
     *         Too many requests have been sent in too short of a time. The service limits the rate at which it will
     *         accept requests.
     * @throws ConflictException
     *         The service couldn't complete your request because there is a conflict with the current state of the
     *         resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConvertException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConvertClient.GetPreset
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconvert-2017-08-29/GetPreset" target="_top">AWS API
     *      Documentation</a>
     */
    default GetPresetResponse getPreset(Consumer<GetPresetRequest.Builder> getPresetRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, NotFoundException, TooManyRequestsException, ConflictException,
            AwsServiceException, SdkClientException, MediaConvertException {
        return getPreset(GetPresetRequest.builder().applyMutation(getPresetRequest).build());
    }

    /**
     * Retrieve the JSON for a specific queue.
     *
     * @param getQueueRequest
     * @return Result of the GetQueue operation returned by the service.
     * @throws BadRequestException
     *         The service can't process your request because of a problem in the request. Please check your request
     *         form and syntax.
     * @throws InternalServerErrorException
     *         The service encountered an unexpected condition and can't fulfill your request.
     * @throws ForbiddenException
     *         You don't have permissions for this action with the credentials you sent.
     * @throws NotFoundException
     *         The resource you requested doesn't exist.
     * @throws TooManyRequestsException
     *         Too many requests have been sent in too short of a time. The service limits the rate at which it will
     *         accept requests.
     * @throws ConflictException
     *         The service couldn't complete your request because there is a conflict with the current state of the
     *         resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConvertException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConvertClient.GetQueue
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconvert-2017-08-29/GetQueue" target="_top">AWS API
     *      Documentation</a>
     */
    default GetQueueResponse getQueue(GetQueueRequest getQueueRequest) throws BadRequestException, InternalServerErrorException,
            ForbiddenException, NotFoundException, TooManyRequestsException, ConflictException, AwsServiceException,
            SdkClientException, MediaConvertException {
        throw new UnsupportedOperationException();
    }

    /**
     * Retrieve the JSON for a specific queue.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetQueueRequest.Builder} avoiding the need to
     * create one manually via {@link GetQueueRequest#builder()}
     * </p>
     *
     * @param getQueueRequest
     *        A {@link Consumer} that will call methods on {@link GetQueueRequest.Builder} to create a request.
     * @return Result of the GetQueue operation returned by the service.
     * @throws BadRequestException
     *         The service can't process your request because of a problem in the request. Please check your request
     *         form and syntax.
     * @throws InternalServerErrorException
     *         The service encountered an unexpected condition and can't fulfill your request.
     * @throws ForbiddenException
     *         You don't have permissions for this action with the credentials you sent.
     * @throws NotFoundException
     *         The resource you requested doesn't exist.
     * @throws TooManyRequestsException
     *         Too many requests have been sent in too short of a time. The service limits the rate at which it will
     *         accept requests.
     * @throws ConflictException
     *         The service couldn't complete your request because there is a conflict with the current state of the
     *         resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConvertException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConvertClient.GetQueue
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconvert-2017-08-29/GetQueue" target="_top">AWS API
     *      Documentation</a>
     */
    default GetQueueResponse getQueue(Consumer<GetQueueRequest.Builder> getQueueRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, NotFoundException, TooManyRequestsException, ConflictException,
            AwsServiceException, SdkClientException, MediaConvertException {
        return getQueue(GetQueueRequest.builder().applyMutation(getQueueRequest).build());
    }

    /**
     * Retrieve a JSON array of up to twenty of your job templates. This will return the templates themselves, not just
     * a list of them. To retrieve the next twenty templates, use the nextToken string returned with the array
     *
     * @param listJobTemplatesRequest
     * @return Result of the ListJobTemplates operation returned by the service.
     * @throws BadRequestException
     *         The service can't process your request because of a problem in the request. Please check your request
     *         form and syntax.
     * @throws InternalServerErrorException
     *         The service encountered an unexpected condition and can't fulfill your request.
     * @throws ForbiddenException
     *         You don't have permissions for this action with the credentials you sent.
     * @throws NotFoundException
     *         The resource you requested doesn't exist.
     * @throws TooManyRequestsException
     *         Too many requests have been sent in too short of a time. The service limits the rate at which it will
     *         accept requests.
     * @throws ConflictException
     *         The service couldn't complete your request because there is a conflict with the current state of the
     *         resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConvertException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConvertClient.ListJobTemplates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconvert-2017-08-29/ListJobTemplates" target="_top">AWS
     *      API Documentation</a>
     */
    default ListJobTemplatesResponse listJobTemplates(ListJobTemplatesRequest listJobTemplatesRequest)
            throws BadRequestException, InternalServerErrorException, ForbiddenException, NotFoundException,
            TooManyRequestsException, ConflictException, AwsServiceException, SdkClientException, MediaConvertException {
        throw new UnsupportedOperationException();
    }

    /**
     * Retrieve a JSON array of up to twenty of your job templates. This will return the templates themselves, not just
     * a list of them. To retrieve the next twenty templates, use the nextToken string returned with the array<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListJobTemplatesRequest.Builder} avoiding the need
     * to create one manually via {@link ListJobTemplatesRequest#builder()}
     * </p>
     *
     * @param listJobTemplatesRequest
     *        A {@link Consumer} that will call methods on {@link ListJobTemplatesRequest.Builder} to create a request.
     * @return Result of the ListJobTemplates operation returned by the service.
     * @throws BadRequestException
     *         The service can't process your request because of a problem in the request. Please check your request
     *         form and syntax.
     * @throws InternalServerErrorException
     *         The service encountered an unexpected condition and can't fulfill your request.
     * @throws ForbiddenException
     *         You don't have permissions for this action with the credentials you sent.
     * @throws NotFoundException
     *         The resource you requested doesn't exist.
     * @throws TooManyRequestsException
     *         Too many requests have been sent in too short of a time. The service limits the rate at which it will
     *         accept requests.
     * @throws ConflictException
     *         The service couldn't complete your request because there is a conflict with the current state of the
     *         resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConvertException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConvertClient.ListJobTemplates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconvert-2017-08-29/ListJobTemplates" target="_top">AWS
     *      API Documentation</a>
     */
    default ListJobTemplatesResponse listJobTemplates(Consumer<ListJobTemplatesRequest.Builder> listJobTemplatesRequest)
            throws BadRequestException, InternalServerErrorException, ForbiddenException, NotFoundException,
            TooManyRequestsException, ConflictException, AwsServiceException, SdkClientException, MediaConvertException {
        return listJobTemplates(ListJobTemplatesRequest.builder().applyMutation(listJobTemplatesRequest).build());
    }

    /**
     * Retrieve a JSON array of up to twenty of your job templates. This will return the templates themselves, not just
     * a list of them. To retrieve the next twenty templates, use the nextToken string returned with the array<br/>
     * <p>
     * This is a variant of
     * {@link #listJobTemplates(software.amazon.awssdk.services.mediaconvert.model.ListJobTemplatesRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mediaconvert.paginators.ListJobTemplatesIterable responses = client.listJobTemplatesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.mediaconvert.paginators.ListJobTemplatesIterable responses = client
     *             .listJobTemplatesPaginator(request);
     *     for (software.amazon.awssdk.services.mediaconvert.model.ListJobTemplatesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mediaconvert.paginators.ListJobTemplatesIterable responses = client.listJobTemplatesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listJobTemplates(software.amazon.awssdk.services.mediaconvert.model.ListJobTemplatesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listJobTemplatesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws BadRequestException
     *         The service can't process your request because of a problem in the request. Please check your request
     *         form and syntax.
     * @throws InternalServerErrorException
     *         The service encountered an unexpected condition and can't fulfill your request.
     * @throws ForbiddenException
     *         You don't have permissions for this action with the credentials you sent.
     * @throws NotFoundException
     *         The resource you requested doesn't exist.
     * @throws TooManyRequestsException
     *         Too many requests have been sent in too short of a time. The service limits the rate at which it will
     *         accept requests.
     * @throws ConflictException
     *         The service couldn't complete your request because there is a conflict with the current state of the
     *         resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConvertException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConvertClient.ListJobTemplates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconvert-2017-08-29/ListJobTemplates" target="_top">AWS
     *      API Documentation</a>
     */
    default ListJobTemplatesIterable listJobTemplatesPaginator(ListJobTemplatesRequest listJobTemplatesRequest)
            throws BadRequestException, InternalServerErrorException, ForbiddenException, NotFoundException,
            TooManyRequestsException, ConflictException, AwsServiceException, SdkClientException, MediaConvertException {
        return new ListJobTemplatesIterable(this, listJobTemplatesRequest);
    }

    /**
     * Retrieve a JSON array of up to twenty of your job templates. This will return the templates themselves, not just
     * a list of them. To retrieve the next twenty templates, use the nextToken string returned with the array<br/>
     * <p>
     * This is a variant of
     * {@link #listJobTemplates(software.amazon.awssdk.services.mediaconvert.model.ListJobTemplatesRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mediaconvert.paginators.ListJobTemplatesIterable responses = client.listJobTemplatesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.mediaconvert.paginators.ListJobTemplatesIterable responses = client
     *             .listJobTemplatesPaginator(request);
     *     for (software.amazon.awssdk.services.mediaconvert.model.ListJobTemplatesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mediaconvert.paginators.ListJobTemplatesIterable responses = client.listJobTemplatesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listJobTemplates(software.amazon.awssdk.services.mediaconvert.model.ListJobTemplatesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListJobTemplatesRequest.Builder} avoiding the need
     * to create one manually via {@link ListJobTemplatesRequest#builder()}
     * </p>
     *
     * @param listJobTemplatesRequest
     *        A {@link Consumer} that will call methods on {@link ListJobTemplatesRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws BadRequestException
     *         The service can't process your request because of a problem in the request. Please check your request
     *         form and syntax.
     * @throws InternalServerErrorException
     *         The service encountered an unexpected condition and can't fulfill your request.
     * @throws ForbiddenException
     *         You don't have permissions for this action with the credentials you sent.
     * @throws NotFoundException
     *         The resource you requested doesn't exist.
     * @throws TooManyRequestsException
     *         Too many requests have been sent in too short of a time. The service limits the rate at which it will
     *         accept requests.
     * @throws ConflictException
     *         The service couldn't complete your request because there is a conflict with the current state of the
     *         resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConvertException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConvertClient.ListJobTemplates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconvert-2017-08-29/ListJobTemplates" target="_top">AWS
     *      API Documentation</a>
     */
    default ListJobTemplatesIterable listJobTemplatesPaginator(Consumer<ListJobTemplatesRequest.Builder> listJobTemplatesRequest)
            throws BadRequestException, InternalServerErrorException, ForbiddenException, NotFoundException,
            TooManyRequestsException, ConflictException, AwsServiceException, SdkClientException, MediaConvertException {
        return listJobTemplatesPaginator(ListJobTemplatesRequest.builder().applyMutation(listJobTemplatesRequest).build());
    }

    /**
     * Retrieve a JSON array of up to twenty of your most recently created jobs. This array includes in-process,
     * completed, and errored jobs. This will return the jobs themselves, not just a list of the jobs. To retrieve the
     * twenty next most recent jobs, use the nextToken string returned with the array.
     *
     * @param listJobsRequest
     * @return Result of the ListJobs operation returned by the service.
     * @throws BadRequestException
     *         The service can't process your request because of a problem in the request. Please check your request
     *         form and syntax.
     * @throws InternalServerErrorException
     *         The service encountered an unexpected condition and can't fulfill your request.
     * @throws ForbiddenException
     *         You don't have permissions for this action with the credentials you sent.
     * @throws NotFoundException
     *         The resource you requested doesn't exist.
     * @throws TooManyRequestsException
     *         Too many requests have been sent in too short of a time. The service limits the rate at which it will
     *         accept requests.
     * @throws ConflictException
     *         The service couldn't complete your request because there is a conflict with the current state of the
     *         resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConvertException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConvertClient.ListJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconvert-2017-08-29/ListJobs" target="_top">AWS API
     *      Documentation</a>
     */
    default ListJobsResponse listJobs(ListJobsRequest listJobsRequest) throws BadRequestException, InternalServerErrorException,
            ForbiddenException, NotFoundException, TooManyRequestsException, ConflictException, AwsServiceException,
            SdkClientException, MediaConvertException {
        throw new UnsupportedOperationException();
    }

    /**
     * Retrieve a JSON array of up to twenty of your most recently created jobs. This array includes in-process,
     * completed, and errored jobs. This will return the jobs themselves, not just a list of the jobs. To retrieve the
     * twenty next most recent jobs, use the nextToken string returned with the array.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListJobsRequest.Builder} avoiding the need to
     * create one manually via {@link ListJobsRequest#builder()}
     * </p>
     *
     * @param listJobsRequest
     *        A {@link Consumer} that will call methods on {@link ListJobsRequest.Builder} to create a request.
     * @return Result of the ListJobs operation returned by the service.
     * @throws BadRequestException
     *         The service can't process your request because of a problem in the request. Please check your request
     *         form and syntax.
     * @throws InternalServerErrorException
     *         The service encountered an unexpected condition and can't fulfill your request.
     * @throws ForbiddenException
     *         You don't have permissions for this action with the credentials you sent.
     * @throws NotFoundException
     *         The resource you requested doesn't exist.
     * @throws TooManyRequestsException
     *         Too many requests have been sent in too short of a time. The service limits the rate at which it will
     *         accept requests.
     * @throws ConflictException
     *         The service couldn't complete your request because there is a conflict with the current state of the
     *         resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConvertException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConvertClient.ListJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconvert-2017-08-29/ListJobs" target="_top">AWS API
     *      Documentation</a>
     */
    default ListJobsResponse listJobs(Consumer<ListJobsRequest.Builder> listJobsRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, NotFoundException, TooManyRequestsException, ConflictException,
            AwsServiceException, SdkClientException, MediaConvertException {
        return listJobs(ListJobsRequest.builder().applyMutation(listJobsRequest).build());
    }

    /**
     * Retrieve a JSON array of up to twenty of your most recently created jobs. This array includes in-process,
     * completed, and errored jobs. This will return the jobs themselves, not just a list of the jobs. To retrieve the
     * twenty next most recent jobs, use the nextToken string returned with the array.<br/>
     * <p>
     * This is a variant of {@link #listJobs(software.amazon.awssdk.services.mediaconvert.model.ListJobsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mediaconvert.paginators.ListJobsIterable responses = client.listJobsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.mediaconvert.paginators.ListJobsIterable responses = client.listJobsPaginator(request);
     *     for (software.amazon.awssdk.services.mediaconvert.model.ListJobsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mediaconvert.paginators.ListJobsIterable responses = client.listJobsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listJobs(software.amazon.awssdk.services.mediaconvert.model.ListJobsRequest)} operation.</b>
     * </p>
     *
     * @param listJobsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws BadRequestException
     *         The service can't process your request because of a problem in the request. Please check your request
     *         form and syntax.
     * @throws InternalServerErrorException
     *         The service encountered an unexpected condition and can't fulfill your request.
     * @throws ForbiddenException
     *         You don't have permissions for this action with the credentials you sent.
     * @throws NotFoundException
     *         The resource you requested doesn't exist.
     * @throws TooManyRequestsException
     *         Too many requests have been sent in too short of a time. The service limits the rate at which it will
     *         accept requests.
     * @throws ConflictException
     *         The service couldn't complete your request because there is a conflict with the current state of the
     *         resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConvertException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConvertClient.ListJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconvert-2017-08-29/ListJobs" target="_top">AWS API
     *      Documentation</a>
     */
    default ListJobsIterable listJobsPaginator(ListJobsRequest listJobsRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, NotFoundException, TooManyRequestsException, ConflictException,
            AwsServiceException, SdkClientException, MediaConvertException {
        return new ListJobsIterable(this, listJobsRequest);
    }

    /**
     * Retrieve a JSON array of up to twenty of your most recently created jobs. This array includes in-process,
     * completed, and errored jobs. This will return the jobs themselves, not just a list of the jobs. To retrieve the
     * twenty next most recent jobs, use the nextToken string returned with the array.<br/>
     * <p>
     * This is a variant of {@link #listJobs(software.amazon.awssdk.services.mediaconvert.model.ListJobsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mediaconvert.paginators.ListJobsIterable responses = client.listJobsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.mediaconvert.paginators.ListJobsIterable responses = client.listJobsPaginator(request);
     *     for (software.amazon.awssdk.services.mediaconvert.model.ListJobsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mediaconvert.paginators.ListJobsIterable responses = client.listJobsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listJobs(software.amazon.awssdk.services.mediaconvert.model.ListJobsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListJobsRequest.Builder} avoiding the need to
     * create one manually via {@link ListJobsRequest#builder()}
     * </p>
     *
     * @param listJobsRequest
     *        A {@link Consumer} that will call methods on {@link ListJobsRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws BadRequestException
     *         The service can't process your request because of a problem in the request. Please check your request
     *         form and syntax.
     * @throws InternalServerErrorException
     *         The service encountered an unexpected condition and can't fulfill your request.
     * @throws ForbiddenException
     *         You don't have permissions for this action with the credentials you sent.
     * @throws NotFoundException
     *         The resource you requested doesn't exist.
     * @throws TooManyRequestsException
     *         Too many requests have been sent in too short of a time. The service limits the rate at which it will
     *         accept requests.
     * @throws ConflictException
     *         The service couldn't complete your request because there is a conflict with the current state of the
     *         resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConvertException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConvertClient.ListJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconvert-2017-08-29/ListJobs" target="_top">AWS API
     *      Documentation</a>
     */
    default ListJobsIterable listJobsPaginator(Consumer<ListJobsRequest.Builder> listJobsRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, NotFoundException, TooManyRequestsException, ConflictException,
            AwsServiceException, SdkClientException, MediaConvertException {
        return listJobsPaginator(ListJobsRequest.builder().applyMutation(listJobsRequest).build());
    }

    /**
     * Retrieve a JSON array of up to twenty of your presets. This will return the presets themselves, not just a list
     * of them. To retrieve the next twenty presets, use the nextToken string returned with the array.
     *
     * @param listPresetsRequest
     * @return Result of the ListPresets operation returned by the service.
     * @throws BadRequestException
     *         The service can't process your request because of a problem in the request. Please check your request
     *         form and syntax.
     * @throws InternalServerErrorException
     *         The service encountered an unexpected condition and can't fulfill your request.
     * @throws ForbiddenException
     *         You don't have permissions for this action with the credentials you sent.
     * @throws NotFoundException
     *         The resource you requested doesn't exist.
     * @throws TooManyRequestsException
     *         Too many requests have been sent in too short of a time. The service limits the rate at which it will
     *         accept requests.
     * @throws ConflictException
     *         The service couldn't complete your request because there is a conflict with the current state of the
     *         resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConvertException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConvertClient.ListPresets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconvert-2017-08-29/ListPresets" target="_top">AWS API
     *      Documentation</a>
     */
    default ListPresetsResponse listPresets(ListPresetsRequest listPresetsRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, NotFoundException, TooManyRequestsException, ConflictException,
            AwsServiceException, SdkClientException, MediaConvertException {
        throw new UnsupportedOperationException();
    }

    /**
     * Retrieve a JSON array of up to twenty of your presets. This will return the presets themselves, not just a list
     * of them. To retrieve the next twenty presets, use the nextToken string returned with the array.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListPresetsRequest.Builder} avoiding the need to
     * create one manually via {@link ListPresetsRequest#builder()}
     * </p>
     *
     * @param listPresetsRequest
     *        A {@link Consumer} that will call methods on {@link ListPresetsRequest.Builder} to create a request.
     * @return Result of the ListPresets operation returned by the service.
     * @throws BadRequestException
     *         The service can't process your request because of a problem in the request. Please check your request
     *         form and syntax.
     * @throws InternalServerErrorException
     *         The service encountered an unexpected condition and can't fulfill your request.
     * @throws ForbiddenException
     *         You don't have permissions for this action with the credentials you sent.
     * @throws NotFoundException
     *         The resource you requested doesn't exist.
     * @throws TooManyRequestsException
     *         Too many requests have been sent in too short of a time. The service limits the rate at which it will
     *         accept requests.
     * @throws ConflictException
     *         The service couldn't complete your request because there is a conflict with the current state of the
     *         resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConvertException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConvertClient.ListPresets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconvert-2017-08-29/ListPresets" target="_top">AWS API
     *      Documentation</a>
     */
    default ListPresetsResponse listPresets(Consumer<ListPresetsRequest.Builder> listPresetsRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, NotFoundException, TooManyRequestsException, ConflictException,
            AwsServiceException, SdkClientException, MediaConvertException {
        return listPresets(ListPresetsRequest.builder().applyMutation(listPresetsRequest).build());
    }

    /**
     * Retrieve a JSON array of up to twenty of your presets. This will return the presets themselves, not just a list
     * of them. To retrieve the next twenty presets, use the nextToken string returned with the array.<br/>
     * <p>
     * This is a variant of {@link #listPresets(software.amazon.awssdk.services.mediaconvert.model.ListPresetsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mediaconvert.paginators.ListPresetsIterable responses = client.listPresetsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.mediaconvert.paginators.ListPresetsIterable responses = client.listPresetsPaginator(request);
     *     for (software.amazon.awssdk.services.mediaconvert.model.ListPresetsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mediaconvert.paginators.ListPresetsIterable responses = client.listPresetsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPresets(software.amazon.awssdk.services.mediaconvert.model.ListPresetsRequest)} operation.</b>
     * </p>
     *
     * @param listPresetsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws BadRequestException
     *         The service can't process your request because of a problem in the request. Please check your request
     *         form and syntax.
     * @throws InternalServerErrorException
     *         The service encountered an unexpected condition and can't fulfill your request.
     * @throws ForbiddenException
     *         You don't have permissions for this action with the credentials you sent.
     * @throws NotFoundException
     *         The resource you requested doesn't exist.
     * @throws TooManyRequestsException
     *         Too many requests have been sent in too short of a time. The service limits the rate at which it will
     *         accept requests.
     * @throws ConflictException
     *         The service couldn't complete your request because there is a conflict with the current state of the
     *         resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConvertException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConvertClient.ListPresets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconvert-2017-08-29/ListPresets" target="_top">AWS API
     *      Documentation</a>
     */
    default ListPresetsIterable listPresetsPaginator(ListPresetsRequest listPresetsRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, NotFoundException, TooManyRequestsException, ConflictException,
            AwsServiceException, SdkClientException, MediaConvertException {
        return new ListPresetsIterable(this, listPresetsRequest);
    }

    /**
     * Retrieve a JSON array of up to twenty of your presets. This will return the presets themselves, not just a list
     * of them. To retrieve the next twenty presets, use the nextToken string returned with the array.<br/>
     * <p>
     * This is a variant of {@link #listPresets(software.amazon.awssdk.services.mediaconvert.model.ListPresetsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mediaconvert.paginators.ListPresetsIterable responses = client.listPresetsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.mediaconvert.paginators.ListPresetsIterable responses = client.listPresetsPaginator(request);
     *     for (software.amazon.awssdk.services.mediaconvert.model.ListPresetsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mediaconvert.paginators.ListPresetsIterable responses = client.listPresetsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPresets(software.amazon.awssdk.services.mediaconvert.model.ListPresetsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListPresetsRequest.Builder} avoiding the need to
     * create one manually via {@link ListPresetsRequest#builder()}
     * </p>
     *
     * @param listPresetsRequest
     *        A {@link Consumer} that will call methods on {@link ListPresetsRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws BadRequestException
     *         The service can't process your request because of a problem in the request. Please check your request
     *         form and syntax.
     * @throws InternalServerErrorException
     *         The service encountered an unexpected condition and can't fulfill your request.
     * @throws ForbiddenException
     *         You don't have permissions for this action with the credentials you sent.
     * @throws NotFoundException
     *         The resource you requested doesn't exist.
     * @throws TooManyRequestsException
     *         Too many requests have been sent in too short of a time. The service limits the rate at which it will
     *         accept requests.
     * @throws ConflictException
     *         The service couldn't complete your request because there is a conflict with the current state of the
     *         resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConvertException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConvertClient.ListPresets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconvert-2017-08-29/ListPresets" target="_top">AWS API
     *      Documentation</a>
     */
    default ListPresetsIterable listPresetsPaginator(Consumer<ListPresetsRequest.Builder> listPresetsRequest)
            throws BadRequestException, InternalServerErrorException, ForbiddenException, NotFoundException,
            TooManyRequestsException, ConflictException, AwsServiceException, SdkClientException, MediaConvertException {
        return listPresetsPaginator(ListPresetsRequest.builder().applyMutation(listPresetsRequest).build());
    }

    /**
     * Retrieve a JSON array of up to twenty of your queues. This will return the queues themselves, not just a list of
     * them. To retrieve the next twenty queues, use the nextToken string returned with the array.
     *
     * @param listQueuesRequest
     * @return Result of the ListQueues operation returned by the service.
     * @throws BadRequestException
     *         The service can't process your request because of a problem in the request. Please check your request
     *         form and syntax.
     * @throws InternalServerErrorException
     *         The service encountered an unexpected condition and can't fulfill your request.
     * @throws ForbiddenException
     *         You don't have permissions for this action with the credentials you sent.
     * @throws NotFoundException
     *         The resource you requested doesn't exist.
     * @throws TooManyRequestsException
     *         Too many requests have been sent in too short of a time. The service limits the rate at which it will
     *         accept requests.
     * @throws ConflictException
     *         The service couldn't complete your request because there is a conflict with the current state of the
     *         resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConvertException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConvertClient.ListQueues
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconvert-2017-08-29/ListQueues" target="_top">AWS API
     *      Documentation</a>
     */
    default ListQueuesResponse listQueues(ListQueuesRequest listQueuesRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, NotFoundException, TooManyRequestsException, ConflictException,
            AwsServiceException, SdkClientException, MediaConvertException {
        throw new UnsupportedOperationException();
    }

    /**
     * Retrieve a JSON array of up to twenty of your queues. This will return the queues themselves, not just a list of
     * them. To retrieve the next twenty queues, use the nextToken string returned with the array.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListQueuesRequest.Builder} avoiding the need to
     * create one manually via {@link ListQueuesRequest#builder()}
     * </p>
     *
     * @param listQueuesRequest
     *        A {@link Consumer} that will call methods on {@link ListQueuesRequest.Builder} to create a request.
     * @return Result of the ListQueues operation returned by the service.
     * @throws BadRequestException
     *         The service can't process your request because of a problem in the request. Please check your request
     *         form and syntax.
     * @throws InternalServerErrorException
     *         The service encountered an unexpected condition and can't fulfill your request.
     * @throws ForbiddenException
     *         You don't have permissions for this action with the credentials you sent.
     * @throws NotFoundException
     *         The resource you requested doesn't exist.
     * @throws TooManyRequestsException
     *         Too many requests have been sent in too short of a time. The service limits the rate at which it will
     *         accept requests.
     * @throws ConflictException
     *         The service couldn't complete your request because there is a conflict with the current state of the
     *         resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConvertException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConvertClient.ListQueues
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconvert-2017-08-29/ListQueues" target="_top">AWS API
     *      Documentation</a>
     */
    default ListQueuesResponse listQueues(Consumer<ListQueuesRequest.Builder> listQueuesRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, NotFoundException, TooManyRequestsException, ConflictException,
            AwsServiceException, SdkClientException, MediaConvertException {
        return listQueues(ListQueuesRequest.builder().applyMutation(listQueuesRequest).build());
    }

    /**
     * Retrieve a JSON array of up to twenty of your queues. This will return the queues themselves, not just a list of
     * them. To retrieve the next twenty queues, use the nextToken string returned with the array.<br/>
     * <p>
     * This is a variant of {@link #listQueues(software.amazon.awssdk.services.mediaconvert.model.ListQueuesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mediaconvert.paginators.ListQueuesIterable responses = client.listQueuesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.mediaconvert.paginators.ListQueuesIterable responses = client.listQueuesPaginator(request);
     *     for (software.amazon.awssdk.services.mediaconvert.model.ListQueuesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mediaconvert.paginators.ListQueuesIterable responses = client.listQueuesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listQueues(software.amazon.awssdk.services.mediaconvert.model.ListQueuesRequest)} operation.</b>
     * </p>
     *
     * @param listQueuesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws BadRequestException
     *         The service can't process your request because of a problem in the request. Please check your request
     *         form and syntax.
     * @throws InternalServerErrorException
     *         The service encountered an unexpected condition and can't fulfill your request.
     * @throws ForbiddenException
     *         You don't have permissions for this action with the credentials you sent.
     * @throws NotFoundException
     *         The resource you requested doesn't exist.
     * @throws TooManyRequestsException
     *         Too many requests have been sent in too short of a time. The service limits the rate at which it will
     *         accept requests.
     * @throws ConflictException
     *         The service couldn't complete your request because there is a conflict with the current state of the
     *         resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConvertException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConvertClient.ListQueues
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconvert-2017-08-29/ListQueues" target="_top">AWS API
     *      Documentation</a>
     */
    default ListQueuesIterable listQueuesPaginator(ListQueuesRequest listQueuesRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, NotFoundException, TooManyRequestsException, ConflictException,
            AwsServiceException, SdkClientException, MediaConvertException {
        return new ListQueuesIterable(this, listQueuesRequest);
    }

    /**
     * Retrieve a JSON array of up to twenty of your queues. This will return the queues themselves, not just a list of
     * them. To retrieve the next twenty queues, use the nextToken string returned with the array.<br/>
     * <p>
     * This is a variant of {@link #listQueues(software.amazon.awssdk.services.mediaconvert.model.ListQueuesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mediaconvert.paginators.ListQueuesIterable responses = client.listQueuesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.mediaconvert.paginators.ListQueuesIterable responses = client.listQueuesPaginator(request);
     *     for (software.amazon.awssdk.services.mediaconvert.model.ListQueuesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mediaconvert.paginators.ListQueuesIterable responses = client.listQueuesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listQueues(software.amazon.awssdk.services.mediaconvert.model.ListQueuesRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListQueuesRequest.Builder} avoiding the need to
     * create one manually via {@link ListQueuesRequest#builder()}
     * </p>
     *
     * @param listQueuesRequest
     *        A {@link Consumer} that will call methods on {@link ListQueuesRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws BadRequestException
     *         The service can't process your request because of a problem in the request. Please check your request
     *         form and syntax.
     * @throws InternalServerErrorException
     *         The service encountered an unexpected condition and can't fulfill your request.
     * @throws ForbiddenException
     *         You don't have permissions for this action with the credentials you sent.
     * @throws NotFoundException
     *         The resource you requested doesn't exist.
     * @throws TooManyRequestsException
     *         Too many requests have been sent in too short of a time. The service limits the rate at which it will
     *         accept requests.
     * @throws ConflictException
     *         The service couldn't complete your request because there is a conflict with the current state of the
     *         resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConvertException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConvertClient.ListQueues
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconvert-2017-08-29/ListQueues" target="_top">AWS API
     *      Documentation</a>
     */
    default ListQueuesIterable listQueuesPaginator(Consumer<ListQueuesRequest.Builder> listQueuesRequest)
            throws BadRequestException, InternalServerErrorException, ForbiddenException, NotFoundException,
            TooManyRequestsException, ConflictException, AwsServiceException, SdkClientException, MediaConvertException {
        return listQueuesPaginator(ListQueuesRequest.builder().applyMutation(listQueuesRequest).build());
    }

    /**
     * Retrieve the tags for a MediaConvert resource.
     *
     * @param listTagsForResourceRequest
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws BadRequestException
     *         The service can't process your request because of a problem in the request. Please check your request
     *         form and syntax.
     * @throws InternalServerErrorException
     *         The service encountered an unexpected condition and can't fulfill your request.
     * @throws ForbiddenException
     *         You don't have permissions for this action with the credentials you sent.
     * @throws NotFoundException
     *         The resource you requested doesn't exist.
     * @throws TooManyRequestsException
     *         Too many requests have been sent in too short of a time. The service limits the rate at which it will
     *         accept requests.
     * @throws ConflictException
     *         The service couldn't complete your request because there is a conflict with the current state of the
     *         resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConvertException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConvertClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconvert-2017-08-29/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest)
            throws BadRequestException, InternalServerErrorException, ForbiddenException, NotFoundException,
            TooManyRequestsException, ConflictException, AwsServiceException, SdkClientException, MediaConvertException {
        throw new UnsupportedOperationException();
    }

    /**
     * Retrieve the tags for a MediaConvert resource.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on {@link ListTagsForResourceRequest.Builder} to create a
     *        request.
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws BadRequestException
     *         The service can't process your request because of a problem in the request. Please check your request
     *         form and syntax.
     * @throws InternalServerErrorException
     *         The service encountered an unexpected condition and can't fulfill your request.
     * @throws ForbiddenException
     *         You don't have permissions for this action with the credentials you sent.
     * @throws NotFoundException
     *         The resource you requested doesn't exist.
     * @throws TooManyRequestsException
     *         Too many requests have been sent in too short of a time. The service limits the rate at which it will
     *         accept requests.
     * @throws ConflictException
     *         The service couldn't complete your request because there is a conflict with the current state of the
     *         resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConvertException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConvertClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconvert-2017-08-29/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, NotFoundException, TooManyRequestsException, ConflictException,
            AwsServiceException, SdkClientException, MediaConvertException {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * Create or change your policy. For more information about policies, see the user guide at
     * http://docs.aws.amazon.com/mediaconvert/latest/ug/what-is.html
     *
     * @param putPolicyRequest
     * @return Result of the PutPolicy operation returned by the service.
     * @throws BadRequestException
     *         The service can't process your request because of a problem in the request. Please check your request
     *         form and syntax.
     * @throws InternalServerErrorException
     *         The service encountered an unexpected condition and can't fulfill your request.
     * @throws ForbiddenException
     *         You don't have permissions for this action with the credentials you sent.
     * @throws NotFoundException
     *         The resource you requested doesn't exist.
     * @throws TooManyRequestsException
     *         Too many requests have been sent in too short of a time. The service limits the rate at which it will
     *         accept requests.
     * @throws ConflictException
     *         The service couldn't complete your request because there is a conflict with the current state of the
     *         resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConvertException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConvertClient.PutPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconvert-2017-08-29/PutPolicy" target="_top">AWS API
     *      Documentation</a>
     */
    default PutPolicyResponse putPolicy(PutPolicyRequest putPolicyRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, NotFoundException, TooManyRequestsException, ConflictException,
            AwsServiceException, SdkClientException, MediaConvertException {
        throw new UnsupportedOperationException();
    }

    /**
     * Create or change your policy. For more information about policies, see the user guide at
     * http://docs.aws.amazon.com/mediaconvert/latest/ug/what-is.html<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutPolicyRequest.Builder} avoiding the need to
     * create one manually via {@link PutPolicyRequest#builder()}
     * </p>
     *
     * @param putPolicyRequest
     *        A {@link Consumer} that will call methods on {@link PutPolicyRequest.Builder} to create a request.
     * @return Result of the PutPolicy operation returned by the service.
     * @throws BadRequestException
     *         The service can't process your request because of a problem in the request. Please check your request
     *         form and syntax.
     * @throws InternalServerErrorException
     *         The service encountered an unexpected condition and can't fulfill your request.
     * @throws ForbiddenException
     *         You don't have permissions for this action with the credentials you sent.
     * @throws NotFoundException
     *         The resource you requested doesn't exist.
     * @throws TooManyRequestsException
     *         Too many requests have been sent in too short of a time. The service limits the rate at which it will
     *         accept requests.
     * @throws ConflictException
     *         The service couldn't complete your request because there is a conflict with the current state of the
     *         resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConvertException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConvertClient.PutPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconvert-2017-08-29/PutPolicy" target="_top">AWS API
     *      Documentation</a>
     */
    default PutPolicyResponse putPolicy(Consumer<PutPolicyRequest.Builder> putPolicyRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, NotFoundException, TooManyRequestsException, ConflictException,
            AwsServiceException, SdkClientException, MediaConvertException {
        return putPolicy(PutPolicyRequest.builder().applyMutation(putPolicyRequest).build());
    }

    /**
     * Add tags to a MediaConvert queue, preset, or job template. For information about tagging, see the User Guide at
     * https://docs.aws.amazon.com/mediaconvert/latest/ug/tagging-resources.html
     *
     * @param tagResourceRequest
     * @return Result of the TagResource operation returned by the service.
     * @throws BadRequestException
     *         The service can't process your request because of a problem in the request. Please check your request
     *         form and syntax.
     * @throws InternalServerErrorException
     *         The service encountered an unexpected condition and can't fulfill your request.
     * @throws ForbiddenException
     *         You don't have permissions for this action with the credentials you sent.
     * @throws NotFoundException
     *         The resource you requested doesn't exist.
     * @throws TooManyRequestsException
     *         Too many requests have been sent in too short of a time. The service limits the rate at which it will
     *         accept requests.
     * @throws ConflictException
     *         The service couldn't complete your request because there is a conflict with the current state of the
     *         resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConvertException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConvertClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconvert-2017-08-29/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, NotFoundException, TooManyRequestsException, ConflictException,
            AwsServiceException, SdkClientException, MediaConvertException {
        throw new UnsupportedOperationException();
    }

    /**
     * Add tags to a MediaConvert queue, preset, or job template. For information about tagging, see the User Guide at
     * https://docs.aws.amazon.com/mediaconvert/latest/ug/tagging-resources.html<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on {@link TagResourceRequest.Builder} to create a request.
     * @return Result of the TagResource operation returned by the service.
     * @throws BadRequestException
     *         The service can't process your request because of a problem in the request. Please check your request
     *         form and syntax.
     * @throws InternalServerErrorException
     *         The service encountered an unexpected condition and can't fulfill your request.
     * @throws ForbiddenException
     *         You don't have permissions for this action with the credentials you sent.
     * @throws NotFoundException
     *         The resource you requested doesn't exist.
     * @throws TooManyRequestsException
     *         Too many requests have been sent in too short of a time. The service limits the rate at which it will
     *         accept requests.
     * @throws ConflictException
     *         The service couldn't complete your request because there is a conflict with the current state of the
     *         resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConvertException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConvertClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconvert-2017-08-29/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default TagResourceResponse tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, NotFoundException, TooManyRequestsException, ConflictException,
            AwsServiceException, SdkClientException, MediaConvertException {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * Remove tags from a MediaConvert queue, preset, or job template. For information about tagging, see the User Guide
     * at https://docs.aws.amazon.com/mediaconvert/latest/ug/tagging-resources.html
     *
     * @param untagResourceRequest
     * @return Result of the UntagResource operation returned by the service.
     * @throws BadRequestException
     *         The service can't process your request because of a problem in the request. Please check your request
     *         form and syntax.
     * @throws InternalServerErrorException
     *         The service encountered an unexpected condition and can't fulfill your request.
     * @throws ForbiddenException
     *         You don't have permissions for this action with the credentials you sent.
     * @throws NotFoundException
     *         The resource you requested doesn't exist.
     * @throws TooManyRequestsException
     *         Too many requests have been sent in too short of a time. The service limits the rate at which it will
     *         accept requests.
     * @throws ConflictException
     *         The service couldn't complete your request because there is a conflict with the current state of the
     *         resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConvertException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConvertClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconvert-2017-08-29/UntagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, NotFoundException, TooManyRequestsException, ConflictException,
            AwsServiceException, SdkClientException, MediaConvertException {
        throw new UnsupportedOperationException();
    }

    /**
     * Remove tags from a MediaConvert queue, preset, or job template. For information about tagging, see the User Guide
     * at https://docs.aws.amazon.com/mediaconvert/latest/ug/tagging-resources.html<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on {@link UntagResourceRequest.Builder} to create a request.
     * @return Result of the UntagResource operation returned by the service.
     * @throws BadRequestException
     *         The service can't process your request because of a problem in the request. Please check your request
     *         form and syntax.
     * @throws InternalServerErrorException
     *         The service encountered an unexpected condition and can't fulfill your request.
     * @throws ForbiddenException
     *         You don't have permissions for this action with the credentials you sent.
     * @throws NotFoundException
     *         The resource you requested doesn't exist.
     * @throws TooManyRequestsException
     *         Too many requests have been sent in too short of a time. The service limits the rate at which it will
     *         accept requests.
     * @throws ConflictException
     *         The service couldn't complete your request because there is a conflict with the current state of the
     *         resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConvertException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConvertClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconvert-2017-08-29/UntagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default UntagResourceResponse untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest)
            throws BadRequestException, InternalServerErrorException, ForbiddenException, NotFoundException,
            TooManyRequestsException, ConflictException, AwsServiceException, SdkClientException, MediaConvertException {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * Modify one of your existing job templates.
     *
     * @param updateJobTemplateRequest
     * @return Result of the UpdateJobTemplate operation returned by the service.
     * @throws BadRequestException
     *         The service can't process your request because of a problem in the request. Please check your request
     *         form and syntax.
     * @throws InternalServerErrorException
     *         The service encountered an unexpected condition and can't fulfill your request.
     * @throws ForbiddenException
     *         You don't have permissions for this action with the credentials you sent.
     * @throws NotFoundException
     *         The resource you requested doesn't exist.
     * @throws TooManyRequestsException
     *         Too many requests have been sent in too short of a time. The service limits the rate at which it will
     *         accept requests.
     * @throws ConflictException
     *         The service couldn't complete your request because there is a conflict with the current state of the
     *         resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConvertException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConvertClient.UpdateJobTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconvert-2017-08-29/UpdateJobTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateJobTemplateResponse updateJobTemplate(UpdateJobTemplateRequest updateJobTemplateRequest)
            throws BadRequestException, InternalServerErrorException, ForbiddenException, NotFoundException,
            TooManyRequestsException, ConflictException, AwsServiceException, SdkClientException, MediaConvertException {
        throw new UnsupportedOperationException();
    }

    /**
     * Modify one of your existing job templates.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateJobTemplateRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateJobTemplateRequest#builder()}
     * </p>
     *
     * @param updateJobTemplateRequest
     *        A {@link Consumer} that will call methods on {@link UpdateJobTemplateRequest.Builder} to create a request.
     * @return Result of the UpdateJobTemplate operation returned by the service.
     * @throws BadRequestException
     *         The service can't process your request because of a problem in the request. Please check your request
     *         form and syntax.
     * @throws InternalServerErrorException
     *         The service encountered an unexpected condition and can't fulfill your request.
     * @throws ForbiddenException
     *         You don't have permissions for this action with the credentials you sent.
     * @throws NotFoundException
     *         The resource you requested doesn't exist.
     * @throws TooManyRequestsException
     *         Too many requests have been sent in too short of a time. The service limits the rate at which it will
     *         accept requests.
     * @throws ConflictException
     *         The service couldn't complete your request because there is a conflict with the current state of the
     *         resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConvertException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConvertClient.UpdateJobTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconvert-2017-08-29/UpdateJobTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateJobTemplateResponse updateJobTemplate(Consumer<UpdateJobTemplateRequest.Builder> updateJobTemplateRequest)
            throws BadRequestException, InternalServerErrorException, ForbiddenException, NotFoundException,
            TooManyRequestsException, ConflictException, AwsServiceException, SdkClientException, MediaConvertException {
        return updateJobTemplate(UpdateJobTemplateRequest.builder().applyMutation(updateJobTemplateRequest).build());
    }

    /**
     * Modify one of your existing presets.
     *
     * @param updatePresetRequest
     * @return Result of the UpdatePreset operation returned by the service.
     * @throws BadRequestException
     *         The service can't process your request because of a problem in the request. Please check your request
     *         form and syntax.
     * @throws InternalServerErrorException
     *         The service encountered an unexpected condition and can't fulfill your request.
     * @throws ForbiddenException
     *         You don't have permissions for this action with the credentials you sent.
     * @throws NotFoundException
     *         The resource you requested doesn't exist.
     * @throws TooManyRequestsException
     *         Too many requests have been sent in too short of a time. The service limits the rate at which it will
     *         accept requests.
     * @throws ConflictException
     *         The service couldn't complete your request because there is a conflict with the current state of the
     *         resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConvertException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConvertClient.UpdatePreset
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconvert-2017-08-29/UpdatePreset" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdatePresetResponse updatePreset(UpdatePresetRequest updatePresetRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, NotFoundException, TooManyRequestsException, ConflictException,
            AwsServiceException, SdkClientException, MediaConvertException {
        throw new UnsupportedOperationException();
    }

    /**
     * Modify one of your existing presets.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdatePresetRequest.Builder} avoiding the need to
     * create one manually via {@link UpdatePresetRequest#builder()}
     * </p>
     *
     * @param updatePresetRequest
     *        A {@link Consumer} that will call methods on {@link UpdatePresetRequest.Builder} to create a request.
     * @return Result of the UpdatePreset operation returned by the service.
     * @throws BadRequestException
     *         The service can't process your request because of a problem in the request. Please check your request
     *         form and syntax.
     * @throws InternalServerErrorException
     *         The service encountered an unexpected condition and can't fulfill your request.
     * @throws ForbiddenException
     *         You don't have permissions for this action with the credentials you sent.
     * @throws NotFoundException
     *         The resource you requested doesn't exist.
     * @throws TooManyRequestsException
     *         Too many requests have been sent in too short of a time. The service limits the rate at which it will
     *         accept requests.
     * @throws ConflictException
     *         The service couldn't complete your request because there is a conflict with the current state of the
     *         resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConvertException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConvertClient.UpdatePreset
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconvert-2017-08-29/UpdatePreset" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdatePresetResponse updatePreset(Consumer<UpdatePresetRequest.Builder> updatePresetRequest)
            throws BadRequestException, InternalServerErrorException, ForbiddenException, NotFoundException,
            TooManyRequestsException, ConflictException, AwsServiceException, SdkClientException, MediaConvertException {
        return updatePreset(UpdatePresetRequest.builder().applyMutation(updatePresetRequest).build());
    }

    /**
     * Modify one of your existing queues.
     *
     * @param updateQueueRequest
     * @return Result of the UpdateQueue operation returned by the service.
     * @throws BadRequestException
     *         The service can't process your request because of a problem in the request. Please check your request
     *         form and syntax.
     * @throws InternalServerErrorException
     *         The service encountered an unexpected condition and can't fulfill your request.
     * @throws ForbiddenException
     *         You don't have permissions for this action with the credentials you sent.
     * @throws NotFoundException
     *         The resource you requested doesn't exist.
     * @throws TooManyRequestsException
     *         Too many requests have been sent in too short of a time. The service limits the rate at which it will
     *         accept requests.
     * @throws ConflictException
     *         The service couldn't complete your request because there is a conflict with the current state of the
     *         resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConvertException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConvertClient.UpdateQueue
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconvert-2017-08-29/UpdateQueue" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateQueueResponse updateQueue(UpdateQueueRequest updateQueueRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, NotFoundException, TooManyRequestsException, ConflictException,
            AwsServiceException, SdkClientException, MediaConvertException {
        throw new UnsupportedOperationException();
    }

    /**
     * Modify one of your existing queues.<br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateQueueRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateQueueRequest#builder()}
     * </p>
     *
     * @param updateQueueRequest
     *        A {@link Consumer} that will call methods on {@link UpdateQueueRequest.Builder} to create a request.
     * @return Result of the UpdateQueue operation returned by the service.
     * @throws BadRequestException
     *         The service can't process your request because of a problem in the request. Please check your request
     *         form and syntax.
     * @throws InternalServerErrorException
     *         The service encountered an unexpected condition and can't fulfill your request.
     * @throws ForbiddenException
     *         You don't have permissions for this action with the credentials you sent.
     * @throws NotFoundException
     *         The resource you requested doesn't exist.
     * @throws TooManyRequestsException
     *         Too many requests have been sent in too short of a time. The service limits the rate at which it will
     *         accept requests.
     * @throws ConflictException
     *         The service couldn't complete your request because there is a conflict with the current state of the
     *         resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MediaConvertException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MediaConvertClient.UpdateQueue
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mediaconvert-2017-08-29/UpdateQueue" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateQueueResponse updateQueue(Consumer<UpdateQueueRequest.Builder> updateQueueRequest) throws BadRequestException,
            InternalServerErrorException, ForbiddenException, NotFoundException, TooManyRequestsException, ConflictException,
            AwsServiceException, SdkClientException, MediaConvertException {
        return updateQueue(UpdateQueueRequest.builder().applyMutation(updateQueueRequest).build());
    }

    /**
     * Create a {@link MediaConvertClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static MediaConvertClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link MediaConvertClient}.
     */
    static MediaConvertClientBuilder builder() {
        return new DefaultMediaConvertClientBuilder();
    }

    static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of(SERVICE_METADATA_ID);
    }

    @Override
    default MediaConvertServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }
}
