/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum InputPsiControl {
    IGNORE_PSI("IGNORE_PSI"),
    USE_PSI("USE_PSI"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, InputPsiControl> VALUE_MAP;
    private final String value;

    private InputPsiControl(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static InputPsiControl fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<InputPsiControl> knownValues() {
        EnumSet<InputPsiControl> knownValues = EnumSet.allOf(InputPsiControl.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(InputPsiControl.class, InputPsiControl::toString);
    }
}

