/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconvert.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * These settings relate to your MXF output container.
 */
@Generated("software.amazon.awssdk:codegen")
public final class MxfSettings implements SdkPojo, Serializable, ToCopyableBuilder<MxfSettings.Builder, MxfSettings> {
    private static final SdkField<String> AFD_SIGNALING_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AfdSignaling").getter(getter(MxfSettings::afdSignalingAsString)).setter(setter(Builder::afdSignaling))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("afdSignaling").build()).build();

    private static final SdkField<String> PROFILE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Profile")
            .getter(getter(MxfSettings::profileAsString)).setter(setter(Builder::profile))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("profile").build()).build();

    private static final SdkField<MxfXavcProfileSettings> XAVC_PROFILE_SETTINGS_FIELD = SdkField
            .<MxfXavcProfileSettings> builder(MarshallingType.SDK_POJO).memberName("XavcProfileSettings")
            .getter(getter(MxfSettings::xavcProfileSettings)).setter(setter(Builder::xavcProfileSettings))
            .constructor(MxfXavcProfileSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("xavcProfileSettings").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AFD_SIGNALING_FIELD,
            PROFILE_FIELD, XAVC_PROFILE_SETTINGS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String afdSignaling;

    private final String profile;

    private final MxfXavcProfileSettings xavcProfileSettings;

    private MxfSettings(BuilderImpl builder) {
        this.afdSignaling = builder.afdSignaling;
        this.profile = builder.profile;
        this.xavcProfileSettings = builder.xavcProfileSettings;
    }

    /**
     * Optional. When you have AFD signaling set up in your output video stream, use this setting to choose whether to
     * also include it in the MXF wrapper. Choose Don't copy (NO_COPY) to exclude AFD signaling from the MXF wrapper.
     * Choose Copy from video stream (COPY_FROM_VIDEO) to copy the AFD values from the video stream for this output to
     * the MXF wrapper. Regardless of which option you choose, the AFD values remain in the video stream. Related
     * settings: To set up your output to include or exclude AFD values, see AfdSignaling, under VideoDescription. On
     * the console, find AFD signaling under the output's video encoding settings.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #afdSignaling} will
     * return {@link MxfAfdSignaling#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #afdSignalingAsString}.
     * </p>
     * 
     * @return Optional. When you have AFD signaling set up in your output video stream, use this setting to choose
     *         whether to also include it in the MXF wrapper. Choose Don't copy (NO_COPY) to exclude AFD signaling from
     *         the MXF wrapper. Choose Copy from video stream (COPY_FROM_VIDEO) to copy the AFD values from the video
     *         stream for this output to the MXF wrapper. Regardless of which option you choose, the AFD values remain
     *         in the video stream. Related settings: To set up your output to include or exclude AFD values, see
     *         AfdSignaling, under VideoDescription. On the console, find AFD signaling under the output's video
     *         encoding settings.
     * @see MxfAfdSignaling
     */
    public final MxfAfdSignaling afdSignaling() {
        return MxfAfdSignaling.fromValue(afdSignaling);
    }

    /**
     * Optional. When you have AFD signaling set up in your output video stream, use this setting to choose whether to
     * also include it in the MXF wrapper. Choose Don't copy (NO_COPY) to exclude AFD signaling from the MXF wrapper.
     * Choose Copy from video stream (COPY_FROM_VIDEO) to copy the AFD values from the video stream for this output to
     * the MXF wrapper. Regardless of which option you choose, the AFD values remain in the video stream. Related
     * settings: To set up your output to include or exclude AFD values, see AfdSignaling, under VideoDescription. On
     * the console, find AFD signaling under the output's video encoding settings.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #afdSignaling} will
     * return {@link MxfAfdSignaling#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #afdSignalingAsString}.
     * </p>
     * 
     * @return Optional. When you have AFD signaling set up in your output video stream, use this setting to choose
     *         whether to also include it in the MXF wrapper. Choose Don't copy (NO_COPY) to exclude AFD signaling from
     *         the MXF wrapper. Choose Copy from video stream (COPY_FROM_VIDEO) to copy the AFD values from the video
     *         stream for this output to the MXF wrapper. Regardless of which option you choose, the AFD values remain
     *         in the video stream. Related settings: To set up your output to include or exclude AFD values, see
     *         AfdSignaling, under VideoDescription. On the console, find AFD signaling under the output's video
     *         encoding settings.
     * @see MxfAfdSignaling
     */
    public final String afdSignalingAsString() {
        return afdSignaling;
    }

    /**
     * Specify the MXF profile, also called shim, for this output. To automatically select a profile according to your
     * output video codec and resolution, leave blank. For a list of codecs supported with each MXF profile, see
     * https://docs.aws.amazon.com/mediaconvert/latest/ug/codecs-supported-with-each-mxf-profile.html. For more
     * information about the automatic selection behavior, see
     * https://docs.aws.amazon.com/mediaconvert/latest/ug/default-automatic-selection-of-mxf-profiles.html.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #profile} will
     * return {@link MxfProfile#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #profileAsString}.
     * </p>
     * 
     * @return Specify the MXF profile, also called shim, for this output. To automatically select a profile according
     *         to your output video codec and resolution, leave blank. For a list of codecs supported with each MXF
     *         profile, see
     *         https://docs.aws.amazon.com/mediaconvert/latest/ug/codecs-supported-with-each-mxf-profile.html. For more
     *         information about the automatic selection behavior, see
     *         https://docs.aws.amazon.com/mediaconvert/latest/ug/default-automatic-selection-of-mxf-profiles.html.
     * @see MxfProfile
     */
    public final MxfProfile profile() {
        return MxfProfile.fromValue(profile);
    }

    /**
     * Specify the MXF profile, also called shim, for this output. To automatically select a profile according to your
     * output video codec and resolution, leave blank. For a list of codecs supported with each MXF profile, see
     * https://docs.aws.amazon.com/mediaconvert/latest/ug/codecs-supported-with-each-mxf-profile.html. For more
     * information about the automatic selection behavior, see
     * https://docs.aws.amazon.com/mediaconvert/latest/ug/default-automatic-selection-of-mxf-profiles.html.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #profile} will
     * return {@link MxfProfile#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #profileAsString}.
     * </p>
     * 
     * @return Specify the MXF profile, also called shim, for this output. To automatically select a profile according
     *         to your output video codec and resolution, leave blank. For a list of codecs supported with each MXF
     *         profile, see
     *         https://docs.aws.amazon.com/mediaconvert/latest/ug/codecs-supported-with-each-mxf-profile.html. For more
     *         information about the automatic selection behavior, see
     *         https://docs.aws.amazon.com/mediaconvert/latest/ug/default-automatic-selection-of-mxf-profiles.html.
     * @see MxfProfile
     */
    public final String profileAsString() {
        return profile;
    }

    /**
     * Specify the XAVC profile settings for MXF outputs when you set your MXF profile to XAVC.
     * 
     * @return Specify the XAVC profile settings for MXF outputs when you set your MXF profile to XAVC.
     */
    public final MxfXavcProfileSettings xavcProfileSettings() {
        return xavcProfileSettings;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(afdSignalingAsString());
        hashCode = 31 * hashCode + Objects.hashCode(profileAsString());
        hashCode = 31 * hashCode + Objects.hashCode(xavcProfileSettings());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MxfSettings)) {
            return false;
        }
        MxfSettings other = (MxfSettings) obj;
        return Objects.equals(afdSignalingAsString(), other.afdSignalingAsString())
                && Objects.equals(profileAsString(), other.profileAsString())
                && Objects.equals(xavcProfileSettings(), other.xavcProfileSettings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MxfSettings").add("AfdSignaling", afdSignalingAsString()).add("Profile", profileAsString())
                .add("XavcProfileSettings", xavcProfileSettings()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AfdSignaling":
            return Optional.ofNullable(clazz.cast(afdSignalingAsString()));
        case "Profile":
            return Optional.ofNullable(clazz.cast(profileAsString()));
        case "XavcProfileSettings":
            return Optional.ofNullable(clazz.cast(xavcProfileSettings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MxfSettings, T> g) {
        return obj -> g.apply((MxfSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MxfSettings> {
        /**
         * Optional. When you have AFD signaling set up in your output video stream, use this setting to choose whether
         * to also include it in the MXF wrapper. Choose Don't copy (NO_COPY) to exclude AFD signaling from the MXF
         * wrapper. Choose Copy from video stream (COPY_FROM_VIDEO) to copy the AFD values from the video stream for
         * this output to the MXF wrapper. Regardless of which option you choose, the AFD values remain in the video
         * stream. Related settings: To set up your output to include or exclude AFD values, see AfdSignaling, under
         * VideoDescription. On the console, find AFD signaling under the output's video encoding settings.
         * 
         * @param afdSignaling
         *        Optional. When you have AFD signaling set up in your output video stream, use this setting to choose
         *        whether to also include it in the MXF wrapper. Choose Don't copy (NO_COPY) to exclude AFD signaling
         *        from the MXF wrapper. Choose Copy from video stream (COPY_FROM_VIDEO) to copy the AFD values from the
         *        video stream for this output to the MXF wrapper. Regardless of which option you choose, the AFD values
         *        remain in the video stream. Related settings: To set up your output to include or exclude AFD values,
         *        see AfdSignaling, under VideoDescription. On the console, find AFD signaling under the output's video
         *        encoding settings.
         * @see MxfAfdSignaling
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MxfAfdSignaling
         */
        Builder afdSignaling(String afdSignaling);

        /**
         * Optional. When you have AFD signaling set up in your output video stream, use this setting to choose whether
         * to also include it in the MXF wrapper. Choose Don't copy (NO_COPY) to exclude AFD signaling from the MXF
         * wrapper. Choose Copy from video stream (COPY_FROM_VIDEO) to copy the AFD values from the video stream for
         * this output to the MXF wrapper. Regardless of which option you choose, the AFD values remain in the video
         * stream. Related settings: To set up your output to include or exclude AFD values, see AfdSignaling, under
         * VideoDescription. On the console, find AFD signaling under the output's video encoding settings.
         * 
         * @param afdSignaling
         *        Optional. When you have AFD signaling set up in your output video stream, use this setting to choose
         *        whether to also include it in the MXF wrapper. Choose Don't copy (NO_COPY) to exclude AFD signaling
         *        from the MXF wrapper. Choose Copy from video stream (COPY_FROM_VIDEO) to copy the AFD values from the
         *        video stream for this output to the MXF wrapper. Regardless of which option you choose, the AFD values
         *        remain in the video stream. Related settings: To set up your output to include or exclude AFD values,
         *        see AfdSignaling, under VideoDescription. On the console, find AFD signaling under the output's video
         *        encoding settings.
         * @see MxfAfdSignaling
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MxfAfdSignaling
         */
        Builder afdSignaling(MxfAfdSignaling afdSignaling);

        /**
         * Specify the MXF profile, also called shim, for this output. To automatically select a profile according to
         * your output video codec and resolution, leave blank. For a list of codecs supported with each MXF profile,
         * see https://docs.aws.amazon.com/mediaconvert/latest/ug/codecs-supported-with-each-mxf-profile.html. For more
         * information about the automatic selection behavior, see
         * https://docs.aws.amazon.com/mediaconvert/latest/ug/default-automatic-selection-of-mxf-profiles.html.
         * 
         * @param profile
         *        Specify the MXF profile, also called shim, for this output. To automatically select a profile
         *        according to your output video codec and resolution, leave blank. For a list of codecs supported with
         *        each MXF profile, see
         *        https://docs.aws.amazon.com/mediaconvert/latest/ug/codecs-supported-with-each-mxf-profile.html. For
         *        more information about the automatic selection behavior, see
         *        https://docs.aws.amazon.com/mediaconvert/latest/ug/default-automatic-selection-of-mxf-profiles.html.
         * @see MxfProfile
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MxfProfile
         */
        Builder profile(String profile);

        /**
         * Specify the MXF profile, also called shim, for this output. To automatically select a profile according to
         * your output video codec and resolution, leave blank. For a list of codecs supported with each MXF profile,
         * see https://docs.aws.amazon.com/mediaconvert/latest/ug/codecs-supported-with-each-mxf-profile.html. For more
         * information about the automatic selection behavior, see
         * https://docs.aws.amazon.com/mediaconvert/latest/ug/default-automatic-selection-of-mxf-profiles.html.
         * 
         * @param profile
         *        Specify the MXF profile, also called shim, for this output. To automatically select a profile
         *        according to your output video codec and resolution, leave blank. For a list of codecs supported with
         *        each MXF profile, see
         *        https://docs.aws.amazon.com/mediaconvert/latest/ug/codecs-supported-with-each-mxf-profile.html. For
         *        more information about the automatic selection behavior, see
         *        https://docs.aws.amazon.com/mediaconvert/latest/ug/default-automatic-selection-of-mxf-profiles.html.
         * @see MxfProfile
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MxfProfile
         */
        Builder profile(MxfProfile profile);

        /**
         * Specify the XAVC profile settings for MXF outputs when you set your MXF profile to XAVC.
         * 
         * @param xavcProfileSettings
         *        Specify the XAVC profile settings for MXF outputs when you set your MXF profile to XAVC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder xavcProfileSettings(MxfXavcProfileSettings xavcProfileSettings);

        /**
         * Specify the XAVC profile settings for MXF outputs when you set your MXF profile to XAVC. This is a
         * convenience method that creates an instance of the {@link MxfXavcProfileSettings.Builder} avoiding the need
         * to create one manually via {@link MxfXavcProfileSettings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MxfXavcProfileSettings.Builder#build()} is called immediately and
         * its result is passed to {@link #xavcProfileSettings(MxfXavcProfileSettings)}.
         * 
         * @param xavcProfileSettings
         *        a consumer that will call methods on {@link MxfXavcProfileSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #xavcProfileSettings(MxfXavcProfileSettings)
         */
        default Builder xavcProfileSettings(Consumer<MxfXavcProfileSettings.Builder> xavcProfileSettings) {
            return xavcProfileSettings(MxfXavcProfileSettings.builder().applyMutation(xavcProfileSettings).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String afdSignaling;

        private String profile;

        private MxfXavcProfileSettings xavcProfileSettings;

        private BuilderImpl() {
        }

        private BuilderImpl(MxfSettings model) {
            afdSignaling(model.afdSignaling);
            profile(model.profile);
            xavcProfileSettings(model.xavcProfileSettings);
        }

        public final String getAfdSignaling() {
            return afdSignaling;
        }

        public final void setAfdSignaling(String afdSignaling) {
            this.afdSignaling = afdSignaling;
        }

        @Override
        public final Builder afdSignaling(String afdSignaling) {
            this.afdSignaling = afdSignaling;
            return this;
        }

        @Override
        public final Builder afdSignaling(MxfAfdSignaling afdSignaling) {
            this.afdSignaling(afdSignaling == null ? null : afdSignaling.toString());
            return this;
        }

        public final String getProfile() {
            return profile;
        }

        public final void setProfile(String profile) {
            this.profile = profile;
        }

        @Override
        public final Builder profile(String profile) {
            this.profile = profile;
            return this;
        }

        @Override
        public final Builder profile(MxfProfile profile) {
            this.profile(profile == null ? null : profile.toString());
            return this;
        }

        public final MxfXavcProfileSettings.Builder getXavcProfileSettings() {
            return xavcProfileSettings != null ? xavcProfileSettings.toBuilder() : null;
        }

        public final void setXavcProfileSettings(MxfXavcProfileSettings.BuilderImpl xavcProfileSettings) {
            this.xavcProfileSettings = xavcProfileSettings != null ? xavcProfileSettings.build() : null;
        }

        @Override
        public final Builder xavcProfileSettings(MxfXavcProfileSettings xavcProfileSettings) {
            this.xavcProfileSettings = xavcProfileSettings;
            return this;
        }

        @Override
        public MxfSettings build() {
            return new MxfSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
