/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconvert.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.internal.EnumUtils;

/**
 * Specify whether MediaConvert should use any dynamic range control metadata from your input file. Keep the default
 * value, Custom (SPECIFIED), to provide dynamic range control values in your job settings. Choose Follow source
 * (INITIALIZE_FROM_SOURCE) to use the metadata from your input. Related settings--Use these settings to specify your
 * dynamic range control values: Dynamic range compression line (DynamicRangeCompressionLine) and Dynamic range
 * compression RF (DynamicRangeCompressionRf). When you keep the value Custom (SPECIFIED) for Dynamic range control
 * (DynamicRangeControl) and you don't specify values for the related settings, MediaConvert uses default values for
 * those settings.
 */
@Generated("software.amazon.awssdk:codegen")
public enum Eac3AtmosDynamicRangeControl {
    SPECIFIED("SPECIFIED"),

    INITIALIZE_FROM_SOURCE("INITIALIZE_FROM_SOURCE"),

    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, Eac3AtmosDynamicRangeControl> VALUE_MAP = EnumUtils.uniqueIndex(
            Eac3AtmosDynamicRangeControl.class, Eac3AtmosDynamicRangeControl::toString);

    private final String value;

    private Eac3AtmosDynamicRangeControl(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return Eac3AtmosDynamicRangeControl corresponding to the value
     */
    public static Eac3AtmosDynamicRangeControl fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link Eac3AtmosDynamicRangeControl}s
     */
    public static Set<Eac3AtmosDynamicRangeControl> knownValues() {
        Set<Eac3AtmosDynamicRangeControl> knownValues = EnumSet.allOf(Eac3AtmosDynamicRangeControl.class);
        knownValues.remove(UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }
}
