/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.mediaconvert.model.CmafIntervalCadence;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CmafImageBasedTrickPlaySettings
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CmafImageBasedTrickPlaySettings> {
    private static final SdkField<String> INTERVAL_CADENCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IntervalCadence").getter(CmafImageBasedTrickPlaySettings.getter(CmafImageBasedTrickPlaySettings::intervalCadenceAsString)).setter(CmafImageBasedTrickPlaySettings.setter(Builder::intervalCadence)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("intervalCadence").build()}).build();
    private static final SdkField<Integer> THUMBNAIL_HEIGHT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ThumbnailHeight").getter(CmafImageBasedTrickPlaySettings.getter(CmafImageBasedTrickPlaySettings::thumbnailHeight)).setter(CmafImageBasedTrickPlaySettings.setter(Builder::thumbnailHeight)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("thumbnailHeight").build()}).build();
    private static final SdkField<Double> THUMBNAIL_INTERVAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("ThumbnailInterval").getter(CmafImageBasedTrickPlaySettings.getter(CmafImageBasedTrickPlaySettings::thumbnailInterval)).setter(CmafImageBasedTrickPlaySettings.setter(Builder::thumbnailInterval)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("thumbnailInterval").build()}).build();
    private static final SdkField<Integer> THUMBNAIL_WIDTH_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ThumbnailWidth").getter(CmafImageBasedTrickPlaySettings.getter(CmafImageBasedTrickPlaySettings::thumbnailWidth)).setter(CmafImageBasedTrickPlaySettings.setter(Builder::thumbnailWidth)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("thumbnailWidth").build()}).build();
    private static final SdkField<Integer> TILE_HEIGHT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("TileHeight").getter(CmafImageBasedTrickPlaySettings.getter(CmafImageBasedTrickPlaySettings::tileHeight)).setter(CmafImageBasedTrickPlaySettings.setter(Builder::tileHeight)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tileHeight").build()}).build();
    private static final SdkField<Integer> TILE_WIDTH_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("TileWidth").getter(CmafImageBasedTrickPlaySettings.getter(CmafImageBasedTrickPlaySettings::tileWidth)).setter(CmafImageBasedTrickPlaySettings.setter(Builder::tileWidth)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tileWidth").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INTERVAL_CADENCE_FIELD, THUMBNAIL_HEIGHT_FIELD, THUMBNAIL_INTERVAL_FIELD, THUMBNAIL_WIDTH_FIELD, TILE_HEIGHT_FIELD, TILE_WIDTH_FIELD));
    private static final long serialVersionUID = 1L;
    private final String intervalCadence;
    private final Integer thumbnailHeight;
    private final Double thumbnailInterval;
    private final Integer thumbnailWidth;
    private final Integer tileHeight;
    private final Integer tileWidth;

    private CmafImageBasedTrickPlaySettings(BuilderImpl builder) {
        this.intervalCadence = builder.intervalCadence;
        this.thumbnailHeight = builder.thumbnailHeight;
        this.thumbnailInterval = builder.thumbnailInterval;
        this.thumbnailWidth = builder.thumbnailWidth;
        this.tileHeight = builder.tileHeight;
        this.tileWidth = builder.tileWidth;
    }

    public final CmafIntervalCadence intervalCadence() {
        return CmafIntervalCadence.fromValue(this.intervalCadence);
    }

    public final String intervalCadenceAsString() {
        return this.intervalCadence;
    }

    public final Integer thumbnailHeight() {
        return this.thumbnailHeight;
    }

    public final Double thumbnailInterval() {
        return this.thumbnailInterval;
    }

    public final Integer thumbnailWidth() {
        return this.thumbnailWidth;
    }

    public final Integer tileHeight() {
        return this.tileHeight;
    }

    public final Integer tileWidth() {
        return this.tileWidth;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.intervalCadenceAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.thumbnailHeight());
        hashCode = 31 * hashCode + Objects.hashCode(this.thumbnailInterval());
        hashCode = 31 * hashCode + Objects.hashCode(this.thumbnailWidth());
        hashCode = 31 * hashCode + Objects.hashCode(this.tileHeight());
        hashCode = 31 * hashCode + Objects.hashCode(this.tileWidth());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CmafImageBasedTrickPlaySettings)) {
            return false;
        }
        CmafImageBasedTrickPlaySettings other = (CmafImageBasedTrickPlaySettings)obj;
        return Objects.equals(this.intervalCadenceAsString(), other.intervalCadenceAsString()) && Objects.equals(this.thumbnailHeight(), other.thumbnailHeight()) && Objects.equals(this.thumbnailInterval(), other.thumbnailInterval()) && Objects.equals(this.thumbnailWidth(), other.thumbnailWidth()) && Objects.equals(this.tileHeight(), other.tileHeight()) && Objects.equals(this.tileWidth(), other.tileWidth());
    }

    public final String toString() {
        return ToString.builder((String)"CmafImageBasedTrickPlaySettings").add("IntervalCadence", (Object)this.intervalCadenceAsString()).add("ThumbnailHeight", (Object)this.thumbnailHeight()).add("ThumbnailInterval", (Object)this.thumbnailInterval()).add("ThumbnailWidth", (Object)this.thumbnailWidth()).add("TileHeight", (Object)this.tileHeight()).add("TileWidth", (Object)this.tileWidth()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "IntervalCadence": {
                return Optional.ofNullable(clazz.cast(this.intervalCadenceAsString()));
            }
            case "ThumbnailHeight": {
                return Optional.ofNullable(clazz.cast(this.thumbnailHeight()));
            }
            case "ThumbnailInterval": {
                return Optional.ofNullable(clazz.cast(this.thumbnailInterval()));
            }
            case "ThumbnailWidth": {
                return Optional.ofNullable(clazz.cast(this.thumbnailWidth()));
            }
            case "TileHeight": {
                return Optional.ofNullable(clazz.cast(this.tileHeight()));
            }
            case "TileWidth": {
                return Optional.ofNullable(clazz.cast(this.tileWidth()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CmafImageBasedTrickPlaySettings, T> g) {
        return obj -> g.apply((CmafImageBasedTrickPlaySettings)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String intervalCadence;
        private Integer thumbnailHeight;
        private Double thumbnailInterval;
        private Integer thumbnailWidth;
        private Integer tileHeight;
        private Integer tileWidth;

        private BuilderImpl() {
        }

        private BuilderImpl(CmafImageBasedTrickPlaySettings model) {
            this.intervalCadence(model.intervalCadence);
            this.thumbnailHeight(model.thumbnailHeight);
            this.thumbnailInterval(model.thumbnailInterval);
            this.thumbnailWidth(model.thumbnailWidth);
            this.tileHeight(model.tileHeight);
            this.tileWidth(model.tileWidth);
        }

        public final String getIntervalCadence() {
            return this.intervalCadence;
        }

        public final void setIntervalCadence(String intervalCadence) {
            this.intervalCadence = intervalCadence;
        }

        @Override
        public final Builder intervalCadence(String intervalCadence) {
            this.intervalCadence = intervalCadence;
            return this;
        }

        @Override
        public final Builder intervalCadence(CmafIntervalCadence intervalCadence) {
            this.intervalCadence(intervalCadence == null ? null : intervalCadence.toString());
            return this;
        }

        public final Integer getThumbnailHeight() {
            return this.thumbnailHeight;
        }

        public final void setThumbnailHeight(Integer thumbnailHeight) {
            this.thumbnailHeight = thumbnailHeight;
        }

        @Override
        public final Builder thumbnailHeight(Integer thumbnailHeight) {
            this.thumbnailHeight = thumbnailHeight;
            return this;
        }

        public final Double getThumbnailInterval() {
            return this.thumbnailInterval;
        }

        public final void setThumbnailInterval(Double thumbnailInterval) {
            this.thumbnailInterval = thumbnailInterval;
        }

        @Override
        public final Builder thumbnailInterval(Double thumbnailInterval) {
            this.thumbnailInterval = thumbnailInterval;
            return this;
        }

        public final Integer getThumbnailWidth() {
            return this.thumbnailWidth;
        }

        public final void setThumbnailWidth(Integer thumbnailWidth) {
            this.thumbnailWidth = thumbnailWidth;
        }

        @Override
        public final Builder thumbnailWidth(Integer thumbnailWidth) {
            this.thumbnailWidth = thumbnailWidth;
            return this;
        }

        public final Integer getTileHeight() {
            return this.tileHeight;
        }

        public final void setTileHeight(Integer tileHeight) {
            this.tileHeight = tileHeight;
        }

        @Override
        public final Builder tileHeight(Integer tileHeight) {
            this.tileHeight = tileHeight;
            return this;
        }

        public final Integer getTileWidth() {
            return this.tileWidth;
        }

        public final void setTileWidth(Integer tileWidth) {
            this.tileWidth = tileWidth;
        }

        @Override
        public final Builder tileWidth(Integer tileWidth) {
            this.tileWidth = tileWidth;
            return this;
        }

        public CmafImageBasedTrickPlaySettings build() {
            return new CmafImageBasedTrickPlaySettings(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CmafImageBasedTrickPlaySettings> {
        public Builder intervalCadence(String var1);

        public Builder intervalCadence(CmafIntervalCadence var1);

        public Builder thumbnailHeight(Integer var1);

        public Builder thumbnailInterval(Double var1);

        public Builder thumbnailWidth(Integer var1);

        public Builder tileHeight(Integer var1);

        public Builder tileWidth(Integer var1);
    }
}

