/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.mediaconvert.model.XavcFlickerAdaptiveQuantization;
import software.amazon.awssdk.services.mediaconvert.model.XavcGopBReference;
import software.amazon.awssdk.services.mediaconvert.model.XavcHdProfileBitrateClass;
import software.amazon.awssdk.services.mediaconvert.model.XavcHdProfileQualityTuningLevel;
import software.amazon.awssdk.services.mediaconvert.model.XavcHdProfileTelecine;
import software.amazon.awssdk.services.mediaconvert.model.XavcInterlaceMode;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class XavcHdProfileSettings
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, XavcHdProfileSettings> {
    private static final SdkField<String> BITRATE_CLASS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BitrateClass").getter(XavcHdProfileSettings.getter(XavcHdProfileSettings::bitrateClassAsString)).setter(XavcHdProfileSettings.setter(Builder::bitrateClass)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bitrateClass").build()}).build();
    private static final SdkField<String> FLICKER_ADAPTIVE_QUANTIZATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FlickerAdaptiveQuantization").getter(XavcHdProfileSettings.getter(XavcHdProfileSettings::flickerAdaptiveQuantizationAsString)).setter(XavcHdProfileSettings.setter(Builder::flickerAdaptiveQuantization)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("flickerAdaptiveQuantization").build()}).build();
    private static final SdkField<String> GOP_B_REFERENCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GopBReference").getter(XavcHdProfileSettings.getter(XavcHdProfileSettings::gopBReferenceAsString)).setter(XavcHdProfileSettings.setter(Builder::gopBReference)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("gopBReference").build()}).build();
    private static final SdkField<Integer> GOP_CLOSED_CADENCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("GopClosedCadence").getter(XavcHdProfileSettings.getter(XavcHdProfileSettings::gopClosedCadence)).setter(XavcHdProfileSettings.setter(Builder::gopClosedCadence)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("gopClosedCadence").build()}).build();
    private static final SdkField<Integer> HRD_BUFFER_SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("HrdBufferSize").getter(XavcHdProfileSettings.getter(XavcHdProfileSettings::hrdBufferSize)).setter(XavcHdProfileSettings.setter(Builder::hrdBufferSize)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hrdBufferSize").build()}).build();
    private static final SdkField<String> INTERLACE_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InterlaceMode").getter(XavcHdProfileSettings.getter(XavcHdProfileSettings::interlaceModeAsString)).setter(XavcHdProfileSettings.setter(Builder::interlaceMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("interlaceMode").build()}).build();
    private static final SdkField<String> QUALITY_TUNING_LEVEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("QualityTuningLevel").getter(XavcHdProfileSettings.getter(XavcHdProfileSettings::qualityTuningLevelAsString)).setter(XavcHdProfileSettings.setter(Builder::qualityTuningLevel)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("qualityTuningLevel").build()}).build();
    private static final SdkField<Integer> SLICES_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Slices").getter(XavcHdProfileSettings.getter(XavcHdProfileSettings::slices)).setter(XavcHdProfileSettings.setter(Builder::slices)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("slices").build()}).build();
    private static final SdkField<String> TELECINE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Telecine").getter(XavcHdProfileSettings.getter(XavcHdProfileSettings::telecineAsString)).setter(XavcHdProfileSettings.setter(Builder::telecine)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("telecine").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BITRATE_CLASS_FIELD, FLICKER_ADAPTIVE_QUANTIZATION_FIELD, GOP_B_REFERENCE_FIELD, GOP_CLOSED_CADENCE_FIELD, HRD_BUFFER_SIZE_FIELD, INTERLACE_MODE_FIELD, QUALITY_TUNING_LEVEL_FIELD, SLICES_FIELD, TELECINE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String bitrateClass;
    private final String flickerAdaptiveQuantization;
    private final String gopBReference;
    private final Integer gopClosedCadence;
    private final Integer hrdBufferSize;
    private final String interlaceMode;
    private final String qualityTuningLevel;
    private final Integer slices;
    private final String telecine;

    private XavcHdProfileSettings(BuilderImpl builder) {
        this.bitrateClass = builder.bitrateClass;
        this.flickerAdaptiveQuantization = builder.flickerAdaptiveQuantization;
        this.gopBReference = builder.gopBReference;
        this.gopClosedCadence = builder.gopClosedCadence;
        this.hrdBufferSize = builder.hrdBufferSize;
        this.interlaceMode = builder.interlaceMode;
        this.qualityTuningLevel = builder.qualityTuningLevel;
        this.slices = builder.slices;
        this.telecine = builder.telecine;
    }

    public final XavcHdProfileBitrateClass bitrateClass() {
        return XavcHdProfileBitrateClass.fromValue(this.bitrateClass);
    }

    public final String bitrateClassAsString() {
        return this.bitrateClass;
    }

    public final XavcFlickerAdaptiveQuantization flickerAdaptiveQuantization() {
        return XavcFlickerAdaptiveQuantization.fromValue(this.flickerAdaptiveQuantization);
    }

    public final String flickerAdaptiveQuantizationAsString() {
        return this.flickerAdaptiveQuantization;
    }

    public final XavcGopBReference gopBReference() {
        return XavcGopBReference.fromValue(this.gopBReference);
    }

    public final String gopBReferenceAsString() {
        return this.gopBReference;
    }

    public final Integer gopClosedCadence() {
        return this.gopClosedCadence;
    }

    public final Integer hrdBufferSize() {
        return this.hrdBufferSize;
    }

    public final XavcInterlaceMode interlaceMode() {
        return XavcInterlaceMode.fromValue(this.interlaceMode);
    }

    public final String interlaceModeAsString() {
        return this.interlaceMode;
    }

    public final XavcHdProfileQualityTuningLevel qualityTuningLevel() {
        return XavcHdProfileQualityTuningLevel.fromValue(this.qualityTuningLevel);
    }

    public final String qualityTuningLevelAsString() {
        return this.qualityTuningLevel;
    }

    public final Integer slices() {
        return this.slices;
    }

    public final XavcHdProfileTelecine telecine() {
        return XavcHdProfileTelecine.fromValue(this.telecine);
    }

    public final String telecineAsString() {
        return this.telecine;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.bitrateClassAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.flickerAdaptiveQuantizationAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.gopBReferenceAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.gopClosedCadence());
        hashCode = 31 * hashCode + Objects.hashCode(this.hrdBufferSize());
        hashCode = 31 * hashCode + Objects.hashCode(this.interlaceModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.qualityTuningLevelAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.slices());
        hashCode = 31 * hashCode + Objects.hashCode(this.telecineAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof XavcHdProfileSettings)) {
            return false;
        }
        XavcHdProfileSettings other = (XavcHdProfileSettings)obj;
        return Objects.equals(this.bitrateClassAsString(), other.bitrateClassAsString()) && Objects.equals(this.flickerAdaptiveQuantizationAsString(), other.flickerAdaptiveQuantizationAsString()) && Objects.equals(this.gopBReferenceAsString(), other.gopBReferenceAsString()) && Objects.equals(this.gopClosedCadence(), other.gopClosedCadence()) && Objects.equals(this.hrdBufferSize(), other.hrdBufferSize()) && Objects.equals(this.interlaceModeAsString(), other.interlaceModeAsString()) && Objects.equals(this.qualityTuningLevelAsString(), other.qualityTuningLevelAsString()) && Objects.equals(this.slices(), other.slices()) && Objects.equals(this.telecineAsString(), other.telecineAsString());
    }

    public final String toString() {
        return ToString.builder((String)"XavcHdProfileSettings").add("BitrateClass", (Object)this.bitrateClassAsString()).add("FlickerAdaptiveQuantization", (Object)this.flickerAdaptiveQuantizationAsString()).add("GopBReference", (Object)this.gopBReferenceAsString()).add("GopClosedCadence", (Object)this.gopClosedCadence()).add("HrdBufferSize", (Object)this.hrdBufferSize()).add("InterlaceMode", (Object)this.interlaceModeAsString()).add("QualityTuningLevel", (Object)this.qualityTuningLevelAsString()).add("Slices", (Object)this.slices()).add("Telecine", (Object)this.telecineAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BitrateClass": {
                return Optional.ofNullable(clazz.cast(this.bitrateClassAsString()));
            }
            case "FlickerAdaptiveQuantization": {
                return Optional.ofNullable(clazz.cast(this.flickerAdaptiveQuantizationAsString()));
            }
            case "GopBReference": {
                return Optional.ofNullable(clazz.cast(this.gopBReferenceAsString()));
            }
            case "GopClosedCadence": {
                return Optional.ofNullable(clazz.cast(this.gopClosedCadence()));
            }
            case "HrdBufferSize": {
                return Optional.ofNullable(clazz.cast(this.hrdBufferSize()));
            }
            case "InterlaceMode": {
                return Optional.ofNullable(clazz.cast(this.interlaceModeAsString()));
            }
            case "QualityTuningLevel": {
                return Optional.ofNullable(clazz.cast(this.qualityTuningLevelAsString()));
            }
            case "Slices": {
                return Optional.ofNullable(clazz.cast(this.slices()));
            }
            case "Telecine": {
                return Optional.ofNullable(clazz.cast(this.telecineAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<XavcHdProfileSettings, T> g) {
        return obj -> g.apply((XavcHdProfileSettings)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String bitrateClass;
        private String flickerAdaptiveQuantization;
        private String gopBReference;
        private Integer gopClosedCadence;
        private Integer hrdBufferSize;
        private String interlaceMode;
        private String qualityTuningLevel;
        private Integer slices;
        private String telecine;

        private BuilderImpl() {
        }

        private BuilderImpl(XavcHdProfileSettings model) {
            this.bitrateClass(model.bitrateClass);
            this.flickerAdaptiveQuantization(model.flickerAdaptiveQuantization);
            this.gopBReference(model.gopBReference);
            this.gopClosedCadence(model.gopClosedCadence);
            this.hrdBufferSize(model.hrdBufferSize);
            this.interlaceMode(model.interlaceMode);
            this.qualityTuningLevel(model.qualityTuningLevel);
            this.slices(model.slices);
            this.telecine(model.telecine);
        }

        public final String getBitrateClass() {
            return this.bitrateClass;
        }

        public final void setBitrateClass(String bitrateClass) {
            this.bitrateClass = bitrateClass;
        }

        @Override
        public final Builder bitrateClass(String bitrateClass) {
            this.bitrateClass = bitrateClass;
            return this;
        }

        @Override
        public final Builder bitrateClass(XavcHdProfileBitrateClass bitrateClass) {
            this.bitrateClass(bitrateClass == null ? null : bitrateClass.toString());
            return this;
        }

        public final String getFlickerAdaptiveQuantization() {
            return this.flickerAdaptiveQuantization;
        }

        public final void setFlickerAdaptiveQuantization(String flickerAdaptiveQuantization) {
            this.flickerAdaptiveQuantization = flickerAdaptiveQuantization;
        }

        @Override
        public final Builder flickerAdaptiveQuantization(String flickerAdaptiveQuantization) {
            this.flickerAdaptiveQuantization = flickerAdaptiveQuantization;
            return this;
        }

        @Override
        public final Builder flickerAdaptiveQuantization(XavcFlickerAdaptiveQuantization flickerAdaptiveQuantization) {
            this.flickerAdaptiveQuantization(flickerAdaptiveQuantization == null ? null : flickerAdaptiveQuantization.toString());
            return this;
        }

        public final String getGopBReference() {
            return this.gopBReference;
        }

        public final void setGopBReference(String gopBReference) {
            this.gopBReference = gopBReference;
        }

        @Override
        public final Builder gopBReference(String gopBReference) {
            this.gopBReference = gopBReference;
            return this;
        }

        @Override
        public final Builder gopBReference(XavcGopBReference gopBReference) {
            this.gopBReference(gopBReference == null ? null : gopBReference.toString());
            return this;
        }

        public final Integer getGopClosedCadence() {
            return this.gopClosedCadence;
        }

        public final void setGopClosedCadence(Integer gopClosedCadence) {
            this.gopClosedCadence = gopClosedCadence;
        }

        @Override
        public final Builder gopClosedCadence(Integer gopClosedCadence) {
            this.gopClosedCadence = gopClosedCadence;
            return this;
        }

        public final Integer getHrdBufferSize() {
            return this.hrdBufferSize;
        }

        public final void setHrdBufferSize(Integer hrdBufferSize) {
            this.hrdBufferSize = hrdBufferSize;
        }

        @Override
        public final Builder hrdBufferSize(Integer hrdBufferSize) {
            this.hrdBufferSize = hrdBufferSize;
            return this;
        }

        public final String getInterlaceMode() {
            return this.interlaceMode;
        }

        public final void setInterlaceMode(String interlaceMode) {
            this.interlaceMode = interlaceMode;
        }

        @Override
        public final Builder interlaceMode(String interlaceMode) {
            this.interlaceMode = interlaceMode;
            return this;
        }

        @Override
        public final Builder interlaceMode(XavcInterlaceMode interlaceMode) {
            this.interlaceMode(interlaceMode == null ? null : interlaceMode.toString());
            return this;
        }

        public final String getQualityTuningLevel() {
            return this.qualityTuningLevel;
        }

        public final void setQualityTuningLevel(String qualityTuningLevel) {
            this.qualityTuningLevel = qualityTuningLevel;
        }

        @Override
        public final Builder qualityTuningLevel(String qualityTuningLevel) {
            this.qualityTuningLevel = qualityTuningLevel;
            return this;
        }

        @Override
        public final Builder qualityTuningLevel(XavcHdProfileQualityTuningLevel qualityTuningLevel) {
            this.qualityTuningLevel(qualityTuningLevel == null ? null : qualityTuningLevel.toString());
            return this;
        }

        public final Integer getSlices() {
            return this.slices;
        }

        public final void setSlices(Integer slices) {
            this.slices = slices;
        }

        @Override
        public final Builder slices(Integer slices) {
            this.slices = slices;
            return this;
        }

        public final String getTelecine() {
            return this.telecine;
        }

        public final void setTelecine(String telecine) {
            this.telecine = telecine;
        }

        @Override
        public final Builder telecine(String telecine) {
            this.telecine = telecine;
            return this;
        }

        @Override
        public final Builder telecine(XavcHdProfileTelecine telecine) {
            this.telecine(telecine == null ? null : telecine.toString());
            return this;
        }

        public XavcHdProfileSettings build() {
            return new XavcHdProfileSettings(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, XavcHdProfileSettings> {
        public Builder bitrateClass(String var1);

        public Builder bitrateClass(XavcHdProfileBitrateClass var1);

        public Builder flickerAdaptiveQuantization(String var1);

        public Builder flickerAdaptiveQuantization(XavcFlickerAdaptiveQuantization var1);

        public Builder gopBReference(String var1);

        public Builder gopBReference(XavcGopBReference var1);

        public Builder gopClosedCadence(Integer var1);

        public Builder hrdBufferSize(Integer var1);

        public Builder interlaceMode(String var1);

        public Builder interlaceMode(XavcInterlaceMode var1);

        public Builder qualityTuningLevel(String var1);

        public Builder qualityTuningLevel(XavcHdProfileQualityTuningLevel var1);

        public Builder slices(Integer var1);

        public Builder telecine(String var1);

        public Builder telecine(XavcHdProfileTelecine var1);
    }
}

