/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.mediaconvert.model.AlphaBehavior;
import software.amazon.awssdk.services.mediaconvert.model.ColorSpace;
import software.amazon.awssdk.services.mediaconvert.model.ColorSpaceUsage;
import software.amazon.awssdk.services.mediaconvert.model.EmbeddedTimecodeOverride;
import software.amazon.awssdk.services.mediaconvert.model.Hdr10Metadata;
import software.amazon.awssdk.services.mediaconvert.model.InputRotate;
import software.amazon.awssdk.services.mediaconvert.model.InputSampleRange;
import software.amazon.awssdk.services.mediaconvert.model.PadVideo;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class VideoSelector
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, VideoSelector> {
    private static final SdkField<String> ALPHA_BEHAVIOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AlphaBehavior").getter(VideoSelector.getter(VideoSelector::alphaBehaviorAsString)).setter(VideoSelector.setter(Builder::alphaBehavior)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("alphaBehavior").build()}).build();
    private static final SdkField<String> COLOR_SPACE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ColorSpace").getter(VideoSelector.getter(VideoSelector::colorSpaceAsString)).setter(VideoSelector.setter(Builder::colorSpace)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("colorSpace").build()}).build();
    private static final SdkField<String> COLOR_SPACE_USAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ColorSpaceUsage").getter(VideoSelector.getter(VideoSelector::colorSpaceUsageAsString)).setter(VideoSelector.setter(Builder::colorSpaceUsage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("colorSpaceUsage").build()}).build();
    private static final SdkField<String> EMBEDDED_TIMECODE_OVERRIDE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EmbeddedTimecodeOverride").getter(VideoSelector.getter(VideoSelector::embeddedTimecodeOverrideAsString)).setter(VideoSelector.setter(Builder::embeddedTimecodeOverride)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("embeddedTimecodeOverride").build()}).build();
    private static final SdkField<Hdr10Metadata> HDR10_METADATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Hdr10Metadata").getter(VideoSelector.getter(VideoSelector::hdr10Metadata)).setter(VideoSelector.setter(Builder::hdr10Metadata)).constructor(Hdr10Metadata::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hdr10Metadata").build()}).build();
    private static final SdkField<String> PAD_VIDEO_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PadVideo").getter(VideoSelector.getter(VideoSelector::padVideoAsString)).setter(VideoSelector.setter(Builder::padVideo)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("padVideo").build()}).build();
    private static final SdkField<Integer> PID_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Pid").getter(VideoSelector.getter(VideoSelector::pid)).setter(VideoSelector.setter(Builder::pid)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pid").build()}).build();
    private static final SdkField<Integer> PROGRAM_NUMBER_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ProgramNumber").getter(VideoSelector.getter(VideoSelector::programNumber)).setter(VideoSelector.setter(Builder::programNumber)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("programNumber").build()}).build();
    private static final SdkField<String> ROTATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Rotate").getter(VideoSelector.getter(VideoSelector::rotateAsString)).setter(VideoSelector.setter(Builder::rotate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rotate").build()}).build();
    private static final SdkField<String> SAMPLE_RANGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SampleRange").getter(VideoSelector.getter(VideoSelector::sampleRangeAsString)).setter(VideoSelector.setter(Builder::sampleRange)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sampleRange").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALPHA_BEHAVIOR_FIELD, COLOR_SPACE_FIELD, COLOR_SPACE_USAGE_FIELD, EMBEDDED_TIMECODE_OVERRIDE_FIELD, HDR10_METADATA_FIELD, PAD_VIDEO_FIELD, PID_FIELD, PROGRAM_NUMBER_FIELD, ROTATE_FIELD, SAMPLE_RANGE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String alphaBehavior;
    private final String colorSpace;
    private final String colorSpaceUsage;
    private final String embeddedTimecodeOverride;
    private final Hdr10Metadata hdr10Metadata;
    private final String padVideo;
    private final Integer pid;
    private final Integer programNumber;
    private final String rotate;
    private final String sampleRange;

    private VideoSelector(BuilderImpl builder) {
        this.alphaBehavior = builder.alphaBehavior;
        this.colorSpace = builder.colorSpace;
        this.colorSpaceUsage = builder.colorSpaceUsage;
        this.embeddedTimecodeOverride = builder.embeddedTimecodeOverride;
        this.hdr10Metadata = builder.hdr10Metadata;
        this.padVideo = builder.padVideo;
        this.pid = builder.pid;
        this.programNumber = builder.programNumber;
        this.rotate = builder.rotate;
        this.sampleRange = builder.sampleRange;
    }

    public final AlphaBehavior alphaBehavior() {
        return AlphaBehavior.fromValue(this.alphaBehavior);
    }

    public final String alphaBehaviorAsString() {
        return this.alphaBehavior;
    }

    public final ColorSpace colorSpace() {
        return ColorSpace.fromValue(this.colorSpace);
    }

    public final String colorSpaceAsString() {
        return this.colorSpace;
    }

    public final ColorSpaceUsage colorSpaceUsage() {
        return ColorSpaceUsage.fromValue(this.colorSpaceUsage);
    }

    public final String colorSpaceUsageAsString() {
        return this.colorSpaceUsage;
    }

    public final EmbeddedTimecodeOverride embeddedTimecodeOverride() {
        return EmbeddedTimecodeOverride.fromValue(this.embeddedTimecodeOverride);
    }

    public final String embeddedTimecodeOverrideAsString() {
        return this.embeddedTimecodeOverride;
    }

    public final Hdr10Metadata hdr10Metadata() {
        return this.hdr10Metadata;
    }

    public final PadVideo padVideo() {
        return PadVideo.fromValue(this.padVideo);
    }

    public final String padVideoAsString() {
        return this.padVideo;
    }

    public final Integer pid() {
        return this.pid;
    }

    public final Integer programNumber() {
        return this.programNumber;
    }

    public final InputRotate rotate() {
        return InputRotate.fromValue(this.rotate);
    }

    public final String rotateAsString() {
        return this.rotate;
    }

    public final InputSampleRange sampleRange() {
        return InputSampleRange.fromValue(this.sampleRange);
    }

    public final String sampleRangeAsString() {
        return this.sampleRange;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.alphaBehaviorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.colorSpaceAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.colorSpaceUsageAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.embeddedTimecodeOverrideAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hdr10Metadata());
        hashCode = 31 * hashCode + Objects.hashCode(this.padVideoAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.pid());
        hashCode = 31 * hashCode + Objects.hashCode(this.programNumber());
        hashCode = 31 * hashCode + Objects.hashCode(this.rotateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.sampleRangeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VideoSelector)) {
            return false;
        }
        VideoSelector other = (VideoSelector)obj;
        return Objects.equals(this.alphaBehaviorAsString(), other.alphaBehaviorAsString()) && Objects.equals(this.colorSpaceAsString(), other.colorSpaceAsString()) && Objects.equals(this.colorSpaceUsageAsString(), other.colorSpaceUsageAsString()) && Objects.equals(this.embeddedTimecodeOverrideAsString(), other.embeddedTimecodeOverrideAsString()) && Objects.equals(this.hdr10Metadata(), other.hdr10Metadata()) && Objects.equals(this.padVideoAsString(), other.padVideoAsString()) && Objects.equals(this.pid(), other.pid()) && Objects.equals(this.programNumber(), other.programNumber()) && Objects.equals(this.rotateAsString(), other.rotateAsString()) && Objects.equals(this.sampleRangeAsString(), other.sampleRangeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"VideoSelector").add("AlphaBehavior", (Object)this.alphaBehaviorAsString()).add("ColorSpace", (Object)this.colorSpaceAsString()).add("ColorSpaceUsage", (Object)this.colorSpaceUsageAsString()).add("EmbeddedTimecodeOverride", (Object)this.embeddedTimecodeOverrideAsString()).add("Hdr10Metadata", (Object)this.hdr10Metadata()).add("PadVideo", (Object)this.padVideoAsString()).add("Pid", (Object)this.pid()).add("ProgramNumber", (Object)this.programNumber()).add("Rotate", (Object)this.rotateAsString()).add("SampleRange", (Object)this.sampleRangeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AlphaBehavior": {
                return Optional.ofNullable(clazz.cast(this.alphaBehaviorAsString()));
            }
            case "ColorSpace": {
                return Optional.ofNullable(clazz.cast(this.colorSpaceAsString()));
            }
            case "ColorSpaceUsage": {
                return Optional.ofNullable(clazz.cast(this.colorSpaceUsageAsString()));
            }
            case "EmbeddedTimecodeOverride": {
                return Optional.ofNullable(clazz.cast(this.embeddedTimecodeOverrideAsString()));
            }
            case "Hdr10Metadata": {
                return Optional.ofNullable(clazz.cast(this.hdr10Metadata()));
            }
            case "PadVideo": {
                return Optional.ofNullable(clazz.cast(this.padVideoAsString()));
            }
            case "Pid": {
                return Optional.ofNullable(clazz.cast(this.pid()));
            }
            case "ProgramNumber": {
                return Optional.ofNullable(clazz.cast(this.programNumber()));
            }
            case "Rotate": {
                return Optional.ofNullable(clazz.cast(this.rotateAsString()));
            }
            case "SampleRange": {
                return Optional.ofNullable(clazz.cast(this.sampleRangeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<VideoSelector, T> g) {
        return obj -> g.apply((VideoSelector)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String alphaBehavior;
        private String colorSpace;
        private String colorSpaceUsage;
        private String embeddedTimecodeOverride;
        private Hdr10Metadata hdr10Metadata;
        private String padVideo;
        private Integer pid;
        private Integer programNumber;
        private String rotate;
        private String sampleRange;

        private BuilderImpl() {
        }

        private BuilderImpl(VideoSelector model) {
            this.alphaBehavior(model.alphaBehavior);
            this.colorSpace(model.colorSpace);
            this.colorSpaceUsage(model.colorSpaceUsage);
            this.embeddedTimecodeOverride(model.embeddedTimecodeOverride);
            this.hdr10Metadata(model.hdr10Metadata);
            this.padVideo(model.padVideo);
            this.pid(model.pid);
            this.programNumber(model.programNumber);
            this.rotate(model.rotate);
            this.sampleRange(model.sampleRange);
        }

        public final String getAlphaBehavior() {
            return this.alphaBehavior;
        }

        public final void setAlphaBehavior(String alphaBehavior) {
            this.alphaBehavior = alphaBehavior;
        }

        @Override
        public final Builder alphaBehavior(String alphaBehavior) {
            this.alphaBehavior = alphaBehavior;
            return this;
        }

        @Override
        public final Builder alphaBehavior(AlphaBehavior alphaBehavior) {
            this.alphaBehavior(alphaBehavior == null ? null : alphaBehavior.toString());
            return this;
        }

        public final String getColorSpace() {
            return this.colorSpace;
        }

        public final void setColorSpace(String colorSpace) {
            this.colorSpace = colorSpace;
        }

        @Override
        public final Builder colorSpace(String colorSpace) {
            this.colorSpace = colorSpace;
            return this;
        }

        @Override
        public final Builder colorSpace(ColorSpace colorSpace) {
            this.colorSpace(colorSpace == null ? null : colorSpace.toString());
            return this;
        }

        public final String getColorSpaceUsage() {
            return this.colorSpaceUsage;
        }

        public final void setColorSpaceUsage(String colorSpaceUsage) {
            this.colorSpaceUsage = colorSpaceUsage;
        }

        @Override
        public final Builder colorSpaceUsage(String colorSpaceUsage) {
            this.colorSpaceUsage = colorSpaceUsage;
            return this;
        }

        @Override
        public final Builder colorSpaceUsage(ColorSpaceUsage colorSpaceUsage) {
            this.colorSpaceUsage(colorSpaceUsage == null ? null : colorSpaceUsage.toString());
            return this;
        }

        public final String getEmbeddedTimecodeOverride() {
            return this.embeddedTimecodeOverride;
        }

        public final void setEmbeddedTimecodeOverride(String embeddedTimecodeOverride) {
            this.embeddedTimecodeOverride = embeddedTimecodeOverride;
        }

        @Override
        public final Builder embeddedTimecodeOverride(String embeddedTimecodeOverride) {
            this.embeddedTimecodeOverride = embeddedTimecodeOverride;
            return this;
        }

        @Override
        public final Builder embeddedTimecodeOverride(EmbeddedTimecodeOverride embeddedTimecodeOverride) {
            this.embeddedTimecodeOverride(embeddedTimecodeOverride == null ? null : embeddedTimecodeOverride.toString());
            return this;
        }

        public final Hdr10Metadata.Builder getHdr10Metadata() {
            return this.hdr10Metadata != null ? this.hdr10Metadata.toBuilder() : null;
        }

        public final void setHdr10Metadata(Hdr10Metadata.BuilderImpl hdr10Metadata) {
            this.hdr10Metadata = hdr10Metadata != null ? hdr10Metadata.build() : null;
        }

        @Override
        public final Builder hdr10Metadata(Hdr10Metadata hdr10Metadata) {
            this.hdr10Metadata = hdr10Metadata;
            return this;
        }

        public final String getPadVideo() {
            return this.padVideo;
        }

        public final void setPadVideo(String padVideo) {
            this.padVideo = padVideo;
        }

        @Override
        public final Builder padVideo(String padVideo) {
            this.padVideo = padVideo;
            return this;
        }

        @Override
        public final Builder padVideo(PadVideo padVideo) {
            this.padVideo(padVideo == null ? null : padVideo.toString());
            return this;
        }

        public final Integer getPid() {
            return this.pid;
        }

        public final void setPid(Integer pid) {
            this.pid = pid;
        }

        @Override
        public final Builder pid(Integer pid) {
            this.pid = pid;
            return this;
        }

        public final Integer getProgramNumber() {
            return this.programNumber;
        }

        public final void setProgramNumber(Integer programNumber) {
            this.programNumber = programNumber;
        }

        @Override
        public final Builder programNumber(Integer programNumber) {
            this.programNumber = programNumber;
            return this;
        }

        public final String getRotate() {
            return this.rotate;
        }

        public final void setRotate(String rotate) {
            this.rotate = rotate;
        }

        @Override
        public final Builder rotate(String rotate) {
            this.rotate = rotate;
            return this;
        }

        @Override
        public final Builder rotate(InputRotate rotate) {
            this.rotate(rotate == null ? null : rotate.toString());
            return this;
        }

        public final String getSampleRange() {
            return this.sampleRange;
        }

        public final void setSampleRange(String sampleRange) {
            this.sampleRange = sampleRange;
        }

        @Override
        public final Builder sampleRange(String sampleRange) {
            this.sampleRange = sampleRange;
            return this;
        }

        @Override
        public final Builder sampleRange(InputSampleRange sampleRange) {
            this.sampleRange(sampleRange == null ? null : sampleRange.toString());
            return this;
        }

        public VideoSelector build() {
            return new VideoSelector(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, VideoSelector> {
        public Builder alphaBehavior(String var1);

        public Builder alphaBehavior(AlphaBehavior var1);

        public Builder colorSpace(String var1);

        public Builder colorSpace(ColorSpace var1);

        public Builder colorSpaceUsage(String var1);

        public Builder colorSpaceUsage(ColorSpaceUsage var1);

        public Builder embeddedTimecodeOverride(String var1);

        public Builder embeddedTimecodeOverride(EmbeddedTimecodeOverride var1);

        public Builder hdr10Metadata(Hdr10Metadata var1);

        default public Builder hdr10Metadata(Consumer<Hdr10Metadata.Builder> hdr10Metadata) {
            return this.hdr10Metadata((Hdr10Metadata)((Hdr10Metadata.Builder)Hdr10Metadata.builder().applyMutation(hdr10Metadata)).build());
        }

        public Builder padVideo(String var1);

        public Builder padVideo(PadVideo var1);

        public Builder pid(Integer var1);

        public Builder programNumber(Integer var1);

        public Builder rotate(String var1);

        public Builder rotate(InputRotate var1);

        public Builder sampleRange(String var1);

        public Builder sampleRange(InputSampleRange var1);
    }
}

