/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum AudioChannelTag {
    L("L"),
    R("R"),
    C("C"),
    LFE("LFE"),
    LS("LS"),
    RS("RS"),
    LC("LC"),
    RC("RC"),
    CS("CS"),
    LSD("LSD"),
    RSD("RSD"),
    TCS("TCS"),
    VHL("VHL"),
    VHC("VHC"),
    VHR("VHR"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, AudioChannelTag> VALUE_MAP;
    private final String value;

    private AudioChannelTag(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static AudioChannelTag fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<AudioChannelTag> knownValues() {
        EnumSet<AudioChannelTag> knownValues = EnumSet.allOf(AudioChannelTag.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(AudioChannelTag.class, AudioChannelTag::toString);
    }
}

