/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.mediaconvert.model.InsertableImage;
import software.amazon.awssdk.services.mediaconvert.model.___listOfInsertableImageCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ImageInserter
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ImageInserter> {
    private static final SdkField<List<InsertableImage>> INSERTABLE_IMAGES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("InsertableImages").getter(ImageInserter.getter(ImageInserter::insertableImages)).setter(ImageInserter.setter(Builder::insertableImages)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("insertableImages").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(InsertableImage::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSERTABLE_IMAGES_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<InsertableImage> insertableImages;

    private ImageInserter(BuilderImpl builder) {
        this.insertableImages = builder.insertableImages;
    }

    public final boolean hasInsertableImages() {
        return this.insertableImages != null && !(this.insertableImages instanceof SdkAutoConstructList);
    }

    public final List<InsertableImage> insertableImages() {
        return this.insertableImages;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInsertableImages() ? this.insertableImages() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImageInserter)) {
            return false;
        }
        ImageInserter other = (ImageInserter)obj;
        return this.hasInsertableImages() == other.hasInsertableImages() && Objects.equals(this.insertableImages(), other.insertableImages());
    }

    public final String toString() {
        return ToString.builder((String)"ImageInserter").add("InsertableImages", this.hasInsertableImages() ? this.insertableImages() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InsertableImages": {
                return Optional.ofNullable(clazz.cast(this.insertableImages()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ImageInserter, T> g) {
        return obj -> g.apply((ImageInserter)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<InsertableImage> insertableImages = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ImageInserter model) {
            this.insertableImages(model.insertableImages);
        }

        public final List<InsertableImage.Builder> getInsertableImages() {
            List<InsertableImage.Builder> result = ___listOfInsertableImageCopier.copyToBuilder(this.insertableImages);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInsertableImages(Collection<InsertableImage.BuilderImpl> insertableImages) {
            this.insertableImages = ___listOfInsertableImageCopier.copyFromBuilder(insertableImages);
        }

        @Override
        public final Builder insertableImages(Collection<InsertableImage> insertableImages) {
            this.insertableImages = ___listOfInsertableImageCopier.copy(insertableImages);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder insertableImages(InsertableImage ... insertableImages) {
            this.insertableImages(Arrays.asList(insertableImages));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder insertableImages(Consumer<InsertableImage.Builder> ... insertableImages) {
            this.insertableImages(Stream.of(insertableImages).map(c -> (InsertableImage)((InsertableImage.Builder)InsertableImage.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public ImageInserter build() {
            return new ImageInserter(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ImageInserter> {
        public Builder insertableImages(Collection<InsertableImage> var1);

        public Builder insertableImages(InsertableImage ... var1);

        public Builder insertableImages(Consumer<InsertableImage.Builder> ... var1);
    }
}

