/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum H264AdaptiveQuantization {
    OFF("OFF"),
    AUTO("AUTO"),
    LOW("LOW"),
    MEDIUM("MEDIUM"),
    HIGH("HIGH"),
    HIGHER("HIGHER"),
    MAX("MAX"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, H264AdaptiveQuantization> VALUE_MAP;
    private final String value;

    private H264AdaptiveQuantization(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static H264AdaptiveQuantization fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<H264AdaptiveQuantization> knownValues() {
        EnumSet<H264AdaptiveQuantization> knownValues = EnumSet.allOf(H264AdaptiveQuantization.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(H264AdaptiveQuantization.class, H264AdaptiveQuantization::toString);
    }
}

