/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum DeinterlaceAlgorithm {
    INTERPOLATE("INTERPOLATE"),
    INTERPOLATE_TICKER("INTERPOLATE_TICKER"),
    BLEND("BLEND"),
    BLEND_TICKER("BLEND_TICKER"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private DeinterlaceAlgorithm(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static DeinterlaceAlgorithm fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(DeinterlaceAlgorithm.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<DeinterlaceAlgorithm> knownValues() {
        return Stream.of(DeinterlaceAlgorithm.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

