/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.mediaconvert.model.AudioDefaultSelection;
import software.amazon.awssdk.services.mediaconvert.model.AudioSelectorType;
import software.amazon.awssdk.services.mediaconvert.model.HlsRenditionGroupSettings;
import software.amazon.awssdk.services.mediaconvert.model.LanguageCode;
import software.amazon.awssdk.services.mediaconvert.model.RemixSettings;
import software.amazon.awssdk.services.mediaconvert.model.___listOf__integerMin1Max2147483647Copier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AudioSelector
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AudioSelector> {
    private static final SdkField<String> CUSTOM_LANGUAGE_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CustomLanguageCode").getter(AudioSelector.getter(AudioSelector::customLanguageCode)).setter(AudioSelector.setter(Builder::customLanguageCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customLanguageCode").build()}).build();
    private static final SdkField<String> DEFAULT_SELECTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DefaultSelection").getter(AudioSelector.getter(AudioSelector::defaultSelectionAsString)).setter(AudioSelector.setter(Builder::defaultSelection)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("defaultSelection").build()}).build();
    private static final SdkField<String> EXTERNAL_AUDIO_FILE_INPUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ExternalAudioFileInput").getter(AudioSelector.getter(AudioSelector::externalAudioFileInput)).setter(AudioSelector.setter(Builder::externalAudioFileInput)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("externalAudioFileInput").build()}).build();
    private static final SdkField<HlsRenditionGroupSettings> HLS_RENDITION_GROUP_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("HlsRenditionGroupSettings").getter(AudioSelector.getter(AudioSelector::hlsRenditionGroupSettings)).setter(AudioSelector.setter(Builder::hlsRenditionGroupSettings)).constructor(HlsRenditionGroupSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hlsRenditionGroupSettings").build()}).build();
    private static final SdkField<String> LANGUAGE_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LanguageCode").getter(AudioSelector.getter(AudioSelector::languageCodeAsString)).setter(AudioSelector.setter(Builder::languageCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("languageCode").build()}).build();
    private static final SdkField<Integer> OFFSET_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Offset").getter(AudioSelector.getter(AudioSelector::offset)).setter(AudioSelector.setter(Builder::offset)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("offset").build()}).build();
    private static final SdkField<List<Integer>> PIDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Pids").getter(AudioSelector.getter(AudioSelector::pids)).setter(AudioSelector.setter(Builder::pids)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pids").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.INTEGER).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Integer> PROGRAM_SELECTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ProgramSelection").getter(AudioSelector.getter(AudioSelector::programSelection)).setter(AudioSelector.setter(Builder::programSelection)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("programSelection").build()}).build();
    private static final SdkField<RemixSettings> REMIX_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("RemixSettings").getter(AudioSelector.getter(AudioSelector::remixSettings)).setter(AudioSelector.setter(Builder::remixSettings)).constructor(RemixSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("remixSettings").build()}).build();
    private static final SdkField<String> SELECTOR_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SelectorType").getter(AudioSelector.getter(AudioSelector::selectorTypeAsString)).setter(AudioSelector.setter(Builder::selectorType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("selectorType").build()}).build();
    private static final SdkField<List<Integer>> TRACKS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tracks").getter(AudioSelector.getter(AudioSelector::tracks)).setter(AudioSelector.setter(Builder::tracks)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tracks").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.INTEGER).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CUSTOM_LANGUAGE_CODE_FIELD, DEFAULT_SELECTION_FIELD, EXTERNAL_AUDIO_FILE_INPUT_FIELD, HLS_RENDITION_GROUP_SETTINGS_FIELD, LANGUAGE_CODE_FIELD, OFFSET_FIELD, PIDS_FIELD, PROGRAM_SELECTION_FIELD, REMIX_SETTINGS_FIELD, SELECTOR_TYPE_FIELD, TRACKS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String customLanguageCode;
    private final String defaultSelection;
    private final String externalAudioFileInput;
    private final HlsRenditionGroupSettings hlsRenditionGroupSettings;
    private final String languageCode;
    private final Integer offset;
    private final List<Integer> pids;
    private final Integer programSelection;
    private final RemixSettings remixSettings;
    private final String selectorType;
    private final List<Integer> tracks;

    private AudioSelector(BuilderImpl builder) {
        this.customLanguageCode = builder.customLanguageCode;
        this.defaultSelection = builder.defaultSelection;
        this.externalAudioFileInput = builder.externalAudioFileInput;
        this.hlsRenditionGroupSettings = builder.hlsRenditionGroupSettings;
        this.languageCode = builder.languageCode;
        this.offset = builder.offset;
        this.pids = builder.pids;
        this.programSelection = builder.programSelection;
        this.remixSettings = builder.remixSettings;
        this.selectorType = builder.selectorType;
        this.tracks = builder.tracks;
    }

    public final String customLanguageCode() {
        return this.customLanguageCode;
    }

    public final AudioDefaultSelection defaultSelection() {
        return AudioDefaultSelection.fromValue(this.defaultSelection);
    }

    public final String defaultSelectionAsString() {
        return this.defaultSelection;
    }

    public final String externalAudioFileInput() {
        return this.externalAudioFileInput;
    }

    public final HlsRenditionGroupSettings hlsRenditionGroupSettings() {
        return this.hlsRenditionGroupSettings;
    }

    public final LanguageCode languageCode() {
        return LanguageCode.fromValue(this.languageCode);
    }

    public final String languageCodeAsString() {
        return this.languageCode;
    }

    public final Integer offset() {
        return this.offset;
    }

    public final boolean hasPids() {
        return this.pids != null && !(this.pids instanceof SdkAutoConstructList);
    }

    public final List<Integer> pids() {
        return this.pids;
    }

    public final Integer programSelection() {
        return this.programSelection;
    }

    public final RemixSettings remixSettings() {
        return this.remixSettings;
    }

    public final AudioSelectorType selectorType() {
        return AudioSelectorType.fromValue(this.selectorType);
    }

    public final String selectorTypeAsString() {
        return this.selectorType;
    }

    public final boolean hasTracks() {
        return this.tracks != null && !(this.tracks instanceof SdkAutoConstructList);
    }

    public final List<Integer> tracks() {
        return this.tracks;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.customLanguageCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultSelectionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.externalAudioFileInput());
        hashCode = 31 * hashCode + Objects.hashCode(this.hlsRenditionGroupSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.languageCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.offset());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPids() ? this.pids() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.programSelection());
        hashCode = 31 * hashCode + Objects.hashCode(this.remixSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.selectorTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTracks() ? this.tracks() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AudioSelector)) {
            return false;
        }
        AudioSelector other = (AudioSelector)obj;
        return Objects.equals(this.customLanguageCode(), other.customLanguageCode()) && Objects.equals(this.defaultSelectionAsString(), other.defaultSelectionAsString()) && Objects.equals(this.externalAudioFileInput(), other.externalAudioFileInput()) && Objects.equals(this.hlsRenditionGroupSettings(), other.hlsRenditionGroupSettings()) && Objects.equals(this.languageCodeAsString(), other.languageCodeAsString()) && Objects.equals(this.offset(), other.offset()) && this.hasPids() == other.hasPids() && Objects.equals(this.pids(), other.pids()) && Objects.equals(this.programSelection(), other.programSelection()) && Objects.equals(this.remixSettings(), other.remixSettings()) && Objects.equals(this.selectorTypeAsString(), other.selectorTypeAsString()) && this.hasTracks() == other.hasTracks() && Objects.equals(this.tracks(), other.tracks());
    }

    public final String toString() {
        return ToString.builder((String)"AudioSelector").add("CustomLanguageCode", (Object)this.customLanguageCode()).add("DefaultSelection", (Object)this.defaultSelectionAsString()).add("ExternalAudioFileInput", (Object)this.externalAudioFileInput()).add("HlsRenditionGroupSettings", (Object)this.hlsRenditionGroupSettings()).add("LanguageCode", (Object)this.languageCodeAsString()).add("Offset", (Object)this.offset()).add("Pids", this.hasPids() ? this.pids() : null).add("ProgramSelection", (Object)this.programSelection()).add("RemixSettings", (Object)this.remixSettings()).add("SelectorType", (Object)this.selectorTypeAsString()).add("Tracks", this.hasTracks() ? this.tracks() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CustomLanguageCode": {
                return Optional.ofNullable(clazz.cast(this.customLanguageCode()));
            }
            case "DefaultSelection": {
                return Optional.ofNullable(clazz.cast(this.defaultSelectionAsString()));
            }
            case "ExternalAudioFileInput": {
                return Optional.ofNullable(clazz.cast(this.externalAudioFileInput()));
            }
            case "HlsRenditionGroupSettings": {
                return Optional.ofNullable(clazz.cast(this.hlsRenditionGroupSettings()));
            }
            case "LanguageCode": {
                return Optional.ofNullable(clazz.cast(this.languageCodeAsString()));
            }
            case "Offset": {
                return Optional.ofNullable(clazz.cast(this.offset()));
            }
            case "Pids": {
                return Optional.ofNullable(clazz.cast(this.pids()));
            }
            case "ProgramSelection": {
                return Optional.ofNullable(clazz.cast(this.programSelection()));
            }
            case "RemixSettings": {
                return Optional.ofNullable(clazz.cast(this.remixSettings()));
            }
            case "SelectorType": {
                return Optional.ofNullable(clazz.cast(this.selectorTypeAsString()));
            }
            case "Tracks": {
                return Optional.ofNullable(clazz.cast(this.tracks()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AudioSelector, T> g) {
        return obj -> g.apply((AudioSelector)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String customLanguageCode;
        private String defaultSelection;
        private String externalAudioFileInput;
        private HlsRenditionGroupSettings hlsRenditionGroupSettings;
        private String languageCode;
        private Integer offset;
        private List<Integer> pids = DefaultSdkAutoConstructList.getInstance();
        private Integer programSelection;
        private RemixSettings remixSettings;
        private String selectorType;
        private List<Integer> tracks = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AudioSelector model) {
            this.customLanguageCode(model.customLanguageCode);
            this.defaultSelection(model.defaultSelection);
            this.externalAudioFileInput(model.externalAudioFileInput);
            this.hlsRenditionGroupSettings(model.hlsRenditionGroupSettings);
            this.languageCode(model.languageCode);
            this.offset(model.offset);
            this.pids(model.pids);
            this.programSelection(model.programSelection);
            this.remixSettings(model.remixSettings);
            this.selectorType(model.selectorType);
            this.tracks(model.tracks);
        }

        public final String getCustomLanguageCode() {
            return this.customLanguageCode;
        }

        public final void setCustomLanguageCode(String customLanguageCode) {
            this.customLanguageCode = customLanguageCode;
        }

        @Override
        public final Builder customLanguageCode(String customLanguageCode) {
            this.customLanguageCode = customLanguageCode;
            return this;
        }

        public final String getDefaultSelection() {
            return this.defaultSelection;
        }

        public final void setDefaultSelection(String defaultSelection) {
            this.defaultSelection = defaultSelection;
        }

        @Override
        public final Builder defaultSelection(String defaultSelection) {
            this.defaultSelection = defaultSelection;
            return this;
        }

        @Override
        public final Builder defaultSelection(AudioDefaultSelection defaultSelection) {
            this.defaultSelection(defaultSelection == null ? null : defaultSelection.toString());
            return this;
        }

        public final String getExternalAudioFileInput() {
            return this.externalAudioFileInput;
        }

        public final void setExternalAudioFileInput(String externalAudioFileInput) {
            this.externalAudioFileInput = externalAudioFileInput;
        }

        @Override
        public final Builder externalAudioFileInput(String externalAudioFileInput) {
            this.externalAudioFileInput = externalAudioFileInput;
            return this;
        }

        public final HlsRenditionGroupSettings.Builder getHlsRenditionGroupSettings() {
            return this.hlsRenditionGroupSettings != null ? this.hlsRenditionGroupSettings.toBuilder() : null;
        }

        public final void setHlsRenditionGroupSettings(HlsRenditionGroupSettings.BuilderImpl hlsRenditionGroupSettings) {
            this.hlsRenditionGroupSettings = hlsRenditionGroupSettings != null ? hlsRenditionGroupSettings.build() : null;
        }

        @Override
        public final Builder hlsRenditionGroupSettings(HlsRenditionGroupSettings hlsRenditionGroupSettings) {
            this.hlsRenditionGroupSettings = hlsRenditionGroupSettings;
            return this;
        }

        public final String getLanguageCode() {
            return this.languageCode;
        }

        public final void setLanguageCode(String languageCode) {
            this.languageCode = languageCode;
        }

        @Override
        public final Builder languageCode(String languageCode) {
            this.languageCode = languageCode;
            return this;
        }

        @Override
        public final Builder languageCode(LanguageCode languageCode) {
            this.languageCode(languageCode == null ? null : languageCode.toString());
            return this;
        }

        public final Integer getOffset() {
            return this.offset;
        }

        public final void setOffset(Integer offset) {
            this.offset = offset;
        }

        @Override
        public final Builder offset(Integer offset) {
            this.offset = offset;
            return this;
        }

        public final Collection<Integer> getPids() {
            if (this.pids instanceof SdkAutoConstructList) {
                return null;
            }
            return this.pids;
        }

        public final void setPids(Collection<Integer> pids) {
            this.pids = ___listOf__integerMin1Max2147483647Copier.copy(pids);
        }

        @Override
        public final Builder pids(Collection<Integer> pids) {
            this.pids = ___listOf__integerMin1Max2147483647Copier.copy(pids);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder pids(Integer ... pids) {
            this.pids(Arrays.asList(pids));
            return this;
        }

        public final Integer getProgramSelection() {
            return this.programSelection;
        }

        public final void setProgramSelection(Integer programSelection) {
            this.programSelection = programSelection;
        }

        @Override
        public final Builder programSelection(Integer programSelection) {
            this.programSelection = programSelection;
            return this;
        }

        public final RemixSettings.Builder getRemixSettings() {
            return this.remixSettings != null ? this.remixSettings.toBuilder() : null;
        }

        public final void setRemixSettings(RemixSettings.BuilderImpl remixSettings) {
            this.remixSettings = remixSettings != null ? remixSettings.build() : null;
        }

        @Override
        public final Builder remixSettings(RemixSettings remixSettings) {
            this.remixSettings = remixSettings;
            return this;
        }

        public final String getSelectorType() {
            return this.selectorType;
        }

        public final void setSelectorType(String selectorType) {
            this.selectorType = selectorType;
        }

        @Override
        public final Builder selectorType(String selectorType) {
            this.selectorType = selectorType;
            return this;
        }

        @Override
        public final Builder selectorType(AudioSelectorType selectorType) {
            this.selectorType(selectorType == null ? null : selectorType.toString());
            return this;
        }

        public final Collection<Integer> getTracks() {
            if (this.tracks instanceof SdkAutoConstructList) {
                return null;
            }
            return this.tracks;
        }

        public final void setTracks(Collection<Integer> tracks) {
            this.tracks = ___listOf__integerMin1Max2147483647Copier.copy(tracks);
        }

        @Override
        public final Builder tracks(Collection<Integer> tracks) {
            this.tracks = ___listOf__integerMin1Max2147483647Copier.copy(tracks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tracks(Integer ... tracks) {
            this.tracks(Arrays.asList(tracks));
            return this;
        }

        public AudioSelector build() {
            return new AudioSelector(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AudioSelector> {
        public Builder customLanguageCode(String var1);

        public Builder defaultSelection(String var1);

        public Builder defaultSelection(AudioDefaultSelection var1);

        public Builder externalAudioFileInput(String var1);

        public Builder hlsRenditionGroupSettings(HlsRenditionGroupSettings var1);

        default public Builder hlsRenditionGroupSettings(Consumer<HlsRenditionGroupSettings.Builder> hlsRenditionGroupSettings) {
            return this.hlsRenditionGroupSettings((HlsRenditionGroupSettings)((HlsRenditionGroupSettings.Builder)HlsRenditionGroupSettings.builder().applyMutation(hlsRenditionGroupSettings)).build());
        }

        public Builder languageCode(String var1);

        public Builder languageCode(LanguageCode var1);

        public Builder offset(Integer var1);

        public Builder pids(Collection<Integer> var1);

        public Builder pids(Integer ... var1);

        public Builder programSelection(Integer var1);

        public Builder remixSettings(RemixSettings var1);

        default public Builder remixSettings(Consumer<RemixSettings.Builder> remixSettings) {
            return this.remixSettings((RemixSettings)((RemixSettings.Builder)RemixSettings.builder().applyMutation(remixSettings)).build());
        }

        public Builder selectorType(String var1);

        public Builder selectorType(AudioSelectorType var1);

        public Builder tracks(Collection<Integer> var1);

        public Builder tracks(Integer ... var1);
    }
}

