/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum H265TemporalIds {
    DISABLED("DISABLED"),
    ENABLED("ENABLED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, H265TemporalIds> VALUE_MAP;
    private final String value;

    private H265TemporalIds(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static H265TemporalIds fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<H265TemporalIds> knownValues() {
        EnumSet<H265TemporalIds> knownValues = EnumSet.allOf(H265TemporalIds.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(H265TemporalIds.class, H265TemporalIds::toString);
    }
}

