/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum CmafCodecSpecification {
    RFC_6381("RFC_6381"),
    RFC_4281("RFC_4281"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, CmafCodecSpecification> VALUE_MAP;
    private final String value;

    private CmafCodecSpecification(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static CmafCodecSpecification fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<CmafCodecSpecification> knownValues() {
        EnumSet<CmafCodecSpecification> knownValues = EnumSet.allOf(CmafCodecSpecification.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(CmafCodecSpecification.class, CmafCodecSpecification::toString);
    }
}

