/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.mediaconvert.model.CmfcAudioDuration;
import software.amazon.awssdk.services.mediaconvert.model.CmfcAudioTrackType;
import software.amazon.awssdk.services.mediaconvert.model.CmfcDescriptiveVideoServiceFlag;
import software.amazon.awssdk.services.mediaconvert.model.CmfcIFrameOnlyManifest;
import software.amazon.awssdk.services.mediaconvert.model.CmfcScte35Esam;
import software.amazon.awssdk.services.mediaconvert.model.CmfcScte35Source;
import software.amazon.awssdk.services.mediaconvert.model.CmfcTimedMetadata;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CmfcSettings
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CmfcSettings> {
    private static final SdkField<String> AUDIO_DURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AudioDuration").getter(CmfcSettings.getter(CmfcSettings::audioDurationAsString)).setter(CmfcSettings.setter(Builder::audioDuration)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("audioDuration").build()}).build();
    private static final SdkField<String> AUDIO_GROUP_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AudioGroupId").getter(CmfcSettings.getter(CmfcSettings::audioGroupId)).setter(CmfcSettings.setter(Builder::audioGroupId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("audioGroupId").build()}).build();
    private static final SdkField<String> AUDIO_RENDITION_SETS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AudioRenditionSets").getter(CmfcSettings.getter(CmfcSettings::audioRenditionSets)).setter(CmfcSettings.setter(Builder::audioRenditionSets)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("audioRenditionSets").build()}).build();
    private static final SdkField<String> AUDIO_TRACK_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AudioTrackType").getter(CmfcSettings.getter(CmfcSettings::audioTrackTypeAsString)).setter(CmfcSettings.setter(Builder::audioTrackType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("audioTrackType").build()}).build();
    private static final SdkField<String> DESCRIPTIVE_VIDEO_SERVICE_FLAG_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DescriptiveVideoServiceFlag").getter(CmfcSettings.getter(CmfcSettings::descriptiveVideoServiceFlagAsString)).setter(CmfcSettings.setter(Builder::descriptiveVideoServiceFlag)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("descriptiveVideoServiceFlag").build()}).build();
    private static final SdkField<String> I_FRAME_ONLY_MANIFEST_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IFrameOnlyManifest").getter(CmfcSettings.getter(CmfcSettings::iFrameOnlyManifestAsString)).setter(CmfcSettings.setter(Builder::iFrameOnlyManifest)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("iFrameOnlyManifest").build()}).build();
    private static final SdkField<String> SCTE35_ESAM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Scte35Esam").getter(CmfcSettings.getter(CmfcSettings::scte35EsamAsString)).setter(CmfcSettings.setter(Builder::scte35Esam)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scte35Esam").build()}).build();
    private static final SdkField<String> SCTE35_SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Scte35Source").getter(CmfcSettings.getter(CmfcSettings::scte35SourceAsString)).setter(CmfcSettings.setter(Builder::scte35Source)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scte35Source").build()}).build();
    private static final SdkField<String> TIMED_METADATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TimedMetadata").getter(CmfcSettings.getter(CmfcSettings::timedMetadataAsString)).setter(CmfcSettings.setter(Builder::timedMetadata)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timedMetadata").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUDIO_DURATION_FIELD, AUDIO_GROUP_ID_FIELD, AUDIO_RENDITION_SETS_FIELD, AUDIO_TRACK_TYPE_FIELD, DESCRIPTIVE_VIDEO_SERVICE_FLAG_FIELD, I_FRAME_ONLY_MANIFEST_FIELD, SCTE35_ESAM_FIELD, SCTE35_SOURCE_FIELD, TIMED_METADATA_FIELD));
    private static final long serialVersionUID = 1L;
    private final String audioDuration;
    private final String audioGroupId;
    private final String audioRenditionSets;
    private final String audioTrackType;
    private final String descriptiveVideoServiceFlag;
    private final String iFrameOnlyManifest;
    private final String scte35Esam;
    private final String scte35Source;
    private final String timedMetadata;

    private CmfcSettings(BuilderImpl builder) {
        this.audioDuration = builder.audioDuration;
        this.audioGroupId = builder.audioGroupId;
        this.audioRenditionSets = builder.audioRenditionSets;
        this.audioTrackType = builder.audioTrackType;
        this.descriptiveVideoServiceFlag = builder.descriptiveVideoServiceFlag;
        this.iFrameOnlyManifest = builder.iFrameOnlyManifest;
        this.scte35Esam = builder.scte35Esam;
        this.scte35Source = builder.scte35Source;
        this.timedMetadata = builder.timedMetadata;
    }

    public final CmfcAudioDuration audioDuration() {
        return CmfcAudioDuration.fromValue(this.audioDuration);
    }

    public final String audioDurationAsString() {
        return this.audioDuration;
    }

    public final String audioGroupId() {
        return this.audioGroupId;
    }

    public final String audioRenditionSets() {
        return this.audioRenditionSets;
    }

    public final CmfcAudioTrackType audioTrackType() {
        return CmfcAudioTrackType.fromValue(this.audioTrackType);
    }

    public final String audioTrackTypeAsString() {
        return this.audioTrackType;
    }

    public final CmfcDescriptiveVideoServiceFlag descriptiveVideoServiceFlag() {
        return CmfcDescriptiveVideoServiceFlag.fromValue(this.descriptiveVideoServiceFlag);
    }

    public final String descriptiveVideoServiceFlagAsString() {
        return this.descriptiveVideoServiceFlag;
    }

    public final CmfcIFrameOnlyManifest iFrameOnlyManifest() {
        return CmfcIFrameOnlyManifest.fromValue(this.iFrameOnlyManifest);
    }

    public final String iFrameOnlyManifestAsString() {
        return this.iFrameOnlyManifest;
    }

    public final CmfcScte35Esam scte35Esam() {
        return CmfcScte35Esam.fromValue(this.scte35Esam);
    }

    public final String scte35EsamAsString() {
        return this.scte35Esam;
    }

    public final CmfcScte35Source scte35Source() {
        return CmfcScte35Source.fromValue(this.scte35Source);
    }

    public final String scte35SourceAsString() {
        return this.scte35Source;
    }

    public final CmfcTimedMetadata timedMetadata() {
        return CmfcTimedMetadata.fromValue(this.timedMetadata);
    }

    public final String timedMetadataAsString() {
        return this.timedMetadata;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.audioDurationAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.audioGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(this.audioRenditionSets());
        hashCode = 31 * hashCode + Objects.hashCode(this.audioTrackTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.descriptiveVideoServiceFlagAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.iFrameOnlyManifestAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.scte35EsamAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.scte35SourceAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.timedMetadataAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CmfcSettings)) {
            return false;
        }
        CmfcSettings other = (CmfcSettings)obj;
        return Objects.equals(this.audioDurationAsString(), other.audioDurationAsString()) && Objects.equals(this.audioGroupId(), other.audioGroupId()) && Objects.equals(this.audioRenditionSets(), other.audioRenditionSets()) && Objects.equals(this.audioTrackTypeAsString(), other.audioTrackTypeAsString()) && Objects.equals(this.descriptiveVideoServiceFlagAsString(), other.descriptiveVideoServiceFlagAsString()) && Objects.equals(this.iFrameOnlyManifestAsString(), other.iFrameOnlyManifestAsString()) && Objects.equals(this.scte35EsamAsString(), other.scte35EsamAsString()) && Objects.equals(this.scte35SourceAsString(), other.scte35SourceAsString()) && Objects.equals(this.timedMetadataAsString(), other.timedMetadataAsString());
    }

    public final String toString() {
        return ToString.builder((String)"CmfcSettings").add("AudioDuration", (Object)this.audioDurationAsString()).add("AudioGroupId", (Object)this.audioGroupId()).add("AudioRenditionSets", (Object)this.audioRenditionSets()).add("AudioTrackType", (Object)this.audioTrackTypeAsString()).add("DescriptiveVideoServiceFlag", (Object)this.descriptiveVideoServiceFlagAsString()).add("IFrameOnlyManifest", (Object)this.iFrameOnlyManifestAsString()).add("Scte35Esam", (Object)this.scte35EsamAsString()).add("Scte35Source", (Object)this.scte35SourceAsString()).add("TimedMetadata", (Object)this.timedMetadataAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AudioDuration": {
                return Optional.ofNullable(clazz.cast(this.audioDurationAsString()));
            }
            case "AudioGroupId": {
                return Optional.ofNullable(clazz.cast(this.audioGroupId()));
            }
            case "AudioRenditionSets": {
                return Optional.ofNullable(clazz.cast(this.audioRenditionSets()));
            }
            case "AudioTrackType": {
                return Optional.ofNullable(clazz.cast(this.audioTrackTypeAsString()));
            }
            case "DescriptiveVideoServiceFlag": {
                return Optional.ofNullable(clazz.cast(this.descriptiveVideoServiceFlagAsString()));
            }
            case "IFrameOnlyManifest": {
                return Optional.ofNullable(clazz.cast(this.iFrameOnlyManifestAsString()));
            }
            case "Scte35Esam": {
                return Optional.ofNullable(clazz.cast(this.scte35EsamAsString()));
            }
            case "Scte35Source": {
                return Optional.ofNullable(clazz.cast(this.scte35SourceAsString()));
            }
            case "TimedMetadata": {
                return Optional.ofNullable(clazz.cast(this.timedMetadataAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CmfcSettings, T> g) {
        return obj -> g.apply((CmfcSettings)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String audioDuration;
        private String audioGroupId;
        private String audioRenditionSets;
        private String audioTrackType;
        private String descriptiveVideoServiceFlag;
        private String iFrameOnlyManifest;
        private String scte35Esam;
        private String scte35Source;
        private String timedMetadata;

        private BuilderImpl() {
        }

        private BuilderImpl(CmfcSettings model) {
            this.audioDuration(model.audioDuration);
            this.audioGroupId(model.audioGroupId);
            this.audioRenditionSets(model.audioRenditionSets);
            this.audioTrackType(model.audioTrackType);
            this.descriptiveVideoServiceFlag(model.descriptiveVideoServiceFlag);
            this.iFrameOnlyManifest(model.iFrameOnlyManifest);
            this.scte35Esam(model.scte35Esam);
            this.scte35Source(model.scte35Source);
            this.timedMetadata(model.timedMetadata);
        }

        public final String getAudioDuration() {
            return this.audioDuration;
        }

        public final void setAudioDuration(String audioDuration) {
            this.audioDuration = audioDuration;
        }

        @Override
        @Transient
        public final Builder audioDuration(String audioDuration) {
            this.audioDuration = audioDuration;
            return this;
        }

        @Override
        @Transient
        public final Builder audioDuration(CmfcAudioDuration audioDuration) {
            this.audioDuration(audioDuration == null ? null : audioDuration.toString());
            return this;
        }

        public final String getAudioGroupId() {
            return this.audioGroupId;
        }

        public final void setAudioGroupId(String audioGroupId) {
            this.audioGroupId = audioGroupId;
        }

        @Override
        @Transient
        public final Builder audioGroupId(String audioGroupId) {
            this.audioGroupId = audioGroupId;
            return this;
        }

        public final String getAudioRenditionSets() {
            return this.audioRenditionSets;
        }

        public final void setAudioRenditionSets(String audioRenditionSets) {
            this.audioRenditionSets = audioRenditionSets;
        }

        @Override
        @Transient
        public final Builder audioRenditionSets(String audioRenditionSets) {
            this.audioRenditionSets = audioRenditionSets;
            return this;
        }

        public final String getAudioTrackType() {
            return this.audioTrackType;
        }

        public final void setAudioTrackType(String audioTrackType) {
            this.audioTrackType = audioTrackType;
        }

        @Override
        @Transient
        public final Builder audioTrackType(String audioTrackType) {
            this.audioTrackType = audioTrackType;
            return this;
        }

        @Override
        @Transient
        public final Builder audioTrackType(CmfcAudioTrackType audioTrackType) {
            this.audioTrackType(audioTrackType == null ? null : audioTrackType.toString());
            return this;
        }

        public final String getDescriptiveVideoServiceFlag() {
            return this.descriptiveVideoServiceFlag;
        }

        public final void setDescriptiveVideoServiceFlag(String descriptiveVideoServiceFlag) {
            this.descriptiveVideoServiceFlag = descriptiveVideoServiceFlag;
        }

        @Override
        @Transient
        public final Builder descriptiveVideoServiceFlag(String descriptiveVideoServiceFlag) {
            this.descriptiveVideoServiceFlag = descriptiveVideoServiceFlag;
            return this;
        }

        @Override
        @Transient
        public final Builder descriptiveVideoServiceFlag(CmfcDescriptiveVideoServiceFlag descriptiveVideoServiceFlag) {
            this.descriptiveVideoServiceFlag(descriptiveVideoServiceFlag == null ? null : descriptiveVideoServiceFlag.toString());
            return this;
        }

        public final String getIFrameOnlyManifest() {
            return this.iFrameOnlyManifest;
        }

        public final void setIFrameOnlyManifest(String iFrameOnlyManifest) {
            this.iFrameOnlyManifest = iFrameOnlyManifest;
        }

        @Override
        @Transient
        public final Builder iFrameOnlyManifest(String iFrameOnlyManifest) {
            this.iFrameOnlyManifest = iFrameOnlyManifest;
            return this;
        }

        @Override
        @Transient
        public final Builder iFrameOnlyManifest(CmfcIFrameOnlyManifest iFrameOnlyManifest) {
            this.iFrameOnlyManifest(iFrameOnlyManifest == null ? null : iFrameOnlyManifest.toString());
            return this;
        }

        public final String getScte35Esam() {
            return this.scte35Esam;
        }

        public final void setScte35Esam(String scte35Esam) {
            this.scte35Esam = scte35Esam;
        }

        @Override
        @Transient
        public final Builder scte35Esam(String scte35Esam) {
            this.scte35Esam = scte35Esam;
            return this;
        }

        @Override
        @Transient
        public final Builder scte35Esam(CmfcScte35Esam scte35Esam) {
            this.scte35Esam(scte35Esam == null ? null : scte35Esam.toString());
            return this;
        }

        public final String getScte35Source() {
            return this.scte35Source;
        }

        public final void setScte35Source(String scte35Source) {
            this.scte35Source = scte35Source;
        }

        @Override
        @Transient
        public final Builder scte35Source(String scte35Source) {
            this.scte35Source = scte35Source;
            return this;
        }

        @Override
        @Transient
        public final Builder scte35Source(CmfcScte35Source scte35Source) {
            this.scte35Source(scte35Source == null ? null : scte35Source.toString());
            return this;
        }

        public final String getTimedMetadata() {
            return this.timedMetadata;
        }

        public final void setTimedMetadata(String timedMetadata) {
            this.timedMetadata = timedMetadata;
        }

        @Override
        @Transient
        public final Builder timedMetadata(String timedMetadata) {
            this.timedMetadata = timedMetadata;
            return this;
        }

        @Override
        @Transient
        public final Builder timedMetadata(CmfcTimedMetadata timedMetadata) {
            this.timedMetadata(timedMetadata == null ? null : timedMetadata.toString());
            return this;
        }

        public CmfcSettings build() {
            return new CmfcSettings(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CmfcSettings> {
        public Builder audioDuration(String var1);

        public Builder audioDuration(CmfcAudioDuration var1);

        public Builder audioGroupId(String var1);

        public Builder audioRenditionSets(String var1);

        public Builder audioTrackType(String var1);

        public Builder audioTrackType(CmfcAudioTrackType var1);

        public Builder descriptiveVideoServiceFlag(String var1);

        public Builder descriptiveVideoServiceFlag(CmfcDescriptiveVideoServiceFlag var1);

        public Builder iFrameOnlyManifest(String var1);

        public Builder iFrameOnlyManifest(CmfcIFrameOnlyManifest var1);

        public Builder scte35Esam(String var1);

        public Builder scte35Esam(CmfcScte35Esam var1);

        public Builder scte35Source(String var1);

        public Builder scte35Source(CmfcScte35Source var1);

        public Builder timedMetadata(String var1);

        public Builder timedMetadata(CmfcTimedMetadata var1);
    }
}

